﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/pca-connector-scep/PcaConnectorScep_EXPORTS.h>
#include <aws/pca-connector-scep/model/ConnectorSummary.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace PcaConnectorScep {
namespace Model {
class ListConnectorsResult {
 public:
  AWS_PCACONNECTORSCEP_API ListConnectorsResult() = default;
  AWS_PCACONNECTORSCEP_API ListConnectorsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_PCACONNECTORSCEP_API ListConnectorsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The connectors belonging to your Amazon Web Services account.</p>
   */
  inline const Aws::Vector<ConnectorSummary>& GetConnectors() const { return m_connectors; }
  template <typename ConnectorsT = Aws::Vector<ConnectorSummary>>
  void SetConnectors(ConnectorsT&& value) {
    m_connectorsHasBeenSet = true;
    m_connectors = std::forward<ConnectorsT>(value);
  }
  template <typename ConnectorsT = Aws::Vector<ConnectorSummary>>
  ListConnectorsResult& WithConnectors(ConnectorsT&& value) {
    SetConnectors(std::forward<ConnectorsT>(value));
    return *this;
  }
  template <typename ConnectorsT = ConnectorSummary>
  ListConnectorsResult& AddConnectors(ConnectorsT&& value) {
    m_connectorsHasBeenSet = true;
    m_connectors.emplace_back(std::forward<ConnectorsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>When you request a list of objects with a <code>MaxResults</code> setting, if
   * the number of objects that are still available for retrieval exceeds the maximum
   * you requested, Connector for SCEP returns a <code>NextToken</code> value in the
   * response. To retrieve the next batch of objects, use the token returned from the
   * prior request in your next request.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListConnectorsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListConnectorsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<ConnectorSummary> m_connectors;

  Aws::String m_nextToken;

  Aws::String m_requestId;
  bool m_connectorsHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace PcaConnectorScep
}  // namespace Aws
