﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/devops-guru/DevOpsGuruRequest.h>
#include <aws/devops-guru/DevOpsGuru_EXPORTS.h>
#include <aws/devops-guru/model/OrganizationResourceCollectionType.h>

#include <utility>

namespace Aws {
namespace DevOpsGuru {
namespace Model {

/**
 */
class DescribeOrganizationResourceCollectionHealthRequest : public DevOpsGuruRequest {
 public:
  AWS_DEVOPSGURU_API DescribeOrganizationResourceCollectionHealthRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DescribeOrganizationResourceCollectionHealth"; }

  AWS_DEVOPSGURU_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p> An Amazon Web Services resource collection type. This type specifies how
   * analyzed Amazon Web Services resources are defined. The two types of Amazon Web
   * Services resource collections supported are Amazon Web Services CloudFormation
   * stacks and Amazon Web Services resources that contain the same Amazon Web
   * Services tag. DevOps Guru can be configured to analyze the Amazon Web Services
   * resources that are defined in the stacks or that are tagged using the same tag
   * <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks.
   * </p>
   */
  inline OrganizationResourceCollectionType GetOrganizationResourceCollectionType() const { return m_organizationResourceCollectionType; }
  inline bool OrganizationResourceCollectionTypeHasBeenSet() const { return m_organizationResourceCollectionTypeHasBeenSet; }
  inline void SetOrganizationResourceCollectionType(OrganizationResourceCollectionType value) {
    m_organizationResourceCollectionTypeHasBeenSet = true;
    m_organizationResourceCollectionType = value;
  }
  inline DescribeOrganizationResourceCollectionHealthRequest& WithOrganizationResourceCollectionType(
      OrganizationResourceCollectionType value) {
    SetOrganizationResourceCollectionType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of the Amazon Web Services account.</p>
   */
  inline const Aws::Vector<Aws::String>& GetAccountIds() const { return m_accountIds; }
  inline bool AccountIdsHasBeenSet() const { return m_accountIdsHasBeenSet; }
  template <typename AccountIdsT = Aws::Vector<Aws::String>>
  void SetAccountIds(AccountIdsT&& value) {
    m_accountIdsHasBeenSet = true;
    m_accountIds = std::forward<AccountIdsT>(value);
  }
  template <typename AccountIdsT = Aws::Vector<Aws::String>>
  DescribeOrganizationResourceCollectionHealthRequest& WithAccountIds(AccountIdsT&& value) {
    SetAccountIds(std::forward<AccountIdsT>(value));
    return *this;
  }
  template <typename AccountIdsT = Aws::String>
  DescribeOrganizationResourceCollectionHealthRequest& AddAccountIds(AccountIdsT&& value) {
    m_accountIdsHasBeenSet = true;
    m_accountIds.emplace_back(std::forward<AccountIdsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of the organizational unit.</p>
   */
  inline const Aws::Vector<Aws::String>& GetOrganizationalUnitIds() const { return m_organizationalUnitIds; }
  inline bool OrganizationalUnitIdsHasBeenSet() const { return m_organizationalUnitIdsHasBeenSet; }
  template <typename OrganizationalUnitIdsT = Aws::Vector<Aws::String>>
  void SetOrganizationalUnitIds(OrganizationalUnitIdsT&& value) {
    m_organizationalUnitIdsHasBeenSet = true;
    m_organizationalUnitIds = std::forward<OrganizationalUnitIdsT>(value);
  }
  template <typename OrganizationalUnitIdsT = Aws::Vector<Aws::String>>
  DescribeOrganizationResourceCollectionHealthRequest& WithOrganizationalUnitIds(OrganizationalUnitIdsT&& value) {
    SetOrganizationalUnitIds(std::forward<OrganizationalUnitIdsT>(value));
    return *this;
  }
  template <typename OrganizationalUnitIdsT = Aws::String>
  DescribeOrganizationResourceCollectionHealthRequest& AddOrganizationalUnitIds(OrganizationalUnitIdsT&& value) {
    m_organizationalUnitIdsHasBeenSet = true;
    m_organizationalUnitIds.emplace_back(std::forward<OrganizationalUnitIdsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The pagination token to use to retrieve the next page of results for this
   * operation. If this value is null, it retrieves the first page.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  inline bool NextTokenHasBeenSet() const { return m_nextTokenHasBeenSet; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  DescribeOrganizationResourceCollectionHealthRequest& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The maximum number of results to return with a single call. To retrieve the
   * remaining results, make another call with the returned <code>nextToken</code>
   * value.</p>
   */
  inline int GetMaxResults() const { return m_maxResults; }
  inline bool MaxResultsHasBeenSet() const { return m_maxResultsHasBeenSet; }
  inline void SetMaxResults(int value) {
    m_maxResultsHasBeenSet = true;
    m_maxResults = value;
  }
  inline DescribeOrganizationResourceCollectionHealthRequest& WithMaxResults(int value) {
    SetMaxResults(value);
    return *this;
  }
  ///@}
 private:
  OrganizationResourceCollectionType m_organizationResourceCollectionType{OrganizationResourceCollectionType::NOT_SET};

  Aws::Vector<Aws::String> m_accountIds;

  Aws::Vector<Aws::String> m_organizationalUnitIds;

  Aws::String m_nextToken;

  int m_maxResults{0};
  bool m_organizationResourceCollectionTypeHasBeenSet = false;
  bool m_accountIdsHasBeenSet = false;
  bool m_organizationalUnitIdsHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_maxResultsHasBeenSet = false;
};

}  // namespace Model
}  // namespace DevOpsGuru
}  // namespace Aws
