from .. import Provider as PersonProvider


class Provider(PersonProvider):
    """
    A Faker provider for generating fake Zulu names in South Africa.
    """

    formats = (
        "{{first_name_male}} {{last_name_male}}",
        "{{first_name_male}} {{last_name_male}}",
        "{{first_name_male}} {{last_name_male}}",
        "{{first_name_male}} {{last_name_male}}",
        "{{first_name_male}} {{last_name_male}}-{{last_name_male}}",
        "{{first_name_female}} {{last_name_female}}",
        "{{first_name_female}} {{last_name_female}}",
        "{{first_name_female}} {{last_name_female}}",
        "{{first_name_female}} {{last_name_female}}",
        "{{first_name_female}} {{last_name_female}}-{{last_name_female}}",
        "{{prefix_male}} {{first_name_male}} {{last_name_male}}",
        "{{prefix_female}} {{first_name_female}} {{last_name_female}}",
        "{{prefix_male}} {{first_name_male}} {{last_name_male}}",
        "{{prefix_female}} {{first_name_female}} {{last_name_female}}",
    )

    # first names sourced from:
    # 1. https://briefly.co.za/35929-230-zulu-names-boys-girls.html
    # 2. https://en.wiktionary.org/wiki/Appendix:Zulu_given_names
    first_names_male = (
        "Andile",
        "Bandile",
        "Bhekani",
        "Jabulani",
        "Langalibalele",
        "Lungile",
        "Luyanda",
        "Lwandile",
        "Mandla",
        "Mandlakhe",
        "Mcebisi",
        "Minenhle",
        "Mlungisi",
        "Mthokozisi",
        "Musa",
        "Mzamo",
        "Nhlanhla",
        "Njabulo",
        "S'fiso",
        "Sandile",
        "Sibonelo",
        "Sibusiso",
        "SimphiweyiNkosi",
        "Siyabonga",
        "Sphiwe",
        "Thabani",
        "Thalente",
        "Thando",
        "Vusumuzi",
        "Zenzele",
    )
    first_names_female = (
        "Amahle",
        "Bhekisisa",
        "Bhekizizwe",
        "Bhekokwakhe",
        "Busisiwe",
        "Dumisani",
        "Dumisile",
        "Gugu",
        "Gugulethu",
        "Khanyisile",
        "Londisizwe",
        "Londiwe",
        "Mnqobi",
        "Ndumiso",
        "Nkazimulo",
        "Nobantu",
        "Nobuhle",
        "Nokulunga",
        "Nomagugu",
        "Nomalanga",
        "Nomasonto",
        "Nomathalente",
        "Nomathemba",
        "Nomcebo",
        "Nomthandazo",
        "Nomusa",
        "Nomvula",
        "Nonhlanhla",
        "Nonjabulo",
        "Nothando",
        "Noxolo",
        "Nozibusiso",
        "Nozizwe",
        "Nqobizitha",
        "Olwethu",
        "Owethu",
        "Sibongile",
        "Sibusisiwe",
        "Sihawukele",
        "Silondile",
        "Simphiwe",
        "Siphesihle",
        "Sithembiso",
        "Thabisa",
        "Thabisile",
        "Thalente",
        "Thandazile",
        "Thandeka",
        "Thandiwe",
        "Thembeka",
        "Thembekile",
        "Thembile",
        "Thembisile",
        "Thuthukile",
        "Zakhele",
        "Zenzile",
        "Zibuyile",
        "Zinhle",
    )

    first_names = first_names_male + first_names_female

    # last names sourced from :
    # 1. https://briefly.co.za/27255-izithakazelo-zakwazulu-zulu-surnames-zulu-clan-names-list.html
    last_names_male = (
        "Amahle",
        "Andile",
        "Anele",
        "Ayanda",
        "Ayize",
        "Bantwini",
        "Bayeni",
        "Bhedleni",
        "Bele",
        "Bhebhe",
        "Bhejelibomvu",
        "Bhembe",
        "Bhengu",
        "Bhensela",
        "Bhovungana",
        "Bhungane",
        "Bikelwayo",
        "Bikwayo",
        "Binda",
        "Biyase",
        "Biyela",
        "Blose",
        "Bophela",
        "Boyabenyathi",
        "Bukhosini",
        "Caluza",
        "Cebisa",
        "Cebekhulu",
        "Cenge",
        "Chagwe",
        "Chamane",
        "Chibi",
        "Chibini",
        "Chiliza",
        "Cibane",
        "Chonco",
        "Cwalile",
        "Delwayo",
        "Dikane",
        "Dimba",
        "Dimbane",
        "Dimbani",
        "Dinabantu",
        "Dinangwe",
        "Dindela",
        "Dingila",
        "Dindi",
        "Dinwa",
        "Dlabane",
        "Dlabazane",
        "Dladla",
        "Dlakadla",
        "Dlakela",
        "Dlamane",
        "Dlambula",
        "Dlamdaka",
        "Dlamini",
        "Dlamlenze",
        "Dlangamandla",
        "Dlawuza",
        "Dlebenkomo",
        "Dlodlo",
        "Dlomo",
        "Dludla",
        "Dludlu",
        "Dlungwana",
        "Doncabe",
        "Donda",
        "Dubandlela",
        "Dubazane",
        "Dube",
        "Dukada",
        "Duma",
        "Dumakude",
        "Dumisa",
        "Dunge",
        "Duyaza",
        "Duze",
        "Dwala",
        "Fihlela",
        "Fakazi",
        "Fakude",
        "Fanisa",
        "Fenya",
        "Gabadela",
        "Gabela",
        "Gabhezi",
        "Gabhisa",
        "Gadlela",
        "Gazu",
        "Galu",
        "Gagashe",
        "Gama",
        "Gambu",
        "Gambuse",
        "Gamede",
        "Gasa",
        "Gasela",
        "Gatsheni",
        "Gcaba",
        "Gcaleka",
        "Gcugcwa",
        "Gcumisa",
        "Gcwabe",
        "Gcwensa",
        "Gebashe",
        "Gebhezi",
        "Gedeza",
        "Gence",
        "Gengeshe",
        "Gigaba",
        "Gina",
        "Gininda",
        "Goba",
        "Gobhozi",
        "Godide",
        "Goje",
        "Gotsholo",
        "Gubeshe",
        "Gubhela",
        "Gubhuza",
        "Gubulundu",
        "Gugushe",
        "Gule",
        "Guliwe",
        "Guma",
        "Gumede",
        "Gumbi",
        "Gwacela",
        "Gwagwa",
        "Gwala",
        "Gwamanda",
        "Gwanyana",
        "Gwija",
        "Gxabhashe",
        "Hadebe",
        "Hangala",
        "Hhoyiyane",
        "Hlabisa",
        "Hlabangane",
        "Hlatshwayo",
        "Hlela",
        "Hlengwa",
        "Hlomuka",
        "Hlongwa",
        "Hlongwane",
        "Hlophe",
        "Hlubi",
        "Hlumakazi",
        "Jali",
        "Jama",
        "Jamasijadu",
        "Jamile",
        "Jele",
        "Jibela",
        "Jili",
        "Jiyane",
        "Jobe",
        "Jokiwe",
        "Juqula",
        "Khaba",
        "Khabalidaka",
        "Khambule",
        "Khanyeza",
        "Khanyile",
        "Khaphela",
        "Khathi",
        "Khathini",
        "Khathide",
        "Khawula",
        "Kheswa",
        "Khezokhulu",
        "Kholose",
        "Khomo",
        "Khonjwayo",
        "Khosini",
        "Khoza",
        "Khuba",
        "Khubisa",
        "Khuboni",
        "Khukhuza",
        "Khulu",
        "Khuluse",
        "Khumalo",
        "Khumbuza",
        "Khuyameni",
        "Khuzwayo",
        "Khwela",
        "Khwane",
        "Kubheka",
        "Kunene",
        "Kweyama",
        "Lakaza",
        "Lamula",
        "Langa",
        "Lange",
        "Langeni",
        "Lembede",
        "Longode",
        "Lubelo",
        "Ludonga",
        "Lukhele",
        "Luqe",
        "Lutholoni",
        "Luthuli",
        "Luvuno",
        "Lwandle",
        "Mabanga",
        "Mabaso",
        "Mabhena",
        "Mabhoko",
        "Mabizela",
        "Mabika",
        "Mabhodla",
        "Mbutho",
        "Mabuya",
        "Mabuyakhulu",
        "Mabuza",
        "Macingwane",
        "Made",
        "Madela",
        "Madi",
        "Madiba",
        "Madide",
        "Madinane",
        "Madlala",
        "Madlanduna",
        "Madondo",
        "Madonsela",
        "Mdotshana",
        "Maduma",
        "Maduna",
        "Malembe",
        "Madlula",
        "Madziba",
        "Mafobo",
        "Mafulela",
        "Mafuleka",
        "Magagula",
        "Magubane",
        "Magutshwa",
        "Magwaza",
        "Mageba",
        "Mahaye",
        "Mahamba",
        "Mahlaba",
        "Mahlalela",
        "Mahlangu",
        "Mahlase",
        "Mahlinza",
        "Mahlobo",
        "Mahulube",
        "Majoka",
        "Majola",
        "Majozi",
        "Makhanya",
        "Makhaye",
        "Makhathini",
        "Makhaza",
        "Makhedama",
        "Makhoba",
        "Makhubo",
        "Makhulukhulu",
        "Makhunga",
        "Malambule",
        "Malevu",
        "Malinga",
        "Maluleka",
        "Mamba",
        "Manana",
        "Mangcamane",
        "Mantshinga",
        "Mangede",
        "Mangena",
        "Mangethe",
        "Manyoni",
        "Mnqamu",
        "Manqele",
        "Mnquhe",
        "Manzi",
        "Manzini",
        "Manzezulu",
        "Maphalala",
        "Maphindela",
        "Maphanga",
        "Maphisa",
        "Mapholoba",
        "Maphumulo",
        "Masango",
        "Maseko",
        "Mashaba",
        "Mashasha",
        "Mashinini",
        "Mashimane",
        "Mashiya",
        "Masibekela",
        "Masikane",
        "Masina",
        "Masinga",
        "Masilela",
        "Masondo",
        "Masuku",
        "Mathaba",
        "Mathebela",
        "Mathebula",
        "Mathebula",
        "Mathenjwa",
        "Mathetha",
        "Mathula",
        "Mathunjwa",
        "Mathibela",
        "Mathonsi",
        "Mathwasa",
        "Mavela",
        "Mavundla",
        "Mavuso",
        "Mawanda",
        "Mawewe",
        "Mayeza",
        "Mayise",
        "Mayisela",
        "Mazalankosi",
        "Mazibuko",
        "Mazwi",
        "Mbamali",
        "Magoza",
        "Magolwana",
        "Magononde",
        "Maziya",
        "Mbanjwa",
        "Mbatha",
        "Mbatshazwa",
        "Magujwa",
        "Mbembe",
        "Mbekwa",
        "Mbende",
        "Mbeje",
        "Mbhele",
        "Mbhense",
        "Mbhodwe",
        "Mbhobho",
        "Mbhulangwe",
        "Mbili",
        "Mbokazi",
        "Mboko",
        "Mbonambi",
        "Mbongwa",
        "Mbongwe",
        "Mbotho",
        "Mbonane",
        "Mboyisa",
        "Mbulazi",
        "Mbulaze",
        "Mbuli",
        "Mbungela",
        "Mbunjwa",
        "Mbuyazi",
        "Mbuyisa",
        "Mbuyise",
        "Mcambe",
        "Mcambi",
        "Mcanco",
        "Mcanyana",
        "Mchunu",
        "Mcoyi",
        "Mcwaye",
        "Mcusi",
        "Mdaka",
        "Mdakane",
        "Mdladla",
        "Mdlalose",
        "Mdlanyoka",
        "Mdletshe",
        "Mdlenevu",
        "Mdluli",
        "Mdlumbi",
        "Mdonswa",
        "Mdunge",
        "Mehloluhlaza",
        "Memela",
        "Nenzi",
        "Menziwa",
        "Meyiwa",
        "Mfeka",
        "Mfusi",
        "Mgabhi",
        "Mgabadeli",
        "Mgasela",
        "Mgazi",
        "Mgcaleka",
        "Mgenge",
        "Mgobhozi",
        "Mgilija",
        "Mhayise",
        "Mhlabandlovu",
        "Mhlambo",
        "Mhlanga",
        "Mhlangu",
        "Mhlanya",
        "Mhlongo",
        "Mhlongwane",
        "Mhlophe",
        "Mhlungu",
        "Mgwaba",
        "Miya",
        "Mjadu",
        "Mjoli",
        "Mjwara",
        "Mkhabela",
        "Mkhandlela",
        "Mkhathini",
        "Mkhatshwa",
        "Mkhithi",
        "Mkhize",
        "Mkhokeleleki",
        "Mkholo",
        "Mkhumbuzi",
        "Mkhungo",
        "Mkhonza",
        "Mkhwananzi",
        "Mlaba",
        "Mlalane",
        "Mlalazi",
        "Mlambo",
        "Mlangatshe",
        "Mlangeni",
        "Mlawula",
        "Mlungisi",
        "Mlungwana",
        "Mlondo",
        "Mlotshwa",
        "Mncube",
        "Mncwabe",
        "Mncwanga",
        "Mngadi",
        "Mngoma",
        "Mngomezulu",
        "Mngwemkhulu",
        "Mngwengwe",
        "Mnguni",
        "Mnikathi",
        "Mnisi",
        "Mnomiya",
        "Mnqayi",
        "Mqungebe",
        "Mnyandu",
        "Mnyoni",
        "Mondise",
        "Motha",
        "Mnangwe",
        "Mntambo",
        "Mntimande",
        "Mtolo",
        "Mntungwa",
        "Mnyamande",
        "Mpangazitha",
        "Mpanza",
        "Mphankomo",
        "Mphahlwa",
        "Mphazima",
        "Mphephethwa",
        "Mphemba",
        "Mpila",
        "Mpikela",
        "Mpofana",
        "Mpungose",
        "Mpumuza",
        "Mpunzana",
        "Mqadi",
        "Msane",
        "Msani",
        "Msamkhulu",
        "Mshazi",
        "Mshengu",
        "Mshibe",
        "Msibi",
        "Mshikela",
        "Mshikila",
        "Mshiyane",
        "Mseleku",
        "Msimang",
        "Msindazwe",
        "Msokazi",
        "Msomi",
        "Msweli",
        "Msuthu",
        "Mthabela",
        "Mthalane",
        "Mthanti",
        "Mthembu",
        "Mthethwa",
        "Mtimande",
        "Mthimkhulu",
        "Mthinti",
        "Mthiya",
        "Mthiyane",
        "Mthombeni",
        "Mthonti",
        "Mtshali",
        "Mtumaseli",
        "Mtuswa",
        "Musi",
        "Mvelase",
        "Mveni",
        "Mvubu",
        "Mvuyana",
        "Myeza",
        "Mwandla",
        "Mwelase",
        "Myeni",
        "Mzila",
        "Mzileni",
        "Mzilankatha",
        "Mzimela",
        "Mzizi",
        "Mzobe",
        "Mzolo",
        "Mzomba",
        "Mzoneli",
        "Mzukase",
        "Mzulwini",
        "Nala",
        "Nandisa",
        "Ncala",
        "Ncwaba",
        "Ncwane",
        "Ndandali",
        "Ntenga",
        "Ncama",
        "Ngcamane",
        "Ncanana",
        "Ncongwane",
        "Ncube",
        "Ncusi",
        "Ndaba",
        "Ndabandaba",
        "Ndabase",
        "Ndabansele",
        "Ndawo",
        "Njomane",
        "Nkundlande",
        "Ndabezitha",
        "Ndawonde",
        "Ndima",
        "Ndimande",
        "Ndinisa",
        "Ndiyema",
        "Ndlala",
        "Ndlandla",
        "Ndlangamandla",
        "Ndlanzi",
        "Ndlanya",
        "Ndlela",
        "Ndlondlo",
        "Ndosi",
        "Ndlovu",
        "Ndondakusuka",
        "Ndonga",
        "Nduli",
        "Ndwandwe",
        "Nene",
        "Ngazitha",
        "Ngcamu",
        "Ngcemu",
        "Ngcobo",
        "Ngcolosi",
        "Ngema",
        "Ngiba",
        "Zikhungwini",
        "Ngidi",
        "Ngobese",
        "Ngobisi",
        "Ngomane",
        "Ngonini",
        "Ngotsha",
        "Ngubane",
        "Ngubeni",
        "Ngungunyana",
        "Ngwane",
        "Ngwazi",
        "Ngwenya",
        "Ngwekazi",
        "Nhlabathi",
        "Nhlanhla",
        "Nhlanhlampofu",
        "Nhlane",
        "Nhlapho",
        "Nhleko",
        "Nhlengethwa",
        "Nkala",
        "Nkamzwayo",
        "Njiki",
        "Njinji",
        "Nkabinde",
        "Nkonyeni",
        "Nkosi",
        "Nkumane",
        "Nkomo",
        "Nkomose",
        "Nkomoye",
        "Nkwakha",
        "Nkwali",
        "Nkwaliyenkosi",
        "Nkwanyana",
        "Njapha",
        "Nodanga",
        "Nodlomo",
        "Nogantshi",
        "Nombela",
        "Nombhoco",
        "Nomndayi",
        "Nomvuma",
        "Nondaba",
        "Nondlela",
        "Nonduma",
        "Nongalaza",
        "Nongalo",
        "Nonkosi",
        "Nonkululeko",
        "Nontanda",
        "Nontuli",
        "Nonyana",
        "Nowanqa",
        "Nozulu",
        "Nqumela",
        "Nsele",
        "Nsibande",
        "Nsibanyoni",
        "Nsindane",
        "Nsukuza",
        "Ntaka",
        "Ntanzi",
        "Ntenga",
        "Ntsele",
        "Ntamonde",
        "Ntshangase",
        "Ntshalintshali",
        "Ntshingila",
        "Ntshiza",
        "Ntombela",
        "Ntuli",
        "Nxamalala",
        "Nxasana",
        "Nxele",
        "Nxumalo",
        "Nyazitla",
        "Nyambose",
        "Nyanda",
        "Nyandeni",
        "Nyathi",
        "Nyawo",
        "Nyawokhulu",
        "Nyawose",
        "Nyembe",
        "Nyembezi",
        "Nyide",
        "Nyokayebululu",
        "Nyongwana",
        "Nzama",
        "Nzamela",
        "Nzima",
        "Nzimande",
        "Nzimase",
        "Nzuza",
        "Onjengenyamazane",
        "Phakathi",
        "Phakathwayo",
        "Phathwayo",
        "Phetha",
        "Phethela",
        "Phewa",
        "Phikela",
        "Phingoshe",
        "Phoseka",
        "Phoswa",
        "Phungula",
        "Phuthini",
        "Qomazitha",
        "Qwabe",
        "Sabela",
        "Sabelo",
        "Sameya",
        "Sangwani",
        "Sangweni",
        "Sembathwa",
        "Sengwayo",
        "Shabane",
        "Shabane",
        "Shabalala",
        "Shabangu",
        "Shamase",
        "Shandu",
        "Shange",
        "Shangase",
        "Shazi",
        "Shengele",
        "Shelembe",
        "Shezi",
        "Dlaba",
        "Shibase",
        "Shinga",
        "Shoba",
        "Shombela",
        "Shoyisa",
        "Shozi",
        "Sibanda",
        "Sibalukhulu",
        "Sibaya",
        "Sibeko",
        "Sibisi",
        "Sibiya",
        "Sigagu",
        "Sigegede",
        "Sibhene",
        "Sibindi",
        "Sijadu",
        "Sikhakhane",
        "Sikhosana",
        "Sikobi",
        "Sikhunyana",
        "Sikwayo",
        "Silangwe",
        "Simelane",
        "Sithenjwa",
        "Sithole",
        "Sithombo",
        "Sithuli",
        "Sitolotolo",
        "Sishangwe",
        "Sishi",
        "Sishiya",
        "Siwele",
        "Siyaya",
        "Siyeshe",
        "Soduba",
        "Sokhela",
        "Sokhulu",
        "Sokhwebula",
        "Somboni",
        "Somfula",
        "Sompisi",
        "Sandanezwe",
        "Sondini",
        "Sondisa",
        "Sontuli",
        "Songiya",
        "Sonqandile",
        "Sothole",
        "Sotobe",
        "Swazi",
        "Tiba",
        "Thabethe",
        "Thabizolo",
        "Thango",
        "Thabekhulu",
        "Thela",
        "Thembekwayo",
        "Thembela",
        "Thenjwayo",
        "Thobeni",
        "Thole",
        "Thoyana",
        "Tukane",
        "Thuliswayo",
        "Thumbela",
        "Thumbeza",
        "Thusi",
        "Thusini",
        "Thwala",
        "Wanda",
        "Wasendlunkulu",
        "Wela",
        "Weza",
        "Vilakazi",
        "Vabaza",
        "Vangisa",
        "Vezi",
        "Vumisa",
        "Vundla",
        "Vunisa",
        "Xaba",
        "Xala",
        "Xhakaza",
        "Ximba",
        "Xolo",
        "Xulu",
        "Yengwa",
        "Yengwayo",
        "Yei",
        "Yeyeye",
    )

    # last names are not sex dependant
    last_names_female = last_names_male
    last_names = last_names_male + last_names_female

    prefixes_female = (
        "Mrs.",
        "Ms.",
        "Miss",
        "Dr.",
        "Nkosikazi",
        "Nkosazana",
        "Mama",
        "Dade",
    )

    prefixes_male = ("Mr.", "Dr.", "Mnumzane", "Baba", "Bhuti")
