/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.its;

import java.io.IOException;
import java.io.OutputStream;
import org.python.bouncycastle.asn1.ASN1Encodable;
import org.python.bouncycastle.its.ITSPublicEncryptionKey;
import org.python.bouncycastle.its.ITSValidityPeriod;
import org.python.bouncycastle.its.operator.ECDSAEncoder;
import org.python.bouncycastle.its.operator.ITSContentVerifierProvider;
import org.python.bouncycastle.oer.Element;
import org.python.bouncycastle.oer.OEREncoder;
import org.python.bouncycastle.oer.its.ieee1609dot2.CertificateBase;
import org.python.bouncycastle.oer.its.ieee1609dot2.IssuerIdentifier;
import org.python.bouncycastle.oer.its.ieee1609dot2.basetypes.PublicEncryptionKey;
import org.python.bouncycastle.oer.its.ieee1609dot2.basetypes.Signature;
import org.python.bouncycastle.oer.its.template.ieee1609dot2.IEEE1609dot2;
import org.python.bouncycastle.operator.ContentVerifier;
import org.python.bouncycastle.util.Encodable;

public class ITSCertificate
implements Encodable {
    private final CertificateBase certificate;

    public ITSCertificate(CertificateBase certificateBase) {
        this.certificate = certificateBase;
    }

    public IssuerIdentifier getIssuer() {
        return this.certificate.getIssuer();
    }

    public ITSValidityPeriod getValidityPeriod() {
        return new ITSValidityPeriod(this.certificate.getToBeSigned().getValidityPeriod());
    }

    public ITSPublicEncryptionKey getPublicEncryptionKey() {
        PublicEncryptionKey publicEncryptionKey = this.certificate.getToBeSigned().getEncryptionKey();
        if (publicEncryptionKey != null) {
            return new ITSPublicEncryptionKey(publicEncryptionKey);
        }
        return null;
    }

    public boolean isSignatureValid(ITSContentVerifierProvider iTSContentVerifierProvider) throws Exception {
        ContentVerifier contentVerifier = iTSContentVerifierProvider.get(this.certificate.getSignature().getChoice());
        OutputStream outputStream = contentVerifier.getOutputStream();
        outputStream.write(OEREncoder.toByteArray((ASN1Encodable)this.certificate.getToBeSigned(), (Element)IEEE1609dot2.ToBeSignedCertificate.build()));
        outputStream.close();
        Signature signature = this.certificate.getSignature();
        return contentVerifier.verify(ECDSAEncoder.toX962(signature));
    }

    public CertificateBase toASN1Structure() {
        return this.certificate;
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return OEREncoder.toByteArray((ASN1Encodable)this.certificate, (Element)IEEE1609dot2.CertificateBase.build());
    }
}

