/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote;

import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.coyote.Processor;
import org.apache.juli.logging.Log;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.DispatchType;
import org.apache.tomcat.util.net.SocketEvent;
import org.apache.tomcat.util.net.SocketWrapperBase;

public abstract class AbstractProcessorLight
implements Processor {
    private final Set<DispatchType> dispatches = new CopyOnWriteArraySet<DispatchType>();

    @Override
    public AbstractEndpoint.Handler.SocketState process(SocketWrapperBase<?> socketWrapperBase, SocketEvent socketEvent) throws IOException {
        AbstractEndpoint.Handler.SocketState socketState = AbstractEndpoint.Handler.SocketState.CLOSED;
        Iterator<DispatchType> iterator = null;
        do {
            if (iterator != null) {
                DispatchType dispatchType = (DispatchType)((Object)iterator.next());
                if (this.getLog().isTraceEnabled()) {
                    this.getLog().trace((Object)("Processing dispatch type: [" + (Object)((Object)dispatchType) + "]"));
                }
                socketState = this.dispatch(dispatchType.getSocketStatus());
                if (!iterator.hasNext()) {
                    socketState = this.checkForPipelinedData(socketState, socketWrapperBase);
                }
            } else if (socketEvent != SocketEvent.DISCONNECT) {
                if (this.isAsync() || this.isUpgrade() || socketState == AbstractEndpoint.Handler.SocketState.ASYNC_END) {
                    socketState = this.dispatch(socketEvent);
                    socketState = this.checkForPipelinedData(socketState, socketWrapperBase);
                } else if (socketEvent == SocketEvent.OPEN_WRITE) {
                    socketState = AbstractEndpoint.Handler.SocketState.LONG;
                } else if (socketEvent == SocketEvent.OPEN_READ) {
                    socketState = this.service(socketWrapperBase);
                } else if (socketEvent == SocketEvent.CONNECT_FAIL) {
                    this.logAccess(socketWrapperBase);
                } else {
                    socketState = AbstractEndpoint.Handler.SocketState.CLOSED;
                }
            }
            if (this.getLog().isTraceEnabled()) {
                this.getLog().trace((Object)("Socket: [" + socketWrapperBase + "], Status in: [" + (Object)((Object)socketEvent) + "], State out: [" + (Object)((Object)socketState) + "]"));
            }
            if (this.isAsync() && socketState != AbstractEndpoint.Handler.SocketState.CLOSED) {
                socketState = this.asyncPostProcess();
                if (this.getLog().isTraceEnabled()) {
                    this.getLog().trace((Object)("Socket: [" + socketWrapperBase + "], State after async post processing: [" + (Object)((Object)socketState) + "]"));
                }
            }
            if (iterator != null && iterator.hasNext()) continue;
            iterator = this.getIteratorAndClearDispatches();
        } while (socketState == AbstractEndpoint.Handler.SocketState.ASYNC_END || iterator != null && socketState != AbstractEndpoint.Handler.SocketState.CLOSED);
        return socketState;
    }

    private AbstractEndpoint.Handler.SocketState checkForPipelinedData(AbstractEndpoint.Handler.SocketState socketState, SocketWrapperBase<?> socketWrapperBase) throws IOException {
        if (socketState == AbstractEndpoint.Handler.SocketState.OPEN) {
            return this.service(socketWrapperBase);
        }
        return socketState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDispatch(DispatchType dispatchType) {
        Set<DispatchType> set = this.dispatches;
        synchronized (set) {
            this.dispatches.add(dispatchType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<DispatchType> getIteratorAndClearDispatches() {
        Iterator<DispatchType> iterator;
        Set<DispatchType> set = this.dispatches;
        synchronized (set) {
            iterator = this.dispatches.iterator();
            if (iterator.hasNext()) {
                this.dispatches.clear();
            } else {
                iterator = null;
            }
        }
        return iterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearDispatches() {
        Set<DispatchType> set = this.dispatches;
        synchronized (set) {
            this.dispatches.clear();
        }
    }

    protected void logAccess(SocketWrapperBase<?> socketWrapperBase) throws IOException {
    }

    protected abstract AbstractEndpoint.Handler.SocketState service(SocketWrapperBase<?> var1) throws IOException;

    protected abstract AbstractEndpoint.Handler.SocketState dispatch(SocketEvent var1) throws IOException;

    protected abstract AbstractEndpoint.Handler.SocketState asyncPostProcess();

    protected abstract Log getLog();
}

