/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http;

import org.apache.tomcat.util.http.ServerCookie;
import org.apache.tomcat.util.res.StringManager;

public class ServerCookies {
    private static final StringManager sm = StringManager.getManager(ServerCookies.class);
    private ServerCookie[] serverCookies;
    private int cookieCount = 0;
    private int limit = 200;

    public ServerCookies(int n) {
        this.serverCookies = new ServerCookie[n];
    }

    public ServerCookie addCookie() {
        ServerCookie serverCookie;
        if (this.limit > -1 && this.cookieCount >= this.limit) {
            throw new IllegalArgumentException(sm.getString("cookies.maxCountFail", new Object[]{this.limit}));
        }
        if (this.cookieCount >= this.serverCookies.length) {
            int n = this.limit > -1 ? Math.min(2 * this.cookieCount, this.limit) : 2 * this.cookieCount;
            ServerCookie[] serverCookieArray = new ServerCookie[n];
            System.arraycopy(this.serverCookies, 0, serverCookieArray, 0, this.cookieCount);
            this.serverCookies = serverCookieArray;
        }
        if ((serverCookie = this.serverCookies[this.cookieCount]) == null) {
            this.serverCookies[this.cookieCount] = serverCookie = new ServerCookie();
        }
        ++this.cookieCount;
        return serverCookie;
    }

    public ServerCookie getCookie(int n) {
        return this.serverCookies[n];
    }

    public int getCookieCount() {
        return this.cookieCount;
    }

    public void setLimit(int n) {
        this.limit = n;
        if (n > -1 && this.serverCookies.length > n && this.cookieCount <= n) {
            ServerCookie[] serverCookieArray = new ServerCookie[n];
            System.arraycopy(this.serverCookies, 0, serverCookieArray, 0, this.cookieCount);
            this.serverCookies = serverCookieArray;
        }
    }

    public void recycle() {
        for (int i = 0; i < this.cookieCount; ++i) {
            this.serverCookies[i].recycle();
        }
        this.cookieCount = 0;
    }
}

