/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ko;

import org.apache.lucene.analysis.ko.KoreanTokenizer;
import org.apache.lucene.analysis.ko.POS;
import org.apache.lucene.analysis.ko.Token;
import org.apache.lucene.analysis.ko.dict.Dictionary;

public class DictionaryToken
extends Token {
    private final int wordId;
    private final KoreanTokenizer.Type type;
    private final Dictionary dictionary;

    public DictionaryToken(KoreanTokenizer.Type type, Dictionary dictionary, int wordId, char[] surfaceForm, int offset, int length, int startOffset, int endOffset) {
        super(surfaceForm, offset, length, startOffset, endOffset);
        this.type = type;
        this.dictionary = dictionary;
        this.wordId = wordId;
    }

    public String toString() {
        return "DictionaryToken(\"" + this.getSurfaceFormString() + "\" pos=" + this.getStartOffset() + " length=" + this.getLength() + " posLen=" + this.getPositionLength() + " type=" + String.valueOf((Object)this.type) + " wordId=" + this.wordId + " leftID=" + this.dictionary.getLeftId(this.wordId) + ")";
    }

    public KoreanTokenizer.Type getType() {
        return this.type;
    }

    public boolean isKnown() {
        return this.type == KoreanTokenizer.Type.KNOWN;
    }

    public boolean isUnknown() {
        return this.type == KoreanTokenizer.Type.UNKNOWN;
    }

    public boolean isUser() {
        return this.type == KoreanTokenizer.Type.USER;
    }

    @Override
    public POS.Type getPOSType() {
        return this.dictionary.getPOSType(this.wordId);
    }

    @Override
    public POS.Tag getLeftPOS() {
        return this.dictionary.getLeftPOS(this.wordId);
    }

    @Override
    public POS.Tag getRightPOS() {
        return this.dictionary.getRightPOS(this.wordId);
    }

    @Override
    public String getReading() {
        return this.dictionary.getReading(this.wordId);
    }

    @Override
    public Dictionary.Morpheme[] getMorphemes() {
        return this.dictionary.getMorphemes(this.wordId, this.getSurfaceForm(), this.getOffset(), this.getLength());
    }
}

