/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.lang.invoke.MethodHandles;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.solr.util.TestInjection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadCpuTimer {
    private static final long UNSUPPORTED = -1L;
    public static final String CPU_TIME = "cpuTime";
    public static final String LOCAL_CPU_TIME = "localCpuTime";
    public static final String ENABLE_CPU_TIME = "solr.log.cputime";
    private static ThreadMXBean THREAD_MX_BEAN;
    private static final Logger log;
    private static final ThreadLocal<Map<String, AtomicLong>> threadLocalTimer;

    private ThreadCpuTimer() {
    }

    public static void beginContext(String context) {
        ThreadCpuTimer.readNSAndReset(context);
    }

    public static boolean isSupported() {
        return THREAD_MX_BEAN != null;
    }

    public static Optional<Long> readNSAndReset(String context) {
        TestInjection.injectCpuUseInSearcherCpuLimitCheck();
        if (THREAD_MX_BEAN == null) {
            return Optional.empty();
        }
        AtomicLong threadCpuTime = threadLocalTimer.get().computeIfAbsent(context, ctx -> new AtomicLong(THREAD_MX_BEAN.getCurrentThreadCpuTime()));
        long currentThreadCpuTime = THREAD_MX_BEAN.getCurrentThreadCpuTime();
        long result = currentThreadCpuTime - threadCpuTime.get();
        threadCpuTime.set(currentThreadCpuTime);
        return Optional.of(result);
    }

    public static void reset(String context) {
        if (THREAD_MX_BEAN != null) {
            threadLocalTimer.get().computeIfAbsent(context, ctx -> new AtomicLong(THREAD_MX_BEAN.getCurrentThreadCpuTime())).set(THREAD_MX_BEAN.getCurrentThreadCpuTime());
        }
    }

    public static Optional<Long> readMSandReset(String context) {
        return ThreadCpuTimer.readNSAndReset(context).map(cpuTimeNs -> TimeUnit.MILLISECONDS.convert((long)cpuTimeNs, TimeUnit.NANOSECONDS));
    }

    public static void reset() {
        threadLocalTimer.get().clear();
    }

    public String toString() {
        return THREAD_MX_BEAN == null ? "UNSUPPORTED" : "Timing contexts:" + threadLocalTimer.get().toString();
    }

    static {
        log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        try {
            ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
            if (!threadBean.isThreadCpuTimeEnabled()) {
                threadBean.setThreadCpuTimeEnabled(true);
            }
            THREAD_MX_BEAN = threadBean;
        }
        catch (SecurityException | UnsupportedOperationException e) {
            THREAD_MX_BEAN = null;
            log.info("Thread CPU time monitoring is not available.");
        }
        threadLocalTimer = ThreadLocal.withInitial(ConcurrentHashMap::new);
    }
}

