/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql.converter;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLevel;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Logging;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.sql.converter.CharacterConverterJDBC;

@DefaultLogger(value="oracle.sql")
@Supports(value={Feature.SQL_CONVERTER})
@DefaultLevel(value=Logging.FINEST)
public class CharacterConverter1Byte
extends CharacterConverterJDBC {
    static final long serialVersionUID = 200017349723606452L;
    static final int ORACHARMASK = 255;
    static final int UCSCHARWIDTH = 16;
    public int m_ucsReplacement;
    public int[] m_ucsChar;
    public char[] m_oraCharLevel1;
    public char[] m_oraCharSurrogateLevel;
    public char[] m_oraCharLevel2;
    public byte m_oraCharReplacement;
    protected transient boolean noSurrogate;
    protected transient boolean strictASCII;
    protected transient int m_oraCharLevel2Size;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;

    public CharacterConverter1Byte() {
        boolean bl = (0x800000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$20, null, new Object[0]);
            }
            this.m_ucsReplacement = 0;
            this.m_ucsChar = null;
            this.m_oraCharLevel1 = null;
            this.m_oraCharSurrogateLevel = null;
            this.m_oraCharLevel2 = null;
            this.m_oraCharReplacement = 0;
            this.noSurrogate = true;
            this.strictASCII = true;
            this.m_oraCharLevel2Size = 0;
            this.m_groupId = 0;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$20, null);
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$20, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$20, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    int toUnicode(byte by) throws SQLException {
        boolean bl = (0x800000L & TraceControllerImpl.feature) != 0L;
        try {
            void srcChar;
            int ucsChar;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$0, this, by);
            }
            if ((ucsChar = this.m_ucsChar[srcChar & 0xFF]) == -1) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(154).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$0, this, sQLException);
                }
                throw sQLException;
            }
            int n2 = ucsChar;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$0, this, n2);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$0, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    int toUnicodeWithReplacement(byte by) {
        boolean bl = (0x800000L & TraceControllerImpl.feature) != 0L;
        try {
            void srcChar;
            int ucsChar;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$1, this, by);
            }
            if ((ucsChar = this.m_ucsChar[srcChar & 0xFF]) == -1) {
                int n2 = this.m_ucsReplacement;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$1, this, n2);
                    ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$1, this, null);
                }
                return n2;
            }
            int n3 = ucsChar;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$1, this, n3);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$1, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    byte toOracleCharacter(char c2, char c3) throws SQLException {
        boolean bl = (0x800000L & TraceControllerImpl.feature) != 0L;
        try {
            void lowSurrogate;
            void srcChar;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$2, this, Character.valueOf(c2), Character.valueOf(c3));
            }
            int l1Key = srcChar >>> 8 & 0xFF;
            int l2Key = srcChar & 0xFF;
            int l3Key = lowSurrogate >>> 8 & 0xFF;
            int l4Key = lowSurrogate & 0xFF;
            if (this.m_oraCharLevel1[l1Key] != (char)this.m_oraCharLevel2Size && this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[l1Key] + l2Key] != '\uffff' && this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[l1Key] + l2Key] + l3Key] != '\uffff' && this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[l1Key] + l2Key] + l3Key] + l4Key] != '\uffff') {
                byte by = (byte)this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[l1Key] + l2Key] + l3Key] + l4Key];
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$2, this, by);
                    ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$2, this, null);
                }
                return by;
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(155).fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$2, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    byte toOracleCharacter(char c2) throws SQLException {
        boolean bl = (0x800000L & TraceControllerImpl.feature) != 0L;
        try {
            int l4Key;
            void srcChar;
            void l3Key;
            char ret;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$3, this, Character.valueOf(c2));
            }
            if ((ret = this.m_oraCharLevel2[this.m_oraCharLevel1[l3Key = srcChar >>> 8] + (l4Key = srcChar & 0xFF)]) != '\uffff') {
                byte by = (byte)ret;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$3, this, by);
                    ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$3, this, null);
                }
                return by;
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(155).fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$3, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    byte toOracleCharacterWithReplacement(char c2, char c3) {
        boolean bl = (0x800000L & TraceControllerImpl.feature) != 0L;
        try {
            void lowSurrogate;
            void srcChar;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$4, this, Character.valueOf(c2), Character.valueOf(c3));
            }
            int l1Key = srcChar >>> 8 & 0xFF;
            int l2Key = srcChar & 0xFF;
            int l3Key = lowSurrogate >>> 8 & 0xFF;
            int l4Key = lowSurrogate & 0xFF;
            if (this.m_oraCharLevel1[l1Key] != (char)this.m_oraCharLevel2Size && this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[l1Key] + l2Key] != '\uffff' && this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[l1Key] + l2Key] + l3Key] != '\uffff' && this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[l1Key] + l2Key] + l3Key] + l4Key] != '\uffff') {
                byte by = (byte)this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[l1Key] + l2Key] + l3Key] + l4Key];
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$4, this, by);
                    ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$4, this, null);
                }
                return by;
            }
            byte by = this.m_oraCharReplacement;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$4, this, by);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$4, this, null);
            }
            return by;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    byte toOracleCharacterWithReplacement(char c2) {
        boolean bl = (0x800000L & TraceControllerImpl.feature) != 0L;
        try {
            int l4Key;
            void srcChar;
            void l3Key;
            char ret;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$5, this, Character.valueOf(c2));
            }
            if ((ret = this.m_oraCharLevel2[this.m_oraCharLevel1[l3Key = srcChar >>> 8] + (l4Key = srcChar & 0xFF)]) != '\uffff') {
                byte by = (byte)ret;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$5, this, by);
                    ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$5, this, null);
                }
                return by;
            }
            byte by = this.m_oraCharReplacement;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$5, this, by);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$5, this, null);
            }
            return by;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int toUnicodeChars(byte[] byArray, int n2, char[] cArray, int n3, int n4) throws SQLException {
        boolean bl = (0x800000L & TraceControllerImpl.feature) != 0L;
        try {
            void dstChar;
            void i2;
            void dstOffset;
            void count;
            void offset;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$6, this, byArray, n2, cArray, n3, n4);
            }
            void endPos = offset + count;
            int ucs2 = 0;
            void dstCharIndex = dstOffset;
            for (i2 = offset; i2 < endPos && dstCharIndex < ((void)dstChar).length; ++i2) {
                void srcChar;
                ucs2 = this.m_ucsChar[srcChar[i2] & 0xFF];
                if (ucs2 == this.m_ucsReplacement) {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(154).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$6, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$6, this, sQLException);
                    }
                    throw sQLException;
                }
                if (((long)ucs2 & 0xFFFFFFFFL) > 65535L) {
                    if (dstCharIndex + 2 < ((void)dstChar).length) {
                        --i2;
                        break;
                    }
                    dstChar[dstCharIndex++] = (char)(ucs2 >>> 16);
                    dstChar[dstCharIndex++] = (char)(ucs2 & 0xFFFF);
                    continue;
                }
                dstChar[dstCharIndex++] = (char)ucs2;
            }
            void var12_13 = i2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$6, this, (int)var12_13);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$6, this, null);
            }
            return (int)var12_13;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String toUnicodeString(byte[] byArray, int n2, int n3) throws SQLException {
        boolean bl = (0x800000L & TraceControllerImpl.feature) != 0L;
        try {
            void count;
            void offset;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$7, this, byArray, n2, n3);
            }
            void endPos = offset + count;
            StringBuilder ucsChars = new StringBuilder((int)count);
            int ucs2 = 0;
            for (void i2 = offset; i2 < endPos; ++i2) {
                void srcChar;
                ucs2 = this.m_ucsChar[srcChar[i2] & 0xFF];
                if (ucs2 == this.m_ucsReplacement) {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(154).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$7, this, sQLException);
                    }
                    throw sQLException;
                }
                if (((long)ucs2 & 0xFFFFFFFFL) > 65535L) {
                    ucsChars.append((char)(ucs2 >>> 16));
                    ucsChars.append((char)(ucs2 & 0xFFFF));
                    continue;
                }
                ucsChars.append((char)ucs2);
            }
            String string = ucsChars.substring(0, ucsChars.length());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$7, this, string);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$7, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String toUnicodeStringWithReplacement(byte[] byArray, int n2, int n3) {
        boolean bl = (0x800000L & TraceControllerImpl.feature) != 0L;
        try {
            void count;
            void offset;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$8, this, byArray, n2, n3);
            }
            void endPos = offset + count;
            StringBuilder ucsChars = new StringBuilder((int)count);
            int ucs2 = 0;
            for (void i2 = offset; i2 < endPos; ++i2) {
                void srcChar;
                ucs2 = this.m_ucsChar[srcChar[i2] & 0xFF];
                if (ucs2 == -1) {
                    ucsChars.append((char)this.m_ucsReplacement);
                    continue;
                }
                ucsChars.append((char)ucs2);
            }
            String string = ucsChars.substring(0, ucsChars.length());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$8, this, string);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$8, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] toOracleString(String string) throws SQLException {
        boolean bl = (0x800000L & TraceControllerImpl.feature) != 0L;
        try {
            void srcString;
            int srcLength;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$9, this, string);
            }
            if ((srcLength = srcString.length()) == 0) {
                byte[] byArray = new byte[]{};
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$9, this, byArray);
                    ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$9, this, null);
                }
                return byArray;
            }
            char[] srcChars = new char[srcLength];
            srcString.getChars(0, srcLength, srcChars, 0);
            byte[] oracleChars = new byte[srcLength * 4];
            int oraCharIdx = 0;
            for (int i2 = 0; i2 < srcLength; ++i2) {
                if (srcChars[i2] >= '\ud800' && srcChars[i2] < '\udc00') {
                    if (i2 + 1 < srcLength && srcChars[i2 + 1] >= '\udc00' && srcChars[i2 + 1] <= '\udfff') {
                        if (this.noSurrogate) {
                            SQLException sQLException = (SQLException)DatabaseError.createSqlException(155).fillInStackTrace();
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$9, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$9, this, sQLException);
                            }
                            throw sQLException;
                        }
                        oracleChars[oraCharIdx++] = this.toOracleCharacter(srcChars[i2], srcChars[i2 + 1]);
                        ++i2;
                        continue;
                    }
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(155).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$9, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$9, this, sQLException);
                    }
                    throw sQLException;
                }
                oracleChars[oraCharIdx++] = srcChars[i2] < '\u0080' && this.strictASCII ? (byte)srcChars[i2] : this.toOracleCharacter(srcChars[i2]);
            }
            if (oraCharIdx < oracleChars.length) {
                byte[] returnArray = new byte[oraCharIdx];
                System.arraycopy(oracleChars, 0, returnArray, 0, oraCharIdx);
                byte[] byArray = returnArray;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$9, this, byArray);
                    ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$9, this, null);
                }
                return returnArray;
            }
            byte[] byArray = oracleChars;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$9, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$9, this, null);
            }
            return oracleChars;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] toOracleStringWithReplacement(String string) {
        boolean bl = (0x800000L & TraceControllerImpl.feature) != 0L;
        try {
            void srcString;
            int srcLength;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$10, this, string);
            }
            if ((srcLength = srcString.length()) == 0) {
                byte[] byArray = new byte[]{};
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$10, this, byArray);
                    ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$10, this, null);
                }
                return byArray;
            }
            char[] srcChars = new char[srcLength];
            srcString.getChars(0, srcLength, srcChars, 0);
            int[] srcLengthArr = new int[]{srcLength};
            byte[] byArray = this.toOracleStringWithReplacement(srcChars, 0, null, 0, srcLengthArr);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$10, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$10, this, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] toOracleStringWithReplacement(char[] cArray, int n2, byte[] byArray, int n3, int[] nArray) {
        boolean bl = (0x800000L & TraceControllerImpl.feature) != 0L;
        try {
            int oraCharIdx;
            void byteOffset;
            byte[] oracleChars;
            void bytes;
            void charOffset;
            void nchars;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$11, this, cArray, n2, byArray, n3, nArray);
            }
            void srcLength = nchars[0];
            void chars_begin = charOffset;
            void chars_end = charOffset + srcLength;
            if (srcLength == false) {
                byte[] byArray2 = new byte[]{};
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$11, this, byArray2);
                    ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$11, this, null);
                }
                return byArray2;
            }
            if (bytes != null) {
                oracleChars = bytes;
                oraCharIdx = byteOffset;
            } else {
                oracleChars = new byte[srcLength * 4];
                oraCharIdx = 0;
            }
            for (void i2 = chars_begin; i2 < chars_end; ++i2) {
                void srcChars;
                if (srcChars[i2] >= 55296 && srcChars[i2] < 56320) {
                    if (i2 + true < srcLength && srcChars[i2 + true] >= 56320 && srcChars[i2 + true] <= 57343) {
                        oracleChars[oraCharIdx++] = this.noSurrogate ? this.m_oraCharReplacement : this.toOracleCharacterWithReplacement((char)srcChars[i2], (char)srcChars[i2 + true]);
                        ++i2;
                        continue;
                    }
                    oracleChars[oraCharIdx++] = this.m_oraCharReplacement;
                    continue;
                }
                oracleChars[oraCharIdx++] = srcChars[i2] < 128 && this.strictASCII ? (byte)srcChars[i2] : this.toOracleCharacterWithReplacement((char)srcChars[i2]);
            }
            nchars[0] = oraCharIdx - byteOffset;
            if (bytes == null && oraCharIdx < oracleChars.length) {
                byte[] returnArray = new byte[oraCharIdx];
                System.arraycopy(oracleChars, 0, returnArray, 0, oraCharIdx);
                byte[] byArray3 = returnArray;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$11, this, byArray3);
                    ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$11, this, null);
                }
                return returnArray;
            }
            byte[] byArray4 = oracleChars;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$11, this, byArray4);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$11, this, null);
            }
            return oracleChars;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void buildUnicodeToOracleMapping() {
        boolean bl = (0x800000L & TraceControllerImpl.feature) != 0L;
        try {
            int l4Key;
            int l3Key;
            int l2Key;
            int l1Key;
            char[] range;
            Object key;
            int ucsCodePt;
            int i2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$12, this, new Object[0]);
            }
            this.m_oraCharLevel1 = new char[256];
            this.m_oraCharSurrogateLevel = null;
            this.m_oraCharLevel2 = null;
            Vector<int[]> mapStore = new Vector<int[]>(45055, 12287);
            Hashtable htable = new Hashtable();
            Hashtable htable2 = new Hashtable();
            int mapCount = this.m_ucsChar.length;
            char lev2Freeptr = '\u0000';
            char surLevFreeptr = '\u0000';
            for (i2 = 0; i2 < 256; ++i2) {
                this.m_oraCharLevel1[i2] = 65535;
            }
            for (i2 = 0; i2 < mapCount; ++i2) {
                ucsCodePt = this.m_ucsChar[i2];
                if (ucsCodePt == -1) continue;
                int[] store = new int[]{ucsCodePt, i2};
                mapStore.addElement(store);
                this.storeMappingRange(ucsCodePt, htable, htable2);
            }
            if (this.extraUnicodeToOracleMapping != null) {
                mapCount = this.extraUnicodeToOracleMapping.length;
                for (i2 = 0; i2 < mapCount; ++i2) {
                    ucsCodePt = this.extraUnicodeToOracleMapping[i2][0];
                    this.storeMappingRange(ucsCodePt, htable, htable2);
                }
            }
            Enumeration enumerator = htable.keys();
            int surLevSize = 0;
            int oraCharLevel2Size = 0;
            while (enumerator.hasMoreElements()) {
                key = enumerator.nextElement();
                range = (char[])htable.get(key);
                if (range == null) continue;
                surLevSize += 256;
            }
            enumerator = htable2.keys();
            while (enumerator.hasMoreElements()) {
                key = enumerator.nextElement();
                range = (char[])htable2.get(key);
                if (range == null) continue;
                oraCharLevel2Size += 256;
            }
            if (surLevSize != 0) {
                this.m_oraCharSurrogateLevel = new char[surLevSize];
            }
            if (oraCharLevel2Size != 0) {
                this.m_oraCharLevel2 = new char[oraCharLevel2Size + 256];
            }
            for (i2 = 0; i2 < surLevSize; ++i2) {
                this.m_oraCharSurrogateLevel[i2] = 65535;
            }
            for (i2 = 0; i2 < oraCharLevel2Size + 256; ++i2) {
                this.m_oraCharLevel2[i2] = 65535;
            }
            for (i2 = 0; i2 < mapStore.size(); ++i2) {
                int[] store = (int[])mapStore.elementAt(i2);
                l1Key = store[0] >> 24 & 0xFF;
                l2Key = store[0] >> 16 & 0xFF;
                l3Key = store[0] >> 8 & 0xFF;
                l4Key = store[0] & 0xFF;
                if (l1Key >= 216 && l1Key < 220) {
                    if (this.m_oraCharLevel1[l1Key] == '\uffff') {
                        this.m_oraCharLevel1[l1Key] = surLevFreeptr;
                        surLevFreeptr = (char)(surLevFreeptr + 256);
                    }
                    if (this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[l1Key] + l2Key] == '\uffff') {
                        this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[l1Key] + l2Key] = surLevFreeptr;
                        surLevFreeptr = (char)(surLevFreeptr + 256);
                    }
                    if (this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[l1Key] + l2Key] + l3Key] == '\uffff') {
                        this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[l1Key] + l2Key] + l3Key] = lev2Freeptr;
                        lev2Freeptr = (char)(lev2Freeptr + 256);
                    }
                    if (this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[l1Key] + l2Key] + l3Key] + l4Key] != '\uffff') continue;
                    this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[l1Key] + l2Key] + l3Key] + l4Key] = (char)(store[1] & 0xFFFF);
                    continue;
                }
                if (this.m_oraCharLevel1[l3Key] == '\uffff') {
                    this.m_oraCharLevel1[l3Key] = lev2Freeptr;
                    lev2Freeptr = (char)(lev2Freeptr + 256);
                }
                if (this.m_oraCharLevel2[this.m_oraCharLevel1[l3Key] + l4Key] != '\uffff') continue;
                this.m_oraCharLevel2[this.m_oraCharLevel1[l3Key] + l4Key] = (char)(store[1] & 0xFFFF);
            }
            if (this.extraUnicodeToOracleMapping != null) {
                mapCount = this.extraUnicodeToOracleMapping.length;
                for (i2 = 0; i2 < mapCount; ++i2) {
                    ucsCodePt = this.extraUnicodeToOracleMapping[i2][0];
                    l1Key = ucsCodePt >>> 24 & 0xFF;
                    l2Key = ucsCodePt >>> 16 & 0xFF;
                    l3Key = ucsCodePt >>> 8 & 0xFF;
                    l4Key = ucsCodePt & 0xFF;
                    if (l1Key >= 216 && l1Key < 220) {
                        if (this.m_oraCharLevel1[l1Key] == '\uffff') {
                            this.m_oraCharLevel1[l1Key] = surLevFreeptr;
                            surLevFreeptr = (char)(surLevFreeptr + 256);
                        }
                        if (this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[l1Key] + l2Key] == '\uffff') {
                            this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[l1Key] + l2Key] = surLevFreeptr;
                            surLevFreeptr = (char)(surLevFreeptr + 256);
                        }
                        if (this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[l1Key] + l2Key] + l3Key] == '\uffff') {
                            this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[l1Key] + l2Key] + l3Key] = lev2Freeptr;
                            lev2Freeptr = (char)(lev2Freeptr + 256);
                        }
                        this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[l1Key] + l2Key] + l3Key] + l4Key] = (char)(this.extraUnicodeToOracleMapping[i2][1] & 0xFF);
                        continue;
                    }
                    if (this.m_oraCharLevel1[l3Key] == '\uffff') {
                        this.m_oraCharLevel1[l3Key] = lev2Freeptr;
                        lev2Freeptr = (char)(lev2Freeptr + 256);
                    }
                    this.m_oraCharLevel2[this.m_oraCharLevel1[l3Key] + l4Key] = (char)(this.extraUnicodeToOracleMapping[i2][1] & 0xFFFF);
                }
            }
            this.noSurrogate = this.m_oraCharSurrogateLevel == null;
            this.strictASCII = true;
            for (i2 = 0; i2 < 128; ++i2) {
                if (this.m_oraCharLevel2[i2] == i2) continue;
                this.strictASCII = false;
                break;
            }
            for (i2 = 0; i2 < 256; ++i2) {
                if (this.m_oraCharLevel1[i2] != '\uffff') continue;
                this.m_oraCharLevel1[i2] = (char)oraCharLevel2Size;
            }
            this.m_oraCharLevel2Size = oraCharLevel2Size;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$12, this);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$12, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void extractCodepoints(Vector vector) {
        boolean bl = (0x800000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$13, this, vector);
            }
            int begin = 0;
            int end = 255;
            for (int x2 = begin; x2 <= end; ++x2) {
                try {
                    void vtable;
                    int[] codepointPair = new int[]{x2, this.toUnicode((byte)x2)};
                    vtable.addElement(codepointPair);
                    continue;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$13, this);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$13, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void extractExtraMappings(Vector vector) {
        boolean bl = (0x800000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$14, this, vector);
            }
            if (this.extraUnicodeToOracleMapping == null) {
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$14, this);
                    ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$14, this, null);
                }
                return;
            }
            for (int x2 = 0; x2 < this.extraUnicodeToOracleMapping.length; ++x2) {
                void vtable;
                int[] codepointPair = new int[]{this.extraUnicodeToOracleMapping[x2][0], this.extraUnicodeToOracleMapping[x2][1]};
                vtable.addElement(codepointPair);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$14, this);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$14, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean hasExtraMappings() {
        boolean bl = (0x800000L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$15, this, new Object[0]);
            }
            boolean bl3 = bl2 = this.extraUnicodeToOracleMapping != null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$15, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$15, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public char getOraChar1ByteRep() {
        boolean bl = (0x800000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$16, this, new Object[0]);
            }
            char c2 = (char)this.m_oraCharReplacement;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$16, this, Character.valueOf(c2));
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$16, this, null);
            }
            return c2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$16, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public char getOraChar2ByteRep() {
        boolean bl = (0x800000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$17, this, new Object[0]);
            }
            char c2 = '\u0000';
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$17, this, Character.valueOf(c2));
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$17, this, null);
            }
            return '\u0000';
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$17, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int getUCS2CharRep() {
        boolean bl = (0x800000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$18, this, new Object[0]);
            }
            int n2 = this.m_ucsReplacement;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$18, this, n2);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$18, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$18, this, throwable2);
            }
            throw throwable;
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        boolean bl = (0x800000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$19, this, new Object[0]);
            }
            OracleConnection oracleConnection = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$19, this, oracleConnection);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$19, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, CharacterConverter1Byte.class, $$$methodRef$$$19, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$20 = CharacterConverter1Byte.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$19 = CharacterConverter1Byte.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$18 = CharacterConverter1Byte.class.getDeclaredMethod("getUCS2CharRep", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$17 = CharacterConverter1Byte.class.getDeclaredMethod("getOraChar2ByteRep", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$16 = CharacterConverter1Byte.class.getDeclaredMethod("getOraChar1ByteRep", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$15 = CharacterConverter1Byte.class.getDeclaredMethod("hasExtraMappings", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$14 = CharacterConverter1Byte.class.getDeclaredMethod("extractExtraMappings", Vector.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$13 = CharacterConverter1Byte.class.getDeclaredMethod("extractCodepoints", Vector.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$12 = CharacterConverter1Byte.class.getDeclaredMethod("buildUnicodeToOracleMapping", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$11 = CharacterConverter1Byte.class.getDeclaredMethod("toOracleStringWithReplacement", char[].class, Integer.TYPE, byte[].class, Integer.TYPE, int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$10 = CharacterConverter1Byte.class.getDeclaredMethod("toOracleStringWithReplacement", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$9 = CharacterConverter1Byte.class.getDeclaredMethod("toOracleString", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$8 = CharacterConverter1Byte.class.getDeclaredMethod("toUnicodeStringWithReplacement", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$7 = CharacterConverter1Byte.class.getDeclaredMethod("toUnicodeString", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$6 = CharacterConverter1Byte.class.getDeclaredMethod("toUnicodeChars", byte[].class, Integer.TYPE, char[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$5 = CharacterConverter1Byte.class.getDeclaredMethod("toOracleCharacterWithReplacement", Character.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$4 = CharacterConverter1Byte.class.getDeclaredMethod("toOracleCharacterWithReplacement", Character.TYPE, Character.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$3 = CharacterConverter1Byte.class.getDeclaredMethod("toOracleCharacter", Character.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$2 = CharacterConverter1Byte.class.getDeclaredMethod("toOracleCharacter", Character.TYPE, Character.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$1 = CharacterConverter1Byte.class.getDeclaredMethod("toUnicodeWithReplacement", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$0 = CharacterConverter1Byte.class.getDeclaredMethod("toUnicode", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
    }
}

