/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.linter;

import java.sql.Connection;
import java.util.Collection;
import schemacrawler.filter.TableTypesFilter;
import schemacrawler.schema.Table;
import schemacrawler.tools.lint.BaseLinter;
import schemacrawler.tools.lint.LintCollector;
import us.fatehi.utility.property.PropertyName;

class LinterTableWithNoIndexes
extends BaseLinter {
    LinterTableWithNoIndexes(PropertyName propertyName, LintCollector lintCollector) {
        super(propertyName, lintCollector);
        this.setTableTypesFilter(new TableTypesFilter(new String[]{"TABLE"}));
    }

    @Override
    public String getSummary() {
        return "no indexes";
    }

    @Override
    protected void lint(Table table, Connection connection) {
        if (table != null) {
            Collection indexes = table.getIndexes();
            if (table.getPrimaryKey() == null && indexes.isEmpty()) {
                this.addTableLint(table, this.getSummary());
            }
        }
    }
}

