/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.jaxwsmodel.project;

import java.io.IOException;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ant.AntBuildExtender;
import org.netbeans.modules.websvc.api.jaxws.project.JaxWsBuildScriptExtensionProvider;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.jaxwsmodel.project.TransformerUtils;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;

public class EjbBuildScriptExtensionProvider
implements JaxWsBuildScriptExtensionProvider {
    static String JAX_WS_STYLESHEET_RESOURCE = "/org/netbeans/modules/websvc/jaxwsmodel/resources/jaxws-ejb.xsl";
    private Project project;

    public EjbBuildScriptExtensionProvider(Project project) {
        this.project = project;
    }

    @Override
    public void addJaxWsExtension(AntBuildExtender ext) throws IOException {
        TransformerUtils.transformClients(this.project.getProjectDirectory(), JAX_WS_STYLESHEET_RESOURCE, true);
        FileObject jaxws_build = this.project.getProjectDirectory().getFileObject("nbproject/jaxws-build.xml");
        assert (jaxws_build != null);
        AntBuildExtender.Extension extension = ext.getExtension("jaxws");
        if (extension == null) {
            extension = ext.addExtension("jaxws", jaxws_build);
            int clientsLength = 0;
            int fromWsdlServicesLength = 0;
            JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
            if (jaxWsModel != null) {
                clientsLength = jaxWsModel.getClients().length;
                for (Service service : jaxWsModel.getServices()) {
                    if (service.getWsdlUrl() == null) continue;
                    ++fromWsdlServicesLength;
                }
            }
            if (clientsLength > 0) {
                extension.addDependency("-pre-pre-compile", "wsimport-client-generate");
            }
            if (fromWsdlServicesLength > 0) {
                extension.addDependency("-pre-pre-compile", "wsimport-service-generate");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeJaxWsExtension(final AntBuildExtender ext) throws IOException {
        FileLock fileLock;
        FileObject jaxws_build;
        AntBuildExtender.Extension extension = ext.getExtension("jaxws");
        if (extension != null) {
            ProjectManager.mutex().writeAccess(new Runnable(){
                final /* synthetic */ EjbBuildScriptExtensionProvider this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    ext.removeExtension("jaxws");
                }
            });
            ProjectManager.getDefault().saveProject(this.project);
        }
        if ((jaxws_build = this.project.getProjectDirectory().getFileObject("nbproject/jaxws-build.xml")) != null && (fileLock = jaxws_build.lock()) != null) {
            try {
                jaxws_build.delete(fileLock);
            }
            finally {
                fileLock.releaseLock();
            }
        }
    }

    @Override
    public void handleJaxWsModelChanges(JaxWsModel model) throws IOException {
        AntBuildExtender ext = (AntBuildExtender)this.project.getLookup().lookup(AntBuildExtender.class);
        if (ext != null) {
            int clientsLength = 0;
            int servicesLength = 0;
            int fromWsdlServicesLength = 0;
            JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
            if (jaxWsModel != null) {
                clientsLength = jaxWsModel.getClients().length;
                servicesLength = jaxWsModel.getServices().length;
                for (Service service : jaxWsModel.getServices()) {
                    if (service.getWsdlUrl() == null) continue;
                    ++fromWsdlServicesLength;
                }
            }
            if (clientsLength + servicesLength == 0) {
                this.removeJaxWsExtension(ext);
            } else {
                this.changeJaxWsExtension(ext, servicesLength, fromWsdlServicesLength, clientsLength);
            }
            ProjectManager.getDefault().saveProject(this.project);
        }
    }

    private void changeJaxWsExtension(AntBuildExtender ext, int servicesLength, int fromWsdlServicesLength, int clientsLength) throws IOException {
        TransformerUtils.transformClients(this.project.getProjectDirectory(), JAX_WS_STYLESHEET_RESOURCE, true);
        FileObject jaxws_build = this.project.getProjectDirectory().getFileObject("nbproject/jaxws-build.xml");
        assert (jaxws_build != null);
        AntBuildExtender.Extension extension = ext.getExtension("jaxws");
        boolean extensionCreated = false;
        if (extension == null) {
            extension = ext.addExtension("jaxws", jaxws_build);
            extensionCreated = true;
        }
        if (clientsLength > 0) {
            extension.addDependency("-pre-pre-compile", "wsimport-client-generate");
        } else if (!extensionCreated) {
            extension.removeDependency("-pre-pre-compile", "wsimport-client-generate");
        }
        if (fromWsdlServicesLength > 0) {
            extension.addDependency("-pre-pre-compile", "wsimport-service-generate");
        } else if (!extensionCreated) {
            extension.removeDependency("-pre-pre-compile", "wsimport-service-generate");
        }
    }
}

