/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.visualeditor.querymodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.api.db.sql.support.SQLIdentifiers;
import org.netbeans.modules.db.sql.visualeditor.querymodel.ColumnNode;
import org.netbeans.modules.db.sql.visualeditor.querymodel.OrderBy;
import org.netbeans.modules.db.sql.visualeditor.querymodel.SortSpecification;

public class OrderByNode
implements OrderBy {
    List<SortSpecification> _sortSpecificationList;

    public OrderByNode() {
    }

    public OrderByNode(List sortSpecificationList) {
        this._sortSpecificationList = sortSpecificationList;
    }

    @Override
    public String genText(SQLIdentifiers.Quoter quoter) {
        String res = "";
        if (this._sortSpecificationList != null && this._sortSpecificationList.size() > 0) {
            res = " ORDER BY " + this._sortSpecificationList.get(0).genText(quoter);
            for (int i = 1; i < this._sortSpecificationList.size(); ++i) {
                res = res + ",                     " + this._sortSpecificationList.get(i).genText(quoter);
            }
        }
        return res;
    }

    void renameTableSpec(String oldTableSpec, String corrName) {
        if (this._sortSpecificationList != null) {
            for (int i = 0; i < this._sortSpecificationList.size(); ++i) {
                this._sortSpecificationList.get(i).renameTableSpec(oldTableSpec, corrName);
            }
        }
    }

    @Override
    public void removeSortSpecification(String tableSpec) {
        if (this._sortSpecificationList != null) {
            for (int i = 0; i < this._sortSpecificationList.size(); ++i) {
                ColumnNode col = (ColumnNode)this._sortSpecificationList.get(i).getColumn();
                if (!col.getTableSpec().equals(tableSpec)) continue;
                this._sortSpecificationList.remove(i);
                --i;
            }
        }
    }

    @Override
    public void removeSortSpecification(String tableSpec, String columnName) {
        if (this._sortSpecificationList != null) {
            for (int i = 0; i < this._sortSpecificationList.size(); ++i) {
                ColumnNode col = (ColumnNode)this._sortSpecificationList.get(i).getColumn();
                if (!col.matches(tableSpec, columnName)) continue;
                this._sortSpecificationList.remove(i);
                --i;
            }
        }
    }

    @Override
    public void addSortSpecification(String tableSpec, String columnName, String direction, int order) {
        SortSpecification sortSpec = new SortSpecification(new ColumnNode(tableSpec, columnName), direction);
        if (this._sortSpecificationList == null) {
            this._sortSpecificationList = new ArrayList<SortSpecification>();
        }
        this._sortSpecificationList.add(order - 1, sortSpec);
    }

    @Override
    public int getSortSpecificationCount() {
        return this._sortSpecificationList != null ? this._sortSpecificationList.size() : 0;
    }

    @Override
    public SortSpecification getSortSpecification(int i) {
        return this._sortSpecificationList != null ? this._sortSpecificationList.get(i) : null;
    }

    @Override
    public void getReferencedColumns(Collection columns) {
        if (this._sortSpecificationList != null) {
            for (int i = 0; i < this._sortSpecificationList.size(); ++i) {
                this._sortSpecificationList.get(i).getReferencedColumns(columns);
            }
        }
    }
}

