/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.multiview.ui;

import java.awt.BorderLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.netbeans.modules.xml.multiview.ui.ErrorPanel;
import org.netbeans.modules.xml.multiview.ui.PanelView;
import org.openide.actions.SaveAction;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

public abstract class AbstractDesignEditor
extends TopComponent
implements ExplorerManager.Provider {
    public static final String PROPERTY_FLUSH_DATA = "Flush Data";
    private static final String ACTION_INVOKE_HELP = "invokeHelp";
    protected JComponent structureView;
    protected PanelView contentView;
    protected Action helpAction;
    private ExplorerManager manager;
    protected static String iconURL = "/org/netbeans/modules/form/resources/inspector.gif";
    protected static final long serialVersionUID = 1L;

    public AbstractDesignEditor() {
        this.init();
    }

    private void init() {
        this.manager = new ExplorerManager();
        this.helpAction = new HelpAction();
        ActionMap map = this.getActionMap();
        this.getInputMap(1).put(KeyStroke.getKeyStroke(112, 0), ACTION_INVOKE_HELP);
        map.put(ACTION_INVOKE_HELP, this.helpAction);
        SaveAction act = (SaveAction)SystemAction.get(SaveAction.class);
        KeyStroke stroke = KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        this.getInputMap(1).put(stroke, "save");
        map.put("save", (Action)act);
        this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this.manager, (ActionMap)map));
        this.manager.addPropertyChangeListener((PropertyChangeListener)new NodeSelectedListener());
        this.setLayout(new BorderLayout());
    }

    public AbstractDesignEditor(PanelView contentView) {
        this.init();
        this.contentView = contentView;
        this.setRootContext(contentView.getRoot());
    }

    public void setContentView(PanelView panelView) {
        this.contentView = panelView;
        this.setRootContext(panelView.getRoot());
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    public void componentActivated() {
        ExplorerUtils.activateActions((ExplorerManager)this.manager, (boolean)true);
    }

    public void componentDeactivated() {
        ExplorerUtils.activateActions((ExplorerManager)this.manager, (boolean)false);
    }

    public void componentClosed() {
        super.componentClosed();
    }

    public void componentOpened() {
        super.componentOpened();
    }

    public void componentShowing() {
        super.componentShowing();
    }

    public void componentHidden() {
        super.componentShowing();
    }

    public void setRootContext(Node node) {
        this.getExplorerManager().setRootContext(node);
    }

    public PanelView getContentView() {
        return this.contentView;
    }

    public JComponent getStructureView() {
        if (this.structureView == null) {
            this.structureView = this.createStructureComponent();
            this.structureView.addPropertyChangeListener(new NodeSelectedListener());
        }
        return this.structureView;
    }

    public abstract JComponent createStructureComponent();

    public abstract ErrorPanel getErrorPanel();

    public void open() {
        if (this.contentView != null) {
            this.contentView.open();
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("ComponentPanel");
    }

    public void fireVetoableChange(String propertyName, Object oldValue, Object newValue) throws PropertyVetoException {
        super.fireVetoableChange(propertyName, oldValue, newValue);
    }

    final class HelpAction
    extends AbstractAction {
        HelpCtx.Provider provider;

        public HelpAction() {
            super(NbBundle.getMessage(AbstractDesignEditor.class, (String)"CTL_Help"), new ImageIcon(((Object)((Object)AbstractDesignEditor.this)).getClass().getResource("/org/netbeans/modules/xml/multiview/resources/help.gif")));
            this.provider = null;
        }

        @Override
        public boolean isEnabled() {
            return this.getContext() != null;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HelpCtx ctx = this.getContext();
            if (ctx == null || !ctx.display()) {
                Toolkit.getDefaultToolkit().beep();
            }
        }

        private HelpCtx getContext() {
            Node[] selectedNodes = AbstractDesignEditor.this.getExplorerManager().getSelectedNodes();
            if (selectedNodes != null && selectedNodes.length > 0) {
                return selectedNodes[0].getHelpCtx();
            }
            return null;
        }
    }

    class NodeSelectedListener
    implements PropertyChangeListener {
        NodeSelectedListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (AbstractDesignEditor.this.contentView.isSectionHeaderClicked()) {
                AbstractDesignEditor.this.contentView.setSectionHeaderClicked(false);
                return;
            }
            if (!"selectedNodes".equals(evt.getPropertyName())) {
                return;
            }
            Node[] selectedNodes = AbstractDesignEditor.this.getExplorerManager().getSelectedNodes();
            if (selectedNodes != null && selectedNodes.length > 0) {
                AbstractDesignEditor.this.contentView.showSelection(selectedNodes);
            }
        }
    }
}

