/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.util;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.netbeans.modules.versioning.util.Utils;

public class FileCollection {
    private static final char FLAT_FOLDER_MARKER = '*';
    private final Set<File> storage = new HashSet<File>(1);

    public synchronized void load(Preferences prefs, String key) {
        List<String> paths = Utils.getStringList(prefs, key);
        this.storage.clear();
        for (String path : paths) {
            if (path.charAt(0) == '*') {
                this.storage.add(VersioningSupport.getFlat((String)path.substring(1)));
                continue;
            }
            this.storage.add(new File(path));
        }
    }

    public synchronized void save(Preferences prefs, String key) {
        ArrayList<String> paths = new ArrayList<String>(this.storage.size());
        for (File file : this.storage) {
            if (VersioningSupport.isFlat((File)file)) {
                paths.add("*" + file.getAbsolutePath());
                continue;
            }
            paths.add(file.getAbsolutePath());
        }
        Utils.put(prefs, key, paths);
    }

    public synchronized boolean contains(File file) {
        for (File element : this.storage) {
            if (!Utils.isAncestorOrEqual(element, file)) continue;
            return true;
        }
        return false;
    }

    public synchronized void add(File file) {
        Iterator<File> i = this.storage.iterator();
        while (i.hasNext()) {
            File element = i.next();
            if (Utils.isAncestorOrEqual(element, file)) {
                return;
            }
            if (!Utils.isAncestorOrEqual(file, element)) continue;
            i.remove();
        }
        this.storage.add(file);
    }

    public synchronized void remove(File file) {
        Iterator<File> i = this.storage.iterator();
        while (i.hasNext()) {
            File element = i.next();
            if (!Utils.isAncestorOrEqual(element, file) && !Utils.isAncestorOrEqual(file, element)) continue;
            i.remove();
        }
    }
}

