/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.gototest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.gototest.Bundle;
import org.netbeans.spi.gototest.TestLocator;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public final class TestOppositesLocator {
    private static final RequestProcessor WORKER = new RequestProcessor(TestOppositesLocator.class.getName(), 1, false, false);

    public static TestOppositesLocator getDefault() {
        return new TestOppositesLocator();
    }

    private TestOppositesLocator() {
    }

    public CompletableFuture<LocatorResult> findOpposites(FileObject fo, int caretOffset) {
        if (!this.isSupportedFileType(fo)) {
            CompletableFuture<LocatorResult> result = new CompletableFuture<LocatorResult>();
            result.complete(new LocatorResult(Bundle.No_Test_Or_Tested_Class_Found(), null, null));
            return result;
        }
        return this.populateLocationResults(fo, caretOffset).thenApply(locations -> new LocatorResult(null, locations.stream().filter(l -> l.getErrorMessage() != null).map(l -> l.getErrorMessage()).collect(Collectors.toList()), locations.stream().filter(l -> l.getFileObject() != null).map(l -> new Location(l.getFileObject(), l.getOffset())).collect(Collectors.toList())));
    }

    private CompletableFuture<? extends List<TestLocator.LocationResult>> populateLocationResults(FileObject fo, int caretOffset) {
        Collection locators = Lookup.getDefault().lookupAll(TestLocator.class).stream().filter(tl -> tl.appliesTo(fo)).collect(Collectors.toList());
        CompletionStage<ArrayList<Object>> result = new CompletableFuture();
        result.complete(new ArrayList());
        for (TestLocator locator : locators) {
            if (!locator.appliesTo(fo)) continue;
            final CompletableFuture currentFuture = new CompletableFuture();
            if (locator.asynchronous()) {
                locator.findOpposite(fo, caretOffset, new TestLocator.LocationListener(){
                    final /* synthetic */ TestOppositesLocator this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void foundLocation(FileObject fo, TestLocator.LocationResult location) {
                        List<Object> resultList = location != null ? Collections.singletonList(location) : Collections.emptyList();
                        currentFuture.complete(resultList);
                    }
                });
            } else {
                WORKER.post(() -> {
                    try {
                        TestLocator.LocationResult opposite = locator.findOpposite(fo, caretOffset);
                        List<Object> resultList = opposite != null ? Collections.singletonList(opposite) : Collections.emptyList();
                        currentFuture.complete(resultList);
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (Throwable t) {
                        currentFuture.completeExceptionally(t);
                    }
                });
            }
            result = result.thenCombine((CompletionStage)currentFuture, (accumulator, currentList) -> {
                accumulator.addAll(currentList);
                return accumulator;
            });
        }
        return result;
    }

    private TestLocator getLocatorFor(FileObject fo) {
        Collection locators = Lookup.getDefault().lookupAll(TestLocator.class);
        for (TestLocator locator : locators) {
            if (!locator.appliesTo(fo)) continue;
            return locator;
        }
        return null;
    }

    private boolean isSupportedFileType(FileObject fo) {
        TestLocator locator;
        TestLocator testLocator = locator = fo != null ? this.getLocatorFor(fo) : null;
        if (locator != null) {
            return locator.getFileType(fo) != TestLocator.FileType.NEITHER;
        }
        return false;
    }

    public static final class LocatorResult {
        private final String errorMessage;
        private final Collection<? extends String> providerErrors;
        private final Collection<? extends Location> locations;

        private LocatorResult(String errorMessage, List<? extends String> providerErrors, List<? extends Location> locations) {
            if (errorMessage == null && locations == null) {
                throw new IllegalArgumentException("Both errorMessage and locations is null!");
            }
            if (errorMessage != null && locations != null) {
                throw new IllegalArgumentException("Both errorMessage and locations is non-null!");
            }
            if (providerErrors == null ^ locations == null) {
                throw new IllegalArgumentException("Both providerErrors and locations must either be null or non-null");
            }
            this.errorMessage = errorMessage;
            this.providerErrors = providerErrors != null ? Collections.unmodifiableList(providerErrors) : null;
            this.locations = locations != null ? Collections.unmodifiableList(locations) : null;
        }

        @CheckForNull
        public String getErrorMessage() {
            return this.errorMessage;
        }

        @CheckForNull
        public Collection<? extends String> getProviderErrors() {
            return this.providerErrors;
        }

        @CheckForNull
        public Collection<? extends Location> getLocations() {
            return this.locations;
        }
    }

    public static final class Location {
        private final FileObject file;
        private final int offset;

        public Location(FileObject file, int offset) {
            this.file = file;
            this.offset = offset;
        }

        public FileObject getFileObject() {
            return this.file;
        }

        public int getOffset() {
            return this.offset;
        }

        public String getDisplayName() {
            return this.file != null ? this.file.getName() : Bundle.DN_Error();
        }
    }
}

