/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.java.customizer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.io.File;
import java.nio.file.Path;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.modules.gradle.java.api.GradleJavaSourceSet;
import org.netbeans.modules.gradle.java.customizer.Bundle;
import org.netbeans.modules.gradle.java.spi.support.JavaToolchainSupport;
import org.netbeans.modules.gradle.spi.nodes.NodeUtils;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class SourceSetPanel
extends JPanel {
    private static final String PROJECT_ICON = "org.netbeans.modules/gradle/resources/gradle.png";
    private static final String ARTIFACT_ICON = "org.netbeans.modules/gradle/resources/module-artifact.png";
    final Icon folderIcon = ImageUtilities.image2Icon((Image)NodeUtils.getTreeFolderIcon((boolean)false));
    final Icon projectIcon = ImageUtilities.loadImageIcon((String)"org.netbeans.modules/gradle/resources/gradle.png", (boolean)false);
    final Icon artifactIcon = ImageUtilities.loadImageIcon((String)"org.netbeans.modules/gradle/resources/module-artifact.png", (boolean)false);
    final Path relativeRoot;
    final GradleJavaSourceSet sourceSet;
    private final DefaultMutableTreeNode sourcesRoot = new DefaultMutableTreeNode(new Object());
    private final DefaultTreeModel sourcesModel = new DefaultTreeModel(this.sourcesRoot, true);
    private final DefaultMutableTreeNode argumentsRoot = new DefaultMutableTreeNode(new Object());
    private final DefaultTreeModel argumentsModel = new DefaultTreeModel(this.argumentsRoot, true);
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane6;
    private JTextField jtPlatform;
    private JLabel lbPlatform;
    private JList<File> lsAnnotationProcessors;
    private JList<File> lsCompile;
    private JList<File> lsRuntime;
    private JTextField tfOutputClasses;
    private JTextField tfOutputResources;
    private JTextField tfSourceLevel;
    private JTabbedPane tpDetails;
    private JTree trCompilerArgs;
    private JTree trSources;

    public SourceSetPanel(GradleJavaSourceSet sourceSet, File relativeTo) {
        JavaPlatform platform;
        this.sourceSet = sourceSet;
        this.relativeRoot = relativeTo.toPath();
        this.initComponents();
        File javaHome = sourceSet.getCompilerJavaHome(GradleJavaSourceSet.SourceType.JAVA);
        JavaPlatform javaPlatform = platform = javaHome != null ? JavaToolchainSupport.getDefault().platformByHome(javaHome) : JavaPlatform.getDefault();
        if (platform != null && platform.isValid()) {
            this.jtPlatform.setText(platform.getDisplayName());
            FileObject home = (FileObject)platform.getInstallFolders().iterator().next();
            this.jtPlatform.setToolTipText(home.getPath());
        } else {
            this.jtPlatform.setText(Bundle.LBL_BrokenPlatform(javaHome));
        }
        if (sourceSet.getSourcesCompatibility().equals(sourceSet.getTargetCompatibility())) {
            this.tfSourceLevel.setText(sourceSet.getSourcesCompatibility());
        } else {
            this.tfSourceLevel.setText(sourceSet.getSourcesCompatibility() + " / " + sourceSet.getTargetCompatibility());
        }
        if (!sourceSet.getOutputClassDirs().isEmpty()) {
            GradleJavaSourceSet.SourceType[] sb = new StringBuilder();
            String separator = "";
            for (File dir : sourceSet.getOutputClassDirs()) {
                sb.append(separator);
                sb.append(this.relativeRoot.relativize(dir.toPath()));
                separator = ", ";
            }
            this.tfOutputClasses.setText(sb.toString());
        }
        if (sourceSet.getOutputResources() != null) {
            this.tfOutputResources.setText(this.relativeRoot.relativize(sourceSet.getOutputResources().toPath()).toString());
        }
        for (GradleJavaSourceSet.SourceType type : GradleJavaSourceSet.SourceType.values()) {
            DefaultMutableTreeNode typeNode;
            if (!sourceSet.getSourceDirs(type).isEmpty()) {
                typeNode = new DefaultMutableTreeNode((Object)type);
                this.sourcesModel.insertNodeInto(typeNode, this.sourcesRoot, this.sourcesRoot.getChildCount());
                for (File dir : sourceSet.getSourceDirs(type)) {
                    this.sourcesModel.insertNodeInto(new DefaultMutableTreeNode(dir, false), typeNode, typeNode.getChildCount());
                }
                this.trSources.expandPath(new TreePath(typeNode.getPath()));
            }
            if (sourceSet.getCompilerArgs(type).isEmpty()) continue;
            typeNode = new DefaultMutableTreeNode((Object)type, true);
            this.argumentsModel.insertNodeInto(typeNode, this.argumentsRoot, this.argumentsRoot.getChildCount());
            for (String compilerArg : sourceSet.getCompilerArgs(type)) {
                this.argumentsModel.insertNodeInto(new DefaultMutableTreeNode(compilerArg, false), typeNode, typeNode.getChildCount());
            }
            this.trCompilerArgs.expandPath(new TreePath(typeNode.getPath()));
        }
        this.trSources.setCellRenderer(new MyTreeCellRenderer());
        DefaultListModel<File> compileModel = new DefaultListModel<File>();
        for (File file : sourceSet.getCompileClassPath()) {
            compileModel.addElement(file);
        }
        this.lsCompile.setModel(compileModel);
        this.lsCompile.setCellRenderer(new MyListCellRenderer());
        DefaultListModel<File> runtimeModel = new DefaultListModel<File>();
        for (File file : sourceSet.getRuntimeClassPath()) {
            runtimeModel.addElement(file);
        }
        this.lsRuntime.setModel(runtimeModel);
        this.lsRuntime.setCellRenderer(new MyListCellRenderer());
        DefaultListModel<File> apModel = new DefaultListModel<File>();
        for (File file : sourceSet.getAnnotationProcessorPath()) {
            apModel.addElement(file);
        }
        this.lsAnnotationProcessors.setModel(apModel);
        this.lsAnnotationProcessors.setCellRenderer(new MyListCellRenderer());
    }

    void addDetailsChangeListener(ChangeListener l) {
        this.tpDetails.addChangeListener(l);
    }

    void setActiveDetails(Details detail) {
        this.tpDetails.setSelectedIndex(detail.ordinal());
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.tpDetails = new JTabbedPane();
        this.jScrollPane1 = new JScrollPane();
        this.trSources = new JTree();
        this.jScrollPane2 = new JScrollPane();
        this.lsCompile = new JList();
        this.jScrollPane3 = new JScrollPane();
        this.lsRuntime = new JList();
        this.jScrollPane4 = new JScrollPane();
        this.lsAnnotationProcessors = new JList();
        this.jScrollPane6 = new JScrollPane();
        this.trCompilerArgs = new JTree();
        this.tfSourceLevel = new JTextField();
        this.tfOutputResources = new JTextField();
        this.tfOutputClasses = new JTextField();
        this.lbPlatform = new JLabel();
        this.jtPlatform = new JTextField();
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(SourceSetPanel.class, (String)"SourceSetPanel.jLabel1.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(SourceSetPanel.class, (String)"SourceSetPanel.jLabel2.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(SourceSetPanel.class, (String)"SourceSetPanel.jLabel3.text"));
        this.tpDetails.setTabPlacement(4);
        this.tpDetails.setMinimumSize(new Dimension(150, 32));
        this.trSources.setModel(this.sourcesModel);
        this.trSources.setRootVisible(false);
        this.jScrollPane1.setViewportView(this.trSources);
        this.tpDetails.addTab(Details.SOURCES.toString(), this.jScrollPane1);
        this.jScrollPane2.setViewportView(this.lsCompile);
        this.tpDetails.addTab(Details.COMPILE_CP.toString(), this.jScrollPane2);
        this.jScrollPane3.setViewportView(this.lsRuntime);
        this.tpDetails.addTab(Details.RUNTIME_CP.toString(), this.jScrollPane3);
        this.jScrollPane4.setViewportView(this.lsAnnotationProcessors);
        this.tpDetails.addTab(Details.ANNOTATION_PROC.toString(), this.jScrollPane4);
        this.trCompilerArgs.setModel(this.argumentsModel);
        this.trCompilerArgs.setRootVisible(false);
        this.jScrollPane6.setViewportView(this.trCompilerArgs);
        this.tpDetails.addTab(Details.COMPILER_ARGS.toString(), this.jScrollPane6);
        this.tfSourceLevel.setEditable(false);
        this.tfOutputResources.setEditable(false);
        this.tfOutputClasses.setEditable(false);
        this.lbPlatform.setLabelFor(this.jtPlatform);
        Mnemonics.setLocalizedText((JLabel)this.lbPlatform, (String)NbBundle.getMessage(SourceSetPanel.class, (String)"SourceSetPanel.lbPlatform.text"));
        this.jtPlatform.setEditable(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tpDetails, -1, 580, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tfOutputResources).addComponent(this.tfOutputClasses))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel3, -1, 157, Short.MAX_VALUE).addComponent(this.lbPlatform, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.tfSourceLevel, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jtPlatform)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbPlatform).addComponent(this.jtPlatform, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.tfSourceLevel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tpDetails, -1, 202, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.tfOutputClasses, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.tfOutputResources, -2, -1, -2)).addGap(12, 12, 12)));
    }

    private class MyTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private MyTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component comp = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (comp instanceof JLabel && value instanceof DefaultMutableTreeNode) {
                JLabel label = (JLabel)comp;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                if (node.getUserObject() instanceof File) {
                    File dir = (File)node.getUserObject();
                    String relative = SourceSetPanel.this.relativeRoot.relativize(dir.toPath()).toString();
                    label.setText(relative);
                    label.setToolTipText(dir.getAbsolutePath());
                    label.setIcon(SourceSetPanel.this.folderIcon);
                    label.setEnabled(dir.exists());
                }
            }
            return comp;
        }
    }

    private class MyListCellRenderer
    extends DefaultListCellRenderer {
        private MyListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component comp = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (comp instanceof JLabel && value instanceof File) {
                JLabel label = (JLabel)comp;
                File file = (File)value;
                Path path = file.toPath();
                if (path.startsWith(SourceSetPanel.this.relativeRoot)) {
                    String relative = SourceSetPanel.this.relativeRoot.relativize(path).toString();
                    label.setText("<html><b>" + relative + "</b>");
                    label.setIcon(relative.endsWith(".jar") ? SourceSetPanel.this.projectIcon : SourceSetPanel.this.folderIcon);
                } else {
                    label.setText(path.getFileName().toString());
                    label.setIcon(SourceSetPanel.this.artifactIcon);
                }
                label.setToolTipText(file.getAbsolutePath());
                label.setEnabled(file.exists());
            }
            return comp;
        }
    }

    static enum Details {
        SOURCES,
        COMPILE_CP,
        RUNTIME_CP,
        ANNOTATION_PROC,
        COMPILER_ARGS;


        public String toString() {
            return NbBundle.getMessage(SourceSetPanel.class, (String)("sourceSetDetail." + this.name()));
        }
    }
}

