/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tools;

import java.io.IOException;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.languagetool.tools.DiffsAsMatches;
import org.languagetool.tools.PseudoMatch;

public class DiffsAsMatchesTest {
    @Test
    public void testDiffsAsMatches() throws IOException {
        DiffsAsMatches diffsAsMatches = new DiffsAsMatches();
        String original0 = "This is a \"thing\". This is.";
        String revised0 = "This is a \"thing.\" This is.";
        List matches0 = diffsAsMatches.getPseudoMatches(original0, revised0);
        Assert.assertEquals((long)1L, (long)matches0.size());
        Assert.assertEquals((Object)"[\"thing.\"]", (Object)((PseudoMatch)matches0.get(0)).getReplacements().toString());
        Assert.assertEquals((long)10L, (long)((PseudoMatch)matches0.get(0)).getFromPos());
        Assert.assertEquals((long)18L, (long)((PseudoMatch)matches0.get(0)).getToPos());
        String original = "This are a sentence with too mistakes.";
        String revised = "This is a sentence with two mistakes.";
        List matches = diffsAsMatches.getPseudoMatches(original, revised);
        Assert.assertEquals((long)matches.size(), (long)2L);
        Assert.assertEquals((Object)((PseudoMatch)matches.get(0)).getReplacements().toString(), (Object)"[is]");
        Assert.assertEquals((long)((PseudoMatch)matches.get(0)).getFromPos(), (long)5L);
        Assert.assertEquals((long)((PseudoMatch)matches.get(0)).getToPos(), (long)8L);
        Assert.assertEquals((Object)((PseudoMatch)matches.get(1)).getReplacements().toString(), (Object)"[two]");
        Assert.assertEquals((long)((PseudoMatch)matches.get(1)).getFromPos(), (long)25L);
        Assert.assertEquals((long)((PseudoMatch)matches.get(1)).getToPos(), (long)28L);
        original = "I am going to er remove one word.";
        revised = "I am going to remove one word.";
        matches = diffsAsMatches.getPseudoMatches(original, revised);
        Assert.assertEquals((long)1L, (long)matches.size());
        Assert.assertEquals((Object)"[]", (Object)((PseudoMatch)matches.get(0)).getReplacements().toString());
        Assert.assertEquals((long)14L, (long)((PseudoMatch)matches.get(0)).getFromPos());
        Assert.assertEquals((long)17L, (long)((PseudoMatch)matches.get(0)).getToPos());
        original = "And I am going to remove one word.";
        revised = "I am going to remove one word.";
        matches = diffsAsMatches.getPseudoMatches(original, revised);
        Assert.assertEquals((long)1L, (long)matches.size());
        Assert.assertEquals((Object)"[]", (Object)((PseudoMatch)matches.get(0)).getReplacements().toString());
        Assert.assertEquals((long)0L, (long)((PseudoMatch)matches.get(0)).getFromPos());
        Assert.assertEquals((long)4L, (long)((PseudoMatch)matches.get(0)).getToPos());
        original = "I am going to add word.";
        revised = "I am going to add one word.";
        matches = diffsAsMatches.getPseudoMatches(original, revised);
        Assert.assertEquals((long)1L, (long)matches.size());
        Assert.assertEquals((Object)"[add one]", (Object)((PseudoMatch)matches.get(0)).getReplacements().toString());
        Assert.assertEquals((long)14L, (long)((PseudoMatch)matches.get(0)).getFromPos());
        Assert.assertEquals((long)17L, (long)((PseudoMatch)matches.get(0)).getToPos());
        original = "a word at the start.";
        revised = "Add a word at the start.";
        matches = diffsAsMatches.getPseudoMatches(original, revised);
        Assert.assertEquals((long)1L, (long)matches.size());
        Assert.assertEquals((Object)"[Add a]", (Object)((PseudoMatch)matches.get(0)).getReplacements().toString());
        Assert.assertEquals((long)0L, (long)((PseudoMatch)matches.get(0)).getFromPos());
        Assert.assertEquals((long)1L, (long)((PseudoMatch)matches.get(0)).getToPos());
        original = "Add word at position 1.";
        revised = "Add a word at position 1.";
        matches = diffsAsMatches.getPseudoMatches(original, revised);
        Assert.assertEquals((long)1L, (long)matches.size());
        Assert.assertEquals((Object)"[Add a]", (Object)((PseudoMatch)matches.get(0)).getReplacements().toString());
        Assert.assertEquals((long)0L, (long)((PseudoMatch)matches.get(0)).getFromPos());
        Assert.assertEquals((long)3L, (long)((PseudoMatch)matches.get(0)).getToPos());
        original = "Esta serealiza cada semana.";
        revised = "Esta se realiza cada semana.";
        matches = diffsAsMatches.getPseudoMatches(original, revised);
        Assert.assertEquals((long)1L, (long)matches.size());
        Assert.assertEquals((Object)"[se realiza]", (Object)((PseudoMatch)matches.get(0)).getReplacements().toString());
        Assert.assertEquals((long)5L, (long)((PseudoMatch)matches.get(0)).getFromPos());
        Assert.assertEquals((long)14L, (long)((PseudoMatch)matches.get(0)).getToPos());
        original = "Una cosa,una altra.";
        revised = "Una cosa, una altra.";
        matches = diffsAsMatches.getPseudoMatches(original, revised);
        Assert.assertEquals((long)1L, (long)matches.size());
        Assert.assertEquals((Object)"[cosa, ]", (Object)((PseudoMatch)matches.get(0)).getReplacements().toString());
        Assert.assertEquals((long)4L, (long)((PseudoMatch)matches.get(0)).getFromPos());
        Assert.assertEquals((long)9L, (long)((PseudoMatch)matches.get(0)).getToPos());
        original = "Que el a\u00f1o nuevo empez\u00f3.";
        revised = "El a\u00f1o nuevo empez\u00f3.";
        matches = diffsAsMatches.getPseudoMatches(original, revised);
        Assert.assertEquals((long)1L, (long)matches.size());
        Assert.assertEquals((Object)"[El]", (Object)((PseudoMatch)matches.get(0)).getReplacements().toString());
        Assert.assertEquals((long)0L, (long)((PseudoMatch)matches.get(0)).getFromPos());
        Assert.assertEquals((long)6L, (long)((PseudoMatch)matches.get(0)).getToPos());
        original = "\u00a1Hol\u00e0 ! Estamos aqu\u00ed.";
        revised = "\u00a1Hola! Estamos aqu\u00ed.";
        matches = diffsAsMatches.getPseudoMatches(original, revised);
        Assert.assertEquals((long)1L, (long)matches.size());
        Assert.assertEquals((Object)"[\u00a1Hola!]", (Object)((PseudoMatch)matches.get(0)).getReplacements().toString());
        Assert.assertEquals((long)0L, (long)((PseudoMatch)matches.get(0)).getFromPos());
        Assert.assertEquals((long)7L, (long)((PseudoMatch)matches.get(0)).getToPos());
        original = "I truely reserve.";
        revised = "I truly deserve.";
        matches = diffsAsMatches.getPseudoMatches(original, revised);
        Assert.assertEquals((long)2L, (long)matches.size());
        Assert.assertEquals((Object)"[truly]", (Object)((PseudoMatch)matches.get(0)).getReplacements().toString());
        Assert.assertEquals((long)2L, (long)((PseudoMatch)matches.get(0)).getFromPos());
        Assert.assertEquals((long)8L, (long)((PseudoMatch)matches.get(0)).getToPos());
        Assert.assertEquals((Object)"[deserve]", (Object)((PseudoMatch)matches.get(1)).getReplacements().toString());
        Assert.assertEquals((long)9L, (long)((PseudoMatch)matches.get(1)).getFromPos());
        Assert.assertEquals((long)16L, (long)((PseudoMatch)matches.get(1)).getToPos());
        original = "}Describes how plants are important";
        revised = "It describes how plants are important";
        matches = diffsAsMatches.getPseudoMatches(original, revised);
        Assert.assertEquals((long)1L, (long)matches.size());
        Assert.assertEquals((Object)"[It describes]", (Object)((PseudoMatch)matches.get(0)).getReplacements().toString());
        Assert.assertEquals((long)0L, (long)((PseudoMatch)matches.get(0)).getFromPos());
        Assert.assertEquals((long)10L, (long)((PseudoMatch)matches.get(0)).getToPos());
        original = "(Calle)Hace falta tener en cuenta una econom\u00eda estable, un trabajo bueno.";
        revised = "Hace falta tener en cuenta una econom\u00eda estable, un trabajo bueno.";
        matches = diffsAsMatches.getPseudoMatches(original, revised);
        Assert.assertEquals((long)1L, (long)matches.size());
        Assert.assertEquals((Object)"[]", (Object)((PseudoMatch)matches.get(0)).getReplacements().toString());
        Assert.assertEquals((long)0L, (long)((PseudoMatch)matches.get(0)).getFromPos());
        Assert.assertEquals((long)7L, (long)((PseudoMatch)matches.get(0)).getToPos());
        original = "(Calle)Hace falta tener en cuenta una econom\u00eda estable, un trabajo bueno.";
        revised = "(Calle) Hace falta tener en cuenta una econom\u00eda estable, un trabajo bueno.";
        matches = diffsAsMatches.getPseudoMatches(original, revised);
        Assert.assertEquals((long)1L, (long)matches.size());
        Assert.assertEquals((Object)"[Calle) ]", (Object)((PseudoMatch)matches.get(0)).getReplacements().toString());
        Assert.assertEquals((long)1L, (long)((PseudoMatch)matches.get(0)).getFromPos());
        Assert.assertEquals((long)7L, (long)((PseudoMatch)matches.get(0)).getToPos());
        original = "Joan Capr\u00ed fou un actor humorista i monologuista catal\u00e0.";
        revised = "Joan Capr\u00ed fou un actor, humorista i monologuista catal\u00e0.";
        matches = diffsAsMatches.getPseudoMatches(original, revised);
        Assert.assertEquals((long)1L, (long)matches.size());
        Assert.assertEquals((Object)"[actor,]", (Object)((PseudoMatch)matches.get(0)).getReplacements().toString());
        Assert.assertEquals((long)18L, (long)((PseudoMatch)matches.get(0)).getFromPos());
        Assert.assertEquals((long)23L, (long)((PseudoMatch)matches.get(0)).getToPos());
        original = "Ei he vist el teu amic!";
        revised = "Ei, he vist el teu amic!";
        matches = diffsAsMatches.getPseudoMatches(original, revised);
        Assert.assertEquals((long)1L, (long)matches.size());
        Assert.assertEquals((Object)"[Ei,]", (Object)((PseudoMatch)matches.get(0)).getReplacements().toString());
        Assert.assertEquals((long)0L, (long)((PseudoMatch)matches.get(0)).getFromPos());
        Assert.assertEquals((long)2L, (long)((PseudoMatch)matches.get(0)).getToPos());
    }
}

