/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stats.impl;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.jmx.annotations.DataType;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.Units;
import org.infinispan.stats.ContainerStats;
import org.infinispan.stats.impl.AbstractStats;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.GLOBAL)
@MBean(objectName="LocalContainerStats", description="General statistic of local container.")
public class LocalContainerStatsImpl
extends AbstractStats
implements ContainerStats {
    public static final String LOCAL_CONTAINER_STATS = "LocalContainerStats";
    private static final Log log = LogFactory.getLog(LocalContainerStatsImpl.class);

    public LocalContainerStatsImpl() {
        super(log);
    }

    @Inject
    public void init(GlobalConfiguration configuration) {
        this.statisticsEnabled = configuration.statistics();
    }

    @Override
    void updateStats() {
        List<Map<String, Number>> memoryMap = Collections.singletonList(ContainerStats.getLocalStatMaps());
        for (String attr : LONG_ATTRIBUTES) {
            this.putLongAttributes(memoryMap, attr);
        }
    }

    @Override
    @ManagedAttribute(description="The maximum amount of free memory in bytes in local JVM", displayName="Local available memory.")
    public long getMemoryAvailable() {
        return this.getStatAsLong("memoryAvailable");
    }

    @Override
    @ManagedAttribute(description="The maximum amount of memory in local JVM will attempt to utilise in bytes", displayName="Local JVM max memory")
    public long getMemoryMax() {
        return this.getStatAsLong("memoryMax");
    }

    @Override
    @ManagedAttribute(description="The total amount of memory in the local JVM in bytes", displayName="Local total memory")
    public long getMemoryTotal() {
        return this.getStatAsLong("memoryTotal");
    }

    @Override
    @ManagedAttribute(description="The amount of memory used by the local JVM in bytes", displayName="Local memory utilisation")
    public long getMemoryUsed() {
        return this.getStatAsLong("memoryUsed");
    }

    @ManagedAttribute(description="Gets the threshold for cluster wide stats refresh (milliseconds)", displayName="Stale Stats Threshold", dataType=DataType.TRAIT, writable=true)
    public long getStaleStatsThreshold() {
        return this.staleStatsThreshold;
    }

    @ManagedAttribute(description="Number of seconds since the statistics were last reset", displayName="Seconds since statistics were reset", units=Units.SECONDS)
    public long getTimeSinceReset() {
        long result = -1L;
        if (this.isStatisticsEnabled()) {
            result = this.timeService.timeDuration(this.resetNanoseconds.get(), TimeUnit.SECONDS);
        }
        return result;
    }

    @ManagedAttribute(description="Enables or disables the gathering of statistics by this component", displayName="Statistics enabled", dataType=DataType.TRAIT, writable=true)
    public boolean isStatisticsEnabled() {
        return this.getStatisticsEnabled();
    }
}

