/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.workflow;

import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import org.keycloak.events.Event;
import org.keycloak.events.EventType;
import org.keycloak.events.admin.AdminEvent;
import org.keycloak.events.admin.OperationType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.workflow.ResourceOperationType;
import org.keycloak.models.workflow.WorkflowEvent;
import org.keycloak.provider.ProviderEvent;

public enum ResourceType {
    USERS(org.keycloak.events.admin.ResourceType.USER, List.of(OperationType.CREATE), List.of(EventType.LOGIN, EventType.REGISTER), (session, id) -> session.users().getUserById(session.getContext().getRealm(), id));

    private final org.keycloak.events.admin.ResourceType supportedAdminResourceType;
    private final List<OperationType> supportedAdminOperationTypes;
    private final List<EventType> supportedEventTypes;
    private final BiFunction<KeycloakSession, String, ?> resourceResolver;

    private ResourceType(org.keycloak.events.admin.ResourceType supportedAdminResourceType, List<OperationType> supportedAdminOperationTypes, List<EventType> supportedEventTypes, BiFunction<KeycloakSession, String, ?> resourceResolver) {
        this.supportedAdminResourceType = supportedAdminResourceType;
        this.supportedAdminOperationTypes = supportedAdminOperationTypes;
        this.supportedEventTypes = supportedEventTypes;
        this.resourceResolver = resourceResolver;
    }

    public WorkflowEvent toEvent(AdminEvent event) {
        ResourceOperationType resourceOperationType;
        if (Objects.equals((Object)this.supportedAdminResourceType, (Object)event.getResourceType()) && this.supportedAdminOperationTypes.contains((Object)event.getOperationType()) && (resourceOperationType = ResourceOperationType.toOperationType(event.getOperationType())) != null && event.getResourceId() != null) {
            return new WorkflowEvent(this, resourceOperationType, event.getResourceId(), event);
        }
        return null;
    }

    public WorkflowEvent toEvent(Event event) {
        if (this.supportedEventTypes.contains((Object)event.getType())) {
            ResourceOperationType resourceOperationType = ResourceOperationType.toOperationType(event.getType());
            switch (this.ordinal()) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case 0: 
            }
            String resourceId = event.getUserId();
            if (resourceOperationType != null && resourceId != null) {
                return new WorkflowEvent(this, resourceOperationType, event.getUserId(), event);
            }
        }
        return null;
    }

    public WorkflowEvent toEvent(ProviderEvent event) {
        ResourceOperationType resourceOperationType = ResourceOperationType.toOperationType(event.getClass());
        if (resourceOperationType == null) {
            return null;
        }
        String resourceId = resourceOperationType.getResourceId(event);
        if (resourceId == null) {
            return null;
        }
        return new WorkflowEvent(this, resourceOperationType, resourceId, event);
    }

    public Object resolveResource(KeycloakSession session, String id) {
        return this.resourceResolver.apply(session, id);
    }
}

