/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.compress.methods;

import tim.prune.data.DataPoint;
import tim.prune.data.MarkingData;
import tim.prune.data.Track;
import tim.prune.function.compress.TrackDetails;
import tim.prune.function.compress.methods.CompressionMethod;

public abstract class NearbyPointsMethod
extends CompressionMethod {
    @Override
    public int compress(Track track, TrackDetails trackDetails, MarkingData markingData) {
        double d = this.getRadianThreshold(trackDetails);
        if (d <= 0.0) {
            return 0;
        }
        int n = track.getNumPoints();
        DataPoint dataPoint = null;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            DataPoint dataPoint2;
            if (!markingData.isPointMarkedForDeletion(n3) && !(dataPoint2 = track.getPoint(n3)).isWaypoint()) {
                double d2;
                boolean bl = false;
                if (!dataPoint2.hasMedia() && !NearbyPointsMethod.isPointAtSegmentBoundary(n3, trackDetails, markingData) && dataPoint != null && (d2 = DataPoint.calculateRadiansBetween(dataPoint, dataPoint2)) < d) {
                    markingData.markPointForDeletion(n3);
                    bl = true;
                    ++n2;
                }
                if (!bl) {
                    dataPoint = dataPoint2;
                }
            }
            ++n3;
        }
        return n2;
    }

    protected abstract double getRadianThreshold(TrackDetails var1);
}

