# -*- coding: utf-8 -*-
"""

    Copyright (C) 2014-2016 bromix (plugin.video.youtube)
    Copyright (C) 2016-2025 plugin.video.youtube

    SPDX-License-Identifier: GPL-2.0-only
    See LICENSES/GPL-2.0-only for more information.
"""

from __future__ import absolute_import, division, unicode_literals


DEFAULT_LANGUAGES = {'items': [
    {'id': 'af', 'snippet': {'hl': 'af', 'name':         'Afrikaans'}},
    {'id': 'sq', 'snippet': {'hl': 'sq', 'name':         'Albanian'}},
    {'id': 'am', 'snippet': {'hl': 'am', 'name':         'Amharic'}},
    {'id': 'ar', 'snippet': {'hl': 'ar', 'name':         'Arabic'}},
    {'id': 'hy', 'snippet': {'hl': 'hy', 'name':         'Armenian'}},
    {'id': 'az', 'snippet': {'hl': 'az', 'name':         'Azerbaijani'}},
    {'id': 'eu', 'snippet': {'hl': 'eu', 'name':         'Basque'}},
    {'id': 'bn', 'snippet': {'hl': 'bn', 'name':         'Bengali'}},
    {'id': 'bg', 'snippet': {'hl': 'bg', 'name':         'Bulgarian'}},
    {'id': 'ca', 'snippet': {'hl': 'ca', 'name':         'Catalan'}},
    {'id': 'zh-CN', 'snippet': {'hl': 'zh-CN', 'name':   'Chinese'}},
    {'id': 'zh-HK', 'snippet': {'hl': 'zh-HK', 'name':   'Chinese (Hong Kong)'}},
    {'id': 'zh-TW', 'snippet': {'hl': 'zh-TW', 'name':   'Chinese (Taiwan)'}},
    {'id': 'hr', 'snippet': {'hl': 'hr', 'name':         'Croatian'}},
    {'id': 'cs', 'snippet': {'hl': 'cs', 'name':         'Czech'}},
    {'id': 'da', 'snippet': {'hl': 'da', 'name':         'Danish'}},
    {'id': 'nl', 'snippet': {'hl': 'nl', 'name':         'Dutch'}},
    {'id': 'en', 'snippet': {'hl': 'en', 'name':         'English'}},
    {'id': 'en-GB', 'snippet': {'hl': 'en-GB', 'name':   'English (United Kingdom)'}},
    {'id': 'et', 'snippet': {'hl': 'et', 'name':         'Estonian'}},
    {'id': 'fil', 'snippet': {'hl': 'fil', 'name':       'Filipino'}},
    {'id': 'fi', 'snippet': {'hl': 'fi', 'name':         'Finnish'}},
    {'id': 'fr', 'snippet': {'hl': 'fr', 'name':         'French'}},
    {'id': 'fr-CA', 'snippet': {'hl': 'fr-CA', 'name':   'French (Canada)'}},
    {'id': 'gl', 'snippet': {'hl': 'gl', 'name':         'Galician'}},
    {'id': 'ka', 'snippet': {'hl': 'ka', 'name':         'Georgian'}},
    {'id': 'de', 'snippet': {'hl': 'de', 'name':         'German'}},
    {'id': 'el', 'snippet': {'hl': 'el', 'name':         'Greek'}},
    {'id': 'gu', 'snippet': {'hl': 'gu', 'name':         'Gujarati'}},
    {'id': 'iw', 'snippet': {'hl': 'iw', 'name':         'Hebrew'}},
    {'id': 'hi', 'snippet': {'hl': 'hi', 'name':         'Hindi'}},
    {'id': 'hu', 'snippet': {'hl': 'hu', 'name':         'Hungarian'}},
    {'id': 'is', 'snippet': {'hl': 'is', 'name':         'Icelandic'}},
    {'id': 'id', 'snippet': {'hl': 'id', 'name':         'Indonesian'}},
    {'id': 'it', 'snippet': {'hl': 'it', 'name':         'Italian'}},
    {'id': 'ja', 'snippet': {'hl': 'ja', 'name':         'Japanese'}},
    {'id': 'kn', 'snippet': {'hl': 'kn', 'name':         'Kannada'}},
    {'id': 'kk', 'snippet': {'hl': 'kk', 'name':         'Kazakh'}},
    {'id': 'km', 'snippet': {'hl': 'km', 'name':         'Khmer'}},
    {'id': 'ko', 'snippet': {'hl': 'ko', 'name':         'Korean'}},
    {'id': 'ky', 'snippet': {'hl': 'ky', 'name':         'Kyrgyz'}},
    {'id': 'lo', 'snippet': {'hl': 'lo', 'name':         'Lao'}},
    {'id': 'lv', 'snippet': {'hl': 'lv', 'name':         'Latvian'}},
    {'id': 'lt', 'snippet': {'hl': 'lt', 'name':         'Lithuanian'}},
    {'id': 'mk', 'snippet': {'hl': 'mk', 'name':         'Macedonian'}},
    {'id': 'ms', 'snippet': {'hl': 'ms', 'name':         'Malay'}},
    {'id': 'ml', 'snippet': {'hl': 'ml', 'name':         'Malayalam'}},
    {'id': 'mr', 'snippet': {'hl': 'mr', 'name':         'Marathi'}},
    {'id': 'mn', 'snippet': {'hl': 'mn', 'name':         'Mongolian'}},
    {'id': 'my', 'snippet': {'hl': 'my', 'name':         'Myanmar (Burmese)'}},
    {'id': 'ne', 'snippet': {'hl': 'ne', 'name':         'Nepali'}},
    {'id': 'no', 'snippet': {'hl': 'no', 'name':         'Norwegian'}},
    {'id': 'fa', 'snippet': {'hl': 'fa', 'name':         'Persian'}},
    {'id': 'pl', 'snippet': {'hl': 'pl', 'name':         'Polish'}},
    {'id': 'pt', 'snippet': {'hl': 'pt', 'name':         'Portuguese (Brazil)'}},
    {'id': 'pt-PT', 'snippet': {'hl': 'pt-PT', 'name':   'Portuguese (Portugal)'}},
    {'id': 'pa', 'snippet': {'hl': 'pa', 'name':         'Punjabi'}},
    {'id': 'ro', 'snippet': {'hl': 'ro', 'name':         'Romanian'}},
    {'id': 'ru', 'snippet': {'hl': 'ru', 'name':         'Russian'}},
    {'id': 'sr', 'snippet': {'hl': 'sr', 'name':         'Serbian'}},
    {'id': 'si', 'snippet': {'hl': 'si', 'name':         'Sinhala'}},
    {'id': 'sk', 'snippet': {'hl': 'sk', 'name':         'Slovak'}},
    {'id': 'sl', 'snippet': {'hl': 'sl', 'name':         'Slovenian'}},
    {'id': 'es-419', 'snippet': {'hl': 'es-419', 'name': 'Spanish (Latin America)'}},
    {'id': 'es', 'snippet': {'hl': 'es', 'name':         'Spanish (Spain)'}},
    {'id': 'sw', 'snippet': {'hl': 'sw', 'name':         'Swahili'}},
    {'id': 'sv', 'snippet': {'hl': 'sv', 'name':         'Swedish'}},
    {'id': 'ta', 'snippet': {'hl': 'ta', 'name':         'Tamil'}},
    {'id': 'te', 'snippet': {'hl': 'te', 'name':         'Telugu'}},
    {'id': 'th', 'snippet': {'hl': 'th', 'name':         'Thai'}},
    {'id': 'tr', 'snippet': {'hl': 'tr', 'name':         'Turkish'}},
    {'id': 'uk', 'snippet': {'hl': 'uk', 'name':         'Ukrainian'}},
    {'id': 'ur', 'snippet': {'hl': 'ur', 'name':         'Urdu'}},
    {'id': 'uz', 'snippet': {'hl': 'uz', 'name':         'Uzbek'}},
    {'id': 'vi', 'snippet': {'hl': 'vi', 'name':         'Vietnamese'}},
    {'id': 'zu', 'snippet': {'hl': 'zu', 'name':         'Zulu'}},
]}

DEFAULT_REGIONS = {'items': [
    {'id': 'DZ', 'snippet': {'gl': 'DZ', 'name': 'Algeria'}},
    {'id': 'AR', 'snippet': {'gl': 'AR', 'name': 'Argentina'}},
    {'id': 'AU', 'snippet': {'gl': 'AU', 'name': 'Australia'}},
    {'id': 'AT', 'snippet': {'gl': 'AT', 'name': 'Austria'}},
    {'id': 'AZ', 'snippet': {'gl': 'AZ', 'name': 'Azerbaijan'}},
    {'id': 'BH', 'snippet': {'gl': 'BH', 'name': 'Bahrain'}},
    {'id': 'BY', 'snippet': {'gl': 'BY', 'name': 'Belarus'}},
    {'id': 'BE', 'snippet': {'gl': 'BE', 'name': 'Belgium'}},
    {'id': 'BA', 'snippet': {'gl': 'BA', 'name': 'Bosnia and Herzegovina'}},
    {'id': 'BR', 'snippet': {'gl': 'BR', 'name': 'Brazil'}},
    {'id': 'BG', 'snippet': {'gl': 'BG', 'name': 'Bulgaria'}},
    {'id': 'CA', 'snippet': {'gl': 'CA', 'name': 'Canada'}},
    {'id': 'CL', 'snippet': {'gl': 'CL', 'name': 'Chile'}},
    {'id': 'CO', 'snippet': {'gl': 'CO', 'name': 'Colombia'}},
    {'id': 'HR', 'snippet': {'gl': 'HR', 'name': 'Croatia'}},
    {'id': 'CZ', 'snippet': {'gl': 'CZ', 'name': 'Czech Republic'}},
    {'id': 'DK', 'snippet': {'gl': 'DK', 'name': 'Denmark'}},
    {'id': 'EG', 'snippet': {'gl': 'EG', 'name': 'Egypt'}},
    {'id': 'EE', 'snippet': {'gl': 'EE', 'name': 'Estonia'}},
    {'id': 'FI', 'snippet': {'gl': 'FI', 'name': 'Finland'}},
    {'id': 'FR', 'snippet': {'gl': 'FR', 'name': 'France'}},
    {'id': 'GE', 'snippet': {'gl': 'GE', 'name': 'Georgia'}},
    {'id': 'DE', 'snippet': {'gl': 'DE', 'name': 'Germany'}},
    {'id': 'GH', 'snippet': {'gl': 'GH', 'name': 'Ghana'}},
    {'id': 'GR', 'snippet': {'gl': 'GR', 'name': 'Greece'}},
    {'id': 'HK', 'snippet': {'gl': 'HK', 'name': 'Hong Kong'}},
    {'id': 'HU', 'snippet': {'gl': 'HU', 'name': 'Hungary'}},
    {'id': 'IS', 'snippet': {'gl': 'IS', 'name': 'Iceland'}},
    {'id': 'IN', 'snippet': {'gl': 'IN', 'name': 'India'}},
    {'id': 'ID', 'snippet': {'gl': 'ID', 'name': 'Indonesia'}},
    {'id': 'IQ', 'snippet': {'gl': 'IQ', 'name': 'Iraq'}},
    {'id': 'IE', 'snippet': {'gl': 'IE', 'name': 'Ireland'}},
    {'id': 'IL', 'snippet': {'gl': 'IL', 'name': 'Israel'}},
    {'id': 'IT', 'snippet': {'gl': 'IT', 'name': 'Italy'}},
    {'id': 'JM', 'snippet': {'gl': 'JM', 'name': 'Jamaica'}},
    {'id': 'JP', 'snippet': {'gl': 'JP', 'name': 'Japan'}},
    {'id': 'JO', 'snippet': {'gl': 'JO', 'name': 'Jordan'}},
    {'id': 'KZ', 'snippet': {'gl': 'KZ', 'name': 'Kazakhstan'}},
    {'id': 'KE', 'snippet': {'gl': 'KE', 'name': 'Kenya'}},
    {'id': 'KW', 'snippet': {'gl': 'KW', 'name': 'Kuwait'}},
    {'id': 'LV', 'snippet': {'gl': 'LV', 'name': 'Latvia'}},
    {'id': 'LB', 'snippet': {'gl': 'LB', 'name': 'Lebanon'}},
    {'id': 'LY', 'snippet': {'gl': 'LY', 'name': 'Libya'}},
    {'id': 'LT', 'snippet': {'gl': 'LT', 'name': 'Lithuania'}},
    {'id': 'LU', 'snippet': {'gl': 'LU', 'name': 'Luxembourg'}},
    {'id': 'MK', 'snippet': {'gl': 'MK', 'name': 'Macedonia'}},
    {'id': 'MY', 'snippet': {'gl': 'MY', 'name': 'Malaysia'}},
    {'id': 'MX', 'snippet': {'gl': 'MX', 'name': 'Mexico'}},
    {'id': 'ME', 'snippet': {'gl': 'ME', 'name': 'Montenegro'}},
    {'id': 'MA', 'snippet': {'gl': 'MA', 'name': 'Morocco'}},
    {'id': 'NP', 'snippet': {'gl': 'NP', 'name': 'Nepal'}},
    {'id': 'NL', 'snippet': {'gl': 'NL', 'name': 'Netherlands'}},
    {'id': 'NZ', 'snippet': {'gl': 'NZ', 'name': 'New Zealand'}},
    {'id': 'NG', 'snippet': {'gl': 'NG', 'name': 'Nigeria'}},
    {'id': 'NO', 'snippet': {'gl': 'NO', 'name': 'Norway'}},
    {'id': 'OM', 'snippet': {'gl': 'OM', 'name': 'Oman'}},
    {'id': 'PK', 'snippet': {'gl': 'PK', 'name': 'Pakistan'}},
    {'id': 'PE', 'snippet': {'gl': 'PE', 'name': 'Peru'}},
    {'id': 'PH', 'snippet': {'gl': 'PH', 'name': 'Philippines'}},
    {'id': 'PL', 'snippet': {'gl': 'PL', 'name': 'Poland'}},
    {'id': 'PT', 'snippet': {'gl': 'PT', 'name': 'Portugal'}},
    {'id': 'PR', 'snippet': {'gl': 'PR', 'name': 'Puerto Rico'}},
    {'id': 'QA', 'snippet': {'gl': 'QA', 'name': 'Qatar'}},
    {'id': 'RO', 'snippet': {'gl': 'RO', 'name': 'Romania'}},
    {'id': 'RU', 'snippet': {'gl': 'RU', 'name': 'Russia'}},
    {'id': 'SA', 'snippet': {'gl': 'SA', 'name': 'Saudi Arabia'}},
    {'id': 'SN', 'snippet': {'gl': 'SN', 'name': 'Senegal'}},
    {'id': 'RS', 'snippet': {'gl': 'RS', 'name': 'Serbia'}},
    {'id': 'SG', 'snippet': {'gl': 'SG', 'name': 'Singapore'}},
    {'id': 'SK', 'snippet': {'gl': 'SK', 'name': 'Slovakia'}},
    {'id': 'SI', 'snippet': {'gl': 'SI', 'name': 'Slovenia'}},
    {'id': 'ZA', 'snippet': {'gl': 'ZA', 'name': 'South Africa'}},
    {'id': 'KR', 'snippet': {'gl': 'KR', 'name': 'South Korea'}},
    {'id': 'ES', 'snippet': {'gl': 'ES', 'name': 'Spain'}},
    {'id': 'LK', 'snippet': {'gl': 'LK', 'name': 'Sri Lanka'}},
    {'id': 'SE', 'snippet': {'gl': 'SE', 'name': 'Sweden'}},
    {'id': 'CH', 'snippet': {'gl': 'CH', 'name': 'Switzerland'}},
    {'id': 'TW', 'snippet': {'gl': 'TW', 'name': 'Taiwan'}},
    {'id': 'TZ', 'snippet': {'gl': 'TZ', 'name': 'Tanzania'}},
    {'id': 'TH', 'snippet': {'gl': 'TH', 'name': 'Thailand'}},
    {'id': 'TN', 'snippet': {'gl': 'TN', 'name': 'Tunisia'}},
    {'id': 'TR', 'snippet': {'gl': 'TR', 'name': 'Turkey'}},
    {'id': 'UG', 'snippet': {'gl': 'UG', 'name': 'Uganda'}},
    {'id': 'UA', 'snippet': {'gl': 'UA', 'name': 'Ukraine'}},
    {'id': 'AE', 'snippet': {'gl': 'AE', 'name': 'United Arab Emirates'}},
    {'id': 'GB', 'snippet': {'gl': 'GB', 'name': 'United Kingdom'}},
    {'id': 'US', 'snippet': {'gl': 'US', 'name': 'United States'}},
    {'id': 'VN', 'snippet': {'gl': 'VN', 'name': 'Vietnam'}},
    {'id': 'YE', 'snippet': {'gl': 'YE', 'name': 'Yemen'}},
    {'id': 'ZW', 'snippet': {'gl': 'ZW', 'name': 'Zimbabwe'}},
]}

TRANSLATION_LANGUAGES = [
    {'languageCode': 'aa', 'languageName': {'simpleText': 'Afar'}},
    {'languageCode': 'ab', 'languageName': {'simpleText': 'Abkhazian'}},
    {'languageCode': 'ace', 'languageName': {'simpleText': 'Acehnese'}},
    {'languageCode': 'ach', 'languageName': {'simpleText': 'Acoli'}},
    {'languageCode': 'ada', 'languageName': {'simpleText': 'Adangme'}},
    {'languageCode': 'ady', 'languageName': {'simpleText': 'Adyghe'}},
    {'languageCode': 'ae', 'languageName': {'simpleText': 'Avestan'}},
    {'languageCode': 'aeb', 'languageName': {'simpleText': 'Tunisian Arabic'}},
    {'languageCode': 'af', 'languageName': {'simpleText': 'Afrikaans'}},
    {'languageCode': 'afh', 'languageName': {'simpleText': 'Afrihili'}},
    {'languageCode': 'agq', 'languageName': {'simpleText': 'Aghem'}},
    {'languageCode': 'ain', 'languageName': {'simpleText': 'Ainu'}},
    {'languageCode': 'ak', 'languageName': {'simpleText': 'Akan'}},
    {'languageCode': 'akk', 'languageName': {'simpleText': 'Akkadian'}},
    {'languageCode': 'akz', 'languageName': {'simpleText': 'Alabama'}},
    {'languageCode': 'ale', 'languageName': {'simpleText': 'Aleut'}},
    {'languageCode': 'aln', 'languageName': {'simpleText': 'Gheg Albanian'}},
    {'languageCode': 'alt', 'languageName': {'simpleText': 'Southern Altai'}},
    {'languageCode': 'am', 'languageName': {'simpleText': 'Amharic'}},
    {'languageCode': 'an', 'languageName': {'simpleText': 'Aragonese'}},
    {'languageCode': 'ang', 'languageName': {'simpleText': 'Old English'}},
    {'languageCode': 'anp', 'languageName': {'simpleText': 'Angika'}},
    {'languageCode': 'ar', 'languageName': {'simpleText': 'Arabic'}},
    {'languageCode': 'ar_001', 'languageName': {'simpleText': 'Arabic (world)'}},
    {'languageCode': 'arc', 'languageName': {'simpleText': 'Aramaic'}},
    {'languageCode': 'arn', 'languageName': {'simpleText': 'Mapuche'}},
    {'languageCode': 'aro', 'languageName': {'simpleText': 'Araona'}},
    {'languageCode': 'arp', 'languageName': {'simpleText': 'Arapaho'}},
    {'languageCode': 'arq', 'languageName': {'simpleText': 'Algerian Arabic'}},
    {'languageCode': 'ars', 'languageName': {'simpleText': 'Najdi Arabic'}},
    {'languageCode': 'arw', 'languageName': {'simpleText': 'Arawak'}},
    {'languageCode': 'ary', 'languageName': {'simpleText': 'Moroccan Arabic'}},
    {'languageCode': 'arz', 'languageName': {'simpleText': 'Egyptian Arabic'}},
    {'languageCode': 'as', 'languageName': {'simpleText': 'Assamese'}},
    {'languageCode': 'asa', 'languageName': {'simpleText': 'Asu'}},
    {'languageCode': 'ase', 'languageName': {'simpleText': 'American Sign Language'}},
    {'languageCode': 'ast', 'languageName': {'simpleText': 'Asturian'}},
    {'languageCode': 'av', 'languageName': {'simpleText': 'Avaric'}},
    {'languageCode': 'avk', 'languageName': {'simpleText': 'Kotava'}},
    {'languageCode': 'awa', 'languageName': {'simpleText': 'Awadhi'}},
    {'languageCode': 'ay', 'languageName': {'simpleText': 'Aymara'}},
    {'languageCode': 'az', 'languageName': {'simpleText': 'Azerbaijani'}},
    {'languageCode': 'az_Cyrl', 'languageName': {'simpleText': 'Azerbaijani (Cyrillic)'}},
    {'languageCode': 'az_Latn', 'languageName': {'simpleText': 'Azerbaijani (Latin)'}},
    {'languageCode': 'ba', 'languageName': {'simpleText': 'Bashkir'}},
    {'languageCode': 'bal', 'languageName': {'simpleText': 'Baluchi'}},
    {'languageCode': 'ban', 'languageName': {'simpleText': 'Balinese'}},
    {'languageCode': 'bar', 'languageName': {'simpleText': 'Bavarian'}},
    {'languageCode': 'bas', 'languageName': {'simpleText': 'Basaa'}},
    {'languageCode': 'bax', 'languageName': {'simpleText': 'Bamun'}},
    {'languageCode': 'bbc', 'languageName': {'simpleText': 'Batak Toba'}},
    {'languageCode': 'bbj', 'languageName': {'simpleText': 'Ghomala'}},
    {'languageCode': 'be', 'languageName': {'simpleText': 'Belarusian'}},
    {'languageCode': 'bej', 'languageName': {'simpleText': 'Beja'}},
    {'languageCode': 'bem', 'languageName': {'simpleText': 'Bemba'}},
    {'languageCode': 'bew', 'languageName': {'simpleText': 'Betawi'}},
    {'languageCode': 'bez', 'languageName': {'simpleText': 'Bena'}},
    {'languageCode': 'bfd', 'languageName': {'simpleText': 'Bafut'}},
    {'languageCode': 'bfq', 'languageName': {'simpleText': 'Badaga'}},
    {'languageCode': 'bg', 'languageName': {'simpleText': 'Bulgarian'}},
    {'languageCode': 'bgc', 'languageName': {'simpleText': 'Haryanvi'}},
    {'languageCode': 'bgn', 'languageName': {'simpleText': 'Western Balochi'}},
    {'languageCode': 'bho', 'languageName': {'simpleText': 'Bhojpuri'}},
    {'languageCode': 'bi', 'languageName': {'simpleText': 'Bislama'}},
    {'languageCode': 'bik', 'languageName': {'simpleText': 'Bikol'}},
    {'languageCode': 'bin', 'languageName': {'simpleText': 'Bini'}},
    {'languageCode': 'bjn', 'languageName': {'simpleText': 'Banjar'}},
    {'languageCode': 'bkm', 'languageName': {'simpleText': 'Kom'}},
    {'languageCode': 'bla', 'languageName': {'simpleText': 'Siksik\u00e1'}},
    {'languageCode': 'blo', 'languageName': {'simpleText': 'Anii'}},
    {'languageCode': 'bm', 'languageName': {'simpleText': 'Bambara'}},
    {'languageCode': 'bn', 'languageName': {'simpleText': 'Bangla'}},
    {'languageCode': 'bo', 'languageName': {'simpleText': 'Tibetan'}},
    {'languageCode': 'bpy', 'languageName': {'simpleText': 'Bishnupriya'}},
    {'languageCode': 'bqi', 'languageName': {'simpleText': 'Bakhtiari'}},
    {'languageCode': 'br', 'languageName': {'simpleText': 'Breton'}},
    {'languageCode': 'bra', 'languageName': {'simpleText': 'Braj'}},
    {'languageCode': 'brh', 'languageName': {'simpleText': 'Brahui'}},
    {'languageCode': 'brx', 'languageName': {'simpleText': 'Bodo'}},
    {'languageCode': 'bs', 'languageName': {'simpleText': 'Bosnian'}},
    {'languageCode': 'bs_Cyrl', 'languageName': {'simpleText': 'Bosnian (Cyrillic)'}},
    {'languageCode': 'bs_Latn', 'languageName': {'simpleText': 'Bosnian (Latin)'}},
    {'languageCode': 'bss', 'languageName': {'simpleText': 'Akoose'}},
    {'languageCode': 'bua', 'languageName': {'simpleText': 'Buriat'}},
    {'languageCode': 'bug', 'languageName': {'simpleText': 'Buginese'}},
    {'languageCode': 'bum', 'languageName': {'simpleText': 'Bulu'}},
    {'languageCode': 'byn', 'languageName': {'simpleText': 'Blin'}},
    {'languageCode': 'byv', 'languageName': {'simpleText': 'Medumba'}},
    {'languageCode': 'ca', 'languageName': {'simpleText': 'Catalan'}},
    {'languageCode': 'cad', 'languageName': {'simpleText': 'Caddo'}},
    {'languageCode': 'car', 'languageName': {'simpleText': 'Carib'}},
    {'languageCode': 'cay', 'languageName': {'simpleText': 'Cayuga'}},
    {'languageCode': 'cch', 'languageName': {'simpleText': 'Atsam'}},
    {'languageCode': 'ccp', 'languageName': {'simpleText': 'Chakma'}},
    {'languageCode': 'ce', 'languageName': {'simpleText': 'Chechen'}},
    {'languageCode': 'ceb', 'languageName': {'simpleText': 'Cebuano'}},
    {'languageCode': 'cgg', 'languageName': {'simpleText': 'Chiga'}},
    {'languageCode': 'ch', 'languageName': {'simpleText': 'Chamorro'}},
    {'languageCode': 'chb', 'languageName': {'simpleText': 'Chibcha'}},
    {'languageCode': 'chg', 'languageName': {'simpleText': 'Chagatai'}},
    {'languageCode': 'chk', 'languageName': {'simpleText': 'Chuukese'}},
    {'languageCode': 'chm', 'languageName': {'simpleText': 'Mari'}},
    {'languageCode': 'chn', 'languageName': {'simpleText': 'Chinook Jargon'}},
    {'languageCode': 'cho', 'languageName': {'simpleText': 'Choctaw'}},
    {'languageCode': 'chp', 'languageName': {'simpleText': 'Chipewyan'}},
    {'languageCode': 'chr', 'languageName': {'simpleText': 'Cherokee'}},
    {'languageCode': 'chy', 'languageName': {'simpleText': 'Cheyenne'}},
    {'languageCode': 'ckb', 'languageName': {'simpleText': 'Central Kurdish'}},
    {'languageCode': 'co', 'languageName': {'simpleText': 'Corsican'}},
    {'languageCode': 'cop', 'languageName': {'simpleText': 'Coptic'}},
    {'languageCode': 'cps', 'languageName': {'simpleText': 'Capiznon'}},
    {'languageCode': 'cr', 'languageName': {'simpleText': 'Cree'}},
    {'languageCode': 'crh', 'languageName': {'simpleText': 'Crimean Tatar'}},
    {'languageCode': 'cs', 'languageName': {'simpleText': 'Czech'}},
    {'languageCode': 'csb', 'languageName': {'simpleText': 'Kashubian'}},
    {'languageCode': 'csw', 'languageName': {'simpleText': 'Swampy Cree'}},
    {'languageCode': 'cu', 'languageName': {'simpleText': 'Church Slavic'}},
    {'languageCode': 'cv', 'languageName': {'simpleText': 'Chuvash'}},
    {'languageCode': 'cy', 'languageName': {'simpleText': 'Welsh'}},
    {'languageCode': 'da', 'languageName': {'simpleText': 'Danish'}},
    {'languageCode': 'dak', 'languageName': {'simpleText': 'Dakota'}},
    {'languageCode': 'dar', 'languageName': {'simpleText': 'Dargwa'}},
    {'languageCode': 'dav', 'languageName': {'simpleText': 'Taita'}},
    {'languageCode': 'de', 'languageName': {'simpleText': 'German'}},
    {'languageCode': 'de_AT', 'languageName': {'simpleText': 'German (Austria)'}},
    {'languageCode': 'de_CH', 'languageName': {'simpleText': 'German (Switzerland)'}},
    {'languageCode': 'del', 'languageName': {'simpleText': 'Delaware'}},
    {'languageCode': 'den', 'languageName': {'simpleText': 'Slave'}},
    {'languageCode': 'dgr', 'languageName': {'simpleText': 'Dogrib'}},
    {'languageCode': 'din', 'languageName': {'simpleText': 'Dinka'}},
    {'languageCode': 'dje', 'languageName': {'simpleText': 'Zarma'}},
    {'languageCode': 'doi', 'languageName': {'simpleText': 'Dogri'}},
    {'languageCode': 'dsb', 'languageName': {'simpleText': 'Lower Sorbian'}},
    {'languageCode': 'dua', 'languageName': {'simpleText': 'Duala'}},
    {'languageCode': 'dum', 'languageName': {'simpleText': 'Middle Dutch'}},
    {'languageCode': 'dv', 'languageName': {'simpleText': 'Divehi'}},
    {'languageCode': 'dyo', 'languageName': {'simpleText': 'Jola-Fonyi'}},
    {'languageCode': 'dyu', 'languageName': {'simpleText': 'Dyula'}},
    {'languageCode': 'dz', 'languageName': {'simpleText': 'Dzongkha'}},
    {'languageCode': 'dzg', 'languageName': {'simpleText': 'Dazaga'}},
    {'languageCode': 'ebu', 'languageName': {'simpleText': 'Embu'}},
    {'languageCode': 'ee', 'languageName': {'simpleText': 'Ewe'}},
    {'languageCode': 'efi', 'languageName': {'simpleText': 'Efik'}},
    {'languageCode': 'egy', 'languageName': {'simpleText': 'Ancient Egyptian'}},
    {'languageCode': 'eka', 'languageName': {'simpleText': 'Ekajuk'}},
    {'languageCode': 'el', 'languageName': {'simpleText': 'Greek'}},
    {'languageCode': 'elx', 'languageName': {'simpleText': 'Elamite'}},
    {'languageCode': 'en', 'languageName': {'simpleText': 'English'}},
    {'languageCode': 'en_AU', 'languageName': {'simpleText': 'English (Australia)'}},
    {'languageCode': 'en_CA', 'languageName': {'simpleText': 'English (Canada)'}},
    {'languageCode': 'en_GB', 'languageName': {'simpleText': 'English (United Kingdom)'}},
    {'languageCode': 'en_US', 'languageName': {'simpleText': 'English (United States)'}},
    {'languageCode': 'enm', 'languageName': {'simpleText': 'Middle English'}},
    {'languageCode': 'eo', 'languageName': {'simpleText': 'Esperanto'}},
    {'languageCode': 'es', 'languageName': {'simpleText': 'Spanish'}},
    {'languageCode': 'es_419', 'languageName': {'simpleText': 'Spanish (Latin America)'}},
    {'languageCode': 'es_ES', 'languageName': {'simpleText': 'Spanish (Spain)'}},
    {'languageCode': 'es_MX', 'languageName': {'simpleText': 'Spanish (Mexico)'}},
    {'languageCode': 'et', 'languageName': {'simpleText': 'Estonian'}},
    {'languageCode': 'eu', 'languageName': {'simpleText': 'Basque'}},
    {'languageCode': 'ewo', 'languageName': {'simpleText': 'Ewondo'}},
    {'languageCode': 'fa', 'languageName': {'simpleText': 'Persian'}},
    {'languageCode': 'fa_AF', 'languageName': {'simpleText': 'Persian (Afghanistan)'}},
    {'languageCode': 'fan', 'languageName': {'simpleText': 'Fang'}},
    {'languageCode': 'fat', 'languageName': {'simpleText': 'Fanti'}},
    {'languageCode': 'ff', 'languageName': {'simpleText': 'Fula'}},
    {'languageCode': 'ff_Adlm', 'languageName': {'simpleText': 'Fula (Adlam)'}},
    {'languageCode': 'ff_Latn', 'languageName': {'simpleText': 'Fula (Latin)'}},
    {'languageCode': 'fi', 'languageName': {'simpleText': 'Finnish'}},
    {'languageCode': 'fil', 'languageName': {'simpleText': 'Filipino'}},
    {'languageCode': 'fj', 'languageName': {'simpleText': 'Fijian'}},
    {'languageCode': 'fo', 'languageName': {'simpleText': 'Faroese'}},
    {'languageCode': 'fon', 'languageName': {'simpleText': 'Fon'}},
    {'languageCode': 'fr', 'languageName': {'simpleText': 'French'}},
    {'languageCode': 'fr_CA', 'languageName': {'simpleText': 'French (Canada)'}},
    {'languageCode': 'fr_CH', 'languageName': {'simpleText': 'French (Switzerland)'}},
    {'languageCode': 'frm', 'languageName': {'simpleText': 'Middle French'}},
    {'languageCode': 'fro', 'languageName': {'simpleText': 'Old French'}},
    {'languageCode': 'frr', 'languageName': {'simpleText': 'Northern Frisian'}},
    {'languageCode': 'frs', 'languageName': {'simpleText': 'Eastern Frisian'}},
    {'languageCode': 'fur', 'languageName': {'simpleText': 'Friulian'}},
    {'languageCode': 'fy', 'languageName': {'simpleText': 'Western Frisian'}},
    {'languageCode': 'ga', 'languageName': {'simpleText': 'Irish'}},
    {'languageCode': 'gaa', 'languageName': {'simpleText': 'Ga'}},
    {'languageCode': 'gay', 'languageName': {'simpleText': 'Gayo'}},
    {'languageCode': 'gba', 'languageName': {'simpleText': 'Gbaya'}},
    {'languageCode': 'gd', 'languageName': {'simpleText': 'Scottish Gaelic'}},
    {'languageCode': 'gez', 'languageName': {'simpleText': 'Geez'}},
    {'languageCode': 'gil', 'languageName': {'simpleText': 'Gilbertese'}},
    {'languageCode': 'gl', 'languageName': {'simpleText': 'Galician'}},
    {'languageCode': 'gmh', 'languageName': {'simpleText': 'Middle High German'}},
    {'languageCode': 'gn', 'languageName': {'simpleText': 'Guarani'}},
    {'languageCode': 'goh', 'languageName': {'simpleText': 'Old High German'}},
    {'languageCode': 'gon', 'languageName': {'simpleText': 'Gondi'}},
    {'languageCode': 'gor', 'languageName': {'simpleText': 'Gorontalo'}},
    {'languageCode': 'got', 'languageName': {'simpleText': 'Gothic'}},
    {'languageCode': 'grb', 'languageName': {'simpleText': 'Grebo'}},
    {'languageCode': 'grc', 'languageName': {'simpleText': 'Ancient Greek'}},
    {'languageCode': 'gsw', 'languageName': {'simpleText': 'Swiss German'}},
    {'languageCode': 'gu', 'languageName': {'simpleText': 'Gujarati'}},
    {'languageCode': 'guz', 'languageName': {'simpleText': 'Gusii'}},
    {'languageCode': 'gv', 'languageName': {'simpleText': 'Manx'}},
    {'languageCode': 'gwi', 'languageName': {'simpleText': 'Gwich\u02bcin'}},
    {'languageCode': 'ha', 'languageName': {'simpleText': 'Hausa'}},
    {'languageCode': 'hai', 'languageName': {'simpleText': 'Haida'}},
    {'languageCode': 'haw', 'languageName': {'simpleText': 'Hawaiian'}},
    {'languageCode': 'he', 'languageName': {'simpleText': 'Hebrew'}},
    {'languageCode': 'hi', 'languageName': {'simpleText': 'Hindi'}},
    {'languageCode': 'hi_Latn', 'languageName': {'simpleText': 'Hindi (Latin)'}},
    {'languageCode': 'hil', 'languageName': {'simpleText': 'Hiligaynon'}},
    {'languageCode': 'hit', 'languageName': {'simpleText': 'Hittite'}},
    {'languageCode': 'hmn', 'languageName': {'simpleText': 'Hmong'}},
    {'languageCode': 'ho', 'languageName': {'simpleText': 'Hiri Motu'}},
    {'languageCode': 'hr', 'languageName': {'simpleText': 'Croatian'}},
    {'languageCode': 'hsb', 'languageName': {'simpleText': 'Upper Sorbian'}},
    {'languageCode': 'ht', 'languageName': {'simpleText': 'Haitian Creole'}},
    {'languageCode': 'hu', 'languageName': {'simpleText': 'Hungarian'}},
    {'languageCode': 'hup', 'languageName': {'simpleText': 'Hupa'}},
    {'languageCode': 'hy', 'languageName': {'simpleText': 'Armenian'}},
    {'languageCode': 'hz', 'languageName': {'simpleText': 'Herero'}},
    {'languageCode': 'ia', 'languageName': {'simpleText': 'Interlingua'}},
    {'languageCode': 'iba', 'languageName': {'simpleText': 'Iban'}},
    {'languageCode': 'ibb', 'languageName': {'simpleText': 'Ibibio'}},
    {'languageCode': 'id', 'languageName': {'simpleText': 'Indonesian'}},
    {'languageCode': 'ie', 'languageName': {'simpleText': 'Interlingue'}},
    {'languageCode': 'ig', 'languageName': {'simpleText': 'Igbo'}},
    {'languageCode': 'ii', 'languageName': {'simpleText': 'Sichuan Yi'}},
    {'languageCode': 'ik', 'languageName': {'simpleText': 'Inupiaq'}},
    {'languageCode': 'ilo', 'languageName': {'simpleText': 'Iloko'}},
    {'languageCode': 'in', 'languageName': {'simpleText': 'Indonesian'}},
    {'languageCode': 'inh', 'languageName': {'simpleText': 'Ingush'}},
    {'languageCode': 'io', 'languageName': {'simpleText': 'Ido'}},
    {'languageCode': 'is', 'languageName': {'simpleText': 'Icelandic'}},
    {'languageCode': 'it', 'languageName': {'simpleText': 'Italian'}},
    {'languageCode': 'iu', 'languageName': {'simpleText': 'Inuktitut'}},
    {'languageCode': 'iw', 'languageName': {'simpleText': 'Hebrew'}},
    {'languageCode': 'ja', 'languageName': {'simpleText': 'Japanese'}},
    {'languageCode': 'jbo', 'languageName': {'simpleText': 'Lojban'}},
    {'languageCode': 'jgo', 'languageName': {'simpleText': 'Ngomba'}},
    {'languageCode': 'jmc', 'languageName': {'simpleText': 'Machame'}},
    {'languageCode': 'jpr', 'languageName': {'simpleText': 'Judeo-Persian'}},
    {'languageCode': 'jrb', 'languageName': {'simpleText': 'Judeo-Arabic'}},
    {'languageCode': 'jv', 'languageName': {'simpleText': 'Javanese'}},
    {'languageCode': 'ka', 'languageName': {'simpleText': 'Georgian'}},
    {'languageCode': 'kaa', 'languageName': {'simpleText': 'Kara-Kalpak'}},
    {'languageCode': 'kab', 'languageName': {'simpleText': 'Kabyle'}},
    {'languageCode': 'kac', 'languageName': {'simpleText': 'Kachin'}},
    {'languageCode': 'kaj', 'languageName': {'simpleText': 'Jju'}},
    {'languageCode': 'kam', 'languageName': {'simpleText': 'Kamba'}},
    {'languageCode': 'kaw', 'languageName': {'simpleText': 'Kawi'}},
    {'languageCode': 'kbd', 'languageName': {'simpleText': 'Kabardian'}},
    {'languageCode': 'kbl', 'languageName': {'simpleText': 'Kanembu'}},
    {'languageCode': 'kcg', 'languageName': {'simpleText': 'Tyap'}},
    {'languageCode': 'kde', 'languageName': {'simpleText': 'Makonde'}},
    {'languageCode': 'kea', 'languageName': {'simpleText': 'Kabuverdianu'}},
    {'languageCode': 'kfo', 'languageName': {'simpleText': 'Koro'}},
    {'languageCode': 'kg', 'languageName': {'simpleText': 'Kongo'}},
    {'languageCode': 'kgp', 'languageName': {'simpleText': 'Kaingang'}},
    {'languageCode': 'kha', 'languageName': {'simpleText': 'Khasi'}},
    {'languageCode': 'kho', 'languageName': {'simpleText': 'Khotanese'}},
    {'languageCode': 'khq', 'languageName': {'simpleText': 'Koyra Chiini'}},
    {'languageCode': 'ki', 'languageName': {'simpleText': 'Kikuyu'}},
    {'languageCode': 'kj', 'languageName': {'simpleText': 'Kuanyama'}},
    {'languageCode': 'kk', 'languageName': {'simpleText': 'Kazakh'}},
    {'languageCode': 'kkj', 'languageName': {'simpleText': 'Kako'}},
    {'languageCode': 'kl', 'languageName': {'simpleText': 'Kalaallisut'}},
    {'languageCode': 'kln', 'languageName': {'simpleText': 'Kalenjin'}},
    {'languageCode': 'km', 'languageName': {'simpleText': 'Khmer'}},
    {'languageCode': 'kmb', 'languageName': {'simpleText': 'Kimbundu'}},
    {'languageCode': 'kn', 'languageName': {'simpleText': 'Kannada'}},
    {'languageCode': 'ko', 'languageName': {'simpleText': 'Korean'}},
    {'languageCode': 'kok', 'languageName': {'simpleText': 'Konkani'}},
    {'languageCode': 'kos', 'languageName': {'simpleText': 'Kosraean'}},
    {'languageCode': 'kpe', 'languageName': {'simpleText': 'Kpelle'}},
    {'languageCode': 'kr', 'languageName': {'simpleText': 'Kanuri'}},
    {'languageCode': 'krc', 'languageName': {'simpleText': 'Karachay-Balkar'}},
    {'languageCode': 'krl', 'languageName': {'simpleText': 'Karelian'}},
    {'languageCode': 'kru', 'languageName': {'simpleText': 'Kurukh'}},
    {'languageCode': 'ks', 'languageName': {'simpleText': 'Kashmiri'}},
    {'languageCode': 'ks_Arab', 'languageName': {'simpleText': 'Kashmiri (Arabic)'}},
    {'languageCode': 'ks_Deva', 'languageName': {'simpleText': 'Kashmiri (Devanagari)'}},
    {'languageCode': 'ksb', 'languageName': {'simpleText': 'Shambala'}},
    {'languageCode': 'ksf', 'languageName': {'simpleText': 'Bafia'}},
    {'languageCode': 'ksh', 'languageName': {'simpleText': 'Colognian'}},
    {'languageCode': 'ku', 'languageName': {'simpleText': 'Kurdish'}},
    {'languageCode': 'kum', 'languageName': {'simpleText': 'Kumyk'}},
    {'languageCode': 'kut', 'languageName': {'simpleText': 'Kutenai'}},
    {'languageCode': 'kv', 'languageName': {'simpleText': 'Komi'}},
    {'languageCode': 'kw', 'languageName': {'simpleText': 'Cornish'}},
    {'languageCode': 'kxv', 'languageName': {'simpleText': 'Kuvi'}},
    {'languageCode': 'kxv_Deva', 'languageName': {'simpleText': 'Kuvi (Devanagari)'}},
    {'languageCode': 'kxv_Latn', 'languageName': {'simpleText': 'Kuvi (Latin)'}},
    {'languageCode': 'kxv_Orya', 'languageName': {'simpleText': 'Kuvi (Odia)'}},
    {'languageCode': 'kxv_Telu', 'languageName': {'simpleText': 'Kuvi (Telugu)'}},
    {'languageCode': 'ky', 'languageName': {'simpleText': 'Kyrgyz'}},
    {'languageCode': 'la', 'languageName': {'simpleText': 'Latin'}},
    {'languageCode': 'lad', 'languageName': {'simpleText': 'Ladino'}},
    {'languageCode': 'lag', 'languageName': {'simpleText': 'Langi'}},
    {'languageCode': 'lah', 'languageName': {'simpleText': 'Western Panjabi'}},
    {'languageCode': 'lam', 'languageName': {'simpleText': 'Lamba'}},
    {'languageCode': 'lb', 'languageName': {'simpleText': 'Luxembourgish'}},
    {'languageCode': 'lez', 'languageName': {'simpleText': 'Lezghian'}},
    {'languageCode': 'lg', 'languageName': {'simpleText': 'Ganda'}},
    {'languageCode': 'li', 'languageName': {'simpleText': 'Limburgish'}},
    {'languageCode': 'lij', 'languageName': {'simpleText': 'Ligurian'}},
    {'languageCode': 'lkt', 'languageName': {'simpleText': 'Lakota'}},
    {'languageCode': 'lmo', 'languageName': {'simpleText': 'Lombard'}},
    {'languageCode': 'ln', 'languageName': {'simpleText': 'Lingala'}},
    {'languageCode': 'lo', 'languageName': {'simpleText': 'Lao'}},
    {'languageCode': 'lol', 'languageName': {'simpleText': 'Mongo'}},
    {'languageCode': 'loz', 'languageName': {'simpleText': 'Lozi'}},
    {'languageCode': 'lrc', 'languageName': {'simpleText': 'Northern Luri'}},
    {'languageCode': 'lt', 'languageName': {'simpleText': 'Lithuanian'}},
    {'languageCode': 'lu', 'languageName': {'simpleText': 'Luba-Katanga'}},
    {'languageCode': 'lua', 'languageName': {'simpleText': 'Luba-Lulua'}},
    {'languageCode': 'lui', 'languageName': {'simpleText': 'Luiseno'}},
    {'languageCode': 'lun', 'languageName': {'simpleText': 'Lunda'}},
    {'languageCode': 'luo', 'languageName': {'simpleText': 'Luo'}},
    {'languageCode': 'lus', 'languageName': {'simpleText': 'Mizo'}},
    {'languageCode': 'luy', 'languageName': {'simpleText': 'Luyia'}},
    {'languageCode': 'lv', 'languageName': {'simpleText': 'Latvian'}},
    {'languageCode': 'mad', 'languageName': {'simpleText': 'Madurese'}},
    {'languageCode': 'maf', 'languageName': {'simpleText': 'Mafa'}},
    {'languageCode': 'mag', 'languageName': {'simpleText': 'Magahi'}},
    {'languageCode': 'mai', 'languageName': {'simpleText': 'Maithili'}},
    {'languageCode': 'mak', 'languageName': {'simpleText': 'Makasar'}},
    {'languageCode': 'man', 'languageName': {'simpleText': 'Mandingo'}},
    {'languageCode': 'mas', 'languageName': {'simpleText': 'Masai'}},
    {'languageCode': 'mde', 'languageName': {'simpleText': 'Maba'}},
    {'languageCode': 'mdf', 'languageName': {'simpleText': 'Moksha'}},
    {'languageCode': 'mdr', 'languageName': {'simpleText': 'Mandar'}},
    {'languageCode': 'men', 'languageName': {'simpleText': 'Mende'}},
    {'languageCode': 'mer', 'languageName': {'simpleText': 'Meru'}},
    {'languageCode': 'mfe', 'languageName': {'simpleText': 'Morisyen'}},
    {'languageCode': 'mg', 'languageName': {'simpleText': 'Malagasy'}},
    {'languageCode': 'mga', 'languageName': {'simpleText': 'Middle Irish'}},
    {'languageCode': 'mgh', 'languageName': {'simpleText': 'Makhuwa-Meetto'}},
    {'languageCode': 'mgo', 'languageName': {'simpleText': 'Meta\u02bc'}},
    {'languageCode': 'mh', 'languageName': {'simpleText': 'Marshallese'}},
    {'languageCode': 'mi', 'languageName': {'simpleText': 'M\u0101ori'}},
    {'languageCode': 'mic', 'languageName': {'simpleText': 'Mi\'kmaw'}},
    {'languageCode': 'min', 'languageName': {'simpleText': 'Minangkabau'}},
    {'languageCode': 'mk', 'languageName': {'simpleText': 'Macedonian'}},
    {'languageCode': 'ml', 'languageName': {'simpleText': 'Malayalam'}},
    {'languageCode': 'mn', 'languageName': {'simpleText': 'Mongolian'}},
    {'languageCode': 'mnc', 'languageName': {'simpleText': 'Manchu'}},
    {'languageCode': 'mni', 'languageName': {'simpleText': 'Manipuri'}},
    {'languageCode': 'mni_Beng', 'languageName': {'simpleText': 'Manipuri (Bangla)'}},
    {'languageCode': 'mo', 'languageName': {'simpleText': 'Romanian'}},
    {'languageCode': 'moh', 'languageName': {'simpleText': 'Mohawk'}},
    {'languageCode': 'mos', 'languageName': {'simpleText': 'Mossi'}},
    {'languageCode': 'mr', 'languageName': {'simpleText': 'Marathi'}},
    {'languageCode': 'ms', 'languageName': {'simpleText': 'Malay'}},
    {'languageCode': 'mt', 'languageName': {'simpleText': 'Maltese'}},
    {'languageCode': 'mua', 'languageName': {'simpleText': 'Mundang'}},
    {'languageCode': 'mul', 'languageName': {'simpleText': 'Multiple languages'}},
    {'languageCode': 'mus', 'languageName': {'simpleText': 'Muscogee'}},
    {'languageCode': 'mwl', 'languageName': {'simpleText': 'Mirandese'}},
    {'languageCode': 'mwr', 'languageName': {'simpleText': 'Marwari'}},
    {'languageCode': 'my', 'languageName': {'simpleText': 'Burmese'}},
    {'languageCode': 'mye', 'languageName': {'simpleText': 'Myene'}},
    {'languageCode': 'myv', 'languageName': {'simpleText': 'Erzya'}},
    {'languageCode': 'mzn', 'languageName': {'simpleText': 'Mazanderani'}},
    {'languageCode': 'na', 'languageName': {'simpleText': 'Nauru'}},
    {'languageCode': 'nap', 'languageName': {'simpleText': 'Neapolitan'}},
    {'languageCode': 'naq', 'languageName': {'simpleText': 'Nama'}},
    {'languageCode': 'nb', 'languageName': {'simpleText': 'Norwegian Bokm\u00e5l'}},
    {'languageCode': 'nd', 'languageName': {'simpleText': 'North Ndebele'}},
    {'languageCode': 'nds', 'languageName': {'simpleText': 'Low German'}},
    {'languageCode': 'nds_NL', 'languageName': {'simpleText': 'Low German (Netherlands)'}},
    {'languageCode': 'ne', 'languageName': {'simpleText': 'Nepali'}},
    {'languageCode': 'new', 'languageName': {'simpleText': 'Newari'}},
    {'languageCode': 'ng', 'languageName': {'simpleText': 'Ndonga'}},
    {'languageCode': 'nia', 'languageName': {'simpleText': 'Nias'}},
    {'languageCode': 'niu', 'languageName': {'simpleText': 'Niuean'}},
    {'languageCode': 'nl', 'languageName': {'simpleText': 'Dutch'}},
    {'languageCode': 'nl_BE', 'languageName': {'simpleText': 'Dutch (Belgium)'}},
    {'languageCode': 'nmg', 'languageName': {'simpleText': 'Kwasio'}},
    {'languageCode': 'nn', 'languageName': {'simpleText': 'Norwegian Nynorsk'}},
    {'languageCode': 'nnh', 'languageName': {'simpleText': 'Ngiemboon'}},
    {'languageCode': 'no', 'languageName': {'simpleText': 'Norwegian'}},
    {'languageCode': 'nog', 'languageName': {'simpleText': 'Nogai'}},
    {'languageCode': 'non', 'languageName': {'simpleText': 'Old Norse'}},
    {'languageCode': 'nqo', 'languageName': {'simpleText': 'N\u2019Ko'}},
    {'languageCode': 'nr', 'languageName': {'simpleText': 'South Ndebele'}},
    {'languageCode': 'nso', 'languageName': {'simpleText': 'Northern Sotho'}},
    {'languageCode': 'nus', 'languageName': {'simpleText': 'Nuer'}},
    {'languageCode': 'nv', 'languageName': {'simpleText': 'Navajo'}},
    {'languageCode': 'nwc', 'languageName': {'simpleText': 'Classical Newari'}},
    {'languageCode': 'ny', 'languageName': {'simpleText': 'Nyanja'}},
    {'languageCode': 'nym', 'languageName': {'simpleText': 'Nyamwezi'}},
    {'languageCode': 'nyn', 'languageName': {'simpleText': 'Nyankole'}},
    {'languageCode': 'nyo', 'languageName': {'simpleText': 'Nyoro'}},
    {'languageCode': 'nzi', 'languageName': {'simpleText': 'Nzima'}},
    {'languageCode': 'oc', 'languageName': {'simpleText': 'Occitan'}},
    {'languageCode': 'oj', 'languageName': {'simpleText': 'Ojibwa'}},
    {'languageCode': 'om', 'languageName': {'simpleText': 'Oromo'}},
    {'languageCode': 'or', 'languageName': {'simpleText': 'Odia'}},
    {'languageCode': 'os', 'languageName': {'simpleText': 'Ossetic'}},
    {'languageCode': 'osa', 'languageName': {'simpleText': 'Osage'}},
    {'languageCode': 'ota', 'languageName': {'simpleText': 'Ottoman Turkish'}},
    {'languageCode': 'pa', 'languageName': {'simpleText': 'Punjabi'}},
    {'languageCode': 'pa_Arab', 'languageName': {'simpleText': 'Punjabi (Arabic)'}},
    {'languageCode': 'pa_Guru', 'languageName': {'simpleText': 'Punjabi (Gurmukhi)'}},
    {'languageCode': 'pag', 'languageName': {'simpleText': 'Pangasinan'}},
    {'languageCode': 'pal', 'languageName': {'simpleText': 'Pahlavi'}},
    {'languageCode': 'pam', 'languageName': {'simpleText': 'Pampanga'}},
    {'languageCode': 'pap', 'languageName': {'simpleText': 'Papiamento'}},
    {'languageCode': 'pau', 'languageName': {'simpleText': 'Palauan'}},
    {'languageCode': 'pcm', 'languageName': {'simpleText': 'Nigerian Pidgin'}},
    {'languageCode': 'peo', 'languageName': {'simpleText': 'Old Persian'}},
    {'languageCode': 'phn', 'languageName': {'simpleText': 'Phoenician'}},
    {'languageCode': 'pi', 'languageName': {'simpleText': 'Pali'}},
    {'languageCode': 'pl', 'languageName': {'simpleText': 'Polish'}},
    {'languageCode': 'pon', 'languageName': {'simpleText': 'Pohnpeian'}},
    {'languageCode': 'prg', 'languageName': {'simpleText': 'Prussian'}},
    {'languageCode': 'pro', 'languageName': {'simpleText': 'Old Proven\u00e7al'}},
    {'languageCode': 'ps', 'languageName': {'simpleText': 'Pashto'}},
    {'languageCode': 'pt', 'languageName': {'simpleText': 'Portuguese'}},
    {'languageCode': 'pt_BR', 'languageName': {'simpleText': 'Portuguese (Brazil)'}},
    {'languageCode': 'pt_PT', 'languageName': {'simpleText': 'Portuguese (Portugal)'}},
    {'languageCode': 'qu', 'languageName': {'simpleText': 'Quechua'}},
    {'languageCode': 'raj', 'languageName': {'simpleText': 'Rajasthani'}},
    {'languageCode': 'rap', 'languageName': {'simpleText': 'Rapanui'}},
    {'languageCode': 'rar', 'languageName': {'simpleText': 'Rarotongan'}},
    {'languageCode': 'rm', 'languageName': {'simpleText': 'Romansh'}},
    {'languageCode': 'rn', 'languageName': {'simpleText': 'Rundi'}},
    {'languageCode': 'ro', 'languageName': {'simpleText': 'Romanian'}},
    {'languageCode': 'ro_MD', 'languageName': {'simpleText': 'Romanian (Moldova)'}},
    {'languageCode': 'rof', 'languageName': {'simpleText': 'Rombo'}},
    {'languageCode': 'rom', 'languageName': {'simpleText': 'Romany'}},
    {'languageCode': 'ru', 'languageName': {'simpleText': 'Russian'}},
    {'languageCode': 'rup', 'languageName': {'simpleText': 'Aromanian'}},
    {'languageCode': 'rw', 'languageName': {'simpleText': 'Kinyarwanda'}},
    {'languageCode': 'rwk', 'languageName': {'simpleText': 'Rwa'}},
    {'languageCode': 'sa', 'languageName': {'simpleText': 'Sanskrit'}},
    {'languageCode': 'sad', 'languageName': {'simpleText': 'Sandawe'}},
    {'languageCode': 'sah', 'languageName': {'simpleText': 'Yakut'}},
    {'languageCode': 'sam', 'languageName': {'simpleText': 'Samaritan Aramaic'}},
    {'languageCode': 'saq', 'languageName': {'simpleText': 'Samburu'}},
    {'languageCode': 'sas', 'languageName': {'simpleText': 'Sasak'}},
    {'languageCode': 'sat', 'languageName': {'simpleText': 'Santali'}},
    {'languageCode': 'sat_Olck', 'languageName': {'simpleText': 'Santali (Ol Chiki)'}},
    {'languageCode': 'sba', 'languageName': {'simpleText': 'Ngambay'}},
    {'languageCode': 'sbp', 'languageName': {'simpleText': 'Sangu'}},
    {'languageCode': 'sc', 'languageName': {'simpleText': 'Sardinian'}},
    {'languageCode': 'scn', 'languageName': {'simpleText': 'Sicilian'}},
    {'languageCode': 'sco', 'languageName': {'simpleText': 'Scots'}},
    {'languageCode': 'sd', 'languageName': {'simpleText': 'Sindhi'}},
    {'languageCode': 'sd_Arab', 'languageName': {'simpleText': 'Sindhi (Arabic)'}},
    {'languageCode': 'sd_Deva', 'languageName': {'simpleText': 'Sindhi (Devanagari)'}},
    {'languageCode': 'se', 'languageName': {'simpleText': 'Northern Sami'}},
    {'languageCode': 'see', 'languageName': {'simpleText': 'Seneca'}},
    {'languageCode': 'seh', 'languageName': {'simpleText': 'Sena'}},
    {'languageCode': 'sel', 'languageName': {'simpleText': 'Selkup'}},
    {'languageCode': 'ses', 'languageName': {'simpleText': 'Koyraboro Senni'}},
    {'languageCode': 'sg', 'languageName': {'simpleText': 'Sango'}},
    {'languageCode': 'sga', 'languageName': {'simpleText': 'Old Irish'}},
    {'languageCode': 'sh', 'languageName': {'simpleText': 'Serbo-Croatian'}},
    {'languageCode': 'shi', 'languageName': {'simpleText': 'Tachelhit'}},
    {'languageCode': 'shi_Latn', 'languageName': {'simpleText': 'Tachelhit (Latin)'}},
    {'languageCode': 'shi_Tfng', 'languageName': {'simpleText': 'Tachelhit (Tifinagh)'}},
    {'languageCode': 'shn', 'languageName': {'simpleText': 'Shan'}},
    {'languageCode': 'shu', 'languageName': {'simpleText': 'Chadian Arabic'}},
    {'languageCode': 'si', 'languageName': {'simpleText': 'Sinhala'}},
    {'languageCode': 'sid', 'languageName': {'simpleText': 'Sidamo'}},
    {'languageCode': 'sk', 'languageName': {'simpleText': 'Slovak'}},
    {'languageCode': 'sl', 'languageName': {'simpleText': 'Slovenian'}},
    {'languageCode': 'sm', 'languageName': {'simpleText': 'Samoan'}},
    {'languageCode': 'sma', 'languageName': {'simpleText': 'Southern Sami'}},
    {'languageCode': 'smj', 'languageName': {'simpleText': 'Lule Sami'}},
    {'languageCode': 'smn', 'languageName': {'simpleText': 'Inari Sami'}},
    {'languageCode': 'sms', 'languageName': {'simpleText': 'Skolt Sami'}},
    {'languageCode': 'sn', 'languageName': {'simpleText': 'Shona'}},
    {'languageCode': 'snk', 'languageName': {'simpleText': 'Soninke'}},
    {'languageCode': 'so', 'languageName': {'simpleText': 'Somali'}},
    {'languageCode': 'sog', 'languageName': {'simpleText': 'Sogdien'}},
    {'languageCode': 'sq', 'languageName': {'simpleText': 'Albanian'}},
    {'languageCode': 'sr', 'languageName': {'simpleText': 'Serbian'}},
    {'languageCode': 'sr_Cyrl', 'languageName': {'simpleText': 'Serbian (Cyrillic)'}},
    {'languageCode': 'sr_Latn', 'languageName': {'simpleText': 'Serbian (Latin)'}},
    {'languageCode': 'srn', 'languageName': {'simpleText': 'Sranan Tongo'}},
    {'languageCode': 'srr', 'languageName': {'simpleText': 'Serer'}},
    {'languageCode': 'ss', 'languageName': {'simpleText': 'Swati'}},
    {'languageCode': 'ssy', 'languageName': {'simpleText': 'Saho'}},
    {'languageCode': 'st', 'languageName': {'simpleText': 'Southern Sotho'}},
    {'languageCode': 'su', 'languageName': {'simpleText': 'Sundanese'}},
    {'languageCode': 'su_Latn', 'languageName': {'simpleText': 'Sundanese (Latin)'}},
    {'languageCode': 'suk', 'languageName': {'simpleText': 'Sukuma'}},
    {'languageCode': 'sus', 'languageName': {'simpleText': 'Susu'}},
    {'languageCode': 'sux', 'languageName': {'simpleText': 'Sumerian'}},
    {'languageCode': 'sv', 'languageName': {'simpleText': 'Swedish'}},
    {'languageCode': 'sw', 'languageName': {'simpleText': 'Swahili'}},
    {'languageCode': 'sw_CD', 'languageName': {'simpleText': 'Swahili (Congo - Kinshasa)'}},
    {'languageCode': 'swb', 'languageName': {'simpleText': 'Comorian'}},
    {'languageCode': 'syc', 'languageName': {'simpleText': 'Classical Syriac'}},
    {'languageCode': 'syr', 'languageName': {'simpleText': 'Syriac'}},
    {'languageCode': 'szl', 'languageName': {'simpleText': 'Silesian'}},
    {'languageCode': 'ta', 'languageName': {'simpleText': 'Tamil'}},
    {'languageCode': 'te', 'languageName': {'simpleText': 'Telugu'}},
    {'languageCode': 'tem', 'languageName': {'simpleText': 'Timne'}},
    {'languageCode': 'teo', 'languageName': {'simpleText': 'Teso'}},
    {'languageCode': 'ter', 'languageName': {'simpleText': 'Tereno'}},
    {'languageCode': 'tet', 'languageName': {'simpleText': 'Tetum'}},
    {'languageCode': 'tg', 'languageName': {'simpleText': 'Tajik'}},
    {'languageCode': 'th', 'languageName': {'simpleText': 'Thai'}},
    {'languageCode': 'ti', 'languageName': {'simpleText': 'Tigrinya'}},
    {'languageCode': 'tig', 'languageName': {'simpleText': 'Tigre'}},
    {'languageCode': 'tiv', 'languageName': {'simpleText': 'Tiv'}},
    {'languageCode': 'tk', 'languageName': {'simpleText': 'Turkmen'}},
    {'languageCode': 'tkl', 'languageName': {'simpleText': 'Tokelau'}},
    {'languageCode': 'tl', 'languageName': {'simpleText': 'Tagalog'}},
    {'languageCode': 'tlh', 'languageName': {'simpleText': 'Klingon'}},
    {'languageCode': 'tli', 'languageName': {'simpleText': 'Tlingit'}},
    {'languageCode': 'tmh', 'languageName': {'simpleText': 'Tamashek'}},
    {'languageCode': 'tn', 'languageName': {'simpleText': 'Tswana'}},
    {'languageCode': 'to', 'languageName': {'simpleText': 'Tongan'}},
    {'languageCode': 'tog', 'languageName': {'simpleText': 'Nyasa Tonga'}},
    {'languageCode': 'tok', 'languageName': {'simpleText': 'Toki Pona'}},
    {'languageCode': 'tpi', 'languageName': {'simpleText': 'Tok Pisin'}},
    {'languageCode': 'tr', 'languageName': {'simpleText': 'Turkish'}},
    {'languageCode': 'trv', 'languageName': {'simpleText': 'Taroko'}},
    {'languageCode': 'ts', 'languageName': {'simpleText': 'Tsonga'}},
    {'languageCode': 'tsi', 'languageName': {'simpleText': 'Tsimshian'}},
    {'languageCode': 'tt', 'languageName': {'simpleText': 'Tatar'}},
    {'languageCode': 'tum', 'languageName': {'simpleText': 'Tumbuka'}},
    {'languageCode': 'tvl', 'languageName': {'simpleText': 'Tuvalu'}},
    {'languageCode': 'tw', 'languageName': {'simpleText': 'Twi'}},
    {'languageCode': 'twq', 'languageName': {'simpleText': 'Tasawaq'}},
    {'languageCode': 'ty', 'languageName': {'simpleText': 'Tahitian'}},
    {'languageCode': 'tyv', 'languageName': {'simpleText': 'Tuvinian'}},
    {'languageCode': 'tzm', 'languageName': {'simpleText': 'Central Atlas Tamazight'}},
    {'languageCode': 'udm', 'languageName': {'simpleText': 'Udmurt'}},
    {'languageCode': 'ug', 'languageName': {'simpleText': 'Uyghur'}},
    {'languageCode': 'uga', 'languageName': {'simpleText': 'Ugaritic'}},
    {'languageCode': 'uk', 'languageName': {'simpleText': 'Ukrainian'}},
    {'languageCode': 'umb', 'languageName': {'simpleText': 'Umbundu'}},
    {'languageCode': 'ur', 'languageName': {'simpleText': 'Urdu'}},
    {'languageCode': 'uz', 'languageName': {'simpleText': 'Uzbek'}},
    {'languageCode': 'uz_Arab', 'languageName': {'simpleText': 'Uzbek (Arabic)'}},
    {'languageCode': 'uz_Cyrl', 'languageName': {'simpleText': 'Uzbek (Cyrillic)'}},
    {'languageCode': 'uz_Latn', 'languageName': {'simpleText': 'Uzbek (Latin)'}},
    {'languageCode': 'vai', 'languageName': {'simpleText': 'Vai'}},
    {'languageCode': 'vai_Latn', 'languageName': {'simpleText': 'Vai (Latin)'}},
    {'languageCode': 'vai_Vaii', 'languageName': {'simpleText': 'Vai (Vai)'}},
    {'languageCode': 've', 'languageName': {'simpleText': 'Venda'}},
    {'languageCode': 'vec', 'languageName': {'simpleText': 'Venetian'}},
    {'languageCode': 'vi', 'languageName': {'simpleText': 'Vietnamese'}},
    {'languageCode': 'vmw', 'languageName': {'simpleText': 'Makhuwa'}},
    {'languageCode': 'vo', 'languageName': {'simpleText': 'Volap\u00fck'}},
    {'languageCode': 'vot', 'languageName': {'simpleText': 'Votic'}},
    {'languageCode': 'vun', 'languageName': {'simpleText': 'Vunjo'}},
    {'languageCode': 'wa', 'languageName': {'simpleText': 'Walloon'}},
    {'languageCode': 'wae', 'languageName': {'simpleText': 'Walser'}},
    {'languageCode': 'wal', 'languageName': {'simpleText': 'Wolaytta'}},
    {'languageCode': 'war', 'languageName': {'simpleText': 'Waray'}},
    {'languageCode': 'was', 'languageName': {'simpleText': 'Washo'}},
    {'languageCode': 'wo', 'languageName': {'simpleText': 'Wolof'}},
    {'languageCode': 'xal', 'languageName': {'simpleText': 'Kalmyk'}},
    {'languageCode': 'xh', 'languageName': {'simpleText': 'Xhosa'}},
    {'languageCode': 'xnr', 'languageName': {'simpleText': 'Kangri'}},
    {'languageCode': 'xog', 'languageName': {'simpleText': 'Soga'}},
    {'languageCode': 'yao', 'languageName': {'simpleText': 'Yao'}},
    {'languageCode': 'yap', 'languageName': {'simpleText': 'Yapese'}},
    {'languageCode': 'yav', 'languageName': {'simpleText': 'Yangben'}},
    {'languageCode': 'ybb', 'languageName': {'simpleText': 'Yemba'}},
    {'languageCode': 'yi', 'languageName': {'simpleText': 'Yiddish'}},
    {'languageCode': 'yo', 'languageName': {'simpleText': 'Yoruba'}},
    {'languageCode': 'yrl', 'languageName': {'simpleText': 'Nheengatu'}},
    {'languageCode': 'yue', 'languageName': {'simpleText': 'Cantonese'}},
    {'languageCode': 'yue_Hans', 'languageName': {'simpleText': 'Cantonese (Simplified)'}},
    {'languageCode': 'yue_Hant', 'languageName': {'simpleText': 'Cantonese (Traditional)'}},
    {'languageCode': 'za', 'languageName': {'simpleText': 'Zhuang'}},
    {'languageCode': 'zap', 'languageName': {'simpleText': 'Zapotec'}},
    {'languageCode': 'zbl', 'languageName': {'simpleText': 'Blissymbols'}},
    {'languageCode': 'zen', 'languageName': {'simpleText': 'Zenaga'}},
    {'languageCode': 'zgh', 'languageName': {'simpleText': 'Standard Moroccan Tamazight'}},
    {'languageCode': 'zh', 'languageName': {'simpleText': 'Chinese'}},
    {'languageCode': 'zh_Hans', 'languageName': {'simpleText': 'Chinese (Simplified)'}},
    {'languageCode': 'zh_Hant', 'languageName': {'simpleText': 'Chinese (Traditional)'}},
    {'languageCode': 'zh_TW', 'languageName': {'simpleText': 'Chinese (Taiwan)'}},
    {'languageCode': 'zu', 'languageName': {'simpleText': 'Zulu'}},
    {'languageCode': 'zun', 'languageName': {'simpleText': 'Zuni'}},
    {'languageCode': 'zxx', 'languageName': {'simpleText': 'No linguistic content'}},
    {'languageCode': 'zza', 'languageName': {'simpleText': 'Zaza'}},
]
