/**
 * Some keyboard/mouse/joystick input functions

 * Copyright (C) 2003  Shawn Betts
 * Copyright (C) 2004  Sylvain Beucler
 * Copyright (C) 1997, 1998, 1999, 2002, 2003  Seth A. Robinson

 * This file is part of GNU FreeDink

 * GNU FreeDink is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2, or (at
 * your option) any later version.

 * GNU FreeDink is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with program; see the file COPYING. If not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.

 * $Header: /cvsroot/dink/dink/src/input.c,v 1.4 2004/01/16 19:55:45 Beuc Exp $
 */

#include <ctype.h>
#include "dink.h"
#include "string_util.h"

BOOL
keypressed (void)
{
  int x;
  for (x = 0; x < 256; x++)

    {
      if (GetKeyboard (/* SDLKey ( */x/* ) */))
	{
	  return (1);
	}
    }
  return (0);
}


void
check_joystick (void)
{
  int e2, x5, x, x2;
  /* UNREFERENCED   int total; */

  for (e2 = 1; e2 <= 10; e2++)
    {
      sjoy.joybit[e2] = 0;
    }

  sjoy.right = 0;
  sjoy.left = 0;
  sjoy.up = 0;
  sjoy.down = 0;

  sjoy.rightd = 0;
  sjoy.leftd = 0;
  sjoy.upd = 0;
  sjoy.downd = 0;

  /* UNREFERENCED pass: */

  /* 17 */
  if (GetKeyboard (SDLK_LCTRL))
    sjoy.joybit[1] = 1;
  if (GetKeyboard (SDLK_SPACE))
    sjoy.joybit[2] = 1;
  if (GetKeyboard (SDLK_LSHIFT))
    sjoy.joybit[3] = 1;
  if (GetKeyboard (SDLK_RETURN))
    sjoy.joybit[4] = 1;
  if (GetKeyboard (SDLK_ESCAPE))
    sjoy.joybit[5] = 1;

  /* 54, 55 */
  if (GetKeyboard (SDLK_6))
    sjoy.joybit[6] = 1;
  if (GetKeyboard (SDLK_7))
    sjoy.joybit[7] = 1;

  for (x5 = 1; x5 <= 10; x5++)
    sjoy.button[x5] = 0;

  for (x = 1; x <= 10; x++)
    {
      if (sjoy.joybit[x])
	{
	  if (sjoy.letgo[x] == 1)
	    {
	      sjoy.button[x] = 1;
	      sjoy.letgo[x] = 0;
	    }
	}
    }

  if (GetKeyboard (SDLK_RIGHT))
    sjoy.right = 1;
  if (GetKeyboard (SDLK_LEFT))
    sjoy.left = 1;
  if (GetKeyboard (SDLK_DOWN))
    sjoy.down = 1;
  if (GetKeyboard (SDLK_UP))
    sjoy.up = 1;

  for (x2 = 1; x2 <= 10; x2++)
    {
      if (sjoy.joybit[x2])
	sjoy.letgo[x2] = 0;
      else
	sjoy.letgo[x2] = 1;
    }

  if (sjoy.right)
    if (sjoy.rightold == 1)
      {
	sjoy.rightd = 1;
	sjoy.rightold = 0;
      }

  if (sjoy.right)
    sjoy.rightold = 0;
  else
    sjoy.rightold = 1;

  if (sjoy.left)
    if (sjoy.leftold == 1)
      {
	sjoy.leftd = 1;
	sjoy.leftold = 0;
      }

  if (sjoy.left)
    sjoy.leftold = 0;
  else
    sjoy.leftold = 1;
  if (sjoy.up)
    if (sjoy.upold == 1)
      {
	sjoy.upd = 1;
	sjoy.upold = 0;
      }

  if (sjoy.up)
    sjoy.upold = 0;
  else
    sjoy.upold = 1;
  if (sjoy.down)
    if (sjoy.downold == 1)
      {
	sjoy.downd = 1;
	sjoy.downold = 0;
      }

  if (sjoy.down)
    sjoy.downold = 0;
  else
    sjoy.downold = 1;

  if (wait.active)
    {
      /* check for dirs */
      int ll;

      if (sjoy.rightd)
	wait.button = 16;
      if (sjoy.leftd)
	wait.button = 14;
      if (sjoy.upd)
	wait.button = 18;
      if (sjoy.downd)
	wait.button = 12;

      sjoy.rightd = 0;
      sjoy.downd = 0;
      sjoy.upd = 0;
      sjoy.leftd = 0;

      /* check buttons */

      for (ll = 1; ll <= 10; ll++)

	{

	  if (sjoy.button[ll])

	    {
	      /* button was pressed */
	      wait.button = ll;

	    }
	  sjoy.button[ll] = 0;

	}

      if (wait.button != 0)

	{

	  *presult = wait.button;
	  wait.active = 0;
	  run_script (wait.script);

	}
    }
}



BOOL
CheckJoyStickPresent (void)
{
  /* first tests if a joystick driver is present */
  /* if TRUE it makes certain that a joystick is plugged in */

  if (SDL_NumJoysticks () > 0)
    {
      jinfo = SDL_JoystickOpen (0);
      Msg (("Name: %s\n", SDL_JoystickName (0)));
      Msg (("Number of Axes: %d\n", SDL_JoystickNumAxes (jinfo)));
      Msg (("Number of Buttons: %d\n", SDL_JoystickNumButtons (jinfo)));
      Msg (("Number of Balls: %d\n", SDL_JoystickNumBalls (jinfo)));
      return 1;
    }
  return 0;
}


void
Scrawl_OnMouseInput (void)
{

  UpdateCursorPosition (mouse_status.x, mouse_status.y);
  mouse1 = mouse_status.button;

}


/*bool*/int
getkey (int key)
{
  if (sjoy.realkey[key])
    return (1);
  else
    return (0);
}

/**
 * Returns 0 if the key has been depressed, else returns 1 (Beuc:
 * commented: and sets key to code recd.)
 */
int
GetKeyboard (int key)
{
/* return (GetAsyncKeyState (key)); */
  Uint8 *keystate = SDL_GetKeyState (NULL);

  return keystate[key];
}


char
key_convert (int key)
{
  if (!getkey (16))
    key = tolower (key);

  if (key == 190) {
    if (getkey (16))
      key = '>';
    else
      key = '.';
  }
  if (key == 188) {
    if (getkey (16))
      key = '<';
    else
      key = ',';
  }
  if (key == 49)
    if (getkey (16))
      key = '!';
  if (key == 50)
    if (getkey (16))
      key = '@';
  if (key == 51)
    if (getkey (16))
      key = '#';
  if (key == 52)
    if (getkey (16))
      key = '$';
  if (key == 53)
    if (getkey (16))
      key = '%';
  if (key == 54)
    if (getkey (16))
      key = '^';
  if (key == 55)
    if (getkey (16))
      key = '&';
  if (key == 56)
    if (getkey (16))
      key = '*';
  if (key == 57)
    if (getkey (16))
      key = '(';
  if (key == 48)
    if (getkey (16))
      key = ')';

  if (key == 189) {
    if (getkey (16))
      key = '_';
    else
      key = '-';
  }
  if (key == 187) {
    if (getkey (16))
      key = '+';
    else
      key = '=';
  }
  if (key == 186) {
    if (getkey (16))
      key = ':';
    else
      key = ';';
  }
  if (key == 222) {
    if (getkey (16))
      key = '\"';
    else
      key = '\'';
  }
  if (key == 191) {
    if (getkey (16))
      key = '?';
    else
      key = '/';
    }
  if (key == 220) {
    if (getkey (16))
      key = '|';
    else
      key = '\\';
  }


  return (key);

}

BOOL
init_mouse ()
{
  return 1;
}
