/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.api.minarea.launcher;

import java.io.Serializable;

public class ElapseTimer
implements Serializable {
    private long start = 0L;
    private long end = 0L;

    private long now() {
        return System.currentTimeMillis();
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public long getTime() {
        return this.end - this.start;
    }

    public static ElapseTimer createInstance() {
        return new ElapseTimer();
    }

    public static ElapseTimer createInstanceByValues(long start, long end) {
        ElapseTimer result = new ElapseTimer();
        result.start = start;
        result.end = end;
        return result;
    }

    public ElapseTimer start() {
        this.start = this.now();
        return this;
    }

    public ElapseTimer end() {
        this.end = this.now();
        return this;
    }

    public String toString() {
        return this.getElapsedTime(this.getTime());
    }

    public Long toLong() {
        return this.end - this.start;
    }

    public void print(String preText) {
        System.out.println(preText + this.toString());
    }

    private String getElapsedTime(long milliseconds) {
        int minutes;
        int hours;
        int days;
        if (milliseconds < 60000L) {
            return (double)milliseconds / 1000.0 + " secs";
        }
        StringBuffer buf = new StringBuffer();
        int seconds = (int)milliseconds / 1000;
        if (seconds < 0) {
            seconds = 0;
        }
        if ((days = seconds / 86400) > 0) {
            buf.append(days + " days, ");
        }
        if ((hours = (seconds -= days * 86400) / 3600) > 0) {
            buf.append(hours + " hrs, ");
        }
        if ((minutes = (seconds -= hours * 3600) / 60) > 0) {
            buf.append(minutes + " mins, ");
        }
        buf.append((seconds -= minutes * 60) + " secs");
        return buf.toString();
    }
}

