/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.tasks;

import com.google.common.collect.ImmutableList;
import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.internal.AbstractTask;
import org.gradle.api.internal.ConfigurationCacheDegradation;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.copy.CopySpecInternal;
import org.gradle.api.internal.lambdas.SerializableLambdas;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.provider.DefaultProvider;
import org.gradle.api.java.archives.Manifest;
import org.gradle.api.java.archives.internal.CustomManifestInternalWrapper;
import org.gradle.api.java.archives.internal.DefaultManifest;
import org.gradle.api.java.archives.internal.ManifestInternal;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.bundling.Zip;
import org.gradle.internal.execution.OutputChangeListener;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.instrumentation.api.annotations.ToBeReplacedByLazyProperty;
import org.gradle.internal.serialization.Cached;
import org.gradle.util.internal.ConfigureUtil;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Not worth caching")
public abstract class Jar
extends Zip {
    public static final String DEFAULT_EXTENSION = "jar";
    private String manifestContentCharset = "UTF-8";
    private Manifest manifest;
    private final CopySpecInternal metaInf;

    public Jar() {
        this.getArchiveExtension().set((Object)DEFAULT_EXTENSION);
        this.setMetadataCharset("UTF-8");
        this.manifest = new DefaultManifest((PathToFileResolver)this.getFileResolver());
        this.metaInf = (CopySpecInternal)this.getRootSpec().addFirst().into((Object)"META-INF");
        this.metaInf.addChild().from(new Object[]{this.manifestFileTree()});
        this.getMainSpec().appendCachingSafeCopyAction((Action)new ExcludeManifestAction());
        ConfigurationCacheDegradation.requireDegradation((AbstractTask)this, (Provider)new DefaultProvider(this::evaluateDegradationReason));
    }

    private String evaluateDegradationReason() {
        if (!this.manifestContentCharset.equals("UTF-8")) {
            return String.format("Custom charset '%s' was used. Only '%s' is supported with the configuration cache", this.manifestContentCharset, "UTF-8");
        }
        return null;
    }

    private FileTreeInternal manifestFileTree() {
        Cached manifest = Cached.of(this::computeManifest);
        OutputChangeListener outputChangeListener = this.outputChangeListener();
        return this.fileCollectionFactory().generated(this.getTemporaryDirFactory(), "MANIFEST.MF", SerializableLambdas.action((SerializableLambdas.SerializableAction & Serializable)file -> outputChangeListener.invalidateCachesFor((Iterable)ImmutableList.of((Object)file.getAbsolutePath()))), SerializableLambdas.action((SerializableLambdas.SerializableAction & Serializable)outputStream -> ((ManifestInternal)manifest.get()).writeTo((OutputStream)outputStream)));
    }

    private ManifestInternal computeManifest() {
        Manifest manifest = this.getManifest();
        if (manifest == null) {
            manifest = new DefaultManifest(null);
        }
        ManifestInternal manifestInternal = manifest instanceof ManifestInternal ? (ManifestInternal)manifest : new CustomManifestInternalWrapper(manifest);
        manifestInternal.setContentCharset(this.manifestContentCharset);
        return manifestInternal;
    }

    private FileCollectionFactory fileCollectionFactory() {
        return (FileCollectionFactory)this.getServices().get(FileCollectionFactory.class);
    }

    private OutputChangeListener outputChangeListener() {
        return (OutputChangeListener)this.getServices().get(OutputChangeListener.class);
    }

    @ToBeReplacedByLazyProperty
    public String getMetadataCharset() {
        return super.getMetadataCharset();
    }

    public void setMetadataCharset(String metadataCharset) {
        super.setMetadataCharset(metadataCharset);
    }

    @Input
    @ToBeReplacedByLazyProperty
    public String getManifestContentCharset() {
        return this.manifestContentCharset;
    }

    public void setManifestContentCharset(String manifestContentCharset) {
        if (manifestContentCharset == null) {
            throw new InvalidUserDataException("manifestContentCharset must not be null");
        }
        if (!Charset.isSupported(manifestContentCharset)) {
            throw new InvalidUserDataException(String.format("Charset for manifestContentCharset '%s' is not supported by your JVM", manifestContentCharset));
        }
        this.manifestContentCharset = manifestContentCharset;
    }

    @Internal
    @ToBeReplacedByLazyProperty
    public Manifest getManifest() {
        return this.manifest;
    }

    public void setManifest(Manifest manifest) {
        this.manifest = manifest;
    }

    public Jar manifest(@DelegatesTo(value=Manifest.class) Closure<?> configureClosure) {
        ConfigureUtil.configure(configureClosure, (Object)this.forceManifest());
        return this;
    }

    public Jar manifest(Action<? super Manifest> configureAction) {
        configureAction.execute((Object)this.forceManifest());
        return this;
    }

    private Manifest forceManifest() {
        if (this.manifest == null) {
            this.manifest = new DefaultManifest((PathToFileResolver)((ProjectInternal)this.getProject()).getFileResolver());
        }
        return this.manifest;
    }

    @Internal
    @ToBeReplacedByLazyProperty(comment="This should probably stay eager")
    public CopySpec getMetaInf() {
        return this.metaInf.addChild();
    }

    public CopySpec metaInf(@DelegatesTo(value=CopySpec.class) Closure<?> configureClosure) {
        return (CopySpec)ConfigureUtil.configure(configureClosure, (Object)this.getMetaInf());
    }

    public CopySpec metaInf(Action<? super CopySpec> configureAction) {
        CopySpec metaInf = this.getMetaInf();
        configureAction.execute((Object)metaInf);
        return metaInf;
    }

    private static class ExcludeManifestAction
    implements Action<FileCopyDetails> {
        private ExcludeManifestAction() {
        }

        public void execute(FileCopyDetails details) {
            if (details.getPath().equalsIgnoreCase("META-INF/MANIFEST.MF")) {
                details.exclude();
            }
        }
    }
}

