/* This code is part of Freenet. It is distributed under the GNU General
 * Public License, version 2 (or at your option any later version). See
 * http://www.gnu.org/ for further details of the GPL. */
package freenet.support;

import java.io.Serializable;

/**
 * Contains uptime statistics.
 *
 * @author Artefact2
 */
public class UptimeContainer implements Serializable {
    private static final long serialVersionUID = 1L;
    public long creationTime = 0;
	public long totalUptime = 0;

	@Override
	public boolean equals(Object o) {
		if(o == null) return false;
	if(o.getClass() == UptimeContainer.class) {
		UptimeContainer oB = (UptimeContainer) o;
		return (oB.creationTime == this.creationTime) &&
			(oB.totalUptime == this.totalUptime);
		} else return false;
	}

	@Override
	public int hashCode() {
		int hash = 7;
		hash = 29 * hash + (int) (this.creationTime ^ (this.creationTime >>> 32));
		hash = 29 * hash + (int) (this.totalUptime ^ (this.totalUptime >>> 32));
		return hash;
	}

    public void addFrom(UptimeContainer latestUptime) {
        this.creationTime = latestUptime.creationTime;
        this.totalUptime += latestUptime.totalUptime;
    }
}
