/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.event.Outputter;
import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Loc;
import net.sf.saxon.functions.Fold;
import net.sf.saxon.functions.FoldingFunction;
import net.sf.saxon.functions.PushableFunction;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.str.EmptyUnicodeString;
import net.sf.saxon.str.UniStringConsumer;
import net.sf.saxon.str.UnicodeBuilder;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.StringValue;

public class StringJoin
extends FoldingFunction
implements PushableFunction {
    private boolean returnEmptyIfEmpty;

    public void setReturnEmptyIfEmpty(boolean option) {
        this.returnEmptyIfEmpty = option;
    }

    public boolean isReturnEmptyIfEmpty() {
        return this.returnEmptyIfEmpty;
    }

    @Override
    public int getCardinality(Expression[] arguments) {
        if (this.returnEmptyIfEmpty) {
            return 24576;
        }
        return 16384;
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof StringJoin && super.equals(o) && this.returnEmptyIfEmpty == ((StringJoin)o).returnEmptyIfEmpty;
    }

    @Override
    public int hashCode() {
        return super.hashCode() | (this.returnEmptyIfEmpty ? 0x5000000 : 0);
    }

    @Override
    public Expression makeOptimizedFunctionCall(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo, Expression ... arguments) throws XPathException {
        Expression e2 = super.makeOptimizedFunctionCall(visitor, contextInfo, arguments);
        if (e2 != null) {
            return e2;
        }
        int card = arguments[0].getCardinality();
        if (!Cardinality.allowsMany(card)) {
            if (Cardinality.allowsZero(card) || arguments[0].getItemType().getPrimitiveItemType() != BuiltInAtomicType.STRING) {
                if (this.returnEmptyIfEmpty) {
                    return new CastExpression(arguments[0], BuiltInAtomicType.STRING, true);
                }
                return SystemFunction.makeCall("string", this.getRetainedStaticContext(), arguments[0]);
            }
            return arguments[0];
        }
        return null;
    }

    @Override
    public Fold getFold(XPathContext context, Sequence ... additionalArguments) throws XPathException {
        UnicodeString separator = EmptyUnicodeString.getInstance();
        if (additionalArguments.length > 0) {
            separator = additionalArguments[0].head().getUnicodeStringValue();
        }
        return new StringJoinFold(separator, this.returnEmptyIfEmpty);
    }

    @Override
    public void process(Outputter destination, XPathContext context, Sequence[] arguments) throws XPathException {
        EmptyUnicodeString separator = arguments.length > 1 ? arguments[1].head().getUnicodeStringValue() : EmptyUnicodeString.getInstance();
        UniStringConsumer output = destination.getStringReceiver(false, Loc.NONE);
        output.open();
        boolean first = true;
        SequenceIterator iter = arguments[0].iterate();
        try {
            Item it;
            while ((it = iter.next()) != null) {
                if (first) {
                    first = false;
                } else {
                    output.accept(separator);
                }
                output.accept(it.getUnicodeStringValue());
            }
        }
        catch (UncheckedXPathException e) {
            throw e.getXPathException();
        }
        output.close();
    }

    private static class StringJoinFold
    implements Fold {
        private int position = 0;
        private final UnicodeString separator;
        private final UnicodeBuilder data;
        private final boolean returnEmptyIfEmpty;

        public StringJoinFold(UnicodeString separator, boolean returnEmptyIfEmpty) {
            this.separator = separator;
            this.data = new UnicodeBuilder();
            this.returnEmptyIfEmpty = returnEmptyIfEmpty;
        }

        @Override
        public void processItem(Item item) {
            if (this.position == 0) {
                this.data.append(item.getUnicodeStringValue());
                this.position = 1;
            } else {
                this.data.accept(this.separator).accept(item.getUnicodeStringValue());
            }
        }

        @Override
        public boolean isFinished() {
            return false;
        }

        @Override
        public Sequence result() {
            if (this.position == 0 && this.returnEmptyIfEmpty) {
                return EmptySequence.getInstance();
            }
            return new StringValue(this.data.toUnicodeString());
        }
    }
}

