/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.ItemEvaluator;
import net.sf.saxon.expr.elab.LearningEvaluator;
import net.sf.saxon.expr.elab.PullElaborator;
import net.sf.saxon.expr.elab.PullEvaluator;
import net.sf.saxon.expr.elab.SequenceEvaluator;
import net.sf.saxon.expr.oper.OperandArray;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Loc;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.functions.registry.BuiltInFunctionSet;
import net.sf.saxon.ma.arrays.ArrayFunctionSet;
import net.sf.saxon.ma.arrays.ArrayItemType;
import net.sf.saxon.ma.map.MapFunctionSet;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyFunctionType;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;

public class DynamicFunctionCall
extends Expression {
    private final Operand targetFunction;
    private final OperandArray suppliedArguments;

    public DynamicFunctionCall(Expression fn, List<Expression> args) {
        this.targetFunction = new Operand(this, fn, OperandRole.INSPECT);
        this.suppliedArguments = new OperandArray(this, args.toArray(new Expression[0]));
    }

    @Override
    public int getImplementationMethod() {
        return 2;
    }

    @Override
    public ItemType getItemType() {
        ItemType fnType = this.targetFunction.getChildExpression().getItemType();
        if (fnType instanceof MapType) {
            return ((MapType)fnType).getValueType().getPrimaryType();
        }
        if (fnType instanceof ArrayItemType) {
            return ((ArrayItemType)fnType).getMemberType().getPrimaryType();
        }
        if (fnType instanceof FunctionItemType) {
            return ((FunctionItemType)fnType).getResultType().getPrimaryType();
        }
        if (fnType instanceof AnyFunctionType) {
            return AnyItemType.getInstance();
        }
        return AnyItemType.getInstance();
    }

    @Override
    protected int computeCardinality() {
        ItemType fnType = this.targetFunction.getChildExpression().getItemType();
        if (fnType instanceof MapType) {
            return Cardinality.union(((MapType)fnType).getValueType().getCardinality(), 8192);
        }
        if (fnType instanceof ArrayItemType) {
            return ((ArrayItemType)fnType).getMemberType().getCardinality();
        }
        if (fnType instanceof FunctionItemType) {
            return ((FunctionItemType)fnType).getResultType().getCardinality();
        }
        return 57344;
    }

    public int getArity() {
        return this.suppliedArguments.getNumberOfOperands();
    }

    @Override
    public Iterable<Operand> operands() {
        ArrayList<Operand> allOperands = new ArrayList<Operand>(this.getArity() + 1);
        allOperands.add(this.targetFunction);
        for (int i = 0; i < this.getArity(); ++i) {
            allOperands.add(this.suppliedArguments.getOperand(i));
        }
        return allOperands;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.typeCheckChildren(visitor, contextInfo);
        TypeChecker tc = visitor.getConfiguration().getTypeChecker(false);
        Supplier<RoleDiagnostic> roleSupplier0 = () -> new RoleDiagnostic(21, this.targetFunction.getChildExpression().toShortString(), 0);
        this.targetFunction.setChildExpression(tc.staticTypeCheck(this.targetFunction.getChildExpression(), SequenceType.SINGLE_FUNCTION, roleSupplier0, visitor));
        if (this.getArity() == 1) {
            Expression target = this.targetFunction.getChildExpression();
            if (target.getItemType() instanceof MapType) {
                return this.makeGetCall(visitor, MapFunctionSet.getInstance(31), contextInfo);
            }
            if (target.getItemType() instanceof ArrayItemType) {
                return this.makeGetCall(visitor, ArrayFunctionSet.getInstance(31), contextInfo);
            }
        }
        return this;
    }

    private Expression makeGetCall(ExpressionVisitor visitor, BuiltInFunctionSet fnSet, ContextItemStaticInfo contextInfo) throws XPathException {
        Expression target = this.targetFunction.getChildExpression();
        Expression key = this.suppliedArguments.getOperandExpression(0);
        Expression getter = fnSet.makeFunction("get", 2).makeFunctionCall(target, key);
        getter.setRetainedStaticContext(target.getRetainedStaticContext());
        TypeChecker tc = visitor.getConfiguration().getTypeChecker(visitor.getStaticContext().isInBackwardsCompatibleMode());
        if (fnSet == MapFunctionSet.getInstance(31)) {
            Supplier<RoleDiagnostic> role = () -> new RoleDiagnostic(20, "key value supplied when calling a map as a function", 0);
            ((SystemFunctionCall)getter).setArg(1, tc.staticTypeCheck(key, SequenceType.SINGLE_ATOMIC, role, visitor));
        } else {
            Supplier<RoleDiagnostic> role = () -> new RoleDiagnostic(20, "subscript supplied when calling an array as a function", 0);
            ((SystemFunctionCall)getter).setArg(1, tc.staticTypeCheck(key, SequenceType.SINGLE_INTEGER, role, visitor));
        }
        return getter.typeCheck(visitor, contextInfo);
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        return this.makeElaborator().elaborateForPull().iterate(context);
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        if ("JS".equals(out.getOptions().target) && out.getOptions().targetVersion == 2) {
            FunctionItem f;
            out.startElement("ifCall", this);
            out.emitAttribute("name", "Q{http://saxon.sf.net/}apply");
            out.emitAttribute("type", "*");
            if (this.targetFunction.getChildExpression() instanceof Literal && (f = (FunctionItem)((Literal)this.targetFunction.getChildExpression()).getGroundedValue()).getFunctionName() != null) {
                out.emitAttribute("dyn", f.getFunctionName().getEQName() + "#" + f.getArity());
            }
            this.targetFunction.getChildExpression().export(out);
            out.startSubsidiaryElement("arrayBlock");
            for (Operand o : this.suppliedArguments) {
                o.getChildExpression().export(out);
            }
            out.endSubsidiaryElement();
            out.endElement();
        } else {
            out.startElement("dynCall", this);
            this.targetFunction.getChildExpression().export(out);
            for (Operand o : this.suppliedArguments) {
                o.getChildExpression().export(out);
            }
            out.endElement();
        }
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        Expression f = this.targetFunction.getChildExpression().copy(rebindings);
        ArrayList<Expression> args = new ArrayList<Expression>(this.getArity());
        for (Operand o : this.suppliedArguments) {
            args.add(o.getChildExpression().copy(rebindings));
        }
        return new DynamicFunctionCall(f, args);
    }

    @Override
    public void gatherProperties(BiConsumer<String, Object> consumer) {
    }

    @Override
    public Elaborator getElaborator() {
        return new DynamicFunctionCallElaborator();
    }

    @Override
    public String toShortString() {
        StringBuilder sb = new StringBuilder(this.targetFunction.getChildExpression().toShortString()).append('(');
        for (Operand op : this.suppliedArguments) {
            sb.append(op.getChildExpression().toShortString()).append(',');
        }
        sb.setCharAt(sb.length() - 1, ')');
        return sb.toString();
    }

    private static class DynamicFunctionCallElaborator
    extends PullElaborator {
        private DynamicFunctionCallElaborator() {
        }

        @Override
        public PullEvaluator elaborateForPull() {
            DynamicFunctionCall expr = (DynamicFunctionCall)this.getExpression();
            TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
            SequenceEvaluator[] argEvaluators = new SequenceEvaluator[expr.getArity()];
            for (int i = 0; i < argEvaluators.length; ++i) {
                Expression arg = expr.suppliedArguments.getOperand(i).getChildExpression();
                argEvaluators[i] = new LearningEvaluator(arg, arg.makeElaborator().lazily(true, false));
            }
            Expression body = expr.targetFunction.getChildExpression();
            ItemEvaluator functionEvaluator = body.makeElaborator().elaborateForItem();
            boolean is40 = expr.getRetainedStaticContext().getPackageData().getHostLanguageVersion() >= 40;
            return context -> {
                int i;
                FunctionItem fn = (FunctionItem)functionEvaluator.eval(context);
                FunctionItemType fit = fn.getFunctionItemType();
                if (fn.getArity() != argEvaluators.length) {
                    String errorCode = "XPTY0004";
                    throw new XPathException("Number of arguments required for dynamic call to " + fn.getDescription() + " is " + fn.getArity() + "; number supplied = " + argEvaluators.length, errorCode).asTypeError().withXPathContext(context).withLocation(expr.getLocation());
                }
                Sequence[] argValues = new Sequence[argEvaluators.length];
                if (fit == AnyFunctionType.ANY_FUNCTION) {
                    for (i = 0; i < argEvaluators.length; ++i) {
                        argValues[i] = argEvaluators[i].evaluate(context);
                    }
                } else {
                    for (i = 0; i < argEvaluators.length; ++i) {
                        SequenceType expected = fit.getArgumentTypes()[i];
                        Sequence actual = argEvaluators[i].evaluate(context);
                        if (!expected.equals(SequenceType.ANY_SEQUENCE)) {
                            Supplier<RoleDiagnostic> role = () -> new RoleDiagnostic(0, fn.getDescription(), 0);
                            actual = th.applyFunctionConversionRules(actual, expected, role, Loc.NONE);
                        }
                        argValues[i] = actual;
                    }
                }
                XPathContext c2 = fn.makeNewContext(context, null);
                if (!is40) {
                    c2.setCurrentOutputUri(null);
                    if (c2 instanceof XPathContextMajor) {
                        ((XPathContextMajor)c2).setCurrentRegexIterator(null);
                    }
                }
                Sequence rawResult = fn.call(c2, argValues);
                if (fn.isTrustedResultType()) {
                    return rawResult.iterate();
                }
                Supplier<RoleDiagnostic> resultRole = () -> new RoleDiagnostic(5, "fn:apply", -1);
                return th.applyFunctionConversionRules(rawResult, fit.getResultType(), resultRole, Loc.NONE).iterate();
            };
        }
    }
}

