/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.invoker;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.DateFormat;
import java.util.Date;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.util.DateUtils;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.StringUtils;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.invoker.Main;
import org.dita.dost.log.AbstractLogger;

class DefaultLogger
extends AbstractLogger
implements BuildLogger {
    private static final int LEFT_COLUMN_SIZE = 12;
    private PrintStream out;
    private PrintStream err;
    private long startTime = System.currentTimeMillis();
    private boolean emacsMode = false;
    private boolean printStacktrace = false;

    public DefaultLogger() {
        this.msgOutputLevel = 0;
    }

    public void setMessageOutputLevel(int level) {
        this.msgOutputLevel = level;
    }

    public void setOutputPrintStream(PrintStream output) {
        this.out = new PrintStream(output, true);
    }

    public void setErrorPrintStream(PrintStream err) {
        this.err = new PrintStream(err, true);
    }

    public void setEmacsMode(boolean emacsMode) {
        this.emacsMode = emacsMode;
    }

    public DefaultLogger useColor(boolean useColor) {
        this.useColor = useColor;
        return this;
    }

    public DefaultLogger setPrintStacktrace(boolean printStacktrace) {
        this.printStacktrace = printStacktrace;
        return this;
    }

    public void buildStarted(BuildEvent event) {
        this.startTime = System.currentTimeMillis();
    }

    private static void throwableMessage(StringBuilder m, Throwable error, boolean verbose) {
        String msg = error.getMessage();
        int i = msg.indexOf(": ");
        if (i != -1) {
            msg = msg.substring(i + 1).trim();
        }
        m.append(msg);
    }

    public void buildFinished(BuildEvent event) {
        Throwable error;
        for (Throwable e = error = event.getException(); e != null; e = e.getCause()) {
            if (!(e instanceof DITAOTException)) continue;
            error = e;
            break;
        }
        StringBuilder message = new StringBuilder();
        if (error == null) {
            if (this.msgOutputLevel >= 2) {
                message.append(StringUtils.LINE_SEP);
                if (this.useColor) {
                    message.append("\u001b[1m").append("\u001b[32m");
                }
                message.append(this.getBuildSuccessfulMessage());
                if (this.useColor) {
                    message.append("\u001b[0m");
                }
                message.append(" in ").append(DefaultLogger.formatTime(System.currentTimeMillis() - this.startTime));
            }
        } else {
            if (this.useColor) {
                message.append("\u001b[31m");
            }
            message.append(Main.locale.getString("error_msg").formatted(""));
            if (this.useColor) {
                message.append("\u001b[0m");
            }
            if (error instanceof DITAOTException && this.msgOutputLevel < 2) {
                message.append(Main.locale.getString("exception_msg").formatted(error.getMessage()));
            } else if (this.printStacktrace) {
                try (StringWriter buf2 = new StringWriter();
                     PrintWriter printWriter = new PrintWriter(buf2);){
                    error.printStackTrace(printWriter);
                    printWriter.flush();
                    message.append(Main.locale.getString("exception_msg").formatted(buf2));
                }
                catch (IOException buf2) {}
            } else {
                message.append(Main.locale.getString("exception_msg").formatted(error.getMessage()));
            }
            if (this.msgOutputLevel >= 2) {
                message.append(StringUtils.LINE_SEP);
                if (this.useColor) {
                    message.append("\u001b[1m").append("\u001b[31m");
                }
                message.append(this.getBuildFailedMessage());
                if (this.useColor) {
                    message.append("\u001b[0m");
                }
                message.append(" in ").append(DefaultLogger.formatTime(System.currentTimeMillis() - this.startTime));
            }
        }
        String msg = message.toString();
        if (error == null && !msg.trim().isEmpty()) {
            this.out.println(msg);
        } else if (!msg.isEmpty()) {
            if (this.legacyFormat) {
                this.err.println(msg);
            } else {
                this.err.println(DefaultLogger.removeLevelPrefix(message));
            }
        }
        this.log(msg);
    }

    protected String getBuildFailedMessage() {
        return "BUILD FAILED";
    }

    protected String getBuildSuccessfulMessage() {
        return "BUILD SUCCESSFUL";
    }

    private boolean evaluate(Project project, String condition) {
        String value;
        return switch (value = project.replaceProperties(condition)) {
            case "true" -> true;
            case "false" -> false;
            default -> project.getProperty(value) != null || project.getUserProperty(value) != null;
        };
    }

    public void targetStarted(BuildEvent event) {
        if (event.getTarget().getIf() != null && !this.evaluate(event.getProject(), event.getTarget().getIf())) {
            return;
        }
        if (event.getTarget().getUnless() != null && this.evaluate(event.getProject(), event.getTarget().getUnless())) {
            return;
        }
        if (2 <= this.msgOutputLevel && !event.getTarget().getName().equals("")) {
            String msg;
            if (event.getTarget().getDescription() == null) {
                msg = null;
            } else {
                StringBuilder buf = new StringBuilder().append(StringUtils.LINE_SEP);
                if (this.useColor) {
                    buf.append("\u001b[34m");
                }
                buf.append("==> ");
                if (this.useColor) {
                    buf.append("\u001b[0m").append("\u001b[1m");
                }
                buf.append(event.getTarget().getDescription());
                if (this.useColor) {
                    buf.append("\u001b[0m");
                }
                msg = buf.toString();
            }
            if (msg != null) {
                this.out.println(msg);
                this.log(msg);
            }
        }
    }

    public void targetFinished(BuildEvent event) {
    }

    public void taskStarted(BuildEvent event) {
    }

    public void taskFinished(BuildEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void messageLogged(BuildEvent event) {
        priority = event.getPriority();
        if (priority <= this.msgOutputLevel) {
            block24: {
                message = new StringBuilder();
                if (!this.legacyFormat) {
                    if (priority == 0) {
                        if (this.useColor) {
                            message.append("\u001b[31m");
                        }
                        message.append(Main.locale.getString("error_msg").formatted(new Object[]{""}));
                        if (this.useColor) {
                            message.append("\u001b[0m");
                        }
                    } else if (priority == 1) {
                        if (this.useColor) {
                            message.append("\u001b[33m");
                        }
                        message.append(Main.locale.getString("warn_msg").formatted(new Object[]{""}));
                        if (this.useColor) {
                            message.append("\u001b[0m");
                        }
                    }
                }
                if (event.getTask() != null && !this.emacsMode) {
                    name = event.getTask().getTaskName();
                    label = "[" + name + "] ";
                    size = 12 - label.length();
                    tmp = new StringBuilder();
                    tmp.append(" ".repeat(Math.max(0, size)));
                    tmp.append((String)label);
                    label = tmp.toString();
                    r = null;
                    try {
                        r = new BufferedReader(new StringReader(event.getMessage()));
                        line = r.readLine();
                        first = true;
                        do {
                            if (first) {
                                if (line == null) {
                                    message.append((String)label);
                                    break;
                                }
                            } else {
                                message.append(StringUtils.LINE_SEP);
                            }
                            first = false;
                            message.append((String)label).append(line);
                        } while ((line = r.readLine()) != null);
                        ** if (r == null) goto lbl-1000
                    }
                    catch (IOException e) {
                        try {
                            message.append((String)label).append(event.getMessage());
                            ** if (r == null) goto lbl-1000
                        }
                        catch (Throwable var11_13) {
                            if (r != null) {
                                FileUtils.close(r);
                            }
                            throw var11_13;
                        }
lbl-1000:
                        // 1 sources

                        {
                            FileUtils.close((Reader)r);
                        }
lbl-1000:
                        // 2 sources

                        {
                            break block24;
                        }
                    }
lbl-1000:
                    // 1 sources

                    {
                        FileUtils.close((Reader)r);
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block24;
                    }
                }
                message.append(event.getMessage());
            }
            ex = event.getException();
            if (3 <= this.msgOutputLevel && ex != null) {
                message.append('\n').append(StringUtils.getStackTrace((Throwable)ex));
            }
            msg = message.toString();
            v0 = dst = priority == 0 ? this.err : this.out;
            if (this.legacyFormat) {
                dst.println(msg);
            } else {
                dst.println(DefaultLogger.removeLevelPrefix(new StringBuilder(msg)));
            }
            this.log(msg);
        }
    }

    protected static String formatTime(long millis) {
        return DateUtils.formatElapsedTime((long)millis);
    }

    private void log(String message) {
    }

    protected String getTimestamp() {
        Date date = new Date(System.currentTimeMillis());
        DateFormat formatter = DateFormat.getDateTimeInstance(3, 3);
        return formatter.format(date);
    }

    protected String extractProjectName(BuildEvent event) {
        Project project = event.getProject();
        return project != null ? project.getName() : null;
    }

    @Override
    public void log(String msg, Throwable t, int level) {
        throw new UnsupportedOperationException();
    }
}

