/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.invoker;

import java.util.ArrayDeque;
import java.util.Arrays;
import org.dita.dost.invoker.Arguments;
import org.dita.dost.invoker.ConversionArguments;
import org.dita.dost.invoker.DeliverablesArguments;
import org.dita.dost.invoker.InitArguments;
import org.dita.dost.invoker.InstallArguments;
import org.dita.dost.invoker.PluginsArguments;
import org.dita.dost.invoker.TranstypesArguments;
import org.dita.dost.invoker.UninstallArguments;
import org.dita.dost.invoker.VersionArguments;

public class HelpArguments
extends Arguments {
    String subcommand;

    @Override
    HelpArguments parse(String[] arguments) {
        String arg;
        ArrayDeque<String> args = new ArrayDeque<String>(Arrays.asList(arguments));
        while (!args.isEmpty() && !(arg = (String)args.pop()).equals("help")) {
            if (arg.startsWith("-")) {
                this.parseCommonOptions(arg, args);
                continue;
            }
            this.subcommand = arg;
        }
        while (!args.isEmpty()) {
            arg = (String)args.pop();
            if (arg.startsWith("-")) {
                this.parseCommonOptions(arg, args);
                continue;
            }
            this.subcommand = arg;
        }
        if (this.msgOutputLevel < 2) {
            this.emacsMode = true;
        }
        this.justPrintUsage = true;
        return this;
    }

    @Override
    String getUsage(boolean compact) {
        if (this.subcommand == null) {
            return new ConversionArguments().getUsage(false);
        }
        return switch (this.subcommand) {
            case "plugins" -> new PluginsArguments().getUsage(false);
            case "version" -> new VersionArguments().getUsage(false);
            case "transtypes" -> new TranstypesArguments().getUsage(false);
            case "deliverables" -> new DeliverablesArguments().getUsage(false);
            case "install" -> new InstallArguments().getUsage(false);
            case "uninstall" -> new UninstallArguments().getUsage(false);
            case "init" -> new InitArguments().getUsage(false);
            default -> new ConversionArguments().getUsage(false);
        };
    }
}

