/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.commonscompress.archivers;

import coursierapi.shaded.commonsio.Charsets;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;

public abstract class ArchiveInputStream<E>
extends FilterInputStream {
    private final byte[] single = new byte[1];
    private long bytesRead;
    private Charset charset;

    private ArchiveInputStream(InputStream inputStream, Charset charset) {
        super(inputStream);
        this.charset = Charsets.toCharset(charset);
    }

    protected ArchiveInputStream(InputStream inputStream, String charsetName) {
        this(inputStream, Charsets.toCharset(charsetName));
    }

    protected void count(int read2) {
        this.count((long)read2);
    }

    protected void count(long read2) {
        if (read2 != -1L) {
            this.bytesRead += read2;
        }
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    @Override
    public synchronized void mark(int readlimit) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    protected void pushedBackBytes(long pushedBack) {
        this.bytesRead -= pushedBack;
    }

    @Override
    public int read() throws IOException {
        int num = this.read(this.single, 0, 1);
        return num == -1 ? -1 : this.single[0] & 0xFF;
    }

    @Override
    public synchronized void reset() throws IOException {
    }
}

