/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization;

import java.io.File;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.gradle.api.internal.initialization.BuildLogicBuildQueue;
import org.gradle.cache.FileLock;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockOptions;
import org.gradle.cache.internal.filelock.DefaultLockOptions;
import org.gradle.composite.internal.BuildTreeWorkGraphController;
import org.gradle.composite.internal.TaskIdentifier;
import org.gradle.initialization.layout.ProjectCacheDir;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.StandAloneNestedBuild;
import org.gradle.internal.buildtree.BuildTreeLifecycleController;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.work.Synchronizer;
import org.gradle.internal.work.WorkerLeaseService;

public class DefaultBuildLogicBuildQueue
implements BuildLogicBuildQueue {
    private final BuildOperationRunner runner;
    private final FileLockManager fileLockManager;
    private final BuildTreeWorkGraphController buildTreeWorkGraphController;
    private final ProjectCacheDir projectCacheDir;
    private final Synchronizer resource;
    private FileLock fileLock = null;

    public DefaultBuildLogicBuildQueue(BuildOperationRunner runner, FileLockManager fileLockManager, BuildTreeWorkGraphController buildTreeWorkGraphController, ProjectCacheDir projectCacheDir, WorkerLeaseService workerLeaseService) {
        this.runner = runner;
        this.fileLockManager = fileLockManager;
        this.buildTreeWorkGraphController = buildTreeWorkGraphController;
        this.projectCacheDir = projectCacheDir;
        this.resource = workerLeaseService.newResource();
    }

    @Override
    public <T> T build(BuildState requester, List<TaskIdentifier.TaskBasedTaskIdentifier> tasks, Supplier<T> continuationUnderLock) {
        if (tasks.isEmpty()) {
            return continuationUnderLock.get();
        }
        List<TaskIdentifier.TaskBasedTaskIdentifier> remaining = DefaultBuildLogicBuildQueue.removeExecuted(tasks);
        if (remaining.isEmpty()) {
            return continuationUnderLock.get();
        }
        return (T)this.withBuildLogicQueueLockInBuildOperation("Run included build logic build for " + DefaultBuildLogicBuildQueue.nameOf(requester), () -> this.doBuild(tasks, continuationUnderLock));
    }

    @Override
    public <T> T buildBuildSrc(StandAloneNestedBuild buildSrcBuild, Function<BuildTreeLifecycleController, T> continuationUnderLock) {
        return (T)this.withBuildLogicQueueLock(() -> buildSrcBuild.run(continuationUnderLock));
    }

    private <T> T doBuild(List<TaskIdentifier.TaskBasedTaskIdentifier> tasks, Supplier<T> continuationUnderLock) {
        this.buildTreeWorkGraphController.withNewWorkGraph(graph -> {
            graph.scheduleWork(builder -> builder.scheduleTasks(tasks)).runWork().rethrow();
            return null;
        });
        return continuationUnderLock.get();
    }

    private <T> T withBuildLogicQueueLockInBuildOperation(final String buildOperationDescription, final Supplier<T> buildAction) {
        return (T)this.runner.call(new CallableBuildOperation<T>(){

            public T call(BuildOperationContext context) {
                return DefaultBuildLogicBuildQueue.this.withBuildLogicQueueLock(buildAction);
            }

            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName((String)buildOperationDescription);
            }
        });
    }

    private <T> T withBuildLogicQueueLock(Supplier<T> buildAction) {
        return (T)this.resource.withLock(() -> {
            if (this.fileLock == null) {
                try (FileLock fileLock = this.lockBuildLogicQueueFile();){
                    this.fileLock = fileLock;
                    try {
                        Object t = buildAction.get();
                        this.fileLock = null;
                        return t;
                    }
                    catch (Throwable throwable) {
                        this.fileLock = null;
                        throw throwable;
                    }
                }
            }
            return buildAction.get();
        });
    }

    private FileLock lockBuildLogicQueueFile() {
        return this.fileLockManager.lock(new File(this.projectCacheDir.getDir(), "noVersion/buildLogic"), (LockOptions)DefaultLockOptions.mode((FileLockManager.LockMode)FileLockManager.LockMode.Exclusive), "build logic queue");
    }

    private static List<TaskIdentifier.TaskBasedTaskIdentifier> removeExecuted(List<TaskIdentifier.TaskBasedTaskIdentifier> tasks) {
        return tasks.stream().filter(identifier -> !identifier.getTask().getState().getExecuted()).collect(Collectors.toList());
    }

    private static String nameOf(BuildState build) {
        return build.getDisplayName().getDisplayName();
    }
}

