/*
 * Decompiled with CFR 0.152.
 */
package net.sf.launch4j.form;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.net.URL;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.launch4j.form.Messages;

public abstract class SplashForm
extends JPanel {
    protected final JLabel _splashFileLabel = new JLabel();
    protected final JLabel _waitForWindowLabel = new JLabel();
    protected final JLabel _timeoutLabel = new JLabel();
    protected final JCheckBox _timeoutErrCheck = new JCheckBox();
    protected final JTextField _splashFileField = new JTextField();
    protected final JTextField _timeoutField = new JTextField();
    protected final JButton _splashFileButton = new JButton();
    protected final JCheckBox _splashCheck = new JCheckBox();
    protected final JCheckBox _waitForWindowCheck = new JCheckBox();

    public SplashForm() {
        this.initializePanel();
    }

    void addFillComponents(Container panel, int[] cols, int[] rows) {
        int index;
        Dimension filler = new Dimension(10, 10);
        boolean filled_cell_11 = false;
        CellConstraints cc = new CellConstraints();
        if (cols.length > 0 && rows.length > 0 && cols[0] == 1 && rows[0] == 1) {
            panel.add(Box.createRigidArea(filler), cc.xy(1, 1));
            filled_cell_11 = true;
        }
        for (index = 0; index < cols.length; ++index) {
            if (cols[index] == 1 && filled_cell_11) continue;
            panel.add(Box.createRigidArea(filler), cc.xy(cols[index], 1));
        }
        for (index = 0; index < rows.length; ++index) {
            if (rows[index] == 1 && filled_cell_11) continue;
            panel.add(Box.createRigidArea(filler), cc.xy(1, rows[index]));
        }
    }

    public ImageIcon loadImage(String imageName) {
        try {
            ClassLoader classloader = this.getClass().getClassLoader();
            URL url = classloader.getResource(imageName);
            if (url != null) {
                ImageIcon icon = new ImageIcon(url);
                return icon;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        throw new IllegalArgumentException("Unable to load image: " + imageName);
    }

    public JPanel createPanel() {
        JPanel jpanel1 = new JPanel();
        FormLayout formlayout1 = new FormLayout("FILL:7DLU:NONE,RIGHT:MAX(65DLU;DEFAULT):NONE,FILL:3DLU:NONE,FILL:60DLU:NONE,FILL:DEFAULT:GROW(1.0),FILL:3DLU:NONE,FILL:26PX:NONE,FILL:7DLU:NONE", "CENTER:9DLU:NONE,CENTER:DEFAULT:NONE,CENTER:3DLU:NONE,CENTER:DEFAULT:NONE,CENTER:3DLU:NONE,CENTER:DEFAULT:NONE,CENTER:3DLU:NONE,CENTER:DEFAULT:NONE,CENTER:3DLU:NONE,CENTER:DEFAULT:NONE,CENTER:9DLU:NONE");
        CellConstraints cc = new CellConstraints();
        jpanel1.setLayout((LayoutManager)formlayout1);
        this._splashFileLabel.setIcon(this.loadImage("images/asterix.gif"));
        this._splashFileLabel.setName("splashFileLabel");
        this._splashFileLabel.setText(Messages.getString("splashFile"));
        jpanel1.add((Component)this._splashFileLabel, cc.xy(2, 4));
        this._waitForWindowLabel.setName("waitForWindowLabel");
        this._waitForWindowLabel.setText(Messages.getString("waitForWindow"));
        jpanel1.add((Component)this._waitForWindowLabel, cc.xy(2, 6));
        this._timeoutLabel.setIcon(this.loadImage("images/asterix.gif"));
        this._timeoutLabel.setName("timeoutLabel");
        this._timeoutLabel.setText(Messages.getString("timeout"));
        jpanel1.add((Component)this._timeoutLabel, cc.xy(2, 8));
        this._timeoutErrCheck.setActionCommand("Signal error on timeout");
        this._timeoutErrCheck.setName("timeoutErrCheck");
        this._timeoutErrCheck.setText(Messages.getString("timeoutErr"));
        this._timeoutErrCheck.setToolTipText(Messages.getString("timeoutErrTip"));
        jpanel1.add((Component)this._timeoutErrCheck, cc.xywh(4, 10, 2, 1));
        this._splashFileField.setName("splashFileField");
        this._splashFileField.setToolTipText(Messages.getString("splashFileTip"));
        jpanel1.add((Component)this._splashFileField, cc.xywh(4, 4, 2, 1));
        this._timeoutField.setName("timeoutField");
        this._timeoutField.setToolTipText(Messages.getString("timeoutTip"));
        jpanel1.add((Component)this._timeoutField, cc.xy(4, 8));
        this._splashFileButton.setIcon(this.loadImage("images/open16.png"));
        this._splashFileButton.setName("splashFileButton");
        jpanel1.add((Component)this._splashFileButton, cc.xy(7, 4));
        this._splashCheck.setActionCommand("Enable splash screen");
        this._splashCheck.setName("splashCheck");
        this._splashCheck.setText(Messages.getString("enableSplash"));
        jpanel1.add((Component)this._splashCheck, cc.xywh(4, 2, 2, 1));
        this._waitForWindowCheck.setActionCommand("Close splash screen when an application window appears");
        this._waitForWindowCheck.setName("waitForWindowCheck");
        this._waitForWindowCheck.setText(Messages.getString("waitForWindowText"));
        jpanel1.add((Component)this._waitForWindowCheck, cc.xywh(4, 6, 2, 1));
        this.addFillComponents(jpanel1, new int[]{1, 2, 3, 4, 5, 6, 7, 8}, new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11});
        return jpanel1;
    }

    protected void initializePanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.createPanel(), "Center");
    }
}

