/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.tool;

import gnu.crypto.auth.Password;
import gnu.crypto.sasl.ClientFactory;
import gnu.crypto.sasl.ClientMechanism;
import gnu.crypto.sasl.SaslInputStream;
import gnu.crypto.sasl.SaslOutputStream;
import gnu.crypto.tool.SimpleCallbackHandler;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;

public class SaslConnection {
    private boolean connected;
    private String id;
    private String protocol;
    private String serverName;
    private int port;
    private CallbackHandler cbh;
    private Map properties;
    private String mechanism;
    private transient Socket socket;
    private ClientMechanism sasl;
    private InputStream in;
    private OutputStream out;
    private InputStream secureIn;
    private OutputStream secureOut;

    private static final byte[] mungeSaslBuffer(InputStream in) throws IOException {
        byte[] header = new byte[4];
        int check = in.read(header);
        if (check == -1) {
            throw new EOFException();
        }
        if (check != 4) {
            throw new IOException();
        }
        int length = (header[0] & 0xFF) << 24 | (header[1] & 0xFF) << 16 | (header[2] & 0xFF) << 8 | header[3] & 0xFF;
        System.out.println("[SaslConnection] Expecting " + String.valueOf(length) + " byte(s) from the stream...");
        byte[] result = new byte[length + 4];
        System.arraycopy(header, 0, result, 0, 4);
        check = in.read(result, 4, length);
        if (check == -1) {
            throw new EOFException();
        }
        if (check != length) {
            throw new IOException();
        }
        return result;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void connect() throws IOException {
        byte[] response;
        if (this.connected) {
            return;
        }
        this.socket = new Socket(this.serverName, this.port);
        this.in = this.socket.getInputStream();
        this.out = this.socket.getOutputStream();
        this.out.write(this.mechanism.getBytes("ASCII"));
        this.out.write(0);
        if (this.sasl.hasInitialResponse()) {
            response = this.sasl.evaluateChallenge(null);
            this.out.write(response);
        }
        while (!this.sasl.isComplete()) {
            byte[] challenge = SaslConnection.mungeSaslBuffer(this.in);
            response = this.sasl.evaluateChallenge(challenge);
            if (response != null) {
                this.out.write(response);
                continue;
            }
            if (this.sasl.isComplete()) break;
            throw new RuntimeException("Response null but client incomplete");
        }
        System.out.println("[SaslConnection] Connected!");
        this.secureIn = new SaslInputStream(this.sasl, this.in);
        this.secureOut = new SaslOutputStream(this.sasl, this.out);
        this.connected = true;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            throw new IllegalStateException();
        }
        return this.secureIn;
    }

    public OutputStream getOutputStream() throws IOException {
        if (!this.connected) {
            throw new IllegalStateException();
        }
        return this.secureOut;
    }

    public void send(byte[] message) throws IOException {
        System.out.println("[SaslConnection] Outgoing message (str): " + new String(message));
        this.secureOut.write(message);
    }

    public byte[] receive() throws IOException {
        int first = this.secureIn.read();
        int limit = this.secureIn.available();
        byte[] result = new byte[limit + 1];
        result[0] = (byte)first;
        this.secureIn.read(result, 1, limit);
        System.out.println("[SaslConnection] Incoming response (str): " + new String(result));
        return result;
    }

    public void disconnect() throws IOException {
        System.out.println("[SaslConnection] ==> disconnect()");
        this.connected = false;
        if (this.sasl != null) {
            this.sasl.reset();
        }
        this.sasl = ClientFactory.getInstance(this.mechanism);
        if (this.sasl == null) {
            throw new RuntimeException("Unable to create SASL client");
        }
        System.out.println("[SaslConnection] Chosen mechanism: " + this.mechanism);
        this.sasl.init(this.properties);
        System.out.println("[SaslConnection] <== disconnect()");
    }

    public void reconnect() throws IOException {
        this.disconnect();
        this.connect();
    }

    public SaslConnection(String m, URL url) throws SaslException, IOException {
        this.mechanism = m;
        String userInfo = url.getUserInfo();
        this.properties = new HashMap();
        int ndx = userInfo.indexOf(58);
        if (ndx == -1) {
            this.id = userInfo;
        } else {
            this.id = userInfo.substring(0, ndx);
            this.properties.put("gnu.crypto.sasl.password", new Password(userInfo.substring(ndx + 1).toCharArray()));
        }
        this.protocol = url.getProtocol();
        this.serverName = url.getHost();
        this.port = url.getPort();
        this.cbh = new SimpleCallbackHandler();
        this.properties.put("gnu.crypto.sasl.authorisation.ID", this.id);
        this.properties.put("gnu.crypto.sasl.protocol", this.protocol);
        this.properties.put("gnu.crypto.sasl.server.name", this.serverName);
        this.properties.put("gnu.crypto.sasl.callback.handler", this.cbh);
        this.properties.put("gnu.crypto.sasl.username", this.id);
        this.properties.put("gnu.crypto.sasl.srp.replay.detection", "true");
        this.properties.put("gnu.crypto.sasl.srp.integrity", "true");
        this.properties.put("gnu.crypto.sasl.srp.confidentiality", "true");
        this.disconnect();
    }
}

