/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.id.ArcProtoId;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.IdManager;
import com.sun.electric.database.id.LibId;
import com.sun.electric.database.id.NodeProtoId;
import com.sun.electric.database.id.PrimitiveNodeId;
import com.sun.electric.database.id.TechId;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.CellName;
import com.sun.electric.database.text.Setting;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.TechPool;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.io.input.JelibParser;
import com.sun.electric.tool.io.input.LibraryFiles;
import com.sun.electric.tool.io.input.LibraryStatistics;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.util.TextUtils;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class JELIB
extends LibraryFiles {
    private final FileType fileType;
    private final JelibParser parser;

    JELIB(EditingPreferences ep, LibId libId, URL fileURL, FileType type) throws IOException {
        super(ep);
        this.fileType = type;
        this.parser = JelibParser.parse(libId, fileURL, this.fileType, false, Input.errorLogger);
    }

    public static Map<Setting, Object> readProjectSettings(URL fileURL, FileType fileType, TechPool techPool, ErrorLogger errorLogger) {
        Variable[] vars;
        JelibParser parser;
        try {
            parser = JELIB.parse(techPool.idManager, fileURL, fileType, true, errorLogger);
        }
        catch (IOException e) {
            errorLogger.logError("Error reading " + fileURL + ": " + e.getMessage(), -1);
            return null;
        }
        HashMap<Setting, Object> projectSettings = new HashMap<Setting, Object>();
        for (Map.Entry<TechId, Variable[]> entry : parser.techIds.entrySet()) {
            TechId techId = entry.getKey();
            vars = entry.getValue();
            Technology tech = techPool.getTech(techId);
            if (tech == null && techId.techName.equals("tsmc90")) {
                tech = techPool.getTech(techPool.idManager.newTechId("cmos90"));
            }
            if (tech == null) {
                errorLogger.logError(fileURL + ", Cannot identify technology " + techId.techName + " while reading project settings", -1);
                continue;
            }
            JELIB.realizeMeaningPrefs(projectSettings, tech, vars);
        }
        for (Map.Entry<Object, Variable[]> entry : parser.tools.entrySet()) {
            String toolName = (String)entry.getKey();
            vars = entry.getValue();
            Tool tool = Tool.findTool(toolName);
            if (tool == null) {
                errorLogger.logError(fileURL + ", Cannot identify tool " + toolName, -1);
                continue;
            }
            JELIB.realizeMeaningPrefs(projectSettings, tool, vars);
        }
        return projectSettings;
    }

    public static JelibParser parse(IdManager idManager, URL fileURL, FileType fileType, boolean onlyProjectSettings, ErrorLogger errorLogger) throws IOException {
        LibId libId = idManager.newLibId(TextUtils.getFileNameWithoutExtension(fileURL));
        return JelibParser.parse(libId, fileURL, fileType, onlyProjectSettings, errorLogger);
    }

    @Override
    boolean readTheLibrary(boolean onlyProjectSettings, LibraryStatistics.FileContents fc, EditingPreferences ep) {
        return false;
    }

    @Override
    Map<Cell, Variable[]> createLibraryCells(boolean onlyProjectSettings, EditingPreferences ep) {
        Variable[] vars;
        this.lib.erase();
        this.realizeVariables(this.lib, this.parser.libVars);
        this.lib.setVersion(this.parser.version);
        for (Map.Entry<TechId, Variable[]> entry : this.parser.techIds.entrySet()) {
            TechId techId = entry.getKey();
            vars = entry.getValue();
            Technology tech = this.findTechnology(techId);
            if (tech == null) {
                String msg = this.filePath != null ? this.filePath + ", " : "";
                Input.errorLogger.logError(msg + "Cannot identify technology " + techId.techName, -1);
                continue;
            }
            this.realizeMeaningPrefs(tech, vars);
        }
        for (Map.Entry<Object, Variable[]> entry : this.parser.tools.entrySet()) {
            String toolName = (String)entry.getKey();
            vars = entry.getValue();
            Tool tool = Tool.findTool(toolName);
            if (tool == null) {
                Input.errorLogger.logError(this.parser.fileURL + ", Cannot identify tool " + toolName, -1);
                continue;
            }
            this.realizeMeaningPrefs(tool, vars);
        }
        for (Map.Entry<Object, Object> entry : this.parser.externalLibIds.entrySet()) {
            LibId libId = (LibId)entry.getKey();
            String libFileName = (String)entry.getValue();
            if (Library.findLibrary(libId.libName) != null) continue;
            this.readExternalLibraryFromFilename(libFileName, this.fileType, ep);
        }
        this.nodeProtoCount = this.parser.allCells.size();
        this.nodeProtoList = new Cell[this.nodeProtoCount];
        this.cellLambda = new double[this.nodeProtoCount];
        HashMap<Cell, Variable[]> originalVars = new HashMap<Cell, Variable[]>();
        HashMap<CellName, Cell> hashMap = new HashMap<CellName, Cell>();
        int cellNum = 0;
        for (JelibParser.CellContents cc : this.parser.allCells.values()) {
            CellId cellId = cc.cellId;
            Cell cell = Cell.newInst(this.lib, cellId.cellName.toString());
            Technology tech = this.findTechnology(cc.techId);
            cell.setTechnology(tech);
            cell.lowLevelSetCreationDate(new Date(cc.creationDate));
            cell.lowLevelSetRevisionDate(new Date(cc.revisionDate));
            if (cc.expanded) {
                cell.setWantExpanded();
            }
            if (cc.allLocked) {
                cell.setAllLocked();
            }
            if (cc.instLocked) {
                cell.setInstancesLocked();
            }
            if (cc.cellLib) {
                cell.setInCellLibrary();
            }
            if (cc.techLib) {
                cell.setInTechnologyLibrary();
            }
            originalVars.put(cell, cc.vars);
            this.nodeProtoList[cellNum++] = cell;
            Cell otherCell = (Cell)hashMap.get(cc.groupName);
            if (otherCell == null) {
                hashMap.put(cc.groupName, cell);
                continue;
            }
            cell.joinGroup(otherCell);
        }
        this.lib.setFromDisk();
        this.lib.setDelibCells();
        return originalVars;
    }

    @Override
    Variable[] findVarsOnExampleIcon(Cell parentCell, Cell iconCell) {
        JelibParser.CellContents cc = this.parser.allCells.get(parentCell.getId());
        if (cc == null) {
            return null;
        }
        for (JelibParser.NodeContents nc : cc.nodes) {
            if (nc.protoId != iconCell.getId()) continue;
            return nc.vars;
        }
        return null;
    }

    @Override
    protected void realizeCellsRecursively(Cell cell, HashSet<Cell> recursiveSetupFlag, HashSet<Cell> patchedCells, String scaledCellName, double scale) {
        if (scaledCellName != null) {
            return;
        }
        JelibParser.CellContents cc = this.parser.allCells.get(cell.getId());
        if (cc == null || cc.filledIn) {
            return;
        }
        this.instantiateCellContent(cell, cc, recursiveSetupFlag, patchedCells);
        JELIB.setProgressValue(++cellsConstructed * 100 / totalCells);
        recursiveSetupFlag.add(cell);
    }

    private void instantiateCellContent(Cell cell, JelibParser.CellContents cc, HashSet<Cell> recursiveSetupFlag, HashSet<Cell> patchedCells) {
        int line;
        HashMap<Technology, Technology.SizeCorrector> sizeCorrectors = new HashMap<Technology, Technology.SizeCorrector>();
        for (JelibParser.NodeContents n : cc.nodes) {
            NodeInst ni;
            Comparable<Cell> subCell;
            line = n.line;
            String prefixName = this.lib.getName();
            Comparable<Cell> np = null;
            NodeProtoId protoId = n.protoId;
            if (protoId instanceof CellId) {
                np = this.database.getCell((CellId)protoId);
            } else {
                PrimitiveNodeId pnId = (PrimitiveNodeId)protoId;
                np = this.findPrimitiveNode(pnId);
                if (np == null) {
                    Input.errorLogger.logError(cc.fileName + ", line " + line + ", Cannot find primitive node " + pnId, cell, -1);
                    HashSet<PrimitiveNodeId> primSet = (HashSet<PrimitiveNodeId>)undefinedTechsAndPrimitives.get(pnId.techId);
                    if (primSet == null) {
                        primSet = new HashSet<PrimitiveNodeId>();
                        undefinedTechsAndPrimitives.put(pnId.techId, primSet);
                    }
                    primSet.add(pnId);
                    CellName cellName = CellName.parseName(pnId.name);
                    if (cellName.getVersion() <= 0) {
                        cellName = CellName.newName(cellName.getName(), cellName.getView(), 1);
                    }
                    protoId = this.lib.getId().newCellId(cellName);
                }
            }
            if (np != null && np instanceof Cell && !recursiveSetupFlag.contains(subCell = np)) {
                LibraryFiles reader = this;
                if (((Cell)subCell).getLibrary() != cell.getLibrary()) {
                    reader = this.getReaderForLib(((Cell)subCell).getLibrary());
                }
                if (reader != null) {
                    ((LibraryFiles)reader).realizeCellsRecursively((Cell)subCell, recursiveSetupFlag, patchedCells, null, 0.0);
                }
            }
            EPoint size = n.size;
            if (np instanceof PrimitiveNode) {
                PrimitiveNode pn = (PrimitiveNode)np;
                Technology tech = pn.getTechnology();
                Technology.SizeCorrector sizeCorrector = (Technology.SizeCorrector)sizeCorrectors.get(tech);
                if (sizeCorrector == null) {
                    sizeCorrector = tech.getSizeCorrector(cc.version, this.projectSettings, true, false);
                    sizeCorrectors.put(tech, sizeCorrector);
                }
                size = sizeCorrector.getSizeFromDisk(pn, size);
            }
            if (np == null) {
                Rectangle2D bounds;
                Cell dummyCell;
                CellId dummyCellId = (CellId)protoId;
                String protoName = dummyCellId.cellName.toString();
                Library cellLib = this.database.getLib(dummyCellId.libId);
                if (cellLib == null) {
                    Input.errorLogger.logError(cc.fileName + ", line " + line + ", Creating dummy library " + prefixName, cell, -1);
                    cellLib = Library.newInst(prefixName, null);
                }
                if ((dummyCell = cellLib.findNodeProto(protoName)) != null && dummyCell.getVar(IO_DUMMY_OBJECT) == null) {
                    dummyCell = null;
                }
                if (dummyCell == null) {
                    dummyCell = Cell.makeInstance(this.ep, cellLib, protoName);
                    if (dummyCell == null) {
                        Input.errorLogger.logError(cc.fileName + ", line " + line + ", Unable to create dummy cell " + protoName + " in " + cellLib, cell, -1);
                        continue;
                    }
                    Input.errorLogger.logError(cc.fileName + ", line " + line + ", Creating dummy cell " + protoName + " in " + cellLib, cell, -1);
                }
                if ((bounds = this.parser.externalCells.get(dummyCellId.toString())) == null) {
                    Input.errorLogger.logError(cc.fileName + ", line " + line + ", Warning: cannot find information about external cell " + dummyCellId, cell, -1);
                    NodeInst.newInst(Generic.tech().invisiblePinNode, this.ep, new Point2D.Double(0.0, 0.0), 0.0, 0.0, dummyCell);
                } else {
                    NodeInst.newInst(Generic.tech().invisiblePinNode, this.ep, new Point2D.Double(bounds.getCenterX(), bounds.getCenterY()), bounds.getWidth(), bounds.getHeight(), dummyCell);
                }
                dummyCell.newVar(IO_TRUE_LIBRARY, (Object)prefixName, this.ep);
                dummyCell.newVar(IO_DUMMY_OBJECT, (Object)protoName, this.ep);
                np = dummyCell;
            }
            if ((ni = NodeInst.newInst(cell, np, n.nodeName, n.nameTextDescriptor, n.anchor, size, n.orient, n.flags, n.techBits, n.protoTextDescriptor, Input.errorLogger)) == null) {
                Input.errorLogger.logError(cc.fileName + ", line " + (cc.lineNumber + line) + " (" + cell + ") cannot create node " + n.protoId, cell, -1);
                continue;
            }
            this.realizeVariables(ni, n.vars);
            n.ni = ni;
        }
        for (JelibParser.ExportContents e : cc.exports) {
            line = e.line;
            PortInst pi = this.figureOutPortInst(cell, e.originalPort.externalId, (JelibParser.NodeContents)e.originalNode, e.pos, cc.fileName, line);
            if (pi == null) continue;
            Export pp = Export.newInstanceNoIcon(cell, e.exportId, e.exportUserName, e.nameTextDescriptor, pi, e.alwaysDrawn, e.bodyOnly, e.ch, errorLogger);
            if (pp == null) {
                Input.errorLogger.logError(cc.fileName + ", line " + (cc.lineNumber + line) + " (" + cell + ") cannot create export " + e.exportUserName, pi.getNodeInst(), cell, null, -1);
                continue;
            }
            this.realizeVariables(pp, e.vars);
        }
        for (JelibParser.ArcContents a : cc.arcs) {
            List<Geometric> geomList;
            ArcInst ai;
            PortInst tailPI;
            Technology tech;
            Technology.SizeCorrector sizeCorrector;
            line = a.line;
            ArcProto ap = this.findArcProto(a.arcProtoId);
            if (ap == null) {
                if (ap == null) {
                    ap = cell.getTechnology().convertOldArcName(a.arcProtoId.name);
                }
                if (ap == null) {
                    Input.errorLogger.logError(cc.fileName + ", line " + line + " (" + cell + ") cannot find arc " + a.arcProtoId, cell, -1);
                    ArcProtoId arcId = a.arcProtoId;
                    HashSet<ArcProtoId> arcSet = (HashSet<ArcProtoId>)undefinedTechsAndPrimitives.get(arcId.techId);
                    if (arcSet == null) {
                        arcSet = new HashSet<ArcProtoId>();
                        undefinedTechsAndPrimitives.put(arcId.techId, arcSet);
                    }
                    arcSet.add(arcId);
                    continue;
                }
            }
            if ((sizeCorrector = (Technology.SizeCorrector)sizeCorrectors.get(tech = ap.getTechnology())) == null) {
                sizeCorrector = tech.getSizeCorrector(cc.version, this.projectSettings, true, false);
                sizeCorrectors.put(tech, sizeCorrector);
            }
            long gridExtendOverMin = sizeCorrector.getExtendFromDisk(ap, a.diskWidth);
            PortInst headPI = this.figureOutPortInst(cell, a.headPort.externalId, (JelibParser.NodeContents)a.headNode, a.headPoint, cc.fileName, line);
            if (headPI == null || (tailPI = this.figureOutPortInst(cell, a.tailPort.externalId, (JelibParser.NodeContents)a.tailNode, a.tailPoint, cc.fileName, line)) == null) continue;
            TextDescriptor nameDescriptor = a.nameTextDescriptor;
            if (nameDescriptor == null) {
                nameDescriptor = this.ep.getArcTextDescriptor();
            }
            if ((ai = ArcInst.newInstanceNoCheck(cell, ap, a.arcName, nameDescriptor, headPI, tailPI, a.headPoint, a.tailPoint, gridExtendOverMin, a.angle, a.flags)) == null) {
                geomList = new ArrayList<NodeInst>();
                geomList.add(headPI.getNodeInst());
                geomList.add(tailPI.getNodeInst());
                Input.errorLogger.logMessage(cc.fileName + ", line " + line + " (" + cell + ") cannot create arc " + a.arcProtoId, geomList, cell, 2, true);
                continue;
            }
            this.realizeVariables(ai, a.vars);
            if (ai.getName().equals(a.arcName) || a.arcName == null || a.arcName.indexOf(64) >= 0 || ai.getVar(Artwork.ART_MESSAGE) != null) continue;
            if (a.nameTextDescriptor != null) {
                ai.newVar(Artwork.ART_MESSAGE, (Object)a.arcName, a.nameTextDescriptor);
            } else {
                ai.newDisplayVar(Artwork.ART_MESSAGE, a.arcName, this.ep);
            }
            patchedCells.add(cell);
            geomList = Collections.singletonList(ai);
            Input.errorLogger.logMessage(cc.fileName + ", line " + line + " (" + cell + ") illegal arc name <" + a.arcName + "> is saved in ART_MESSAGE variable", geomList, cell, 2, true);
        }
        cc.filledIn = true;
    }

    private PortInst figureOutPortInst(Cell cell, String portName, JelibParser.NodeContents n, Point2D pos, String fileName, int lineNumber) {
        NodeInst ni;
        NodeInst nodeInst = ni = n != null ? n.ni : null;
        if (ni == null) {
            Input.errorLogger.logError(fileName + ", line " + lineNumber + " (" + cell + ") cannot find node " + n.nodeName, cell, -1);
            return null;
        }
        PortInst pi = null;
        PortProto pp = JELIB.findPortProto(ni.getProto(), portName);
        if (pp != null) {
            pi = ni.findPortInstFromProto(pp);
        }
        if (pi != null) {
            return pi;
        }
        Variable var = null;
        Cell subCell = null;
        if (ni.isCellInstance()) {
            subCell = (Cell)ni.getProto();
            var = subCell.getVar(IO_TRUE_LIBRARY);
            if (pos == null) {
                pos = this.parser.externalExports.get(subCell.getId().newPortId(portName));
            }
        }
        if (pos == null) {
            pos = ni.getAnchorCenter();
        }
        if (var == null) {
            NodeInst portNI = NodeInst.newInst(Generic.tech().universalPinNode, this.ep, pos, 0.0, 0.0, cell);
            if (portNI == null) {
                Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Unable to create dummy node in " + cell + " (cannot create source node)", cell, -1);
                return null;
            }
            Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Port " + portName + " on " + ni.getProto() + " renamed or deleted, still used on node " + n.nodeName + " in " + cell, portNI, cell, null, -1);
            return portNI.getOnlyPortInst();
        }
        String name = portName;
        if (name.length() == 0) {
            name = "X";
        }
        Point2D.Double tpos = new Point2D.Double();
        ni.transformIn().transform(pos, tpos);
        NodeInst portNI = NodeInst.newInst(Generic.tech().universalPinNode, this.ep, tpos, 0.0, 0.0, subCell);
        if (portNI == null) {
            Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Unable to create export " + name + " on dummy " + subCell + " (cannot create source node)", cell, -1);
            return null;
        }
        PortInst portPI = portNI.getOnlyPortInst();
        Export export = Export.newInstanceNoIcon(subCell, portPI, name, this.ep, null);
        if (export == null) {
            Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Unable to create export " + name + " on dummy " + subCell, cell, -1);
            return null;
        }
        pi = ni.findPortInstFromProto(export);
        Input.errorLogger.logError(fileName + ", line " + lineNumber + ", Creating export " + name + " on dummy " + subCell, cell, -1);
        return pi;
    }

    Technology findTechnology(TechId techId) {
        TechPool techPool = this.database.getTechPool();
        Technology tech = techPool.getTech(techId);
        if (tech == null && techId.techName.equals("tsmc90")) {
            tech = techPool.getTech(this.idManager.newTechId("cmos90"));
        }
        return tech;
    }

    PrimitiveNode findPrimitiveNode(PrimitiveNodeId primitiveNodeId) {
        Technology tech;
        TechPool techPool = this.database.getTechPool();
        PrimitiveNode pn = techPool.getPrimitiveNode(primitiveNodeId);
        if (pn == null && primitiveNodeId.techId.techName.equals("tsmc90")) {
            pn = this.findPrimitiveNode(this.idManager.newTechId("cmos90").newPrimitiveNodeId(primitiveNodeId.name));
        }
        if (pn == null && (tech = this.findTechnology(primitiveNodeId.techId)) != null) {
            pn = tech.convertOldNodeName(primitiveNodeId.name);
        }
        return pn;
    }

    ArcProto findArcProto(ArcProtoId arcProtoId) {
        TechPool techPool = this.database.getTechPool();
        ArcProto ap = techPool.getArcProto(arcProtoId);
        if (ap == null && arcProtoId.techId.techName.equals("tsmc90")) {
            ap = this.findArcProto(this.idManager.newTechId("cmos90").newArcProtoId(arcProtoId.name));
        }
        return ap;
    }
}

