/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input.bookshelf;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.id.CellId;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.io.input.bookshelf.BookshelfAux;
import com.sun.electric.tool.io.input.bookshelf.BookshelfNets;
import com.sun.electric.tool.io.input.bookshelf.BookshelfNodes;
import com.sun.electric.tool.io.input.bookshelf.BookshelfPlacement;
import com.sun.electric.tool.io.input.bookshelf.BookshelfWeights;
import java.net.URL;
import java.util.BitSet;
import java.util.Map;

public class Bookshelf
extends Input<Object> {
    private BookshelfPreferences preferences;

    private Bookshelf(BookshelfPreferences preferences) {
        this.preferences = preferences;
    }

    @Override
    protected Library importALibrary(Library lib, Technology tech, Map<Library, Cell> currentCells) {
        try {
            BookshelfAux auxParser = new BookshelfAux(this.preferences.fileUrl.getFile());
            Object files = auxParser.parse();
            String auxDir = auxParser.getAuxDir();
            BookshelfNodes nodes = new BookshelfNodes(auxDir + (String)files.get((Object)BookshelfFiles.nodes));
            nodes.parse();
            BookshelfPlacement pl = new BookshelfPlacement(auxDir + (String)files.get((Object)BookshelfFiles.pl));
            pl.parse();
            BookshelfWeights wts = new BookshelfWeights(auxDir + (String)files.get((Object)BookshelfFiles.wts));
            wts.parse();
            BookshelfNets nets = new BookshelfNets(auxDir + (String)files.get((Object)BookshelfFiles.nets), lib);
            nets.parse();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return lib;
    }

    public static class BookshelfPreferences
    extends Input.InputPreferences {
        private URL fileUrl = null;

        public BookshelfPreferences(boolean factory) {
            super(factory);
        }

        @Override
        public Library doInput(URL fileURL, Library lib, Technology tech, Map<Library, Cell> currentCells, Map<CellId, BitSet> nodesToExpand, Job job) {
            Bookshelf bookshelf = new Bookshelf(this);
            this.fileUrl = fileURL;
            return bookshelf.importALibrary(lib, tech, currentCells);
        }
    }

    public static enum BookshelfFiles {
        aux,
        nodes,
        nets,
        wts,
        pl,
        scl;


        public static BookshelfFiles getFileType(String file) {
            if (file.endsWith("." + aux.toString())) {
                return aux;
            }
            if (file.endsWith("." + nodes.toString())) {
                return nodes;
            }
            if (file.endsWith("." + nets.toString())) {
                return nets;
            }
            if (file.endsWith("." + wts.toString())) {
                return wts;
            }
            if (file.endsWith("." + pl.toString())) {
                return pl;
            }
            if (file.endsWith("." + scl.toString())) {
                return scl;
            }
            return null;
        }
    }
}

