/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.util.concurrent.runtime;

import com.sun.electric.tool.util.concurrent.runtime.ThreadID;
import java.util.Random;

public class MultiThreadedRandomizer {
    private int numOfCores;
    private Random[] randomizers;

    public MultiThreadedRandomizer(int numOfCores) {
        this.numOfCores = numOfCores;
        this.randomizers = new Random[this.numOfCores];
        Random rand = new Random(System.currentTimeMillis());
        for (int i = 0; i < this.numOfCores; ++i) {
            this.randomizers[i] = new Random(rand.nextLong());
        }
    }

    public Random getRandomizer() {
        int threadId = ThreadID.get();
        if (threadId < 0 || threadId >= this.numOfCores) {
            return new Random(System.currentTimeMillis());
        }
        return this.randomizers[ThreadID.get()];
    }

    public Random getRandomizer(int n) {
        return this.randomizers[n];
    }
}

