/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.text.Pref;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.menus.ToolMenu;
import com.sun.electric.tool.user.ui.TopLevel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanguageScripts
extends EDialog {
    private JList scriptsList;
    private DefaultListModel scriptsModel;
    private boolean changingMnemonic;
    private static Pref prefScriptList = Pref.makeStringPref("BoundScripts", User.getUserTool().prefs, "");
    private JButton addScript;
    private JButton cancel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JTextField mnemonic;
    private JButton ok;
    private JButton removeScript;
    private JScrollPane scriptsPane;

    public LanguageScripts() {
        super((Frame)TopLevel.getCurrentJFrame(), true);
        this.initComponents();
        this.scriptsModel = new DefaultListModel();
        this.scriptsList = new JList(this.scriptsModel);
        this.scriptsList.setSelectionMode(0);
        this.scriptsPane.setViewportView(this.scriptsList);
        List<ScriptBinding> scripts = LanguageScripts.getScripts();
        for (ScriptBinding s : scripts) {
            String scriptLine = this.makeLine(s);
            this.scriptsModel.addElement(scriptLine);
        }
        this.mnemonic.getDocument().addDocumentListener(new MnemonicDocumentListener());
        this.scriptsList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                LanguageScripts.this.clickedScript();
            }
        });
        this.pack();
        this.finishInitialization();
        this.setVisible(true);
    }

    @Override
    protected void escapePressed() {
        this.closeDialog(null);
    }

    public static List<ScriptBinding> getScripts() {
        ArrayList<ScriptBinding> scripts = new ArrayList<ScriptBinding>();
        String allScripts = prefScriptList.getString();
        String[] eachScript = allScripts.split("\t");
        for (int i = 0; i < eachScript.length; ++i) {
            String script = eachScript[i].trim();
            if (script.length() == 0) continue;
            ScriptBinding sb = new ScriptBinding();
            if (script.charAt(1) == '/') {
                sb.fileName = script.substring(2);
                sb.mnemonic = script.charAt(0);
            } else {
                sb.fileName = script;
                sb.mnemonic = '\u0000';
            }
            scripts.add(sb);
        }
        return scripts;
    }

    public void saveScripts() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.scriptsModel.getSize(); ++i) {
            String scriptLine;
            if (sb.length() > 0) {
                sb.append('\t');
            }
            if ((scriptLine = (String)this.scriptsModel.elementAt(i)).charAt(1) == ':') {
                scriptLine = scriptLine.substring(0, 1) + "/" + scriptLine.substring(3);
            }
            scriptLine = scriptLine.trim();
            sb.append(scriptLine);
        }
        prefScriptList.setString(sb.toString());
    }

    private void clickedScript() {
        ScriptBinding sb = this.getSelected();
        if (sb == null) {
            return;
        }
        this.changingMnemonic = true;
        if (sb.mnemonic == '\u0000') {
            this.mnemonic.setText("");
        } else {
            this.mnemonic.setText(sb.mnemonic + "");
        }
        this.changingMnemonic = false;
    }

    private String makeLine(ScriptBinding sb) {
        String scriptLine = sb.fileName;
        scriptLine = sb.mnemonic != '\u0000' ? sb.mnemonic + ": " + scriptLine : "   " + scriptLine;
        return scriptLine;
    }

    private ScriptBinding getSelected() {
        int index2 = this.scriptsList.getSelectedIndex();
        if (index2 < 0 || index2 >= this.scriptsModel.size()) {
            return null;
        }
        ScriptBinding sb = new ScriptBinding();
        String scriptLine = (String)this.scriptsModel.elementAt(index2);
        sb.fileName = scriptLine.substring(3);
        if (scriptLine.charAt(1) == ':') {
            sb.mnemonic = scriptLine.charAt(0);
        }
        return sb;
    }

    private void changedMnemonic() {
        if (this.changingMnemonic) {
            return;
        }
        ScriptBinding sb = this.getSelected();
        if (sb == null) {
            return;
        }
        String mn = this.mnemonic.getText().trim();
        sb.mnemonic = mn.length() == 0 ? (char)'\u0000' : mn.charAt(0);
        this.scriptsModel.set(this.scriptsList.getSelectedIndex(), this.makeLine(sb));
    }

    private void initComponents() {
        this.ok = new JButton();
        this.scriptsPane = new JScrollPane();
        this.jLabel2 = new JLabel();
        this.removeScript = new JButton();
        this.addScript = new JButton();
        this.cancel = new JButton();
        this.mnemonic = new JTextField();
        this.jLabel1 = new JLabel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Language Scripts");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                LanguageScripts.this.closeDialog(evt);
            }
        });
        this.ok.setText("OK");
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LanguageScripts.this.okActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.ok, gridBagConstraints);
        this.scriptsPane.setPreferredSize(new Dimension(300, 200));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.scriptsPane, gridBagConstraints);
        this.jLabel2.setText("Scripts:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.removeScript.setText("Remove Script");
        this.removeScript.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LanguageScripts.this.removeScriptActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 0.6;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.removeScript, gridBagConstraints);
        this.addScript.setText("Add Script");
        this.addScript.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LanguageScripts.this.addScriptActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.addScript, gridBagConstraints);
        this.cancel.setText("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LanguageScripts.this.cancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.cancel, gridBagConstraints);
        this.mnemonic.setColumns(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 0.2;
        this.getContentPane().add((Component)this.mnemonic, gridBagConstraints);
        this.jLabel1.setText("Mnemonic:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 0.2;
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.pack();
    }

    private void cancelActionPerformed(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void addScriptActionPerformed(ActionEvent evt) {
        String fileName = OpenFile.chooseInputFile(FileType.JAVA, null);
        if (fileName != null) {
            this.scriptsModel.addElement("   " + fileName);
            this.scriptsList.setSelectedIndex(this.scriptsModel.size() - 1);
        }
    }

    private void removeScriptActionPerformed(ActionEvent evt) {
        int index2 = this.scriptsList.getSelectedIndex();
        if (index2 < 0 || index2 >= this.scriptsModel.size()) {
            return;
        }
        this.scriptsModel.remove(index2);
    }

    private void okActionPerformed(ActionEvent evt) {
        this.saveScripts();
        ToolMenu.setDynamicLanguageMenu();
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private class MnemonicDocumentListener
    implements DocumentListener {
        private MnemonicDocumentListener() {
        }

        public void changedUpdate(DocumentEvent e) {
            LanguageScripts.this.changedMnemonic();
        }

        public void insertUpdate(DocumentEvent e) {
            LanguageScripts.this.changedMnemonic();
        }

        public void removeUpdate(DocumentEvent e) {
            LanguageScripts.this.changedMnemonic();
        }
    }

    public static class ScriptBinding {
        public char mnemonic;
        public String fileName;
    }
}

