/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.seaOfGates;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.Environment;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.routing.SeaOfGates;
import com.sun.electric.tool.routing.seaOfGates.SeaOfGatesEngine;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.util.concurrent.Parallel;
import com.sun.electric.tool.util.concurrent.datastructures.WorkStealingStructure;
import com.sun.electric.tool.util.concurrent.exceptions.PoolExistsException;
import com.sun.electric.tool.util.concurrent.patterns.PForTask;
import com.sun.electric.tool.util.concurrent.patterns.PJob;
import com.sun.electric.tool.util.concurrent.patterns.PTask;
import com.sun.electric.tool.util.concurrent.runtime.Scheduler;
import com.sun.electric.tool.util.concurrent.runtime.taskParallel.ThreadPool;
import com.sun.electric.tool.util.concurrent.utils.BlockedRange1D;
import com.sun.electric.util.math.DBMath;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeaOfGatesEngineNew2
extends SeaOfGatesEngine {
    private ThreadPool pools;
    private PJob seaOfGatesJob;

    @Override
    protected void doRouting(List<SeaOfGatesEngine.NeededRoute> allRoutes, SeaOfGatesEngine.RouteBatches[] routeBatches, Job job, Environment env, EditingPreferences ep) {
        try {
            ThreadPool.initialize(Scheduler.SchedulingStrategy.workStealing, 2, ThreadPool.ThreadPoolType.userDefined);
        }
        catch (PoolExistsException e1) {
        }
        catch (Scheduler.UnknownSchedulerException e) {
            // empty catch block
        }
        super.doRouting(allRoutes, routeBatches, job, env, ep);
        try {
            ThreadPool.getThreadPool().shutdown();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }

    @Override
    protected void doRoutingParallel(int numberOfThreads, List<SeaOfGatesEngine.NeededRoute> allRoutes, SeaOfGatesEngine.RouteBatches[] routeBatches, Environment env, EditingPreferences ep) {
        if (Job.getDebug()) {
            System.out.println("Do routing parallel with new parallel Infrastructure 2");
        }
        try {
            this.pools = ThreadPool.initialize(Scheduler.SchedulingStrategy.workStealing, numberOfThreads, ThreadPool.ThreadPoolType.userDefined);
        }
        catch (Exception e1) {
            // empty catch block
        }
        this.seaOfGatesJob = new PJob();
        this.seaOfGatesJob.execute(false);
        SeaOfGatesEngine.NeededRoute[] routesToDo = new SeaOfGatesEngine.NeededRoute[numberOfThreads];
        int[] routeIndices = new int[numberOfThreads];
        ArrayList<SeaOfGatesEngine.NeededRoute> myList = new ArrayList<SeaOfGatesEngine.NeededRoute>();
        for (SeaOfGatesEngine.NeededRoute nr : allRoutes) {
            myList.add(nr);
        }
        ArrayList<Rectangle2D> blocked = new ArrayList<Rectangle2D>();
        int totalRoutes = allRoutes.size();
        int routesDone = 0;
        while (myList.size() > 0) {
            int i;
            int threadAssign = 0;
            blocked.clear();
            for (int i2 = 0; i2 < myList.size(); ++i2) {
                SeaOfGatesEngine.NeededRoute nr = (SeaOfGatesEngine.NeededRoute)myList.get(i2);
                boolean isBlocked = false;
                for (Rectangle2D block : blocked) {
                    if (!block.intersects(nr.routeBounds)) continue;
                    isBlocked = true;
                    break;
                }
                if (isBlocked) continue;
                blocked.add(nr.routeBounds);
                routesToDo[threadAssign] = nr;
                routeIndices[threadAssign] = i2;
                this.findPath(nr, env, ep);
                if (++threadAssign >= numberOfThreads) break;
            }
            String routes = "";
            for (i = 0; i < threadAssign; ++i) {
                String routeName = routesToDo[i].routeName;
                if (routeBatches[routesToDo[i].batchNumber].segsInBatch > 1) {
                    routeName = routeName + "(" + routesToDo[i].routeInBatch + "/" + routeBatches[routesToDo[i].batchNumber].segsInBatch + ")";
                }
                if (routes.length() > 0) {
                    routes = routes + ", ";
                }
                routes = routes + routeName;
            }
            System.out.println("Parallel routing " + routes + "...");
            Job.getUserInterface().setProgressNote(routes);
            this.seaOfGatesJob.join();
            for (i = 0; i < threadAssign; ++i) {
                if (routesToDo[i].winningWF == null || routesToDo[i].winningWF.vertices == null) continue;
                this.createRoute(routesToDo[i]);
            }
            for (i = threadAssign - 1; i >= 0; --i) {
                myList.remove(routeIndices[i]);
            }
            Job.getUserInterface().setProgressValue((routesDone += threadAssign) * 100 / totalRoutes);
        }
        this.seaOfGatesJob.join();
        try {
            ThreadPool.getThreadPool().shutdown();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void findPath(SeaOfGatesEngine.NeededRoute nr, Environment env, EditingPreferences ep) {
        SeaOfGatesEngine.Wavefront d1 = nr.dir1;
        if (DBMath.areEquals(d1.toX, d1.fromX) && DBMath.areEquals(d1.toY, d1.fromY) && d1.toZ == d1.fromZ) {
            nr.winningWF = d1;
            nr.winningWF.vertices = new ArrayList<SeaOfGatesEngine.SearchVertex>();
            SeaOfGatesEngine.SearchVertex sv = new SeaOfGatesEngine.SearchVertex(d1.toX, d1.toY, d1.toZ, 0, null, 0, nr.winningWF);
            nr.winningWF.vertices.add(sv);
            nr.cleanSearchMemory();
            return;
        }
        if (this.parallelDij) {
            RoutingTask rtask = new RoutingTask(this.seaOfGatesJob, nr, env, ep, this.errorLogger, this.cell);
            this.seaOfGatesJob.add(new DijkstraInTask(this.seaOfGatesJob, nr.dir1, nr.dir2, ep, rtask, 0));
            this.seaOfGatesJob.add(new DijkstraInTask(this.seaOfGatesJob, nr.dir2, nr.dir1, ep, rtask, 1));
        } else {
            this.doTwoWayDijkstra(nr);
        }
    }

    @Override
    protected void makeListOfRoutes(int numBatches, SeaOfGatesEngine.RouteBatches[] routeBatches, List<SeaOfGatesEngine.NeededRoute> allRoutes, List<ArcInst> arcsToRoute, SeaOfGates.SeaOfGatesOptions prefs, EditingPreferences ep) {
        try {
            ThreadPool.initialize(WorkStealingStructure.createForThreadPool(8));
        }
        catch (PoolExistsException e) {
            e.printStackTrace();
        }
        Parallel.For(new BlockedRange1D(0, numBatches, numBatches / 8), new ParallelListOfRoutes(routeBatches, allRoutes, arcsToRoute, prefs, ep));
        try {
            ThreadPool.getThreadPool().shutdown();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ParallelListOfRoutes
    extends PForTask<BlockedRange1D> {
        private SeaOfGatesEngine.RouteBatches[] routeBatches;
        private List<SeaOfGatesEngine.NeededRoute> allRoutes;
        private List<ArcInst> arcsToRoute;
        private SeaOfGates.SeaOfGatesOptions prefs;
        private EditingPreferences ep;

        public ParallelListOfRoutes(SeaOfGatesEngine.RouteBatches[] routeBatches, List<SeaOfGatesEngine.NeededRoute> allRoutes, List<ArcInst> arcsToRoute, SeaOfGates.SeaOfGatesOptions prefs, EditingPreferences ep) {
            this.routeBatches = routeBatches;
            this.allRoutes = allRoutes;
            this.arcsToRoute = arcsToRoute;
            this.prefs = prefs;
            this.ep = ep;
        }

        @Override
        public void execute() {
            EditingPreferences.setThreadEditingPreferences(this.ep);
            SeaOfGatesEngineNew2.this.doMakeListOfRoutes(((BlockedRange1D)this.range).start(), ((BlockedRange1D)this.range).end(), this.routeBatches, this.allRoutes, this.arcsToRoute, this.prefs);
        }
    }

    class DijkstraInTask
    extends PTask {
        private SeaOfGatesEngine.Wavefront wf;
        private SeaOfGatesEngine.Wavefront otherWf;
        private EditingPreferences ep;
        private RoutingTask rtask;
        private int number;

        public DijkstraInTask(PJob job, SeaOfGatesEngine.Wavefront wf, SeaOfGatesEngine.Wavefront otherWf, EditingPreferences ep, RoutingTask rtask, int number2) {
            super(job);
            this.wf = wf;
            this.otherWf = otherWf;
            this.ep = ep;
            this.rtask = rtask;
            this.number = number2;
        }

        public void execute() {
            EditingPreferences.setThreadEditingPreferences(this.ep);
            SeaOfGatesEngine.SearchVertex result2 = null;
            int numSearchVertices = 0;
            while (result2 == null) {
                if (++numSearchVertices > this.wf.nr.prefs.complexityLimit) {
                    result2 = SeaOfGatesEngineNew2.this.svLimited;
                    continue;
                }
                if (this.wf.abort) {
                    result2 = SeaOfGatesEngineNew2.this.svAborted;
                    continue;
                }
                result2 = SeaOfGatesEngineNew2.this.advanceWavefront(this.wf);
            }
            if (result2 != SeaOfGatesEngineNew2.this.svAborted && result2 != SeaOfGatesEngineNew2.this.svExhausted && result2 != SeaOfGatesEngineNew2.this.svLimited) {
                this.wf.vertices = SeaOfGatesEngineNew2.this.getOptimizedList(result2);
                this.wf.nr.winningWF = this.wf;
                this.otherWf.abort = true;
            }
            if (this.rtask.isReady(this.number)) {
                SeaOfGatesEngineNew2.this.seaOfGatesJob.add(this.rtask);
            }
        }
    }

    public static class RoutingTask
    extends PTask {
        private SeaOfGatesEngine.NeededRoute nr;
        private Environment env;
        private EditingPreferences ep;
        private ErrorLogger errorLogger;
        private Cell cell;
        private boolean[] isReady = new boolean[]{false, false};

        public RoutingTask(PJob job, SeaOfGatesEngine.NeededRoute nr, Environment env, EditingPreferences ep, ErrorLogger errorLogger, Cell cell) {
            super(job);
            this.nr = nr;
            this.env = env;
            this.ep = ep;
            this.errorLogger = errorLogger;
            this.cell = cell;
        }

        public synchronized boolean isReady(int id) {
            this.isReady[id] = true;
            return this.isReady[0] && this.isReady[1];
        }

        public void execute() {
            SeaOfGatesEngine.Wavefront wf = this.nr.winningWF;
            double verLength = Double.MAX_VALUE;
            if (wf != null) {
                verLength = SeaOfGatesEngine.getVertexLength(wf.vertices);
            }
            if (verLength == Double.MAX_VALUE) {
                if (wf == null) {
                    wf = this.nr.dir1;
                }
                String errorMsg = wf.vertices == null ? "Search too complex (exceeds complexity limit of " + this.nr.prefs.complexityLimit + " steps)" : "Failed to route from port " + wf.from.getPortProto().getName() + " of node " + wf.from.getNodeInst().describe(false) + " to port " + wf.to.getPortProto().getName() + " of node " + wf.to.getNodeInst().describe(false);
                System.out.println("ERROR: " + errorMsg);
                ArrayList<EPoint> lineList = new ArrayList<EPoint>();
                lineList.add(new EPoint(wf.toX, wf.toY));
                lineList.add(new EPoint(wf.fromX, wf.fromY));
                this.errorLogger.logMessageWithLines(errorMsg, null, lineList, this.cell, 0, true);
            }
            this.nr.cleanSearchMemory();
        }
    }

    private class RouteInTask
    extends PTask {
        private SeaOfGatesEngine.NeededRoute nr;
        private EditingPreferences ed;

        public RouteInTask(PJob job, SeaOfGatesEngine.NeededRoute nr, EditingPreferences ed) {
            super(job);
            this.nr = nr;
            this.ed = ed;
        }

        public void execute() {
            EditingPreferences.setThreadEditingPreferences(this.ed);
            if (this.nr == null) {
                return;
            }
            SeaOfGatesEngineNew2.this.findPath(this.nr, Environment.getThreadEnvironment(), this.ed);
        }
    }
}

