/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.trees;

import com.sun.electric.tool.Job;
import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.lists.LeafList;
import com.sun.electric.tool.ncc.lists.RecordList;
import com.sun.electric.tool.ncc.netlist.NetObject;
import com.sun.electric.tool.ncc.processing.LocalPartitionWires;
import com.sun.electric.tool.ncc.result.EquivRecReport;
import com.sun.electric.tool.ncc.result.NetObjReport;
import com.sun.electric.tool.ncc.strategy.Strategy;
import com.sun.electric.tool.ncc.trees.Circuit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EquivRecord
implements EquivRecReport.EquivRecReportable {
    private EquivRecord parent;
    private int randCode;
    private int value;
    private String partitionReason;
    private LocalPartitionWires.Signature wireSignature;
    private RecordList offspring;
    private List<Circuit> circuits;

    private static void error(boolean pred, String msg) {
        Job.error(pred, msg);
    }

    private ArrayList<HashMap<Integer, List<NetObject>>> getOneMapPerCircuit(Strategy js) {
        ArrayList<HashMap<Integer, List<NetObject>>> mapPerCkt = new ArrayList<HashMap<Integer, List<NetObject>>>();
        Iterator<Circuit> it = this.getCircuits();
        while (it.hasNext()) {
            Circuit ckt = it.next();
            HashMap<Integer, List<NetObject>> codeToNetObjs = js.doFor(ckt);
            mapPerCkt.add(codeToNetObjs);
        }
        return mapPerCkt;
    }

    private Set<Integer> getKeysFromAllMaps(ArrayList<HashMap<Integer, List<NetObject>>> mapPerCkt) {
        HashSet<Integer> keys = new HashSet<Integer>();
        for (HashMap<Integer, List<NetObject>> map2 : mapPerCkt) {
            keys.addAll(map2.keySet());
        }
        return keys;
    }

    private EquivRecord makeEquivRecForKey(ArrayList<HashMap<Integer, List<NetObject>>> mapPerCkt, Integer key, NccGlobals globals) {
        ArrayList<Circuit> ckts = new ArrayList<Circuit>();
        for (HashMap<Integer, List<NetObject>> map2 : mapPerCkt) {
            ArrayList netObjs = (ArrayList)map2.get(key);
            if (netObjs == null) {
                netObjs = new ArrayList();
            }
            ckts.add(Circuit.please(netObjs));
        }
        return EquivRecord.newLeafRecord(key, ckts, globals);
    }

    private EquivRecord() {
    }

    private void addOffspring(EquivRecord r) {
        this.offspring.add(r);
        r.setParent(this);
    }

    private LeafList applyToLeaf(Strategy js) {
        ArrayList<HashMap<Integer, List<NetObject>>> mapPerCkt = this.getOneMapPerCircuit(js);
        Set<Integer> keys = this.getKeysFromAllMaps(mapPerCkt);
        EquivRecord.error(keys.size() == 0, "must have at least one key");
        if (keys.size() == 1) {
            return new LeafList();
        }
        this.circuits = null;
        this.offspring = new RecordList();
        for (Integer key : keys) {
            EquivRecord er = this.makeEquivRecForKey(mapPerCkt, key, js.globals);
            this.addOffspring(er);
        }
        LeafList el = new LeafList();
        el.addAll(this.offspring);
        return el;
    }

    private LeafList applyToInternal(Strategy js) {
        LeafList offspring = new LeafList();
        Iterator<EquivRecord> it = this.getOffspring();
        while (it.hasNext()) {
            EquivRecord jr = it.next();
            offspring.addAll(js.doFor(jr));
        }
        return offspring;
    }

    public EquivRecord getParent() {
        return this.parent;
    }

    public int getCode() {
        return this.isMismatched() ? 0 : this.randCode;
    }

    public void checkMe(EquivRecord parent) {
        EquivRecord.error(this.getParent() != parent, "wrong parent");
        EquivRecord.error(!(this.offspring == null ^ this.circuits == null), "bad lists");
    }

    public void setParent(EquivRecord x) {
        this.parent = x;
    }

    public int getValue() {
        return this.value;
    }

    public Iterator<Circuit> getCircuits() {
        return this.circuits.iterator();
    }

    public int numCircuits() {
        return this.circuits.size();
    }

    public void addCircuit(Circuit c) {
        this.circuits.add(c);
        c.setParent(this);
    }

    public NetObject.Type getNetObjType() {
        Iterator<Circuit> ci = this.getCircuits();
        while (ci.hasNext()) {
            Circuit c = ci.next();
            Iterator<NetObject> ni = c.getNetObjs();
            if (!ni.hasNext()) continue;
            NetObject no = ni.next();
            return no.getNetObjType();
        }
        EquivRecord.error(true, "no NetObjects in a leaf EquivRecord?");
        return null;
    }

    public int numNetObjs() {
        int sum2 = 0;
        Iterator<Circuit> ci = this.getCircuits();
        while (ci.hasNext()) {
            Circuit c = ci.next();
            sum2 += c.numNetObjs();
        }
        return sum2;
    }

    public String sizeString() {
        if (this.numCircuits() == 0) {
            return "0";
        }
        String s = "";
        Iterator<Circuit> it = this.getCircuits();
        while (it.hasNext()) {
            Circuit jc = it.next();
            s = s + " " + jc.numNetObjs();
        }
        return s;
    }

    public int maxSizeDiff() {
        int out = 0;
        int max2 = this.maxSize();
        Iterator<Circuit> it = this.getCircuits();
        while (it.hasNext()) {
            Circuit j = it.next();
            int diff2 = max2 - j.numNetObjs();
            if (diff2 <= out) continue;
            out = diff2;
        }
        return out;
    }

    public int maxSize() {
        int out = 0;
        Iterator<Circuit> it = this.getCircuits();
        while (it.hasNext()) {
            Circuit j = it.next();
            out = Math.max(out, j.numNetObjs());
        }
        return out;
    }

    public boolean isActive() {
        EquivRecord.error(this.numCircuits() == 0, "leaf record with no circuits?");
        Iterator<Circuit> it = this.getCircuits();
        while (it.hasNext()) {
            Circuit c = it.next();
            if (c.numNetObjs() == 0) {
                return false;
            }
            if (c.numNetObjs() <= 1) continue;
            return true;
        }
        return false;
    }

    public boolean isBalanced() {
        boolean first = true;
        int sz = 0;
        Iterator<Circuit> it = this.getCircuits();
        while (it.hasNext()) {
            Circuit c = it.next();
            if (first) {
                sz = c.numNetObjs();
                first = false;
                continue;
            }
            if (c.numNetObjs() == sz) continue;
            return false;
        }
        return true;
    }

    public boolean isMatched() {
        Iterator<Circuit> it = this.getCircuits();
        while (it.hasNext()) {
            Circuit c = it.next();
            if (c.numNetObjs() == 1) continue;
            return false;
        }
        return true;
    }

    public boolean isMismatched() {
        Iterator<Circuit> it = this.getCircuits();
        while (it.hasNext()) {
            Circuit c = it.next();
            if (c.numNetObjs() != 0) continue;
            return true;
        }
        return false;
    }

    public Iterator<EquivRecord> getOffspring() {
        return this.offspring.iterator();
    }

    public int numOffspring() {
        return this.offspring.size();
    }

    public LeafList apply(Strategy js) {
        return this.isLeaf() ? this.applyToLeaf(js) : this.applyToInternal(js);
    }

    public String nameString() {
        String name = "";
        if (this.isLeaf()) {
            name = this.isMatched() ? "Matched" : (this.isMismatched() ? "Mismatched" : "Active");
            name = name + " leaf";
        } else {
            name = "Internal";
        }
        name = name + " Record randCode=" + this.randCode + " value=" + this.value;
        name = name + (this.isLeaf() ? " maxSize=" + this.maxSize() : " #offspring=" + this.numOffspring());
        return name;
    }

    public boolean isLeaf() {
        return this.offspring == null;
    }

    public void setPartitionReason(String s) {
        this.partitionReason = s;
    }

    public String getPartitionReason() {
        return this.partitionReason;
    }

    @Override
    public List<String> getPartitionReasonsFromRootToMe() {
        if (this.wireSignature != null) {
            return this.wireSignature.getReasons();
        }
        LinkedList<String> reasons = new LinkedList<String>();
        for (EquivRecord r = this; r != null; r = r.getParent()) {
            String reason = r.getPartitionReason();
            if (reason == null) continue;
            reasons.addFirst(reason);
        }
        return reasons;
    }

    public void setWireSignature(LocalPartitionWires.Signature sig) {
        this.wireSignature = sig;
    }

    public static EquivRecord newLeafRecord(int key, List<Circuit> ckts, NccGlobals globals) {
        EquivRecord r = new EquivRecord();
        r.circuits = new ArrayList<Circuit>();
        r.value = key;
        r.randCode = globals.getRandom();
        for (Circuit ckt : ckts) {
            r.addCircuit(ckt);
        }
        EquivRecord.error(r.maxSize() == 0, "invalid leaf EquivRecord: all Circuits are empty");
        return r;
    }

    public static EquivRecord newRootRecord(List<EquivRecord> offspring) {
        if (offspring.size() == 0) {
            return null;
        }
        EquivRecord r = new EquivRecord();
        r.offspring = new RecordList();
        for (EquivRecord er : offspring) {
            r.addOffspring(er);
        }
        return r;
    }

    public void getNetObjsFromEntireTree(List<List<NetObject>> matched, List<List<NetObject>> notMatched) {
        GetNetObjs gno = new GetNetObjs(this);
        matched.clear();
        matched.addAll(gno.getMatchedNetObjs());
        notMatched.clear();
        notMatched.addAll(gno.getNotMatchedNetObjs());
    }

    private List<List<NetObjReport.NetObjReportable>> coerceToReportable(List<List<NetObject>> no) {
        ArrayList<List<NetObjReport.NetObjReportable>> nor = new ArrayList<List<NetObjReport.NetObjReportable>>();
        for (List<NetObject> i : no) {
            ArrayList<NetObject> j = new ArrayList<NetObject>();
            j.addAll(i);
            nor.add(j);
        }
        return nor;
    }

    @Override
    public void getNetObjReportablesFromEntireTree(List<List<NetObjReport.NetObjReportable>> matched, List<List<NetObjReport.NetObjReportable>> notMatched) {
        ArrayList<List<NetObject>> m = new ArrayList<List<NetObject>>();
        ArrayList<List<NetObject>> nm = new ArrayList<List<NetObject>>();
        this.getNetObjsFromEntireTree(m, nm);
        matched.clear();
        matched.addAll(this.coerceToReportable(m));
        notMatched.clear();
        notMatched.addAll(this.coerceToReportable(nm));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GetNetObjs
    extends Strategy {
        private int numDesigns = -1;
        private final List<List<NetObject>> matches = new ArrayList<List<NetObject>>();
        private final List<List<NetObject>> notMatches = new ArrayList<List<NetObject>>();

        private void appendNetObjsFromCircuit(List<List<NetObject>> lists, EquivRecord er) {
            int i = 0;
            Iterator<Circuit> itC = er.getCircuits();
            while (itC.hasNext()) {
                Circuit ckt = itC.next();
                Iterator<NetObject> itN = ckt.getNetObjs();
                while (itN.hasNext()) {
                    lists.get(i).add(itN.next());
                }
                ++i;
            }
            Job.error(i != this.numDesigns, "wrong number of circuits");
        }

        @Override
        public LeafList doFor(EquivRecord er) {
            if (er.isLeaf()) {
                if (this.numDesigns == -1) {
                    this.numDesigns = er.numCircuits();
                    for (int i = 0; i < this.numDesigns; ++i) {
                        this.matches.add(new ArrayList());
                        this.notMatches.add(new ArrayList());
                    }
                }
                this.appendNetObjsFromCircuit(er.isMatched() ? this.matches : this.notMatches, er);
                return new LeafList();
            }
            return super.doFor(er);
        }

        public GetNetObjs(EquivRecord er) {
            super(null);
            this.doFor(er);
        }

        public List<List<NetObject>> getMatchedNetObjs() {
            return this.matches;
        }

        public List<List<NetObject>> getNotMatchedNetObjs() {
            return this.notMatches;
        }
    }
}

