/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.placement.Placement;
import com.sun.electric.tool.placement.PlacementAdapter;
import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.Orientation;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Spice
extends Input {
    private Map<String, SubcktDef> allCells = new HashMap<String, SubcktDef>();
    private SpicePreferences localPrefs;
    private String lastLine = null;

    Spice(SpicePreferences ap) {
        this.localPrefs = ap;
    }

    public void readDirectory(URL dirURL, Library lib) {
        try {
            String dirName = dirURL.getPath();
            File dir = new File(dirName);
            if (dir == null) {
                System.out.println("Unable to find files in directory " + dirName);
                return;
            }
            String[] filesInDir = dir.list();
            for (int i = 0; i < filesInDir.length; ++i) {
                URL url;
                String ext;
                String fileName = filesInDir[i];
                int lastDotPos = fileName.lastIndexOf(46);
                if (lastDotPos < 0 || !(ext = fileName.substring(lastDotPos + 1).toLowerCase()).equals("spi") && !ext.equals("sp") || (url = TextUtils.makeURLToFile(dirName + fileName)) == null || this.openTextInput(url)) continue;
                System.out.println("Reading " + fileName);
                this.readSimFile();
                this.closeInput();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.placeCells(lib);
    }

    private void readSimFile() throws IOException {
        String line;
        SubcktDef current = null;
        while ((line = this.getNextLine()) != null) {
            int i;
            if ((line = line.trim()).length() == 0 || line.charAt(0) == '*') continue;
            String lineLC = line.toLowerCase();
            if (lineLC.startsWith(".subckt")) {
                String[] expPieces = line.split(" ");
                current = new SubcktDef();
                this.allCells.put(expPieces[1], current);
                for (int i2 = 2; i2 < expPieces.length; ++i2) {
                    current.exports.add(expPieces[i2]);
                }
                continue;
            }
            if (lineLC.startsWith(".ends")) {
                current = null;
            }
            if (lineLC.charAt(0) == 'm' && current != null) {
                TransistorDef td = new TransistorDef();
                current.transistors.add(td);
                String[] traPieces = line.split(" ");
                if (traPieces.length < 6) {
                    System.out.println("Error on Transistor line: " + line);
                    continue;
                }
                td.name = traPieces[0].substring(1);
                td.drain = traPieces[1];
                td.gate = traPieces[2];
                td.source = traPieces[3];
                td.bias = traPieces[4];
                td.type = traPieces[5].toLowerCase();
                for (i = 6; i < traPieces.length; ++i) {
                    if (traPieces[i].toLowerCase().startsWith("w=")) {
                        td.width = traPieces[i].substring(2);
                    }
                    if (!traPieces[i].toLowerCase().startsWith("l=")) continue;
                    td.length = traPieces[i].substring(2);
                }
                continue;
            }
            if (lineLC.charAt(0) == 'r' && current != null) {
                ResistorDef rd = new ResistorDef();
                current.resistors.add(rd);
                String[] resPieces = line.split(" ");
                if (resPieces.length < 3) {
                    System.out.println("Error on Resistor line: " + line);
                    continue;
                }
                rd.name = resPieces[0].substring(1);
                rd.left = resPieces[1];
                rd.right = resPieces[2];
                if (resPieces.length < 4) continue;
                rd.resistance = resPieces[3];
                continue;
            }
            if (lineLC.charAt(0) == 'c' && current != null) {
                CapacitorDef cd = new CapacitorDef();
                current.capacitors.add(cd);
                String[] capPieces = line.split(" ");
                if (capPieces.length < 3) {
                    System.out.println("Error on Capacitor line: " + line);
                    continue;
                }
                cd.name = capPieces[0].substring(1);
                cd.top = capPieces[1];
                cd.bottom = capPieces[2];
                if (capPieces.length < 4) continue;
                cd.capacitance = capPieces[3];
                continue;
            }
            if (lineLC.charAt(0) != 'x' || current == null) continue;
            InstanceDef id = new InstanceDef();
            current.instances.add(id);
            String[] iPieces = line.split(" ");
            if (iPieces.length < 2) {
                System.out.println("Error on Instance line: " + line);
                continue;
            }
            id.name = iPieces[0].substring(1);
            id.instName = iPieces[iPieces.length - 1];
            for (i = 1; i < iPieces.length - 1; ++i) {
                id.signals.add(iPieces[i]);
            }
        }
    }

    private void placeCells(Library lib) {
        SubcktDef sd;
        PlacementFrame pla = Placement.getCurrentPlacementAlgorithm(this.localPrefs.placementOptions);
        System.out.println("Placing cells using the " + pla.getAlgorithmName() + " algorithm");
        for (String name : this.allCells.keySet()) {
            double yPos;
            Cell cell;
            sd = this.allCells.get(name);
            sd.iconCell = cell = Cell.makeInstance(lib, name + "{ic}");
            double lowY = yPos = 1.0;
            for (String export : sd.exports) {
                PrimitiveNode np = Schematics.tech().wirePinNode;
                EPoint center1 = new EPoint(0.0, yPos);
                EPoint center2 = new EPoint(2.0, yPos);
                NodeInst ni1 = NodeInst.makeInstance(np, center1, np.getDefWidth(), np.getDefHeight(), cell);
                PortInst pi1 = ni1.getOnlyPortInst();
                NodeInst ni2 = NodeInst.makeInstance(np, center2, np.getDefWidth(), np.getDefHeight(), cell);
                PortInst pi2 = ni2.getOnlyPortInst();
                ArcProto ap = Schematics.tech().wire_arc;
                ArcInst.makeInstance(ap, pi1, pi2);
                Export e = Export.newInstance(cell, pi1, export, PortCharacteristic.UNKNOWN);
                TextDescriptor newTD = e.getTextDescriptor(Export.EXPORT_NAME).withPos(AbstractTextDescriptor.Position.LEFT);
                e.setTextDescriptor(Export.EXPORT_NAME, newTD);
                yPos += 2.0;
            }
            if (yPos == lowY) {
                yPos += 2.0;
            }
            double width = 10.0;
            double height = yPos - lowY;
            EPoint center = new EPoint(7.0, (yPos - 2.0 + lowY) / 2.0);
            PrimitiveNode np = Artwork.tech().boxNode;
            NodeInst ni = NodeInst.makeInstance(np, center, width, height, cell);
            ni.setName(name.replaceAll("@", "_"));
            TextDescriptor newTD = ni.getTextDescriptor(NodeInst.NODE_NAME).withRelSize(2.0);
            ni.setTextDescriptor(NodeInst.NODE_NAME, newTD);
        }
        for (String name : this.allCells.keySet()) {
            PlacementAdapter.PlacementNode plNode;
            PlacementAdapter.PlacementNode plNode2;
            PortInst piGate;
            PortInst piSource;
            NodeInst niDummy;
            ArrayList<PlacementAdapter.PlacementPort> ports;
            Comparable<PrimitiveNode> np;
            sd = this.allCells.get(name);
            ArrayList<PlacementAdapter.PlacementNode> nodesToPlace = new ArrayList<PlacementAdapter.PlacementNode>();
            HashMap<String, PlacementFrame.PlacementNetwork> allNetworks = new HashMap<String, PlacementFrame.PlacementNetwork>();
            ArrayList<PlacementAdapter.PlacementExport> exportsToPlace = new ArrayList<PlacementAdapter.PlacementExport>();
            for (TransistorDef td : sd.transistors) {
                int bits = 0;
                bits = td.type.equals("p") ? Schematics.getPrimitiveFunctionBits(PrimitiveNode.Function.TRAPMOS) : Schematics.getPrimitiveFunctionBits(PrimitiveNode.Function.TRANMOS);
                np = Schematics.tech().transistorNode;
                NodeInst niDummy2 = NodeInst.makeDummyInstance((NodeProto)((Object)np));
                ports = new ArrayList<PlacementAdapter.PlacementPort>();
                PortInst piSource2 = niDummy2.getTransistorSourcePort();
                ports.add(this.addPlacementPort(niDummy2, piSource2, td.source, allNetworks, sd.exports, sd.usedExports, exportsToPlace));
                PortInst piGate2 = niDummy2.getTransistorGatePort();
                ports.add(this.addPlacementPort(niDummy2, piGate2, td.gate, allNetworks, sd.exports, sd.usedExports, exportsToPlace));
                PortInst piDrain = niDummy2.getTransistorDrainPort();
                ports.add(this.addPlacementPort(niDummy2, piDrain, td.drain, allNetworks, sd.exports, sd.usedExports, exportsToPlace));
                PlacementAdapter.PlacementNode plNode3 = new PlacementAdapter.PlacementNode((NodeProto)((Object)np), "m" + td.name, bits, ((PrimitiveNode)np).getDefWidth(), ((PrimitiveNode)np).getDefHeight(), (List<PlacementAdapter.PlacementPort>)ports, false);
                nodesToPlace.add(plNode3);
                for (PlacementAdapter.PlacementPort plPort : ports) {
                    plPort.setPlacementNode(plNode3);
                }
                plNode3.setOrientation(Orientation.IDENT);
                if (td.width != null) {
                    plNode3.addVariable(Schematics.ATTR_WIDTH.getName(), td.width);
                }
                if (td.length == null) continue;
                plNode3.addVariable(Schematics.ATTR_LENGTH.getName(), td.length);
            }
            for (ResistorDef rd : sd.resistors) {
                PrimitiveNode np2 = Schematics.tech().resistorNode;
                niDummy = NodeInst.makeDummyInstance(np2);
                ArrayList<PlacementAdapter.PlacementPort> ports2 = new ArrayList<PlacementAdapter.PlacementPort>();
                piSource = niDummy.getPortInst(0);
                ports2.add(this.addPlacementPort(niDummy, piSource, rd.left, allNetworks, sd.exports, sd.usedExports, exportsToPlace));
                piGate = niDummy.getPortInst(1);
                ports2.add(this.addPlacementPort(niDummy, piGate, rd.right, allNetworks, sd.exports, sd.usedExports, exportsToPlace));
                plNode2 = new PlacementAdapter.PlacementNode(np2, "r" + rd.name, 0, np2.getDefWidth(), np2.getDefHeight(), ports2, false);
                nodesToPlace.add(plNode2);
                for (PlacementAdapter.PlacementPort plPort : ports2) {
                    plPort.setPlacementNode(plNode2);
                }
                plNode2.setOrientation(Orientation.IDENT);
                if (rd.resistance == null) continue;
                plNode2.addVariable(Schematics.SCHEM_RESISTANCE.getName(), rd.resistance);
            }
            for (CapacitorDef cd : sd.capacitors) {
                PrimitiveNode np3 = Schematics.tech().capacitorNode;
                niDummy = NodeInst.makeDummyInstance(np3);
                ArrayList<PlacementAdapter.PlacementPort> ports3 = new ArrayList<PlacementAdapter.PlacementPort>();
                piSource = niDummy.getPortInst(0);
                ports3.add(this.addPlacementPort(niDummy, piSource, cd.top, allNetworks, sd.exports, sd.usedExports, exportsToPlace));
                piGate = niDummy.getPortInst(1);
                ports3.add(this.addPlacementPort(niDummy, piGate, cd.bottom, allNetworks, sd.exports, sd.usedExports, exportsToPlace));
                plNode2 = new PlacementAdapter.PlacementNode(np3, "c" + cd.name, 0, np3.getDefWidth(), np3.getDefHeight(), ports3, false);
                nodesToPlace.add(plNode2);
                for (PlacementAdapter.PlacementPort plPort : ports3) {
                    plPort.setPlacementNode(plNode2);
                }
                plNode2.setOrientation(Orientation.IDENT);
                if (cd.capacitance == null) continue;
                plNode2.addVariable(Schematics.SCHEM_CAPACITANCE.getName(), cd.capacitance);
            }
            for (InstanceDef id : sd.instances) {
                SubcktDef subSD = this.allCells.get(id.instName);
                if (subSD == null) {
                    System.out.println("Cannot find subcircuit " + id.instName);
                    continue;
                }
                np = subSD.iconCell;
                NodeInst niDummy3 = NodeInst.makeDummyInstance((NodeProto)((Object)np));
                if (subSD.exports.size() != id.signals.size()) {
                    System.out.println("Error: Subcircuit " + id.instName + " has " + subSD.exports.size() + " exports but instance " + id.name + " of it in cell " + name + "{sch}" + " has " + id.signals.size() + " signals on it");
                    continue;
                }
                ports = new ArrayList();
                for (int i = 0; i < subSD.exports.size(); ++i) {
                    PortProto pp = subSD.iconCell.findPortProto(subSD.exports.get(i));
                    if (pp == null) continue;
                    PortInst pi = niDummy3.findPortInstFromProto(pp);
                    String sigName = id.signals.get(i);
                    ports.add(this.addPlacementPort(niDummy3, pi, sigName, allNetworks, sd.exports, sd.usedExports, exportsToPlace));
                }
                plNode = new PlacementAdapter.PlacementNode((NodeProto)((Object)np), id.name.replace('@', '_'), 0, ((Cell)np).getDefWidth(), ((Cell)np).getDefHeight(), (List<PlacementAdapter.PlacementPort>)ports, false);
                nodesToPlace.add(plNode);
                for (PlacementAdapter.PlacementPort plPort : ports) {
                    plPort.setPlacementNode(plNode);
                }
                plNode.setOrientation(Orientation.IDENT);
            }
            for (String export : sd.exports) {
                if (sd.usedExports.contains(export)) continue;
                PrimitiveNode np4 = Schematics.tech().wirePinNode;
                niDummy = NodeInst.makeDummyInstance(np4);
                ArrayList<PlacementAdapter.PlacementPort> ports4 = new ArrayList<PlacementAdapter.PlacementPort>();
                PortInst pi = niDummy.getPortInst(0);
                ports4.add(this.addPlacementPort(niDummy, pi, export, allNetworks, sd.exports, sd.usedExports, exportsToPlace));
                plNode = new PlacementAdapter.PlacementNode(np4, null, 0, np4.getDefWidth(), np4.getDefHeight(), ports4, false);
                nodesToPlace.add(plNode);
                for (PlacementAdapter.PlacementPort plPort : ports4) {
                    plPort.setPlacementNode(plNode);
                }
                plNode.setOrientation(Orientation.IDENT);
            }
            ArrayList<PlacementFrame.PlacementNetwork> nets = new ArrayList<PlacementFrame.PlacementNetwork>();
            for (String netName : allNetworks.keySet()) {
                PlacementFrame.PlacementNetwork net = (PlacementFrame.PlacementNetwork)allNetworks.get(netName);
                for (PlacementFrame.PlacementPort port : net.getPortsOnNet()) {
                    port.setPlacementNetwork(net);
                }
                if (net.getPortsOnNet() == null || net.getPortsOnNet().size() <= 1) continue;
                nets.add(net);
            }
            PlacementAdapter.doPlacement(pla, lib, name + "{sch}", nodesToPlace, nets, exportsToPlace, sd.iconCell, this.localPrefs.placementOptions);
        }
    }

    private PlacementAdapter.PlacementPort addPlacementPort(NodeInst ni, PortInst pi, String name, Map<String, PlacementFrame.PlacementNetwork> allNetworks, List<String> exports, Set<String> usedExports, List<PlacementAdapter.PlacementExport> exportsToPlace) {
        PlacementFrame.PlacementNetwork net = allNetworks.get(name);
        if (net == null) {
            net = new PlacementFrame.PlacementNetwork(new ArrayList<PlacementFrame.PlacementPort>());
            allNetworks.put(name, net);
        }
        List<PlacementFrame.PlacementPort> portsOnNet = net.getPortsOnNet();
        Poly poly = pi.getPoly();
        double offX = poly.getCenterX() - ni.getTrueCenterX();
        double offY = poly.getCenterY() - ni.getTrueCenterY();
        PlacementAdapter.PlacementPort plPort = new PlacementAdapter.PlacementPort(offX, offY, pi.getPortProto());
        portsOnNet.add(plPort);
        if (exports.contains(name) && !usedExports.contains(name)) {
            usedExports.add(name);
            PlacementAdapter.PlacementExport plExport = new PlacementAdapter.PlacementExport(plPort, name, PortCharacteristic.UNKNOWN);
            exportsToPlace.add(plExport);
        }
        return plPort;
    }

    private String getNextLine() throws IOException {
        String line = this.lastLine;
        if (line == null) {
            line = this.getLine();
        }
        if (line != null) {
            this.lastLine = this.getLine();
            while (this.lastLine != null && this.lastLine.startsWith("+")) {
                line = line + this.lastLine.substring(1);
                this.lastLine = this.getLine();
            }
        }
        return line;
    }

    private static class CapacitorDef {
        String name;
        String top;
        String bottom;
        String capacitance;

        private CapacitorDef() {
        }
    }

    private static class ResistorDef {
        String name;
        String left;
        String right;
        String resistance;

        private ResistorDef() {
        }
    }

    private static class TransistorDef {
        String name;
        String source;
        String gate;
        String drain;
        String bias;
        String type;
        String width;
        String length;

        private TransistorDef() {
        }
    }

    private static class InstanceDef {
        String name;
        String instName;
        List<String> signals = new ArrayList<String>();
    }

    private static class SubcktDef {
        List<String> exports = new ArrayList<String>();
        List<TransistorDef> transistors = new ArrayList<TransistorDef>();
        List<ResistorDef> resistors = new ArrayList<ResistorDef>();
        List<CapacitorDef> capacitors = new ArrayList<CapacitorDef>();
        List<InstanceDef> instances = new ArrayList<InstanceDef>();
        Set<String> usedExports = new HashSet<String>();
        Cell iconCell;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SpicePreferences
    extends Input.InputPreferences {
        public Placement.PlacementPreferences placementOptions;

        public SpicePreferences(boolean factory) {
            super(factory);
            this.placementOptions = new Placement.PlacementPreferences(factory);
        }

        @Override
        public Library doInput(URL fileURL, Library lib, Technology tech, Map<Library, Cell> currentCells, Map<CellId, BitSet> nodesToExpand, Job job) {
            Spice in = new Spice(this);
            in.readDirectory(fileURL, lib);
            return lib;
        }
    }
}

