/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool;

import com.sun.electric.Main;
import com.sun.electric.StartupPrefs;
import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.Environment;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.change.Undo;
import com.sun.electric.database.constraint.Constraints;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.tool.EJob;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.ServerJobManager;
import com.sun.electric.tool.user.ActivityLogger;
import java.util.ArrayList;
import java.util.logging.Level;

class EThread
extends Thread {
    private static final String CLASS_NAME = EThread.class.getName();
    private static final ArrayList<Snapshot> snapshotCache = new ArrayList();
    private static int maximumSnapshots = StartupPrefs.getMaxUndoHistory();
    EJob ejob;
    boolean isServerThread;
    EDatabase database;
    ServerJobManager.UserInterfaceRedirect userInterface;

    EThread(int id) {
        super("EThread-" + id);
        Job.logger.logp(Level.FINER, CLASS_NAME, "constructor", this.getName());
        this.start();
    }

    EThread(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Job.logger.logp(Level.FINE, CLASS_NAME, "run", this.getName());
        while (true) {
            this.ejob = Job.serverJobManager.selectEJob();
            Job.logger.logp(Level.FINER, CLASS_NAME, "run", "selectedJob {0}", this.ejob.jobName);
            this.isServerThread = this.ejob.jobType != Job.Type.CLIENT_EXAMINE;
            this.database = this.isServerThread ? EDatabase.serverDatabase() : EDatabase.clientDatabase();
            this.ejob.changedFields = new ArrayList();
            Environment.setThreadEnvironment(this.database.getEnvironment());
            EditingPreferences.setThreadEditingPreferences(this.ejob.editingPreferences);
            this.userInterface = new ServerJobManager.UserInterfaceRedirect(this.ejob.jobKey);
            this.database.lock(!this.ejob.isExamine());
            this.ejob.oldSnapshot = this.database.backup();
            try {
                Throwable e;
                if (this.ejob.jobType != Job.Type.CLIENT_EXAMINE && !this.ejob.jobKey.startedByServer() && (e = this.ejob.deserializeToServer()) != null) {
                    throw e;
                }
                switch (this.ejob.jobType) {
                    case CHANGE: {
                        this.database.lowLevelBeginChanging(this.ejob.serverJob.tool);
                        Constraints.getCurrent().startBatch(this.ejob.oldSnapshot);
                        this.userInterface.setCurrents(this.ejob.serverJob);
                        if (!this.ejob.serverJob.doIt()) {
                            throw new JobException("Job '" + this.ejob.jobName + "' failed");
                        }
                        Constraints.getCurrent().endBatch(this.ejob.client.userName);
                        this.database.lowLevelEndChanging();
                        this.ejob.newSnapshot = this.database.backup();
                        break;
                    }
                    case UNDO: {
                        this.database.lowLevelSetCanUndoing(true);
                        int snapshotId = ((Undo.UndoJob)this.ejob.serverJob).getSnapshotId();
                        Snapshot undoSnapshot = EThread.findInCache(snapshotId);
                        if (undoSnapshot == null) {
                            throw new JobException("Snapshot " + snapshotId + " not found");
                        }
                        this.database.undo(undoSnapshot);
                        this.database.lowLevelSetCanUndoing(false);
                        break;
                    }
                    case SERVER_EXAMINE: {
                        this.userInterface.setCurrents(this.ejob.serverJob);
                        if (this.ejob.serverJob.doIt()) break;
                        throw new JobException("Job '" + this.ejob.jobName + "' failed");
                    }
                    case CLIENT_EXAMINE: {
                        Throwable e2;
                        if (this.ejob.jobKey.startedByServer() && (e2 = this.ejob.deserializeToClient()) != null) {
                            throw e2;
                        }
                        this.userInterface.setCurrents(this.ejob.clientJob);
                        if (this.ejob.clientJob.doIt()) break;
                        throw new JobException("Job '" + this.ejob.jobName + "' failed");
                    }
                }
                this.ejob.serializeResult(this.database);
                this.ejob.newSnapshot = this.database.backup();
            }
            catch (Throwable e) {
                if (Main.isBatch()) {
                    e.printStackTrace();
                    System.exit(-1);
                }
                e.getStackTrace();
                if (!(e instanceof JobException)) {
                    e.printStackTrace();
                }
                if (!this.ejob.isExamine()) {
                    this.recoverDatabase(e instanceof JobException);
                    this.database.lowLevelEndChanging();
                    this.database.lowLevelSetCanUndoing(false);
                }
                this.ejob.serializeExceptionResult(e, this.database);
            }
            finally {
                this.database.unlock();
                this.userInterface = null;
                Environment.setThreadEnvironment(null);
                EditingPreferences.setThreadEditingPreferences(null);
            }
            EThread.putInCache(this.ejob.oldSnapshot, this.ejob.newSnapshot);
            String finishedEJobName = this.ejob.jobName;
            Job.serverJobManager.finishEJob(this.ejob);
            this.ejob = null;
            this.isServerThread = false;
            this.database = null;
            Job.logger.logp(Level.FINER, CLASS_NAME, "run", "finishedJob {0}", finishedEJobName);
        }
    }

    private void recoverDatabase(boolean quick) {
        this.database.lowLevelSetCanUndoing(true);
        try {
            if (quick) {
                this.database.undo(this.ejob.oldSnapshot);
            } else {
                this.database.recover(this.ejob.oldSnapshot);
            }
            this.ejob.newSnapshot = this.ejob.oldSnapshot;
            return;
        }
        catch (Throwable e) {
            ActivityLogger.logException(e);
            while (true) {
                try {
                    Snapshot snapshot = EThread.findValidSnapshot();
                    this.database.recover(snapshot);
                    this.ejob.newSnapshot = snapshot;
                    return;
                }
                catch (Throwable e2) {
                    ActivityLogger.logException(e2);
                    continue;
                }
                break;
            }
        }
    }

    UserInterface getUserInterface() {
        return this.userInterface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Snapshot findValidSnapshot() {
        while (true) {
            Snapshot snapshot;
            ArrayList<Snapshot> arrayList = snapshotCache;
            synchronized (arrayList) {
                if (snapshotCache.isEmpty()) {
                    return EDatabase.serverDatabase().getInitialSnapshot();
                }
                snapshot = snapshotCache.remove(snapshotCache.size() - 1);
            }
            try {
                snapshot.check();
                return snapshot;
            }
            catch (Throwable e) {
                ActivityLogger.logException(e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Snapshot findInCache(int snapshotId) {
        ArrayList<Snapshot> arrayList = snapshotCache;
        synchronized (arrayList) {
            for (int i = snapshotCache.size() - 1; i >= 0; --i) {
                Snapshot snapshot = snapshotCache.get(i);
                if (snapshot.snapshotId != snapshotId) continue;
                return snapshot;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putInCache(Snapshot oldSnapshot, Snapshot newSnapshot) {
        ArrayList<Snapshot> arrayList = snapshotCache;
        synchronized (arrayList) {
            if (!snapshotCache.contains(newSnapshot)) {
                while (!snapshotCache.isEmpty() && snapshotCache.get(snapshotCache.size() - 1) != oldSnapshot) {
                    snapshotCache.remove(snapshotCache.size() - 1);
                }
                snapshotCache.add(newSnapshot);
            }
            while (snapshotCache.size() > maximumSnapshots) {
                snapshotCache.remove(0);
            }
        }
    }

    public static int setHistoryListSize(int newSize) {
        if (newSize <= 0) {
            return maximumSnapshots;
        }
        int oldSize = maximumSnapshots;
        maximumSnapshots = newSize;
        while (snapshotCache.size() > maximumSnapshots) {
            snapshotCache.remove(0);
        }
        return oldSize;
    }

    Job getRunningJob() {
        if (this.ejob == null) {
            return null;
        }
        return this.ejob.jobType == Job.Type.CLIENT_EXAMINE ? this.ejob.clientJob : this.ejob.serverJob;
    }

    EJob getRunningEJob() {
        return this.ejob;
    }
}

