/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.geometry.btree;

import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RadixTrie<V> {
    private final Node root = new Node('\u0000', null);
    private final int[] scores = new int[65535];

    public char guessHierarchySeparator() {
        int best = 0;
        char ret = '\u0000';
        for (int i = 0; i < this.scores.length; ++i) {
            if (this.scores[i] <= best) continue;
            best = this.scores[i];
            ret = (char)i;
        }
        return ret;
    }

    public V get(String key) {
        return this.root.get(key);
    }

    public void put(String key, V value2) {
        System.out.println("put \"" + key + "\"");
        if (value2 == null) {
            throw new RuntimeException("deletions not yet implemented");
        }
        this.root.put(key, value2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Node {
        private char firstChar;
        private V entry;
        private TreeMap<String, Node> children = null;

        public Node(char firstChar, V value2) {
            this.firstChar = firstChar;
            this.entry = value2;
        }

        private String getPrev(String key) {
            if (this.children == null) {
                return null;
            }
            SortedMap<String, Node> prevMap = this.children.headMap(key);
            return prevMap.size() == 0 ? null : prevMap.lastKey();
        }

        public void put(String key, V value2) {
            if (key.length() != 0 && this.children == null) {
                this.children = new TreeMap();
            }
            String prev = this.getPrev(key);
            if (key.length() == 0) {
                this.entry = value2;
            } else if (this.children.containsKey(key)) {
                this.children.get(key).put("", value2);
            } else if (prev != null && key.startsWith(prev)) {
                this.children.get(prev).put(key.substring(prev.length()), value2);
            } else if (prev == null || prev.charAt(0) != key.charAt(0)) {
                if (this.children == null) {
                    this.children = new TreeMap();
                }
                this.children.put(key, new Node(key.charAt(0), value2));
                int[] nArray = RadixTrie.this.scores;
                int n = this.firstChar & 0xFFFF;
                nArray[n] = nArray[n] + 1;
            } else {
                int i = 0;
                for (i = 0; i < Math.min(key.length(), prev.length()) && key.charAt(i) == prev.charAt(i); ++i) {
                }
                Node oldnode = this.children.get(prev);
                this.children.remove(prev);
                int[] nArray = RadixTrie.this.scores;
                int n = this.firstChar & 0xFFFF;
                nArray[n] = nArray[n] - 1;
                Node newnode = new Node(key.charAt(i - 1), null);
                this.children.put(key.substring(0, i), newnode);
                int[] nArray2 = RadixTrie.this.scores;
                int n2 = this.firstChar & 0xFFFF;
                nArray2[n2] = nArray2[n2] + 1;
                if (newnode.children == null) {
                    newnode.children = new TreeMap();
                }
                newnode.children.put(key.substring(i), new Node(key.charAt(key.length() - 1), value2));
                int[] nArray3 = RadixTrie.this.scores;
                int n3 = newnode.firstChar & 0xFFFF;
                nArray3[n3] = nArray3[n3] + 1;
                newnode.children.put(prev.substring(i), oldnode);
                int[] nArray4 = RadixTrie.this.scores;
                int n4 = newnode.firstChar & 0xFFFF;
                nArray4[n4] = nArray4[n4] + 1;
            }
        }

        private int size() {
            return this.children == null ? 0 : this.children.size();
        }

        public V get(String key) {
            String prev;
            if (key.length() == 0) {
                return this.entry;
            }
            if (this.children == null) {
                return null;
            }
            if (this.children.containsKey(key)) {
                return this.children.get(key).get("");
            }
            SortedMap<String, Node> prevMap = this.children.headMap(key);
            String string2 = prev = prevMap.size() == 0 ? null : prevMap.lastKey();
            if (prev != null && key.startsWith(prev)) {
                return this.children.get(prev).get(key.substring(prev.length()));
            }
            return null;
        }
    }
}

