/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.genetic2;

import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.tool.placement.genetic2.Evolver;
import com.sun.electric.tool.placement.genetic2.Individual;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnifiedPopulation<I extends Individual> {
    private I[] indis;
    private Evolver[] evolvers;
    private Random rand;
    private long evolutionStepTime;
    double p;

    UnifiedPopulation(List<PlacementFrame.PlacementNode> nodesToPlace, List<PlacementFrame.PlacementNetwork> allNetworks, I[] indis, long evoStepTime, int numThreads, Random rand) {
        this.evolutionStepTime = evoStepTime;
        this.rand = rand;
        this.indis = indis;
        this.evolvers = new Evolver[numThreads];
        Random[] rands = new Random[numThreads];
        int n = 0;
        for (int i = 0; i < numThreads; ++i) {
            rands[i] = new Random(n += rand.nextInt());
            this.evolvers[i] = new Evolver((Individual[])indis, this.evolutionStepTime, rands[i]);
        }
    }

    public int getSize() {
        return this.indis.length;
    }

    public void setProgress(double p) {
        this.p = p;
        ((Individual)this.indis[0]).ref.setProgress(p);
        for (int i = 0; i < this.indis.length; ++i) {
            ((Individual)this.indis[i]).setProgress(p);
        }
    }

    public long getEvolverSteps() {
        long steps = 0L;
        for (Evolver e : this.evolvers) {
            steps += e.getSteps();
        }
        return steps;
    }

    public void insert(Individual immigrant) {
        this.indis[this.indis.length - 1].copyFrom((Individual)immigrant);
    }

    public void reboot() {
        for (I i : this.indis) {
            ((Individual)i).reboot(this.rand);
        }
    }

    public void evolveLocalMT(int numThreads) {
        int i;
        Thread[] threads = new Thread[numThreads];
        for (i = 0; i < numThreads; ++i) {
            threads[i] = new Thread(this.evolvers[i]);
            threads[i].start();
        }
        for (i = 0; i < numThreads; ++i) {
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException e) {
                System.exit(-3333);
            }
        }
    }

    public void reEvaluateAll() {
        for (I i : this.indis) {
            ((Individual)i).evaluate();
        }
    }

    public Individual getChampion() {
        int pos = 0;
        int c = 0;
        double badness = ((Individual)this.indis[0]).getBadness();
        for (I i : this.indis) {
            if (((Individual)i).getBadness() < badness) {
                pos = c;
                badness = ((Individual)i).getBadness();
            }
            ++c;
        }
        return this.indis[pos];
    }

    public Individual getRandomOne() {
        return this.indis[this.rand.nextInt(this.indis.length)];
    }

    public Individual getAt(int pos) {
        return this.indis[pos];
    }
}

