/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.text;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.EvalJavaBsh;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Client;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.User;
import java.awt.Color;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextUtils {
    private static NumberFormat numberFormatPostFix = null;
    private static NumberFormat numberFormatSpecific = null;
    private static SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE MMM dd, yyyy HH:mm:ss");
    private static SimpleDateFormat simpleDateFormatGMT = new SimpleDateFormat("EEE MMMM dd, yyyy HH:mm:ss zzz");
    private static ConversionRange[] allRanges;
    private static final double LOOKS_LIKE_ZERO;
    private static final double SMALLEST_JUST_PRINT;
    private static final double LARGEST_JUST_PRINT;
    public static final Comparator<String> STRING_NUMBER_ORDER;
    public static final Comparator<Connection> CONNECTIONS_ORDER;

    public static boolean isDigit(char ch) {
        return '0' <= ch && ch <= '9';
    }

    public static boolean isLetterOrDigit(char ch) {
        return TextUtils.isDigit(ch) || Character.isLetter(ch);
    }

    public static String eatWhiteSpaces(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return str.substring(i);
        }
        return "";
    }

    public static char canonicChar(char ch) {
        if (ch <= 'Z') {
            if (ch >= 'A') {
                ch = (char)(ch + 32);
            }
        } else if (ch >= '\u0080') {
            ch = Character.toLowerCase(Character.toUpperCase(ch));
        }
        return ch;
    }

    public static String canonicString(String s) {
        char ch;
        int i;
        for (i = 0; i < s.length() && TextUtils.canonicChar(ch = s.charAt(i)) == ch; ++i) {
        }
        if (i == s.length()) {
            return s;
        }
        char[] chars = s.toCharArray();
        while (i < s.length()) {
            chars[i] = TextUtils.canonicChar(chars[i]);
            ++i;
        }
        return new String(chars);
    }

    public static boolean startsWithIgnoreCase(String main, String with) {
        int mainLen = main.length();
        int withLen = with.length();
        if (withLen > mainLen) {
            return false;
        }
        for (int i = 0; i < withLen; ++i) {
            char withChr;
            char mainChr = TextUtils.canonicChar(main.charAt(i));
            if (mainChr == (withChr = TextUtils.canonicChar(with.charAt(i)))) continue;
            return false;
        }
        return true;
    }

    public static double atof(String text) {
        return TextUtils.atof(text, null, null, null);
    }

    public static double atof(String text, Double defaultVal) {
        return TextUtils.atof(text, defaultVal, null, null);
    }

    public static double atofDistance(String text, Technology tech) {
        if (tech != null && tech.isLayout()) {
            return TextUtils.atof(text, null, AbstractTextDescriptor.Unit.DISTANCE, tech);
        }
        return TextUtils.atof(text);
    }

    public static double atofDistance(String text) {
        return TextUtils.atof(text, null, AbstractTextDescriptor.Unit.DISTANCE, Technology.getCurrent());
    }

    public static double atof(String text, Double defaultVal, AbstractTextDescriptor.Unit unitType, Technology tech) {
        String pf;
        if (unitType != null && text.endsWith(pf = unitType.getPostfixChar())) {
            text = text.substring(0, text.length() - pf.length());
        }
        text = text.replaceAll(",", "");
        double v = 0.0;
        try {
            UnitScale us = null;
            if (unitType == AbstractTextDescriptor.Unit.DISTANCE) {
                us = User.getDistanceUnits();
            }
            Number n = TextUtils.parsePostFixNumber(text, us);
            v = n.doubleValue();
        }
        catch (NumberFormatException ex) {
            int start;
            for (start = 0; start < text.length() && text.charAt(start) == ' '; ++start) {
            }
            int end = start;
            if (end < text.length() && (text.charAt(end) == '-' || text.charAt(end) == '+')) {
                ++end;
            }
            while (end < text.length() && TextUtils.isDigit(text.charAt(end))) {
                ++end;
            }
            if (end < text.length() && text.charAt(end) == '.') {
                ++end;
                while (end < text.length() && TextUtils.isDigit(text.charAt(end))) {
                    ++end;
                }
            }
            if (end < text.length() && (text.charAt(end) == 'e' || text.charAt(end) == 'E')) {
                if (++end < text.length() && (text.charAt(end) == '-' || text.charAt(end) == '+')) {
                    ++end;
                }
                while (end < text.length() && TextUtils.isDigit(text.charAt(end))) {
                    ++end;
                }
            }
            if (end <= start) {
                if (defaultVal != null) {
                    return defaultVal;
                }
                return 0.0;
            }
            try {
                v = Double.parseDouble(text.substring(start, end - start));
            }
            catch (NumberFormatException e) {
                v = 0.0;
            }
        }
        if (unitType == AbstractTextDescriptor.Unit.DISTANCE && User.getDistanceUnits() != null) {
            v = v / Technology.getCurrent().getScale() / UnitScale.NANO.getMultiplier().doubleValue();
        }
        return v;
    }

    public static int atoi(String s) {
        return TextUtils.atoi(s, 0, 0);
    }

    public static int atoi(String s, int pos) {
        return TextUtils.atoi(s, pos, 0);
    }

    public static int atoi(String s, int pos, int base) {
        char cat;
        int digit;
        int num = 0;
        int sign = 1;
        int len = s.length();
        if (pos < len && s.charAt(pos) == '-') {
            ++pos;
            sign = -1;
        }
        if (base == 0) {
            base = 10;
            if (pos < len && s.charAt(pos) == '0') {
                base = 8;
                if (++pos < len && (s.charAt(pos) == 'x' || s.charAt(pos) == 'X')) {
                    ++pos;
                    base = 16;
                } else if (pos < len && (s.charAt(pos) == 'b' || s.charAt(pos) == 'B')) {
                    ++pos;
                    base = 2;
                }
            }
        }
        while (pos < len && (digit = Character.digit(cat = s.charAt(pos), base)) >= 0) {
            num = num * base + digit;
            ++pos;
        }
        return num * sign;
    }

    public static double getValueOfExpression(String expression) {
        if (TextUtils.isANumber(expression)) {
            double res = TextUtils.atof(expression);
            return res;
        }
        Object o = EvalJavaBsh.evalJavaBsh.doEvalLine(expression);
        if (o == null) {
            return 0.0;
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof Integer) {
            return ((Integer)o).intValue();
        }
        return 0.0;
    }

    public static Color[] getTransparentColors(String str) {
        String[] colorNames = str.split("/");
        Color[] colors = new Color[colorNames.length];
        for (int i = 0; i < colorNames.length; ++i) {
            String colorName = colorNames[i].trim();
            String[] rgb = colorName.split(",");
            if (rgb.length != 3) {
                return null;
            }
            int r = TextUtils.atoi(rgb[0]);
            int g = TextUtils.atoi(rgb[1]);
            int b = TextUtils.atoi(rgb[2]);
            colors[i] = new Color(r, g, b);
        }
        return colors;
    }

    public static String formatDoublePostFix(double v) {
        int unitScaleIndex;
        if (numberFormatPostFix == null) {
            numberFormatPostFix = NumberFormat.getInstance(Locale.US);
            try {
                DecimalFormat d = (DecimalFormat)numberFormatPostFix;
                d.setDecimalSeparatorAlwaysShown(false);
                d.setGroupingSize(300);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        numberFormatPostFix.setMaximumFractionDigits(3);
        if (v != 0.0) {
            for (unitScaleIndex = 0; Math.abs(v) >= 1000000.0 && unitScaleIndex > -3; --unitScaleIndex) {
                v /= 1000.0;
            }
            while (Math.abs(v) < 0.1 && unitScaleIndex < 5) {
                v *= 1000.0;
                ++unitScaleIndex;
            }
            if (Math.abs(v) < 0.1) {
                int maxDecimals = 3;
                for (double v2 = Math.abs(v); v2 < 0.1; v2 *= 10.0) {
                    ++maxDecimals;
                }
                numberFormatPostFix.setMaximumFractionDigits(maxDecimals);
            }
        }
        UnitScale u = UnitScale.findFromIndex(unitScaleIndex);
        String result = numberFormatPostFix.format(v);
        return result + u.getPostFix();
    }

    public static String formatDouble(double v) {
        return TextUtils.formatDouble(v, 3);
    }

    public static String formatDistance(double v, Technology tech) {
        if (tech != null && tech.isLayout()) {
            return TextUtils.displayedUnits(v, AbstractTextDescriptor.Unit.DISTANCE, User.getDistanceUnits(), tech);
        }
        return TextUtils.formatDouble(v);
    }

    public static String formatDistance(double v) {
        return TextUtils.displayedUnits(v, AbstractTextDescriptor.Unit.DISTANCE, User.getDistanceUnits(), Technology.getCurrent());
    }

    public static synchronized String formatDouble(double v, int numFractions) {
        if (numberFormatSpecific == null) {
            numberFormatSpecific = NumberFormat.getInstance(Locale.US);
            if (numberFormatSpecific != null) {
                numberFormatSpecific.setGroupingUsed(false);
            }
            try {
                DecimalFormat d = (DecimalFormat)numberFormatSpecific;
                d.setDecimalSeparatorAlwaysShown(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (numFractions == 0) {
            numberFormatSpecific.setMaximumFractionDigits(340);
        } else {
            numberFormatSpecific.setMaximumFractionDigits(numFractions);
        }
        return numberFormatSpecific.format(v);
    }

    public static String formatDate(Date date) {
        return simpleDateFormat.format(date);
    }

    public static String formatDateGMT(Date date) {
        return simpleDateFormatGMT.format(date);
    }

    public static String convertToEngineeringNotation(double value) {
        return TextUtils.convertToEngineeringNotation(value, "", 9999);
    }

    public static String convertToEngineeringNotation(double value, String unit) {
        return TextUtils.convertToEngineeringNotation(value, unit, 9999);
    }

    public static String convertToEngineeringNotation(double time, String unit, int precpower) {
        String unitPostfix;
        String negative = "";
        if (time < 0.0) {
            negative = "-";
            time = -time;
        }
        if ((unitPostfix = unit) == null) {
            unitPostfix = "";
        }
        if (time < LOOKS_LIKE_ZERO) {
            return "0" + unitPostfix;
        }
        if (time < SMALLEST_JUST_PRINT || time >= LARGEST_JUST_PRINT) {
            return negative + TextUtils.formatDouble(time) + unitPostfix;
        }
        String secType = "";
        int rangePos = -1;
        long intTime = 0L;
        double scaled = 0.0;
        for (int i = 0; i < allRanges.length; ++i) {
            scaled = time * TextUtils.allRanges[i].scale;
            intTime = Math.round(scaled);
            if (i != allRanges.length - 1 && (!(scaled < 2000000.0) || intTime >= 100000L)) continue;
            if (unit == null) {
                if (TextUtils.allRanges[i].power != 0) {
                    secType = "e" + TextUtils.allRanges[i].power;
                }
            } else {
                secType = TextUtils.allRanges[i].postfix + unitPostfix;
            }
            rangePos = i;
            break;
        }
        if (precpower >= TextUtils.allRanges[rangePos].power) {
            long timeleft = intTime / 1000L;
            long timeright = intTime % 1000L;
            if (timeright == 0L) {
                return negative + timeleft + secType;
            }
            if (timeright % 100L == 0L) {
                return negative + timeleft + "." + timeright / 100L + secType;
            }
            if (timeright % 10L == 0L) {
                String tensDigit = "";
                if (timeright < 100L) {
                    tensDigit = "0";
                }
                return negative + timeleft + "." + tensDigit + timeright / 10L + secType;
            }
            String tensDigit = "";
            if (timeright < 10L) {
                tensDigit = "00";
            } else if (timeright < 100L) {
                tensDigit = "0";
            }
            return negative + timeleft + "." + tensDigit + timeright + secType;
        }
        int digits = TextUtils.allRanges[rangePos].power - precpower;
        if (rangePos > 0) {
            --rangePos;
            if (unit == null) {
                if (TextUtils.allRanges[rangePos].power != 0) {
                    secType = "e" + TextUtils.allRanges[rangePos].power;
                }
            } else {
                secType = TextUtils.allRanges[rangePos].postfix + unitPostfix;
            }
            digits += 3;
        } else {
            scaled /= 1000.0;
        }
        String numPart = TextUtils.formatDouble(scaled, digits);
        if (numPart.indexOf(46) >= 0) {
            while (numPart.endsWith("0")) {
                numPart = numPart.substring(0, numPart.length() - 1);
            }
            if (numPart.endsWith(".")) {
                numPart = numPart.substring(0, numPart.length() - 1);
            }
        }
        return negative + numPart + secType;
    }

    public static String toBlankPaddedString(int value, int width) {
        String msg = Integer.toString(value);
        while (msg.length() < width) {
            msg = " " + msg;
        }
        return msg;
    }

    public static boolean isANumber(String pp) {
        if (pp == null) {
            return false;
        }
        int i = 0;
        int len = pp.length();
        if (i < len && (pp.charAt(i) == '+' || pp.charAt(i) == '-')) {
            ++i;
        }
        boolean xflag = false;
        if (i < len - 1 && pp.charAt(i) == '0' && (pp.charAt(i + 1) == 'x' || pp.charAt(i + 1) == 'X')) {
            i += 2;
            xflag = true;
        }
        boolean founddigits = false;
        if (xflag) {
            while (i < len && (TextUtils.isDigit(pp.charAt(i)) || pp.charAt(i) == 'a' || pp.charAt(i) == 'A' || pp.charAt(i) == 'b' || pp.charAt(i) == 'B' || pp.charAt(i) == 'c' || pp.charAt(i) == 'C' || pp.charAt(i) == 'd' || pp.charAt(i) == 'D' || pp.charAt(i) == 'e' || pp.charAt(i) == 'E' || pp.charAt(i) == 'f' || pp.charAt(i) == 'F')) {
                ++i;
                founddigits = true;
            }
        } else {
            while (i < len && (TextUtils.isDigit(pp.charAt(i)) || pp.charAt(i) == '.')) {
                if (pp.charAt(i) != '.') {
                    founddigits = true;
                }
                ++i;
            }
        }
        if (!founddigits) {
            return false;
        }
        if (i == len) {
            return true;
        }
        if (xflag) {
            return false;
        }
        if (pp.charAt(i) != 'e' && pp.charAt(i) != 'E') {
            return false;
        }
        if (++i == len) {
            return false;
        }
        if (pp.charAt(i) == '+' || pp.charAt(i) == '-') {
            ++i;
        }
        if (i == len) {
            return false;
        }
        while (i < len && TextUtils.isDigit(pp.charAt(i))) {
            ++i;
        }
        return i == len;
    }

    public static boolean isANumberPostFix(String pp) {
        char c;
        int i = 0;
        int len = pp.length();
        if (i < len && (pp.charAt(i) == '+' || pp.charAt(i) == '-')) {
            ++i;
        }
        boolean founddigits = false;
        while (i < len && (TextUtils.isDigit(pp.charAt(i)) || pp.charAt(i) == '.')) {
            if (pp.charAt(i) != '.') {
                founddigits = true;
            }
            ++i;
        }
        if (!founddigits) {
            return false;
        }
        if (i == len) {
            return true;
        }
        return i + 1 == len ? (c = Character.toLowerCase(pp.charAt(i))) == 'g' || c == 'k' || c == 'm' || c == 'u' || c == 'n' || c == 'p' || c == 'f' : pp.substring(i).toLowerCase().equals("meg");
    }

    public static String getElapsedTime(long milliseconds) {
        int minutes;
        int hours;
        int days;
        if (milliseconds < 60000L) {
            return (double)milliseconds / 1000.0 + " secs";
        }
        StringBuffer buf = new StringBuffer();
        int seconds = (int)milliseconds / 1000;
        if (seconds < 0) {
            seconds = 0;
        }
        if ((days = seconds / 86400) > 0) {
            buf.append(days + " days, ");
        }
        if ((hours = (seconds -= days * 86400) / 3600) > 0) {
            buf.append(hours + " hrs, ");
        }
        if ((minutes = (seconds -= hours * 3600) / 60) > 0) {
            buf.append(minutes + " mins, ");
        }
        buf.append((seconds -= minutes * 60) + " secs");
        return buf.toString();
    }

    public static int findStringInString(String string, String search, int startingPos, boolean caseSensitive, boolean reverse) {
        if (caseSensitive) {
            int i = 0;
            i = reverse ? string.lastIndexOf(search, startingPos) : string.indexOf(search, startingPos);
            return i;
        }
        if (startingPos > 0) {
            string = string.substring(startingPos);
        }
        String stringLC = TextUtils.canonicString(string);
        String searchLC = TextUtils.canonicString(search);
        int i = 0;
        i = reverse ? stringLC.lastIndexOf(searchLC) : stringLC.indexOf(searchLC);
        if (i >= 0) {
            i += startingPos;
        }
        return i;
    }

    public static String[] parseString(String line, String delim) {
        StringTokenizer st = new StringTokenizer(line, delim);
        int total = st.countTokens();
        String[] strings = new String[total];
        for (int i = 0; i < total; ++i) {
            strings[i] = st.nextToken().trim();
        }
        return strings;
    }

    public static double convertDistance(double value, Technology tech, UnitScale unitScale) {
        double scale = tech.getScale();
        double distanceScale = 1.0E-9 / unitScale.getMultiplier().doubleValue() * scale;
        return value * distanceScale;
    }

    public static double convertFromDistance(double value, Technology tech, UnitScale unitScale) {
        double scale = tech.getScale();
        double distanceScale = 1.0E-9 / unitScale.getMultiplier().doubleValue() * scale;
        return value / distanceScale;
    }

    private static String displayedUnits(double value, AbstractTextDescriptor.Unit unitType, UnitScale unitScale, Technology tech) {
        if (unitType == AbstractTextDescriptor.Unit.DISTANCE && unitScale != null) {
            value *= UnitScale.NANO.getMultiplier().doubleValue() * tech.getScale();
        }
        String postFix = "";
        if (unitScale != null) {
            value /= unitScale.getMultiplier().doubleValue();
            postFix = unitScale.getPostFix() + unitType.getPostfixChar();
        }
        return TextUtils.formatDouble(value) + postFix;
    }

    public static String makeUnits(double value, AbstractTextDescriptor.Unit units) {
        if (units == AbstractTextDescriptor.Unit.NONE) {
            return TextUtils.formatDouble(value);
        }
        if (units == AbstractTextDescriptor.Unit.DISTANCE) {
            return TextUtils.displayedUnits(value, units, User.getDistanceUnits(), Technology.getCurrent());
        }
        return TextUtils.formatDoublePostFix(value);
    }

    public static Number parsePostFixNumber(String s, UnitScale us) throws NumberFormatException {
        s = s.replaceAll(",", "");
        Number n = null;
        Number m = null;
        if (us != null) {
            m = us.getMultiplier();
        }
        for (int i = 0; i < UnitScale.allUnits.length; ++i) {
            String sSuffix;
            UnitScale u = UnitScale.allUnits[i];
            String postfix = u.getPostFix();
            if (postfix.equals("") || postfix.length() >= s.length() || !(sSuffix = s.substring(s.length() - postfix.length(), s.length())).equalsIgnoreCase(postfix)) continue;
            m = u.getMultiplier();
            String sub = s.substring(0, s.length() - postfix.length());
            try {
                n = TextUtils.parseNumber(sub);
                break;
            }
            catch (NumberFormatException e) {
                m = null;
            }
        }
        if (n == null) {
            n = TextUtils.parseNumber(s);
        }
        if (m != null) {
            if (m instanceof Integer && m.intValue() == 1) {
                return n;
            }
            if (n instanceof Integer && m instanceof Integer) {
                return new Integer(n.intValue() * m.intValue());
            }
            if (n instanceof Long && m instanceof Integer) {
                return new Long(n.longValue() * m.longValue());
            }
            return new Double(n.doubleValue() * m.doubleValue());
        }
        return n;
    }

    private static Number parseNumber(String s) throws NumberFormatException {
        Number n = null;
        try {
            n = new Integer(s);
        }
        catch (NumberFormatException e) {
            try {
                n = new Double(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (n == null) {
            e = new NumberFormatException(s + "cannot be parsed into a Number");
            throw e;
        }
        return n;
    }

    public static void printLongString(String str) {
        String prefix = "";
        while (str.length() > 80) {
            int i;
            for (i = 80; i > 0 && str.charAt(i) != ' ' && str.charAt(i) != ','; --i) {
            }
            if (i <= 0) {
                i = 80;
            }
            if (str.charAt(i) == ',') {
                ++i;
            }
            System.out.println(prefix + str.substring(0, i));
            if (str.charAt(i) == ' ') {
                ++i;
            }
            str = str.substring(i);
            prefix = "   ";
        }
        System.out.println(prefix + str);
    }

    public static void setTextOnClipboard(String text) {
        Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection transferable = new StringSelection(text);
        cb.setContents(transferable, null);
    }

    public static String getTextOnClipboard() {
        String result;
        block4: {
            result = null;
            try {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                Transferable contents = clipboard.getContents(null);
                if (contents != null && contents.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    result = (String)contents.getTransferData(DataFlavor.stringFlavor);
                }
            }
            catch (UnsupportedFlavorException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                if (Client.isOSMac() && ex.getMessage().toLowerCase().contains("system clipboard data unavailable")) break block4;
                ex.printStackTrace();
            }
        }
        return result;
    }

    public static URL makeURLToFile(String fileName) {
        if (fileName.startsWith("file://")) {
            fileName = fileName.substring(6);
        }
        if (fileName.startsWith("file:/")) {
            fileName = fileName.substring(5);
        }
        try {
            fileName = URLDecoder.decode(fileName, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        File file = new File(fileName);
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            System.out.println("Cannot find file " + fileName);
            return null;
        }
    }

    public static File getFile(URL url) {
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException e) {
            System.out.println("URL -> File conversion error: " + e.getMessage());
            return new File(url.getPath());
        }
        catch (IllegalArgumentException e) {
            if (Job.getDebug()) {
                System.out.println("URL -> File conversion error: " + e.getMessage());
            }
            return null;
        }
    }

    public static String URLtoString(URL url) {
        if (url == null) {
            System.out.println("Null URL in TextUtils.URLtoString");
            return "";
        }
        String filePath = url.getFile();
        try {
            URI uri = new URI(filePath);
            filePath = uri.getPath();
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
        try {
            filePath = URLDecoder.decode(filePath, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return filePath;
    }

    public static String getFilePath(URL url) {
        int slashPos;
        int colonPos;
        int backSlashPos;
        int charPos;
        if (url == null) {
            return "";
        }
        String filePath = TextUtils.URLtoString(url);
        File file = new File(filePath);
        if (file.getName().toLowerCase().endsWith(".delib")) {
            filePath = file.getPath();
        }
        if ((charPos = Math.max(backSlashPos = filePath.lastIndexOf(92), Math.max(colonPos = filePath.lastIndexOf(58), slashPos = filePath.lastIndexOf(47)))) < 0) {
            return "";
        }
        return filePath.substring(0, charPos + 1);
    }

    public static String getFileNameWithoutExtension(URL url) {
        return TextUtils.getFileNameWithoutExtension(TextUtils.URLtoString(url), true);
    }

    public static String getFileNameWithoutExtension(String fileName, boolean removePath) {
        int dotPos;
        if (removePath) {
            int slashPos;
            int colonPos;
            while (fileName.endsWith("\\") || fileName.endsWith(":") || fileName.endsWith("/")) {
                fileName = fileName.substring(0, fileName.length() - 1);
            }
            int backSlashPos = fileName.lastIndexOf(92);
            int charPos = Math.max(backSlashPos, Math.max(colonPos = fileName.lastIndexOf(58), slashPos = fileName.lastIndexOf(47)));
            if (charPos >= 0) {
                fileName = fileName.substring(charPos + 1);
            }
        }
        if ((dotPos = fileName.lastIndexOf(46)) >= 0) {
            fileName = fileName.substring(0, dotPos);
        }
        StringBuffer buf = null;
        for (int i = 0; i < fileName.length(); ++i) {
            char ch = fileName.charAt(i);
            if (ch == '\n' || ch == '|' || ch == ':' || ch == ' ' || ch == '{' || ch == '}' || ch == ';') {
                if (buf == null) {
                    buf = new StringBuffer();
                    buf.append(fileName.substring(0, i));
                }
                buf.append('-');
                continue;
            }
            if (buf == null) continue;
            buf.append(ch);
        }
        if (buf != null) {
            String newS = buf.toString();
            System.out.println("File name " + fileName + " was converted to " + newS);
            return newS;
        }
        return fileName;
    }

    public static String getExtension(URL url) {
        if (url == null) {
            return "";
        }
        String fileName = TextUtils.URLtoString(url);
        return TextUtils.getExtension(fileName);
    }

    public static String getExtension(String fileName) {
        int dotPos = fileName.lastIndexOf(46);
        if (dotPos < 0) {
            return "";
        }
        return fileName.substring(dotPos + 1);
    }

    public static InputStream getURLStream(URL url) {
        return TextUtils.getURLStream(url, null);
    }

    public static InputStream getURLStream(URL url, StringBuffer errorMsg) {
        if (url != null) {
            try {
                return url.openStream();
            }
            catch (IOException e) {
                if (errorMsg != null) {
                    errorMsg.append("Error: cannot open " + e.getMessage() + "\n");
                }
                System.out.println("Error: cannot open " + e.getMessage());
            }
        }
        return null;
    }

    public static boolean URLExists(URL url) {
        return TextUtils.URLExists(url, null);
    }

    public static boolean URLExists(URL url, StringBuffer errorMsg) {
        if (url == null) {
            return false;
        }
        try {
            URLConnection con = url.openConnection();
            con.connect();
            int conLength = con.getContentLength();
            con.getInputStream().close();
            if (conLength < 0) {
                return false;
            }
        }
        catch (Exception e) {
            if (errorMsg != null) {
                errorMsg.append("Error: cannot open " + e.getMessage() + "\n");
            }
            return false;
        }
        return true;
    }

    public static List<String> getAllResources(String resourceName) {
        String[] cpElements;
        ArrayList<String> retval = new ArrayList<String>();
        String cp = System.getProperty("java.class.path", ".");
        for (String cpElement : cpElements = cp.split(File.pathSeparator)) {
            String classPath = cpElement + File.separator + resourceName.replace('.', File.separatorChar);
            File file = new File(classPath);
            if (file.isDirectory()) {
                retval.addAll(TextUtils.getResourcesFromDirectory(file));
                continue;
            }
            File jarFile = new File(cpElement);
            retval.addAll(TextUtils.getResourcesFromJarFile(jarFile, resourceName.replace('.', '/')));
        }
        return retval;
    }

    private static List<String> getResourcesFromJarFile(File file, String resName) {
        ArrayList<String> retval = new ArrayList<String>();
        try {
            ZipFile zf = new ZipFile(file);
            Enumeration<? extends ZipEntry> e = zf.entries();
            while (e.hasMoreElements()) {
                ZipEntry ze = e.nextElement();
                String entry = ze.getName();
                if (!entry.startsWith(resName)) continue;
                retval.add(entry.substring(resName.length() + 1));
            }
            zf.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return retval;
    }

    private static List<String> getResourcesFromDirectory(File directory) {
        File[] fileList;
        ArrayList<String> retval = new ArrayList<String>();
        for (File file : fileList = directory.listFiles()) {
            if (file.isDirectory()) {
                retval.addAll(TextUtils.getResourcesFromDirectory(file));
                continue;
            }
            String fileName = file.getName();
            retval.add(fileName);
        }
        return retval;
    }

    private static int digit(char ch) {
        if (ch < '\u0080') {
            return ch >= '0' && ch <= '9' ? ch - 48 : -1;
        }
        return Character.digit((int)ch, 10);
    }

    public static String correctName(String n, boolean onlyBrackets, boolean correctBrackets) {
        int index;
        if (correctBrackets && (index = n.indexOf("]")) != -1 && index < n.length() - 1) {
            n = n.replace('[', '-');
            n = n.replace("]", "-");
        }
        if (onlyBrackets) {
            return n;
        }
        index = n.indexOf("/");
        if (index != -1) {
            n = n.replaceAll("/", "_");
        }
        return n;
    }

    static {
        simpleDateFormatGMT.setTimeZone(TimeZone.getTimeZone("GMT"));
        allRanges = new ConversionRange[]{new ConversionRange("z", -21, 1.0E24), new ConversionRange("a", -18, 1.0E21), new ConversionRange("f", -15, 1.0E18), new ConversionRange("p", -12, 1.0E15), new ConversionRange("n", -9, 1.0E12), new ConversionRange("u", -6, 1.0E9), new ConversionRange("m", -3, 1000000.0), new ConversionRange("", 0, 1000.0), new ConversionRange("k", 3, 1.0), new ConversionRange("M", 6, 0.001), new ConversionRange("G", 9, 1.0E-6), new ConversionRange("T", 12, 1.0E-9), new ConversionRange("P", 15, 1.0E-12), new ConversionRange("E", 18, 1.0E-15), new ConversionRange("Z", 21, 1.0E-18)};
        LOOKS_LIKE_ZERO = 1.0 / (TextUtils.allRanges[0].scale * 10000.0);
        SMALLEST_JUST_PRINT = 1.0 / (TextUtils.allRanges[0].scale * 1.0);
        LARGEST_JUST_PRINT = 1.0 / TextUtils.allRanges[TextUtils.allRanges.length - 1].scale * 10000.0;
        STRING_NUMBER_ORDER = new Comparator<String>(){

            @Override
            public int compare(String name1, String name2) {
                int len1 = name1.length();
                int len2 = name2.length();
                int extent = Math.min(len1, len2);
                for (int pos = 0; pos < extent; ++pos) {
                    char ch2;
                    char ch1 = name1.charAt(pos);
                    if (ch1 == (ch2 = name2.charAt(pos))) continue;
                    int digit1 = TextUtils.digit(ch1);
                    int digit2 = TextUtils.digit(ch2);
                    if (digit1 >= 0 || digit2 >= 0) {
                        int digit;
                        int pos1 = pos + 1;
                        int pos2 = pos + 1;
                        int n = digit = pos > 0 ? TextUtils.digit(name1.charAt(--pos)) : -1;
                        if (digit < 0 && (digit1 < 0 || digit2 < 0)) {
                            return digit2 - digit1;
                        }
                        while (digit == 0) {
                            digit = pos > 0 ? TextUtils.digit(name1.charAt(--pos)) : -1;
                        }
                        if (digit < 0) {
                            while (digit1 == 0) {
                                digit1 = pos1 < len1 ? TextUtils.digit(name1.charAt(pos1++)) : -1;
                            }
                            while (digit2 == 0) {
                                digit2 = pos2 < len2 ? TextUtils.digit(name2.charAt(pos2++)) : -1;
                            }
                        }
                        while (digit1 == digit2 && digit1 >= 0) {
                            digit1 = pos1 < len1 ? TextUtils.digit(name1.charAt(pos1++)) : -1;
                            digit2 = pos2 < len2 ? TextUtils.digit(name2.charAt(pos2++)) : -1;
                        }
                        boolean dig1 = digit1 >= 0;
                        boolean dig2 = digit2 >= 0;
                        int i = 0;
                        while (dig1 && dig2) {
                            dig1 = pos1 + i < len1 && TextUtils.digit(name1.charAt(pos1 + i)) >= 0;
                            dig2 = pos2 + i < len2 && TextUtils.digit(name2.charAt(pos2 + i)) >= 0;
                            ++i;
                        }
                        if (dig1 != dig2) {
                            return dig1 ? 1 : -1;
                        }
                        if (digit1 != digit2) {
                            return digit1 - digit2;
                        }
                    }
                    return ch1 - ch2;
                }
                return len1 - len2;
            }
        };
        CONNECTIONS_ORDER = new Comparator<Connection>(){

            @Override
            public int compare(Connection c1, Connection c2) {
                int i2;
                int i1 = c1.getPortInst().getPortProto().getPortIndex();
                int cmp = i1 - (i2 = c2.getPortInst().getPortProto().getPortIndex());
                if (cmp != 0) {
                    return cmp;
                }
                cmp = c1.getArc().getArcId() - c2.getArc().getArcId();
                if (cmp != 0) {
                    return cmp;
                }
                return c1.getEndIndex() - c2.getEndIndex();
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WhatToSearch {
        ARC_NAME("Arc Name"),
        ARC_VAR("Arc Variable"),
        NODE_NAME("Node Name"),
        NODE_VAR("Node Variable"),
        EXPORT_NAME("Export Name"),
        EXPORT_VAR("Export Variable"),
        CELL_VAR("Cell Name"),
        TEMP_NAMES(null);

        private String descriptionOfObjectFound;

        private WhatToSearch(String descriptionOfObjectFound) {
            this.descriptionOfObjectFound = descriptionOfObjectFound;
        }

        public String toString() {
            return this.descriptionOfObjectFound;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NetworksByName
    implements Comparator<Network> {
        @Override
        public int compare(Network n1, Network n2) {
            String s1 = n1.describe(false);
            String s2 = n2.describe(false);
            return s1.compareToIgnoreCase(s2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PrefsByName
    implements Comparator<Pref> {
        @Override
        public int compare(Pref p1, Pref p2) {
            String s1 = p1.getPrefName();
            String s2 = p2.getPrefName();
            return s1.compareToIgnoreCase(s2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CellsByDate
    implements Comparator<Cell> {
        @Override
        public int compare(Cell c1, Cell c2) {
            Date r1 = c1.getRevisionDate();
            Date r2 = c2.getRevisionDate();
            return r1.compareTo(r2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CellsByName
    implements Comparator<Cell> {
        @Override
        public int compare(Cell c1, Cell c2) {
            String r1 = c1.getName();
            String r2 = c2.getName();
            return r1.compareTo(r2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CellsByVersion
    implements Comparator<Cell> {
        @Override
        public int compare(Cell c1, Cell c2) {
            return c2.getVersion() - c1.getVersion();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CellsByView
    implements Comparator<Cell> {
        @Override
        public int compare(Cell c1, Cell c2) {
            View v1 = c1.getView();
            View v2 = c2.getView();
            return v1.getOrder() - v2.getOrder();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ObjectsByToString
    implements Comparator<Object> {
        @Override
        public int compare(Object o1, Object o2) {
            String s1 = o1.toString();
            String s2 = o2.toString();
            return s1.compareToIgnoreCase(s2);
        }
    }

    public static class UnitScale {
        private final String name;
        private final int index;
        private final String postFix;
        private final Number multiplier;
        private static final int UNIT_BASE = -3;
        private static final int UNIT_END = 5;
        public static final UnitScale GIGA = new UnitScale("Giga", "giga:  x 1000000000", -3, "G", new Integer(1000000000));
        public static final UnitScale MEGA = new UnitScale("Mega", "mega:  x 1000000", -2, "meg", new Integer(1000000));
        public static final UnitScale KILO = new UnitScale("Kilo", "kilo:  x 1000", -1, "k", new Integer(1000));
        public static final UnitScale NONE = new UnitScale("", "-:     x 1", 0, "", new Integer(1));
        public static final UnitScale MILLI = new UnitScale("Milli", "milli: x 10 ^ -3", 1, "m", new Double(0.001));
        public static final UnitScale MICRO = new UnitScale("Micro", "micro: x 10 ^ -6", 2, "u", new Double(1.0E-6));
        public static final UnitScale NANO = new UnitScale("Nano", "nano:  x 10 ^ -9", 3, "n", new Double(1.0E-9));
        public static final UnitScale PICO = new UnitScale("Pico", "pico:  x 10 ^ -12", 4, "p", new Double(1.0E-12));
        public static final UnitScale FEMTO = new UnitScale("Femto", "femto: x 10 ^ -15", 5, "f", new Double(1.0E-15));
        public static final UnitScale ATTO = new UnitScale("Atto", "atto:  x 10 ^ -18", 6, "a", new Double(1.0E-18));
        public static final UnitScale ZEPTO = new UnitScale("Zepto", "zepto: x 10 ^ -21", 7, "z", new Double(1.0E-21));
        public static final UnitScale YOCTO = new UnitScale("Yocto", "yocto: x 10 ^ -24", 8, "y", new Double(1.0E-24));
        private static final UnitScale[] allUnits = new UnitScale[]{GIGA, MEGA, KILO, NONE, MILLI, MICRO, NANO, PICO, FEMTO, ATTO, ZEPTO, YOCTO};

        private UnitScale(String name, String description, int index, String postFix, Number multiplier) {
            this.name = name;
            this.index = index;
            this.postFix = postFix;
            this.multiplier = multiplier;
        }

        public String getName() {
            return this.name;
        }

        public int getIndex() {
            return this.index;
        }

        public String getPostFix() {
            return this.postFix;
        }

        public Number getMultiplier() {
            return this.multiplier;
        }

        public static UnitScale findFromIndex(int index) {
            int i = index - -3;
            if (i < 0 || i >= allUnits.length) {
                return NONE;
            }
            return allUnits[i];
        }

        public static UnitScale[] getUnitScales() {
            return allUnits;
        }

        public String toString() {
            return this.name;
        }
    }

    private static class ConversionRange {
        String postfix;
        int power;
        double scale;

        ConversionRange(String p, int pow, double s) {
            this.postfix = p;
            this.power = pow;
            this.scale = s;
        }
    }
}

