/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.ncc.Aborter;
import com.sun.electric.tool.ncc.ListNccAnnotations;
import com.sun.electric.tool.ncc.NccBottomUp;
import com.sun.electric.tool.ncc.NccOptions;
import com.sun.electric.tool.ncc.PassedNcc;
import com.sun.electric.tool.ncc.basic.CellContext;
import com.sun.electric.tool.ncc.basic.NccUtils;
import com.sun.electric.tool.ncc.result.NccResults;
import java.util.Date;

public class Ncc {
    private static void prln(String s) {
        System.out.println(s);
    }

    private static void pr(String s) {
        System.out.print(s);
    }

    private Ncc() {
    }

    private NccResults compare1(CellContext cc1, CellContext cc2, PassedNcc passed, NccOptions options, Aborter aborter) {
        if (options.operation == 3) {
            ListNccAnnotations.doYourJob(cc1.cell, cc2.cell);
            return new NccResults();
        }
        Date before = new Date();
        switch (options.operation) {
            case 2: {
                Ncc.pr("Flat NCC top cells: ");
                break;
            }
            case 1: {
                Ncc.pr("Flat NCC every cell in the design: ");
                break;
            }
            case 0: {
                Ncc.pr("Hierarchical NCC every cell in the design: ");
                break;
            }
            default: {
                LayoutLib.error(true, "bad operation: " + options.operation);
            }
        }
        Ncc.prln(cc1.cell + "  " + cc2.cell);
        NccResults results = NccBottomUp.compare(cc1, cc2, passed, options, aborter);
        if (aborter.userWantsToAbort()) {
            return results;
        }
        Ncc.prln("Summary for all cells: " + results.summary(options.checkSizes));
        Date after = new Date();
        Ncc.prln("NCC command completed in: " + NccUtils.hourMinSec(before, after) + ".");
        return results;
    }

    public static NccResults compare(Cell cell1, VarContext ctxt1, Cell cell2, VarContext ctxt2, NccOptions options) {
        return Ncc.compare(cell1, ctxt1, cell2, ctxt2, new PassedNcc(), options, null);
    }

    public static NccResults compare(Cell cell1, VarContext ctxt1, Cell cell2, VarContext ctxt2, PassedNcc passed, NccOptions options, Job job) {
        if (ctxt1 == null) {
            ctxt1 = VarContext.globalContext;
        }
        if (ctxt2 == null) {
            ctxt2 = VarContext.globalContext;
        }
        Ncc ncc = new Ncc();
        NccResults results = ncc.compare1(new CellContext(cell1, ctxt1), new CellContext(cell2, ctxt2), passed, options, new Aborter(job));
        return results;
    }
}

