/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.ImmutableExport;
import com.sun.electric.database.ImmutableNetSchem;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.ExportId;
import com.sun.electric.database.network.Global;
import com.sun.electric.database.text.ImmutableArrayList;
import com.sun.electric.database.text.Name;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class EquivalentSchematicExports {
    public final CellId cellId;
    public final EquivalentSchematicExports implementation;
    public final int[] portImplementation;
    public final Global.Set globals;
    public final int numExports;
    public final int[] portOffsets;
    public final int numExpandedExports;
    final ImmutableArrayList<ImmutableExport> exports;
    private final HashMap<ExportId, Global.Set[]> globalPartitions;
    final int[] equivPortsN;
    final int[] equivPortsP;
    final int[] equivPortsA;

    EquivalentSchematicExports(ImmutableNetSchem netSchem) {
        this.cellId = netSchem.cellTree.top.cellRevision.d.cellId;
        this.implementation = this.cellId == netSchem.implementationCellId ? this : netSchem.snapshot.equivSchemExports[netSchem.implementationCellId.cellIndex];
        this.portImplementation = netSchem.portImplementation;
        this.exports = netSchem.cellTree.top.cellRevision.exports;
        this.numExports = this.exports.size();
        this.numExpandedExports = netSchem.equivPortsN.length;
        this.portOffsets = netSchem.portOffsets;
        this.globals = netSchem.globals;
        this.globalPartitions = netSchem.globalPartitions;
        this.equivPortsN = netSchem.equivPortsN;
        this.equivPortsP = netSchem.equivPortsP;
        this.equivPortsA = netSchem.equivPortsA;
    }

    public static EquivalentSchematicExports computeEquivExports(Snapshot snapshot, CellId top) {
        ImmutableNetSchem netSchem = new ImmutableNetSchem(snapshot, top);
        return new EquivalentSchematicExports(netSchem);
    }

    public CellId getCellId() {
        return this.cellId;
    }

    public Global.Set getGlobals() {
        return this.globals;
    }

    public int getNumExports() {
        return this.numExports;
    }

    public Name getExportName(int exportIndex) {
        return ((ImmutableExport)this.exports.get((int)exportIndex)).name;
    }

    public int getNumExpandedExports() {
        return this.numExports;
    }

    public int[] getEquivPortsN() {
        return (int[])this.equivPortsN.clone();
    }

    public int[] getEquivPortsP() {
        return (int[])this.equivPortsP.clone();
    }

    public int[] getEquivPortsA() {
        return (int[])this.equivPortsA.clone();
    }

    public int hashCode() {
        return Arrays.hashCode(this.equivPortsN);
    }

    public boolean equals(Object o) {
        if (!(o instanceof EquivalentSchematicExports)) {
            return false;
        }
        EquivalentSchematicExports that = (EquivalentSchematicExports)o;
        if (this.cellId != that.cellId || this.implementation.cellId != that.implementation.cellId) {
            return false;
        }
        if (this.cellId != this.implementation.cellId && !this.implementation.equals(that.implementation)) {
            return false;
        }
        if (!Arrays.equals(this.portImplementation, that.portImplementation)) {
            return false;
        }
        if (this.globals != that.globals) {
            return false;
        }
        if (this.exports != that.exports) {
            if (this.exports.size() != that.exports.size()) {
                return false;
            }
            for (int exportIndex = 0; exportIndex < this.exports.size(); ++exportIndex) {
                ImmutableExport e1 = (ImmutableExport)this.exports.get(exportIndex);
                ImmutableExport e2 = (ImmutableExport)that.exports.get(exportIndex);
                if (e1.exportId == e2.exportId && e1.name == e2.name) continue;
                return false;
            }
        }
        assert (this.numExpandedExports == that.numExpandedExports);
        assert (Arrays.equals(this.portOffsets, that.portOffsets));
        if (this.globalPartitions == null || that.globalPartitions == null) {
            if (this.globalPartitions != null || that.globalPartitions != null) {
                return false;
            }
        } else {
            if (this.globalPartitions.size() != that.globalPartitions.size()) {
                return false;
            }
            for (Map.Entry<ExportId, Global.Set[]> e : this.globalPartitions.entrySet()) {
                Object[] thatG;
                ExportId eId = e.getKey();
                Object[] thisG = e.getValue();
                if (Arrays.equals(thisG, thatG = that.globalPartitions.get(eId))) continue;
                return false;
            }
        }
        return Arrays.equals(this.equivPortsN, that.equivPortsN) && Arrays.equals(this.equivPortsP, that.equivPortsP) && Arrays.equals(this.equivPortsA, that.equivPortsA);
    }
}

