/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.database.text.TextUtils;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.WindowContent;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LayerTab
extends JPanel
implements DragSourceListener,
DragGestureListener {
    private JList layerList;
    private DefaultListModel layerListModel;
    private HashMap<Layer, Boolean> highlighted;
    private List<Layer> layersInList;
    private DragSource dragSource;
    private boolean loading;
    private boolean layerDrawing;
    private static HashMap<Layer, Boolean> visibility;
    private JCheckBox annotationText;
    private JCheckBox arcText;
    private JCheckBox cellText;
    private JCheckBox exportText;
    private JCheckBox instanceNames;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane layerPane;
    private JButton makeInvisible;
    private JButton makeVisible;
    private JCheckBox nodeText;
    private JSlider opacitySlider;
    private JCheckBox portText;
    private JButton resetOpacity;
    private JButton selectAll;
    private JComboBox technology;
    private JButton toggleHighlight;
    private JButton unhighlightAll;

    public LayerTab(WindowFrame wf) {
        this.initComponents();
        this.layerListModel = new DefaultListModel();
        this.layerList = new JList(this.layerListModel);
        this.layerList.setSelectionMode(2);
        this.layerPane.setViewportView(this.layerList);
        this.layerList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                LayerTab.this.apply(e);
            }
        });
        this.dragSource = new DragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this.layerList, 1, this);
        new DropTarget(this.layerList, 0x40000000, new LayerTabTreeDropTarget(), true);
        this.nodeText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerTab.this.update();
            }
        });
        this.arcText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerTab.this.update();
            }
        });
        this.portText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerTab.this.update();
            }
        });
        this.exportText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerTab.this.update();
            }
        });
        this.annotationText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerTab.this.update();
            }
        });
        this.instanceNames.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerTab.this.update();
            }
        });
        this.cellText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerTab.this.update();
            }
        });
        this.opacitySlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                LayerTab.this.sliderChanged();
            }
        });
        this.technology.setLightWeightPopupEnabled(false);
        this.loadTechnologies(true);
        this.updateLayersTab();
        this.technology.addActionListener(new WindowFrame.CurTechControlListener(wf));
    }

    public void finished() {
        this.layersInList.clear();
        this.layersInList = null;
        this.highlighted.clear();
        this.highlighted = null;
    }

    public void loadTechnologies(boolean makeCurrent) {
        Technology cur = Technology.getCurrent();
        if (!makeCurrent || cur == null) {
            cur = Technology.findTechnology((String)this.technology.getSelectedItem());
        }
        this.loading = true;
        this.technology.removeAllItems();
        visibility = new HashMap();
        Iterator<Technology> it = Technology.getTechnologies();
        while (it.hasNext()) {
            Technology tech = it.next();
            if (tech == Generic.tech() && !Job.getDebug()) continue;
            this.technology.addItem(tech.getTechName());
            Iterator<Layer> lIt = tech.getLayers();
            while (lIt.hasNext()) {
                Layer layer = lIt.next();
                if (layer.isPseudoLayer()) continue;
                visibility.put(layer, new Boolean(layer.isVisible()));
            }
        }
        visibility.put(Generic.tech().drcLay, new Boolean(Generic.tech().drcLay.isVisible()));
        visibility.put(Generic.tech().afgLay, new Boolean(Generic.tech().afgLay.isVisible()));
        this.setSelectedTechnology(cur);
        this.loading = false;
    }

    public void setSelectedTechnology(Technology tech) {
        if (tech == null) {
            System.out.println("Selecting a null technology");
        } else {
            this.technology.setSelectedItem(tech.getTechName());
        }
    }

    public void setDisplayAlgorithm(boolean layerDrawing) {
        boolean changed = this.layerDrawing != layerDrawing;
        this.layerDrawing = layerDrawing;
        if (changed) {
            this.updateLayersTab();
        }
    }

    public void updateLayersTab() {
        Layer layer;
        Iterator<Layer> lIt;
        Technology tech;
        if (this.loading) {
            return;
        }
        this.nodeText.setSelected(User.isTextVisibilityOnNode());
        this.arcText.setSelected(User.isTextVisibilityOnArc());
        this.portText.setSelected(User.isTextVisibilityOnPort());
        this.exportText.setSelected(User.isTextVisibilityOnExport());
        this.annotationText.setSelected(User.isTextVisibilityOnAnnotation());
        this.instanceNames.setSelected(User.isTextVisibilityOnInstance());
        this.cellText.setSelected(User.isTextVisibilityOnCell());
        boolean noDimming = true;
        Iterator<Technology> it = Technology.getTechnologies();
        while (it.hasNext()) {
            tech = it.next();
            lIt = tech.getLayers();
            while (lIt.hasNext()) {
                layer = lIt.next();
                if (!layer.isDimmed()) continue;
                noDimming = false;
            }
        }
        this.highlighted = new HashMap();
        it = Technology.getTechnologies();
        while (it.hasNext()) {
            tech = it.next();
            lIt = tech.getLayers();
            while (lIt.hasNext()) {
                layer = lIt.next();
                if (layer.isPseudoLayer()) continue;
                if (noDimming) {
                    this.highlighted.put(layer, false);
                    continue;
                }
                this.highlighted.put(layer, !layer.isDimmed());
            }
        }
        Technology tech2 = Technology.getCurrent();
        this.setSelectedTechnology(tech2);
        this.layerListModel.clear();
        this.layersInList = new ArrayList<Layer>();
        if (tech2 != null) {
            List<Layer> savedOrder = tech2.getSavedLayerOrder();
            List<Layer> allLayers = tech2.getLayersSortedByHeight();
            if (tech2.isLayout()) {
                allLayers.add(Generic.tech().drcLay);
                allLayers.add(Generic.tech().afgLay);
            }
            if (savedOrder == null) {
                savedOrder = allLayers;
            }
            for (Layer layer2 : savedOrder) {
                if (layer2.getTechnology() != Generic.tech() && layer2.isPseudoLayer()) continue;
                this.layersInList.add(layer2);
                this.layerListModel.addElement(this.lineName(layer2));
            }
            for (Layer layer2 : allLayers) {
                if (savedOrder.contains(layer2) || layer2.getTechnology() != Generic.tech() && layer2.isPseudoLayer()) continue;
                this.layersInList.add(layer2);
                this.layerListModel.addElement(this.lineName(layer2));
            }
            this.layerList.setSelectedIndex(0);
        }
        this.opacitySlider.setVisible(this.layerDrawing);
        this.resetOpacity.setVisible(this.layerDrawing);
    }

    private String lineName(Layer layer) {
        StringBuffer layerName = new StringBuffer();
        Boolean layerVisible = visibility.get(layer);
        if (layerVisible != null && layerVisible.booleanValue()) {
            layerName.append("\u2713 ");
        } else {
            layerName.append("  ");
        }
        if (layer.isPseudoLayer()) {
            layerName.append(" (for pins)");
        }
        Boolean layerHighlighted = this.highlighted.get(layer);
        layerName.append(layer.getName());
        if (layerHighlighted.booleanValue()) {
            layerName.append(" (HIGHLIGHTED)");
        }
        if (this.layerDrawing) {
            layerName.append(" (" + TextUtils.formatDouble(layer.getGraphics().getOpacity(), 2) + ")");
        }
        return layerName.toString();
    }

    private void apply(MouseEvent e) {
        Layer layer;
        int[] indices = this.layerList.getSelectedIndices();
        if (indices.length == 1 && this.layerDrawing && (layer = this.getSelectedLayer(indices[0])) != null) {
            double opacity = layer.getGraphics().getOpacity();
            double range = this.opacitySlider.getMaximum() - this.opacitySlider.getMinimum();
            int newValue = this.opacitySlider.getMinimum() + (int)(range * opacity);
            this.opacitySlider.setValue(newValue);
        }
        if (e.getClickCount() == 2) {
            for (int i = 0; i < indices.length; ++i) {
                int line;
                this.setVisibility(line, !this.isLineChecked(line = indices[i]), true);
            }
        }
    }

    private void sliderChanged() {
        int[] indices = this.layerList.getSelectedIndices();
        if (indices.length != 1) {
            return;
        }
        Layer layer = this.getSelectedLayer(indices[0]);
        if (layer == null) {
            return;
        }
        int sliderValue = this.opacitySlider.getValue() - this.opacitySlider.getMinimum();
        double range = this.opacitySlider.getMaximum() - this.opacitySlider.getMinimum();
        double newOpacity = (double)sliderValue / range;
        layer.getGraphics().setOpacity(newOpacity);
        this.layerListModel.set(indices[0], this.lineName(layer));
        this.opacityChanged();
    }

    private void opacityChanged() {
        Iterator<WindowFrame> it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = it.next();
            WindowContent content = wf.getContent();
            if (!(content instanceof EditWindow)) continue;
            EditWindow wnd = (EditWindow)content;
            wnd.opacityChanged();
            LayerTab layerTab = wf.getLayersTab();
            if (layerTab != this) continue;
            wnd.repaint();
        }
    }

    private void clearAllHighlight() {
        for (int i = 0; i < this.layerListModel.size(); ++i) {
            this.changeHighlighted(i, 0);
        }
    }

    private void toggleHighlight() {
        int[] indices = this.layerList.getSelectedIndices();
        for (int i = 0; i < indices.length; ++i) {
            int line = indices[i];
            this.changeHighlighted(line, 1);
        }
    }

    private void selectAll() {
        int len = this.layerListModel.size();
        int[] indices = new int[len];
        for (int i = 0; i < len; ++i) {
            indices[i] = i;
        }
        this.layerList.setSelectedIndices(indices);
    }

    private void setVisibility(boolean on) {
        int[] indices = this.layerList.getSelectedIndices();
        for (int i = 0; i < indices.length; ++i) {
            int line = indices[i];
            this.setVisibility(line, on, false);
        }
        this.update();
    }

    private boolean isLineChecked(int i) {
        String s = (String)this.layerListModel.get(i);
        return s.charAt(0) != ' ';
    }

    private Layer getSelectedLayer(int i) {
        Layer layer;
        String name = (String)this.layerListModel.get(i);
        if (name != null) {
            name = name.substring(2);
        }
        String techName = (String)this.technology.getSelectedItem();
        Technology tech = Technology.findTechnology(techName);
        int spacePos = name.indexOf(32);
        if (spacePos >= 0) {
            name = name.substring(0, spacePos);
        }
        if ((layer = tech.findLayer(name)) == null && (layer = Generic.tech().findLayer(name)) == null) {
            System.out.println("Can't find " + name);
        }
        return layer;
    }

    private void setVisibility(int i, boolean on, boolean doUpdate) {
        Layer layer = this.getSelectedLayer(i);
        if (layer == null) {
            return;
        }
        visibility.put(layer, new Boolean(on));
        this.layerListModel.set(i, this.lineName(layer));
        if (doUpdate) {
            this.update();
        }
    }

    public void setVisibilityLevel(int level) {
        int len = this.layerListModel.size();
        for (int i = 0; i < len; ++i) {
            Layer layer = this.getSelectedLayer(i);
            Boolean b = new Boolean(false);
            if (level == 2 && layer.getFunction() == Layer.Function.GATE) {
                b = new Boolean(true);
            }
            if (level == 1 && layer.getFunction().getLevel() <= 1) {
                b = new Boolean(true);
            }
            if (layer.getFunction().getLevel() == level || layer.getFunction().getLevel() == level - 1 || level == 0) {
                b = new Boolean(true);
            }
            visibility.put(layer, b);
            this.layerListModel.set(i, this.lineName(layer));
        }
        this.update();
    }

    private void changeHighlighted(int i, int how) {
        Layer layer;
        String name = (String)this.layerListModel.get(i);
        if (name != null) {
            name = name.substring(2);
        }
        String techName = (String)this.technology.getSelectedItem();
        Technology tech = Technology.findTechnology(techName);
        int spacePos = name.indexOf(32);
        if (spacePos >= 0) {
            name = name.substring(0, spacePos);
        }
        if ((layer = tech.findLayer(name)) == null) {
            System.out.println("Can't find " + name);
            return;
        }
        boolean newState = false;
        if (how == 1) {
            newState = this.highlighted.get(layer) == false;
        }
        this.highlighted.put(layer, new Boolean(newState));
        this.layerListModel.set(i, this.lineName(layer));
        this.update();
    }

    private void update() {
        boolean currentTextOnCell;
        boolean currentTextOnInstance;
        boolean currentTextOnAnnotation;
        boolean currentTextOnExport;
        boolean currentTextOnPort;
        boolean currentTextOnArc;
        Layer layer;
        Iterator<Layer> lIt;
        Technology tech;
        boolean changed = false;
        boolean anyHighlighted = false;
        Iterator<Technology> it = Technology.getTechnologies();
        while (it.hasNext()) {
            tech = it.next();
            lIt = tech.getLayers();
            while (lIt.hasNext()) {
                layer = lIt.next();
                Boolean layerHighlighted = this.highlighted.get(layer.getNonPseudoLayer());
                if (layerHighlighted == null || !layerHighlighted.booleanValue()) continue;
                anyHighlighted = true;
            }
        }
        it = Technology.getTechnologies();
        while (it.hasNext()) {
            tech = it.next();
            lIt = tech.getLayers();
            while (lIt.hasNext()) {
                Boolean layerHighlighted;
                layer = lIt.next();
                Boolean layerVis = visibility.get(layer.getNonPseudoLayer());
                if (layerVis != null && layer.isVisible() != layerVis.booleanValue()) {
                    changed = true;
                    layer.setVisible(layerVis);
                    layer.getGraphics().notifyVisibility(layerVis);
                }
                if ((layerHighlighted = this.highlighted.get(layer.getNonPseudoLayer())) == null) continue;
                boolean newState = false;
                if (anyHighlighted && !layerHighlighted.booleanValue()) {
                    newState = true;
                }
                if (newState == layer.isDimmed()) continue;
                layer.setDimmed(newState);
                changed = true;
            }
        }
        it = Technology.getTechnologies();
        while (it.hasNext()) {
            tech = it.next();
            Iterator<PrimitiveNode> nIt = tech.getNodes();
            while (nIt.hasNext()) {
                PrimitiveNode np = nIt.next();
                Technology.NodeLayer[] layers = np.getLayers();
                boolean invisible = true;
                for (int i = 0; i < layers.length; ++i) {
                    Technology.NodeLayer lay = layers[i];
                    if (!lay.getLayer().isVisible()) continue;
                    invisible = false;
                    break;
                }
                np.setNodeInvisible(invisible);
            }
            Iterator<ArcProto> aIt = tech.getArcs();
            while (aIt.hasNext()) {
                ArcProto ap = aIt.next();
                boolean invisible = true;
                Iterator<Layer> lIt2 = ap.getLayerIterator();
                while (lIt2.hasNext()) {
                    Layer layer2 = lIt2.next();
                    if (!layer2.isVisible()) continue;
                    invisible = false;
                    break;
                }
                ap.setArcInvisible(invisible);
            }
        }
        boolean textVisChanged = false;
        boolean currentTextOnNode = this.nodeText.isSelected();
        if (currentTextOnNode != User.isTextVisibilityOnNode()) {
            textVisChanged = true;
            User.setTextVisibilityOnNode(currentTextOnNode);
        }
        if ((currentTextOnArc = this.arcText.isSelected()) != User.isTextVisibilityOnArc()) {
            textVisChanged = true;
            User.setTextVisibilityOnArc(currentTextOnArc);
        }
        if ((currentTextOnPort = this.portText.isSelected()) != User.isTextVisibilityOnPort()) {
            textVisChanged = true;
            User.setTextVisibilityOnPort(currentTextOnPort);
        }
        if ((currentTextOnExport = this.exportText.isSelected()) != User.isTextVisibilityOnExport()) {
            textVisChanged = true;
            User.setTextVisibilityOnExport(currentTextOnExport);
        }
        if ((currentTextOnAnnotation = this.annotationText.isSelected()) != User.isTextVisibilityOnAnnotation()) {
            textVisChanged = true;
            User.setTextVisibilityOnAnnotation(currentTextOnAnnotation);
        }
        if ((currentTextOnInstance = this.instanceNames.isSelected()) != User.isTextVisibilityOnInstance()) {
            textVisChanged = true;
            User.setTextVisibilityOnInstance(currentTextOnInstance);
        }
        if ((currentTextOnCell = this.cellText.isSelected()) != User.isTextVisibilityOnCell()) {
            textVisChanged = true;
            User.setTextVisibilityOnCell(currentTextOnCell);
        }
        Iterator<WindowFrame> it2 = WindowFrame.getWindows();
        while (it2.hasNext()) {
            WindowFrame wf = it2.next();
            LayerTab lt = wf.getLayersTab();
            if (lt == this) continue;
            lt.updateLayersTab();
        }
        if (changed || textVisChanged) {
            User.layerVisibilityChanged(!changed);
        }
    }

    public void dragGestureRecognized(DragGestureEvent dge) {
        StringSelection transferable = new StringSelection("" + this.layerList.getSelectedIndex());
        this.dragSource.startDrag(dge, DragSource.DefaultCopyDrop, transferable, this);
    }

    public void dragEnter(DragSourceDragEvent dsde) {
    }

    public void dragExit(DragSourceEvent dse) {
    }

    public void dragOver(DragSourceDragEvent dsde) {
    }

    public void dragDropEnd(DragSourceDropEvent dsde) {
    }

    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    private void initComponents() {
        this.layerPane = new JScrollPane();
        this.technology = new JComboBox();
        this.selectAll = new JButton();
        this.makeVisible = new JButton();
        this.makeInvisible = new JButton();
        this.jPanel1 = new JPanel();
        this.unhighlightAll = new JButton();
        this.toggleHighlight = new JButton();
        this.jPanel2 = new JPanel();
        this.cellText = new JCheckBox();
        this.arcText = new JCheckBox();
        this.annotationText = new JCheckBox();
        this.instanceNames = new JCheckBox();
        this.exportText = new JCheckBox();
        this.portText = new JCheckBox();
        this.nodeText = new JCheckBox();
        this.opacitySlider = new JSlider();
        this.resetOpacity = new JButton();
        this.setLayout(new GridBagLayout());
        this.setName("");
        this.layerPane.setMinimumSize(new Dimension(100, 300));
        this.layerPane.setPreferredSize(new Dimension(100, 300));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.layerPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.add((Component)this.technology, gridBagConstraints);
        this.selectAll.setText("Select All");
        this.selectAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerTab.this.selectAllActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(1, 4, 1, 4);
        this.add((Component)this.selectAll, gridBagConstraints);
        this.makeVisible.setText("Make Visible");
        this.makeVisible.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerTab.this.makeVisibleActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(1, 4, 1, 4);
        this.add((Component)this.makeVisible, gridBagConstraints);
        this.makeInvisible.setText("Make Invisible");
        this.makeInvisible.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerTab.this.makeInvisibleActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(1, 4, 2, 4);
        this.add((Component)this.makeInvisible, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Highlighting"));
        this.unhighlightAll.setText("Clear");
        this.unhighlightAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerTab.this.unhighlightAllActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(1, 4, 2, 4);
        this.jPanel1.add((Component)this.unhighlightAll, gridBagConstraints);
        this.toggleHighlight.setText("Toggle");
        this.toggleHighlight.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerTab.this.toggleHighlightActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 4, 1, 4);
        this.jPanel1.add((Component)this.toggleHighlight, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Text Visibility"));
        this.cellText.setText("Cell text");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.cellText, gridBagConstraints);
        this.arcText.setText("Arc text");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.arcText, gridBagConstraints);
        this.annotationText.setText("Annotation text");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.annotationText, gridBagConstraints);
        this.instanceNames.setText("Instance names");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.instanceNames, gridBagConstraints);
        this.exportText.setText("Export text");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.exportText, gridBagConstraints);
        this.portText.setText("Port text");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.portText, gridBagConstraints);
        this.nodeText.setText("Node text");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.jPanel2.add((Component)this.nodeText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.add((Component)this.opacitySlider, gridBagConstraints);
        this.resetOpacity.setText("Reset Opacity");
        this.resetOpacity.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerTab.this.resetOpacityActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(2, 4, 1, 4);
        this.add((Component)this.resetOpacity, gridBagConstraints);
    }

    private void resetOpacityActionPerformed(ActionEvent evt) {
        String techName = (String)this.technology.getSelectedItem();
        Technology tech = Technology.findTechnology(techName);
        if (tech == null) {
            return;
        }
        EditWindow.setDefaultOpacity(tech);
        this.updateLayersTab();
        this.opacityChanged();
    }

    private void toggleHighlightActionPerformed(ActionEvent evt) {
        this.toggleHighlight();
    }

    private void unhighlightAllActionPerformed(ActionEvent evt) {
        this.clearAllHighlight();
    }

    private void makeInvisibleActionPerformed(ActionEvent evt) {
        this.setVisibility(false);
    }

    private void makeVisibleActionPerformed(ActionEvent evt) {
        this.setVisibility(true);
    }

    private void selectAllActionPerformed(ActionEvent evt) {
        this.selectAll();
    }

    private class LayerTabTreeDropTarget
    implements DropTargetListener {
        private Rectangle lastDrawn = null;

        private LayerTabTreeDropTarget() {
        }

        public void dragEnter(DropTargetDragEvent e) {
            DropTarget dt = (DropTarget)e.getSource();
            if (dt.getComponent() == LayerTab.this.layerList) {
                e.acceptDrag(e.getDropAction());
            }
        }

        public void dragOver(DropTargetDragEvent e) {
            DropTarget dt = (DropTarget)e.getSource();
            if (dt.getComponent() != LayerTab.this.layerList) {
                return;
            }
            e.acceptDrag(e.getDropAction());
            this.eraseDragImage();
            int index = LayerTab.this.layerList.locationToIndex(e.getLocation());
            Rectangle path = LayerTab.this.layerList.getCellBounds(index, index);
            if (path == null) {
                return;
            }
            Graphics2D g2 = (Graphics2D)LayerTab.this.layerList.getGraphics();
            g2.setColor(Color.RED);
            g2.drawRect(path.x, path.y, path.width - 1, 1);
            this.lastDrawn = path;
        }

        public void dropActionChanged(DropTargetDragEvent e) {
            e.acceptDrag(e.getDropAction());
        }

        public void dragExit(DropTargetEvent e) {
            this.eraseDragImage();
        }

        public void drop(DropTargetDropEvent dtde) {
            dtde.acceptDrop(0x40000000);
            this.eraseDragImage();
            String text = null;
            DataFlavor[] flavors = dtde.getCurrentDataFlavors();
            if (flavors.length > 0 && flavors[0].isFlavorTextType()) {
                try {
                    text = (String)dtde.getTransferable().getTransferData(flavors[0]);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (text == null) {
                return;
            }
            int start = TextUtils.atoi(text);
            int end = LayerTab.this.layerList.locationToIndex(dtde.getLocation());
            Layer moveIt = (Layer)LayerTab.this.layersInList.get(start);
            LayerTab.this.layersInList.remove(start);
            if (start < end) {
                --end;
            }
            LayerTab.this.layersInList.add(end, moveIt);
            LayerTab.this.layerListModel.clear();
            for (Layer layer : LayerTab.this.layersInList) {
                LayerTab.this.layerListModel.addElement(LayerTab.this.lineName(layer));
            }
            LayerTab.this.layerList.setSelectedIndex(end);
            Technology tech = Technology.getCurrent();
            tech.setSavedLayerOrder(LayerTab.this.layersInList);
            dtde.dropComplete(false);
        }

        private void eraseDragImage() {
            if (this.lastDrawn == null) {
                return;
            }
            LayerTab.this.layerList.paintImmediately(this.lastDrawn);
            this.lastDrawn = null;
        }
    }
}

