/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.variable;

import com.sun.electric.database.ImmutableElectricObject;
import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.DisplayedText;
import com.sun.electric.database.variable.EditWindow0;
import com.sun.electric.database.variable.MutableTextDescriptor;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.user.ActivityLogger;
import com.sun.electric.tool.user.User;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ElectricObject
implements Serializable {
    protected ElectricObject() {
    }

    public abstract ImmutableElectricObject getD();

    public abstract boolean isLinked();

    public Variable getVar(String name) {
        Variable.Key key = Variable.findKey(name);
        return this.getVar(key, null);
    }

    public Variable getVar(Variable.Key key) {
        return this.getVar(key, null);
    }

    public Variable getVar(String name, Class type) {
        Variable.Key key = Variable.findKey(name);
        return this.getVar(key, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Variable getVar(Variable.Key key, Class type) {
        Variable var;
        this.checkExamine();
        if (key == null) {
            return null;
        }
        ElectricObject electricObject = this;
        synchronized (electricObject) {
            var = this.getD().getVar(key);
        }
        if (var != null) {
            if (type == null) {
                return var;
            }
            if (type.isInstance(var.getObject())) {
                return var;
            }
        }
        return null;
    }

    public TextDescriptor getTextDescriptor(Variable.Key varKey) {
        Variable var = this.getVar(varKey);
        if (var == null) {
            return null;
        }
        return var.getTextDescriptor();
    }

    public MutableTextDescriptor getMutableTextDescriptor(Variable.Key varKey) {
        TextDescriptor td = this.getTextDescriptor(varKey);
        if (td == null) {
            return null;
        }
        return new MutableTextDescriptor(td);
    }

    public boolean isParam(Variable.Key varKey) {
        return false;
    }

    public int numDisplayableVariables(boolean multipleStrings) {
        int numVars = 0;
        Iterator<Variable> it = this.getVariables();
        while (it.hasNext()) {
            Variable var = it.next();
            if (!var.isDisplay()) continue;
            int len = var.getLength();
            if (len > 1 && var.getTextDescriptor().getDispPart() == AbstractTextDescriptor.DispPos.NAMEVALUE) {
                ++len;
            }
            if (!multipleStrings) {
                len = 1;
            }
            numVars += len;
        }
        return numVars;
    }

    public int addDisplayableVariables(Rectangle2D rect, Poly[] polys, int start, EditWindow0 wnd, boolean multipleStrings) {
        this.checkExamine();
        int numAddedVariables = 0;
        double cX = rect.getCenterX();
        double cY = rect.getCenterY();
        Iterator<Variable> it = this.getVariables();
        while (it.hasNext()) {
            Variable var = it.next();
            if (!var.isDisplay()) continue;
            Poly[] polyList = this.getPolyList(var, cX, cY, wnd, multipleStrings);
            for (int i = 0; i < polyList.length; ++i) {
                int index = start + numAddedVariables;
                polys[index] = polyList[i];
                polys[index].setStyle(Poly.rotateType(polys[index].getStyle(), this));
                ++numAddedVariables;
            }
        }
        return numAddedVariables;
    }

    public Poly[] getDisplayableVariables(Rectangle2D rect, EditWindow0 wnd, boolean multipleStrings) {
        int numVars = this.numDisplayableVariables(multipleStrings);
        if (numVars == 0) {
            return Poly.NULL_ARRAY;
        }
        Poly[] polys = new Poly[numVars];
        this.addDisplayableVariables(rect, polys, 0, wnd, multipleStrings);
        return polys;
    }

    public Poly computeTextPoly(EditWindow0 wnd, Variable.Key varKey) {
        this.checkExamine();
        Poly poly = null;
        if (varKey != null) {
            Cell cell;
            Poly[] polys;
            if (this instanceof Export) {
                Export pp = (Export)this;
                if (varKey == Export.EXPORT_NAME) {
                    poly = pp.getNamePoly();
                } else {
                    Rectangle2D bounds = pp.getNamePoly().getBounds2D();
                    Poly[] polys2 = pp.getPolyList(pp.getVar(varKey), bounds.getCenterX(), bounds.getCenterY(), wnd, false);
                    if (polys2.length > 0) {
                        poly = polys2[0];
                    }
                }
            } else if (this instanceof PortInst) {
                PortInst pi = (PortInst)this;
                Rectangle2D bounds = pi.getPoly().getBounds2D();
                Poly[] polys3 = pi.getPolyList(pi.getVar(varKey), bounds.getCenterX(), bounds.getCenterY(), wnd, false);
                if (polys3.length > 0) {
                    poly = polys3[0];
                    poly.transform(pi.getNodeInst().rotateOut());
                }
            } else if (this instanceof Geometric) {
                Geometric geom = (Geometric)this;
                if (varKey == NodeInst.NODE_NAME || varKey == ArcInst.ARC_NAME) {
                    TextDescriptor td = geom.getTextDescriptor(varKey);
                    Poly.Type style = td.getPos().getPolyType();
                    Point2D[] pointList = null;
                    pointList = style == Poly.Type.TEXTBOX ? Poly.makePoints(geom.getBounds()) : new Point2D.Double[]{new Point2D.Double(geom.getTrueCenterX() + td.getXOff(), geom.getTrueCenterY() + td.getYOff())};
                    poly = new Poly(pointList);
                    poly.setStyle(style);
                    if (geom instanceof NodeInst) {
                        poly.transform(((NodeInst)geom).rotateOutAboutTrueCenter());
                    }
                    poly.setTextDescriptor(td);
                    if (varKey == NodeInst.NODE_NAME) {
                        poly.setString(((NodeInst)geom).getName());
                    } else {
                        poly.setString(((ArcInst)geom).getName());
                    }
                } else if (varKey == NodeInst.NODE_PROTO) {
                    if (!(geom instanceof NodeInst)) {
                        return null;
                    }
                    NodeInst ni = (NodeInst)this;
                    TextDescriptor td = ni.getTextDescriptor(NodeInst.NODE_PROTO);
                    Poly.Type style = td.getPos().getPolyType();
                    Point2D[] pointList = null;
                    pointList = style == Poly.Type.TEXTBOX ? Poly.makePoints(ni.getBounds()) : new Point2D.Double[]{new Point2D.Double(ni.getTrueCenterX() + td.getXOff(), ni.getTrueCenterY() + td.getYOff())};
                    poly = new Poly(pointList);
                    poly.setStyle(style);
                    poly.setTextDescriptor(td);
                    poly.setString(ni.getProto().describe(false));
                } else {
                    Poly[] polys4;
                    double x = geom.getTrueCenterX();
                    double y = geom.getTrueCenterY();
                    if (geom instanceof NodeInst) {
                        NodeInst ni = (NodeInst)geom;
                        Rectangle2D uBounds = ni.getUntransformedBounds();
                        x = uBounds.getCenterX();
                        y = uBounds.getCenterY();
                    }
                    if ((polys4 = geom.getPolyList(geom.getVar(varKey), x, y, wnd, false)).length > 0) {
                        poly = polys4[0];
                        if (geom instanceof NodeInst) {
                            NodeInst ni = (NodeInst)geom;
                            poly.transform(ni.rotateOut());
                        }
                    }
                }
            } else if (this instanceof Cell && (polys = (cell = (Cell)this).getPolyList(cell.getVar(varKey), 0.0, 0.0, wnd, false)).length > 0) {
                poly = polys[0];
            }
        }
        if (poly != null) {
            poly.setExactTextBounds(wnd, this);
        }
        return poly;
    }

    public Rectangle2D getTextBounds(EditWindow0 wnd) {
        ArcInst ai;
        Name name;
        Rectangle2D polyBound;
        Poly poly;
        Rectangle2D bounds = null;
        Iterator<Variable> vIt = this.getVariables();
        while (vIt.hasNext()) {
            Variable var = vIt.next();
            if (!var.isDisplay() || (poly = this.computeTextPoly(wnd, var.getKey())) == null) continue;
            polyBound = poly.getBounds2D();
            if (bounds == null) {
                bounds = polyBound;
                continue;
            }
            Rectangle2D.union(bounds, polyBound, bounds);
        }
        if (this instanceof ArcInst && !(name = (ai = (ArcInst)this).getNameKey()).isTempname() && (poly = this.computeTextPoly(wnd, ArcInst.ARC_NAME)) != null) {
            polyBound = poly.getBounds2D();
            if (bounds == null) {
                bounds = polyBound;
            } else {
                Rectangle2D.union(bounds, polyBound, bounds);
            }
        }
        if (this instanceof NodeInst) {
            NodeInst ni = (NodeInst)this;
            name = ni.getNameKey();
            if (!name.isTempname() && (poly = this.computeTextPoly(wnd, NodeInst.NODE_NAME)) != null) {
                polyBound = poly.getBounds2D();
                if (bounds == null) {
                    bounds = polyBound;
                } else {
                    Rectangle2D.union(bounds, polyBound, bounds);
                }
            }
            Iterator<Export> it = ni.getExports();
            while (it.hasNext()) {
                Export pp = it.next();
                Poly poly2 = pp.computeTextPoly(wnd, Export.EXPORT_NAME);
                if (poly2 == null) continue;
                Rectangle2D polyBound2 = poly2.getBounds2D();
                if (bounds == null) {
                    bounds = polyBound2;
                    continue;
                }
                Rectangle2D.union(bounds, polyBound2, bounds);
            }
        }
        return bounds;
    }

    public Poly[] getPolyList(Variable var, double cX, double cY, EditWindow0 wnd, boolean multipleStrings) {
        if (var == null) {
            return new Poly[0];
        }
        double offX = var.getXOff();
        double offY = var.getYOff();
        int varLength = var.getLength();
        double lineOffX = 0.0;
        double lineOffY = 0.0;
        AffineTransform trans = null;
        Poly.Type style = var.getPos().getPolyType();
        TextDescriptor td = var.getTextDescriptor();
        if (this instanceof NodeInst && (offX != 0.0 || offY != 0.0)) {
            td = td.withOff(0.0, 0.0);
        }
        boolean headerString = false;
        double fontHeight = 1.0;
        double scale = 1.0;
        if (wnd != null) {
            fontHeight = td.getTrueSize(wnd);
            scale = wnd.getScale();
        }
        fontHeight *= User.getGlobalTextScale();
        if (varLength > 1) {
            double lineDist = fontHeight / scale;
            int rotQuadrant = td.getRotation().getIndex();
            switch (rotQuadrant) {
                case 0: {
                    lineOffY = lineDist;
                    break;
                }
                case 1: {
                    lineOffX = -lineDist;
                    break;
                }
                case 2: {
                    lineOffY = -lineDist;
                    break;
                }
                case 3: {
                    lineOffX = lineDist;
                }
            }
            Poly.Type rotStyle = style;
            if (this instanceof NodeInst) {
                NodeInst ni = (NodeInst)this;
                AffineTransform offsetTrans = ni.pureRotateIn();
                Point2D.Double off = new Point2D.Double(lineOffX, lineOffY);
                offsetTrans.transform(off, off);
                lineOffX = ((Point2D)off).getX();
                lineOffY = ((Point2D)off).getY();
                if (style != Poly.Type.TEXTCENT && style != Poly.Type.TEXTBOX) {
                    trans = ni.rotateIn();
                    int origAngle = style.getTextAngle();
                    if (ni.isMirroredAboutXAxis() != ni.isMirroredAboutYAxis() && (origAngle % 1800 == 0 || origAngle % 1800 == 1350)) {
                        origAngle += 1800;
                    }
                    int angle = (origAngle - ni.getAngle() + 3600) % 3600;
                    style = Poly.Type.getTextTypeFromAngle(angle);
                }
            }
            if (td.getDispPart() == AbstractTextDescriptor.DispPos.NAMEVALUE) {
                headerString = true;
                ++varLength;
            }
            if (multipleStrings) {
                if (rotStyle == Poly.Type.TEXTCENT || rotStyle == Poly.Type.TEXTBOX || rotStyle == Poly.Type.TEXTLEFT || rotStyle == Poly.Type.TEXTRIGHT) {
                    cX += lineOffX * (double)(varLength - 1) / 2.0;
                    cY += lineOffY * (double)(varLength - 1) / 2.0;
                }
                if (rotStyle == Poly.Type.TEXTBOT || rotStyle == Poly.Type.TEXTBOTLEFT || rotStyle == Poly.Type.TEXTBOTRIGHT) {
                    cX += lineOffX * (double)(varLength - 1);
                    cY += lineOffY * (double)(varLength - 1);
                }
            } else {
                if (rotStyle == Poly.Type.TEXTCENT || rotStyle == Poly.Type.TEXTBOX || rotStyle == Poly.Type.TEXTLEFT || rotStyle == Poly.Type.TEXTRIGHT) {
                    cX -= lineOffX * (double)(varLength - 1) / 2.0;
                    cY -= lineOffY * (double)(varLength - 1) / 2.0;
                }
                if (rotStyle == Poly.Type.TEXTTOP || rotStyle == Poly.Type.TEXTTOPLEFT || rotStyle == Poly.Type.TEXTTOPRIGHT) {
                    cX -= lineOffX * (double)(varLength - 1);
                    cY -= lineOffY * (double)(varLength - 1);
                }
                varLength = 1;
                headerString = false;
            }
        }
        VarContext context = null;
        if (wnd != null) {
            context = wnd.getVarContext();
        }
        Poly[] polys = new Poly[varLength];
        for (int i = 0; i < varLength; ++i) {
            String message = null;
            TextDescriptor entryTD = td;
            if (varLength > 1 && headerString) {
                if (i == 0) {
                    message = var.getTrueName() + "[" + (varLength - 1) + "]:";
                    entryTD = entryTD.withUnderline(true);
                } else {
                    message = var.describe(i - 1, context, this);
                }
            } else {
                message = var.describe(i, context, this);
            }
            Point2D[] pointList = null;
            if (style == Poly.Type.TEXTBOX && this instanceof Geometric) {
                Geometric geom = (Geometric)this;
                Rectangle2D bounds = geom.getBounds();
                pointList = Poly.makePoints(bounds);
            } else {
                pointList = new Point2D.Double[]{new Point2D.Double(cX + offX, cY + offY)};
                if (trans != null) {
                    trans.transform(pointList[0], pointList[0]);
                }
            }
            polys[i] = new Poly(pointList);
            polys[i].setString(message);
            polys[i].setStyle(style);
            polys[i].setTextDescriptor(entryTD);
            polys[i].setDisplayedText(new DisplayedText(this, var.getKey()));
            polys[i].setLayer(null);
            cX -= lineOffX;
            cY -= lineOffY;
        }
        return polys;
    }

    public Variable newVar(String name, Object value) {
        return this.newVar(Variable.newKey(name, this), value);
    }

    public Variable newDisplayVar(Variable.Key key, Object value) {
        return this.newVar(key, value, true);
    }

    public Variable newVar(Variable.Key key, Object value) {
        return this.newVar(key, value, false);
    }

    public Variable newVar(Variable.Key key, Object value, boolean display) {
        TextDescriptor td = null;
        td = this instanceof Cell ? TextDescriptor.cacheCellDescriptor.newTextDescriptor(display) : (this instanceof Export ? TextDescriptor.cacheExportDescriptor.newTextDescriptor(display) : (this instanceof NodeInst ? TextDescriptor.cacheNodeDescriptor.newTextDescriptor(display) : (this instanceof ArcInst ? TextDescriptor.cacheArcDescriptor.newTextDescriptor(display) : TextDescriptor.cacheAnnotationDescriptor.newTextDescriptor(display))));
        return this.newVar(key, value, td);
    }

    public Variable newVar(Variable.Key key, Object value, TextDescriptor td) {
        if (value == null) {
            return null;
        }
        if (this.isDeprecatedVariable(key)) {
            System.out.println("Deprecated variable " + key + " on " + this);
        }
        Variable var = null;
        try {
            var = Variable.newInstance(key, value, td);
        }
        catch (IllegalArgumentException e) {
            ActivityLogger.logException(e);
            return null;
        }
        this.addVar(var);
        return this.getVar(key);
    }

    public abstract void addVar(Variable var1);

    public Variable updateVar(Variable.Key key, Object value) {
        Variable var = this.getVar(key);
        if (var == null) {
            return this.newVar(key, value);
        }
        this.addVar(var.withObject(value));
        return this.getVar(key);
    }

    public void setTextDescriptor(Variable.Key varKey, TextDescriptor td) {
        Variable var = this.getVar(varKey);
        if (var == null) {
            return;
        }
        if (!(this instanceof Cell)) {
            td = td.withParam(false);
        }
        this.addVar(var.withTextDescriptor(td));
    }

    public synchronized void setOff(Variable.Key varKey, double xd, double yd) {
        TextDescriptor td = this.getTextDescriptor(varKey);
        if (td != null) {
            this.setTextDescriptor(varKey, td.withOff(xd, yd));
        }
    }

    public void copyTextDescriptorFrom(ElectricObject other, Variable.Key varKey) {
        TextDescriptor td = other.getTextDescriptor(varKey);
        if (td == null) {
            return;
        }
        this.setTextDescriptor(varKey, td);
    }

    public Variable renameVar(String name, String newName) {
        return this.renameVar(Variable.findKey(name), newName);
    }

    public Variable renameVar(Variable.Key key, String newName) {
        Variable.Key newKey = Variable.newKey(newName);
        Variable var = this.getVar(newKey);
        if (var != null) {
            return null;
        }
        Variable oldvar = this.getVar(key);
        if (oldvar == null) {
            return null;
        }
        Variable newVar = this.newVar(newKey, oldvar.getObject(), oldvar.getTextDescriptor());
        if (newVar == null) {
            return null;
        }
        this.delVar(oldvar.getKey());
        return newVar;
    }

    public abstract void delVar(Variable.Key var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyVarsFrom(ElectricObject other) {
        this.checkChanging();
        Iterator<Variable> it = other.getVariables();
        ElectricObject electricObject = this;
        synchronized (electricObject) {
            while (it.hasNext()) {
                Variable var = it.next();
                Variable newVar = this.newVar(var.getKey(), var.getObject(), var.getTextDescriptor());
                if (newVar == null) continue;
            }
        }
    }

    public static String uniqueObjectName(String name, Cell cell, Class cls, boolean leaveIndexValues) {
        String newName = name;
        int i = 0;
        while (!cell.isUniqueName(newName, cls, null)) {
            newName = ElectricObject.uniqueObjectNameLow(newName, cell, cls, null, null, leaveIndexValues);
            if (i > 100) {
                System.out.println("Can't create unique object name in " + cell + " from original " + name + " attempted " + newName);
                return null;
            }
            ++i;
        }
        return newName;
    }

    public static String uniqueObjectName(String name, Cell cell, Class cls, Set already, Map<String, GenMath.MutableInteger> nextPlainIndex, boolean leaveIndexValues) {
        String newName = name;
        String lcName = TextUtils.canonicString(newName);
        int i = 0;
        while (already.contains(lcName)) {
            newName = ElectricObject.uniqueObjectNameLow(newName, cell, cls, already, nextPlainIndex, leaveIndexValues);
            if (i > 100) {
                System.out.println("Can't create unique object name in " + cell + " from original " + name + " attempted " + newName);
                return null;
            }
            lcName = TextUtils.canonicString(newName);
            ++i;
        }
        return newName;
    }

    private static String uniqueObjectNameLow(String name, Cell cell, Class cls, Set already, Map<String, GenMath.MutableInteger> nextPlainIndex, boolean leaveIndexValues) {
        int minusMinusPos;
        if (already != null ? !already.contains(TextUtils.canonicString(name)) : cell.isUniqueName(name, cls, null)) {
            return name;
        }
        int plusPlusPos = name.indexOf("++");
        if (plusPlusPos >= 0) {
            int numStart;
            for (numStart = plusPlusPos; numStart > 0 && TextUtils.isDigit(name.charAt(numStart - 1)); --numStart) {
            }
            if (numStart < plusPlusPos) {
                int nextIndex = TextUtils.atoi(name.substring(numStart)) + 1;
                while (true) {
                    String newname = name.substring(0, numStart) + nextIndex + name.substring(plusPlusPos);
                    if (already != null ? !already.contains(TextUtils.canonicString(newname)) : cell.isUniqueName(newname, cls, null)) {
                        return newname;
                    }
                    ++nextIndex;
                }
            }
        }
        if ((minusMinusPos = name.indexOf("--")) >= 0) {
            int numStart;
            for (numStart = minusMinusPos; numStart > 0 && TextUtils.isDigit(name.charAt(numStart - 1)); --numStart) {
            }
            if (numStart < minusMinusPos) {
                for (int nextIndex = TextUtils.atoi(name.substring(numStart)) - 1; nextIndex >= 0; --nextIndex) {
                    String newname = name.substring(0, numStart) + nextIndex + name.substring(minusMinusPos);
                    if (!(already != null ? !already.contains(TextUtils.canonicString(newname)) : cell.isUniqueName(newname, cls, null))) continue;
                    return newname;
                }
            }
        }
        ArrayList<ArrayName> names = new ArrayList<ArrayName>();
        boolean inBracket = false;
        int len = name.length();
        int startOfBase = 0;
        int startOfIndex = -1;
        for (int i = 0; i < len; ++i) {
            char ch = name.charAt(i);
            if (ch == '[') {
                if (startOfIndex < 0) {
                    startOfIndex = i;
                }
                inBracket = true;
            }
            if (ch == ']') {
                inBracket = false;
            }
            if ((ch != ',' || inBracket) && i != len - 1) continue;
            if (i == len - 1) {
                ++i;
            }
            ArrayName an = new ArrayName();
            int endOfBase = startOfIndex;
            if (endOfBase < 0) {
                endOfBase = i;
            }
            an.baseName = name.substring(startOfBase, endOfBase);
            if (startOfIndex >= 0) {
                an.indexPart = name.substring(startOfIndex, i);
            }
            names.add(an);
            startOfBase = i + 1;
            startOfIndex = -1;
        }
        char separateChar = '_';
        for (ArrayName an : names) {
            int startPos;
            boolean indexAdjusted = false;
            String index = an.indexPart;
            if (index != null && !leaveIndexValues) {
                int startPos2;
                int possibleEnd = 0;
                int nameLen = index.length();
                int possibleStart = -1;
                int endPos = nameLen - 1;
                while ((startPos2 = index.lastIndexOf(91, endPos)) >= 0) {
                    int i = index.indexOf(44, startPos2);
                    if (i >= 0 && i < endPos) {
                        if (startPos2 <= 0 || index.charAt(startPos2 - 1) != ']') break;
                        endPos = startPos2 - 1;
                        continue;
                    }
                    i = index.indexOf(58, startPos2);
                    if (i >= 0 && i < endPos) {
                        String firstIndex = index.substring(startPos2 + 1, i);
                        String secondIndex = index.substring(i + 1, endPos);
                        if (TextUtils.isANumber(firstIndex) && TextUtils.isANumber(secondIndex)) {
                            String newIndex;
                            int startIndex = TextUtils.atoi(firstIndex);
                            int endIndex = TextUtils.atoi(secondIndex);
                            int spacing = Math.abs(endIndex - startIndex) + 1;
                            int nextIndex = 1;
                            while (true) {
                                newIndex = index.substring(0, startPos2) + "[" + (startIndex + spacing * nextIndex) + ":" + (endIndex + spacing * nextIndex) + index.substring(endPos);
                                boolean unique = already != null ? !already.contains(TextUtils.canonicString(an.baseName + newIndex)) : cell.isUniqueName(an.baseName + newIndex, cls, null);
                                if (unique) break;
                                ++nextIndex;
                            }
                            indexAdjusted = true;
                            an.indexPart = newIndex;
                            if (indexAdjusted) break;
                        }
                        if (startPos2 <= 0 || index.charAt(startPos2 - 1) != ']') break;
                        endPos = startPos2 - 1;
                        continue;
                    }
                    String bracketedExpression = index.substring(startPos2 + 1, endPos);
                    if (TextUtils.isANumber(bracketedExpression)) {
                        String newIndex;
                        int nextIndex = TextUtils.atoi(bracketedExpression) + 1;
                        while (true) {
                            newIndex = index.substring(0, startPos2) + "[" + nextIndex + index.substring(endPos);
                            boolean unique = already != null ? !already.contains(TextUtils.canonicString(an.baseName + newIndex)) : cell.isUniqueName(an.baseName + newIndex, cls, null);
                            if (unique) break;
                            ++nextIndex;
                        }
                        indexAdjusted = true;
                        an.indexPart = newIndex;
                        if (indexAdjusted) break;
                    }
                    if (possibleStart < 0) {
                        possibleStart = startPos2;
                        possibleEnd = endPos;
                    }
                    if (startPos2 <= 0 || index.charAt(startPos2 - 1) != ']') break;
                    endPos = startPos2 - 1;
                }
                if (!indexAdjusted && possibleStart >= 0) {
                    int i;
                    for (i = possibleEnd - 1; i > possibleStart && TextUtils.isDigit(index.charAt(i)); --i) {
                    }
                    int nextIndex = TextUtils.atoi(index.substring(i + 1)) + 1;
                    int startPos3 = i + 1;
                    if (index.charAt(startPos3 - 1) == separateChar) {
                        --startPos3;
                    }
                    while (true) {
                        String newIndex = index.substring(0, startPos3) + separateChar + nextIndex + index.substring(possibleEnd);
                        boolean unique = already != null ? !already.contains(TextUtils.canonicString(an.baseName + newIndex)) : cell.isUniqueName(an.baseName + newIndex, cls, null);
                        if (unique) {
                            indexAdjusted = true;
                            an.indexPart = newIndex;
                            break;
                        }
                        ++nextIndex;
                    }
                }
            }
            if (indexAdjusted) continue;
            String base = an.baseName;
            int endPos = base.length();
            String localSepString = String.valueOf(separateChar);
            for (startPos = base.length(); startPos > 0 && TextUtils.isDigit(base.charAt(startPos - 1)); --startPos) {
            }
            int nextIndex = 1;
            if (startPos >= endPos) {
                if (startPos > 0 && base.charAt(startPos - 1) == separateChar) {
                    --startPos;
                }
            } else {
                nextIndex = TextUtils.atoi(base.substring(startPos)) + 1;
                localSepString = "";
            }
            String prefix = base.substring(0, startPos) + localSepString;
            if (nextPlainIndex != null) {
                GenMath.MutableInteger nxt = nextPlainIndex.get(prefix);
                if (nxt == null) {
                    nxt = new GenMath.MutableInteger(cell.getUniqueNameIndex(prefix, cls, nextIndex));
                    nextPlainIndex.put(prefix, nxt);
                }
                nextIndex = nxt.intValue();
                nxt.increment();
            } else {
                nextIndex = cell.getUniqueNameIndex(prefix, cls, nextIndex);
            }
            an.baseName = prefix + nextIndex + base.substring(endPos);
        }
        StringBuffer result = new StringBuffer();
        boolean first = true;
        for (ArrayName an : names) {
            if (first) {
                first = false;
            } else {
                result.append(",");
            }
            result.append(an.baseName);
            if (an.indexPart == null) continue;
            result.append(an.indexPart);
        }
        return result.toString();
    }

    public boolean isDeprecatedVariable(Variable.Key key) {
        char chr;
        String name = key.toString();
        if (name.length() == 0) {
            return true;
        }
        return name.length() == 1 && !Character.isLetter(chr = name.charAt(0));
    }

    public synchronized Iterator<Variable> getVariables() {
        return this.getD().getVariables();
    }

    public synchronized int getNumVariables() {
        return this.getD().getNumVariables();
    }

    public void checkChanging() {
        EDatabase database = this.getDatabase();
        if (database != null) {
            database.checkChanging();
        }
    }

    public void checkUndoing() {
        this.getDatabase().checkUndoing();
    }

    public void checkExamine() {
        EDatabase database = this.getDatabase();
        if (database != null) {
            database.checkExamine();
        }
    }

    public abstract EDatabase getDatabase();

    protected boolean isDatabaseObject() {
        return true;
    }

    public Cell whichCell() {
        return null;
    }

    public void getInfo() {
        this.checkExamine();
        boolean firstvar = true;
        Iterator<Variable> it = this.getVariables();
        while (it.hasNext()) {
            String par;
            Variable val = it.next();
            Variable.Key key = val.getKey();
            if (val == null) continue;
            if (firstvar) {
                System.out.println("Variables:");
            }
            firstvar = false;
            Object addr = val.getObject();
            String string = par = this.isParam(key) ? "(param)" : "";
            if (addr instanceof Object[]) {
                Object[] ary = (Object[])addr;
                System.out.print("   " + key.getName() + "(" + ary.length + ") = [");
                for (int i = 0; i < ary.length; ++i) {
                    if (i > 4) {
                        System.out.print("...");
                        break;
                    }
                    if (ary[i] instanceof String) {
                        System.out.print("\"");
                    }
                    System.out.print(ary[i]);
                    if (ary[i] instanceof String) {
                        System.out.print("\"");
                    }
                    if (i >= ary.length - 1) continue;
                    System.out.print(", ");
                }
                System.out.println("] " + par);
                continue;
            }
            System.out.println("   " + key.getName() + "= " + addr + " " + par);
        }
    }

    public String toString() {
        return this.getClass().getName();
    }

    protected void check() {
    }

    private static class ArrayName {
        private String baseName;
        private String indexPart;

        private ArrayName() {
        }
    }
}

