/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.user.dialogs.OpenFile;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Observable;
import java.util.Observer;

public class MessagesStream
extends OutputStream {
    private PrintWriter printWriter = null;
    private static MessagesStream messagesStream;
    private MessagesObserver notifyGUI = null;
    private static boolean newCommand;
    private static int commandNumber;

    private static void initializeMessageStream() {
        if (messagesStream == null) {
            messagesStream = new MessagesStream();
        }
    }

    public static MessagesStream getMessagesStream() {
        MessagesStream.initializeMessageStream();
        return messagesStream;
    }

    public MessagesStream() {
        System.setProperty("line.separator", "\n");
        System.setOut(new PrintStream(this));
        this.notifyGUI = new MessagesObserver();
    }

    public void addObserver(Observer o) {
        this.notifyGUI.addObserver(o);
    }

    public void write(byte[] b) {
        this.appendString(new String(b));
    }

    public void write(int b) {
        this.appendString(String.valueOf((char)b));
    }

    public void write(byte[] b, int off, int len) {
        this.appendString(new String(b, off, len));
    }

    public static void userCommandIssued() {
        newCommand = true;
    }

    public void save() {
        this.save(OpenFile.chooseOutputFile(FileType.TEXT, null, "emessages.txt"));
    }

    public void save(String filePath) {
        if (filePath == null) {
            return;
        }
        try {
            this.printWriter = new PrintWriter(new BufferedWriter(new FileWriter(filePath)));
        }
        catch (IOException e) {
            System.err.println("Error creating " + filePath);
            System.out.println("Error creating " + filePath);
            return;
        }
        System.out.println("Messages will be saved to " + filePath);
    }

    protected void appendString(String str) {
        if (str.equals("")) {
            return;
        }
        if (newCommand) {
            newCommand = false;
            str = "=================================" + commandNumber++ + "=================================\n" + str;
        }
        if (this.printWriter != null) {
            this.printWriter.print(str);
            this.printWriter.flush();
        }
        if (this.notifyGUI == null) {
            return;
        }
        this.notifyGUI.setChanged();
        this.notifyGUI.notifyObservers(str);
        this.notifyGUI.clearChanged();
    }

    static {
        newCommand = true;
        commandNumber = 1;
    }

    static class MessagesObserver
    extends Observable {
        MessagesObserver() {
        }

        public void setChanged() {
            super.setChanged();
        }

        public void clearChanged() {
            super.clearChanged();
        }
    }
}

