/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.topology;

import com.sun.electric.database.CellId;
import com.sun.electric.database.EObjectInputStream;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableElectricObject;
import com.sun.electric.database.constraint.Constraints;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.HeadConnection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.topology.TailConnection;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.DisplayedText;
import com.sun.electric.database.variable.EditWindow0;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.User;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArcInst
extends Geometric
implements Comparable<ArcInst> {
    public static final ArcInst[] NULL_ARRAY = new ArcInst[0];
    public static final int TAILEND = 0;
    public static final int HEADEND = 1;
    public static final Variable.Key ARC_NAME = Variable.newKey("ARC_name");
    public static final Variable.Key ARC_RADIUS = Variable.newKey("ARC_radius");
    static final double MINPORTDISTANCE = DBMath.getEpsilon() * 0.71;
    ImmutableArcInst d;
    private final Rectangle2D visBounds = new Rectangle2D.Double();
    final PortInst tailPortInst;
    private final TailConnection tailEnd;
    final PortInst headPortInst;
    private final HeadConnection headEnd;
    private int arcIndex = -1;
    private static final int MAXARCPIECES = 16;
    private static int[] extendFactor = new int[]{0, 11459, 5729, 3819, 2864, 2290, 1908, 1635, 1430, 1271, 1143, 1039, 951, 878, 814, 760, 712, 669, 631, 598, 567, 540, 514, 492, 470, 451, 433, 417, 401, 387, 373, 361, 349, 338, 327, 317, 308, 299, 290, 282, 275, 267, 261, 254, 248, 241, 236, 230, 225, 219, 214, 210, 205, 201, 196, 192, 188, 184, 180, 177, 173, 170, 166, 163, 160, 157, 154, 151, 148, 146, 143, 140, 138, 135, 133, 130, 128, 126, 123, 121, 119, 117, 115, 113, 111, 109, 107, 105, 104, 102, 100};

    public ArcInst(Cell parent, ImmutableArcInst d, PortInst headPort, PortInst tailPort) {
        super(parent);
        assert (parent == headPort.getNodeInst().getParent());
        assert (parent == tailPort.getNodeInst().getParent());
        assert (d.headNodeId == headPort.getNodeInst().getD().nodeId);
        assert (d.tailNodeId == tailPort.getNodeInst().getD().nodeId);
        assert (d.headPortId == headPort.getPortProto().getId());
        assert (d.tailPortId == tailPort.getPortProto().getId());
        this.d = d;
        this.tailPortInst = tailPort;
        this.tailEnd = new TailConnection(this);
        this.headPortInst = headPort;
        this.headEnd = new HeadConnection(this);
    }

    private Object writeReplace() throws ObjectStreamException {
        return new ArcInstKey(this);
    }

    private Object readResolve() throws ObjectStreamException {
        throw new InvalidObjectException("ArcInst");
    }

    public static ArcInst makeInstance(ArcProto type, double width, PortInst head, PortInst tail) {
        return ArcInst.newInstance(type, width, head, tail, null, null, null, 0, type.getDefaultConstraints());
    }

    public static ArcInst makeInstance(ArcProto type, double width, PortInst head, PortInst tail, Point2D headPt, Point2D tailPt, String name) {
        return ArcInst.newInstance(type, width, head, tail, headPt, tailPt, name, 0, type.getDefaultConstraints());
    }

    public static ArcInst makeDummyInstance(ArcProto ap, double arcLength) {
        PrimitiveNode npEnd = ap.findPinProto();
        if (npEnd == null) {
            System.out.println("Cannot find pin for " + ap);
            return null;
        }
        EPoint xPH = new EPoint(-arcLength / 2.0, 0.0);
        NodeInst niH = NodeInst.makeDummyInstance(npEnd, xPH, npEnd.getDefWidth(), npEnd.getDefHeight(), Orientation.IDENT);
        PortInst piH = niH.getOnlyPortInst();
        EPoint xPT = new EPoint(arcLength / 2.0, 0.0);
        NodeInst niT = NodeInst.makeDummyInstance(npEnd, xPT, npEnd.getDefWidth(), npEnd.getDefHeight(), Orientation.IDENT);
        PortInst piT = niT.getOnlyPortInst();
        ImmutableArcInst d = ImmutableArcInst.newInstance(0, ap, ImmutableArcInst.BASENAME, TextDescriptor.getArcTextDescriptor(), niT.getD().nodeId, piT.getPortProto().getId(), xPT, niH.getD().nodeId, piH.getPortProto().getId(), xPH, ap.getDefaultWidth(), 0, 0);
        ArcInst ai = new ArcInst(null, d, piH, piT);
        ai.updateGeometric();
        return ai;
    }

    public static ArcInst newInstance(ArcProto type, double width, PortInst head, PortInst tail) {
        return ArcInst.newInstance(type, width, head, tail, null, null, null, 0, 0);
    }

    public static ArcInst newInstance(ArcProto type, double width, PortInst head, PortInst tail, Point2D headPt, Point2D tailPt, String name, int defAngle) {
        return ArcInst.newInstance(type, width, head, tail, headPt, tailPt, name, defAngle, 0);
    }

    public static ArcInst newInstance(ArcProto type, double width, PortInst head, PortInst tail, Point2D headPt, Point2D tailPt, String name, int defAngle, int flags) {
        EPoint headP = headPt == null ? head.getCenter() : EPoint.snap(headPt);
        EPoint tailP = tailPt == null ? tail.getCenter() : EPoint.snap(tailPt);
        Cell parent = head.getNodeInst().getParent();
        Poly headPoly = head.getPoly();
        if (!ArcInst.stillInPoly(headP, headPoly)) {
            System.out.println("Error in " + parent + ": head of " + type.getName() + " arc at (" + headP.getX() + "," + headP.getY() + ") does not fit in " + head + " which is centered at (" + headPoly.getCenterX() + "," + headPoly.getCenterY() + ")");
            return null;
        }
        Poly tailPoly = tail.getPoly();
        if (!ArcInst.stillInPoly(tailP, tailPoly)) {
            System.out.println("Error in " + parent + ": tail of " + type.getName() + " arc at (" + tailP.getX() + "," + tailP.getY() + ") does not fit in " + tail + " which is centered at (" + tailPoly.getCenterX() + "," + tailPoly.getCenterY() + ")");
            return null;
        }
        return ArcInst.newInstance(parent, type, name, null, head, tail, headP, tailP, width, defAngle, flags);
    }

    public static ArcInst newInstance(Cell parent, ArcProto protoType, String name, TextDescriptor nameDescriptor, PortInst headPort, PortInst tailPort, EPoint headPt, EPoint tailPt, double width, int angle, int flags) {
        int arcId;
        Name nameKey;
        if (protoType == null || headPort == null || tailPort == null || !headPort.isLinked() || !tailPort.isLinked()) {
            return null;
        }
        if (headPt == null || tailPt == null) {
            return null;
        }
        if (parent != headPort.getNodeInst().getParent() || parent != tailPort.getNodeInst().getParent()) {
            System.out.println("ArcProto.newInst: the 2 PortInsts are in different Cells!");
            return null;
        }
        PortProto headProto = headPort.getPortProto();
        PrimitivePort headPrimPort = headProto.getBasePort();
        if (!headPrimPort.connectsTo(protoType)) {
            System.out.println("Cannot create " + protoType + " in " + parent + " because it cannot connect to port " + headProto.getName());
            return null;
        }
        PortProto tailProto = tailPort.getPortProto();
        PrimitivePort tailPrimPort = tailProto.getBasePort();
        if (!tailPrimPort.connectsTo(protoType)) {
            System.out.println("Cannot create " + protoType + " in " + parent + " because it cannot connect to port " + tailProto.getName());
            return null;
        }
        if (nameDescriptor == null) {
            nameDescriptor = TextDescriptor.getArcTextDescriptor();
        }
        Name name2 = nameKey = name != null ? Name.findName(name) : null;
        if (nameKey == null || nameKey.isTempname() && !parent.isUniqueName(nameKey, ArcInst.class, null) || ArcInst.checkNameKey(nameKey, parent)) {
            nameKey = parent.getArcAutoname();
        } else {
            TextDescriptor smartDescriptor = ArcInst.getSmartTextDescriptor(angle, width, nameDescriptor);
            if (smartDescriptor != null) {
                nameDescriptor = smartDescriptor;
            }
        }
        if (width < 0.0) {
            width = protoType.getWidth();
        }
        CellId parentId = parent.getId();
        while (parent.getArcById(arcId = parentId.newArcId()) != null) {
        }
        ImmutableArcInst d = ImmutableArcInst.newInstance(arcId, protoType, nameKey, nameDescriptor, tailPort.getNodeInst().getD().nodeId, tailProto.getId(), tailPt, headPort.getNodeInst().getD().nodeId, headProto.getId(), headPt, width, angle, flags);
        ArcInst ai = new ArcInst(parent, d, headPort, tailPort);
        ai.lowLevelLink();
        Constraints.getCurrent().newObject(ai);
        return ai;
    }

    public void kill() {
        if (!this.isLinked()) {
            System.out.println("ArcInst already killed");
            return;
        }
        this.lowLevelUnlink();
        Constraints.getCurrent().killObject(this);
    }

    public void modify(double dWidth, double dHeadX, double dHeadY, double dTailX, double dTailY) {
        ImmutableArcInst oldD = this.d;
        EPoint tail = this.d.tailLocation;
        if (dTailX != 0.0 || dTailY != 0.0) {
            tail = new EPoint(tail.getX() + dTailX, tail.getY() + dTailY);
        }
        EPoint head = this.d.headLocation;
        if (dHeadX != 0.0 || dHeadY != 0.0) {
            head = new EPoint(head.getX() + dHeadX, head.getY() + dHeadY);
        }
        this.lowLevelModify(this.d.withWidth(this.d.width + dWidth).withLocations(tail, head));
        Constraints.getCurrent().modifyArcInst(this, oldD);
    }

    public ArcInst replace(ArcProto ap) {
        if (!this.headPortInst.getPortProto().connectsTo(ap) || !this.tailPortInst.getPortProto().connectsTo(ap)) {
            System.out.println("Cannot replace " + this + " with one of type " + ap.getName() + " because the nodes cannot connect to it");
            return null;
        }
        double newwid = this.getWidth() - this.getProto().getWidthOffset() + ap.getWidthOffset();
        ArcInst newar = ArcInst.newInstance(ap, newwid, this.headPortInst, this.tailPortInst, this.d.headLocation, this.d.tailLocation, null, 0);
        if (newar == null) {
            System.out.println("Cannot replace " + this + " with one of type " + ap.getName() + " because the new arc failed to create");
            return null;
        }
        newar.copyPropertiesFrom(this);
        this.kill();
        newar.setName(this.getName());
        return newar;
    }

    public ImmutableArcInst getD() {
        return this.d;
    }

    public boolean setD(ImmutableArcInst newD, boolean notify) {
        this.checkChanging();
        ImmutableArcInst oldD = this.d;
        if (newD == oldD) {
            return false;
        }
        this.d = newD;
        if (this.parent != null) {
            this.parent.setContentsModified();
            if (notify) {
                Constraints.getCurrent().modifyArcInst(this, oldD);
            }
        }
        return true;
    }

    public void setDInUndo(ImmutableArcInst newD) {
        this.checkUndoing();
        this.d = newD;
    }

    @Override
    public ImmutableElectricObject getImmutable() {
        return this.d;
    }

    @Override
    public void addVar(Variable var) {
        if (this.setD(this.d.withVariable(var), true)) {
            this.checkPossibleVariableEffects(var.getKey());
        }
    }

    public void checkPossibleVariableEffects(Variable.Key key) {
        if (key == ARC_RADIUS) {
            this.lowLevelModify(this.d);
        }
    }

    @Override
    public void delVar(Variable.Key key) {
        this.setD(this.d.withoutVariable(key), true);
    }

    public void lowLevelLink() {
        assert (this.getDatabase() != null);
        this.checkChanging();
        this.headPortInst.getNodeInst().addConnection(this.headEnd);
        this.tailPortInst.getNodeInst().addConnection(this.tailEnd);
        this.updateGeometric();
        this.parent.addArc(this);
        this.parent.linkArc(this);
    }

    public void lowLevelUnlink() {
        this.checkChanging();
        this.headPortInst.getNodeInst().removeConnection(this.headEnd);
        this.tailPortInst.getNodeInst().removeConnection(this.tailEnd);
        this.parent.removeArc(this);
        this.parent.unLinkArc(this);
    }

    public void lowLevelModify(ImmutableArcInst d) {
        boolean renamed;
        this.parent.unLinkArc(this);
        boolean bl = renamed = this.d.name != d.name;
        if (renamed) {
            this.parent.removeArc(this);
        }
        this.setD(d, false);
        if (renamed) {
            this.parent.addArc(this);
        }
        this.updateGeometric();
        this.headPortInst.getNodeInst().updateShrinkage();
        this.tailPortInst.getNodeInst().updateShrinkage();
        this.parent.linkArc(this);
    }

    public double getWidth() {
        return this.d.width;
    }

    public double getLength() {
        return this.d.length;
    }

    public int getAngle() {
        return this.d.angle;
    }

    public void setAngle(int angle) {
        this.checkChanging();
        ImmutableArcInst oldD = this.d;
        this.lowLevelModify(this.d.withAngle(angle));
        if (this.parent != null) {
            Constraints.getCurrent().modifyArcInst(this, oldD);
        }
    }

    @Override
    public Rectangle2D getBounds() {
        return this.visBounds;
    }

    public Poly makePoly(double width, Poly.Type style) {
        return ArcInst.makePolyForArc(this, this.d.length, width, this.d.headLocation, this.d.tailLocation, style);
    }

    public static Poly makePolyForArc(ArcInst real, double length, double width, EPoint headPt, EPoint tailPt, Poly.Type style) {
        Poly curvedPoly;
        Double radiusDouble;
        if (real.getProto().isCurvable() && (radiusDouble = real.getRadius()) != null && (curvedPoly = real.curvedArcOutline(style, width, radiusDouble)) != null) {
            return curvedPoly;
        }
        if (width == 0.0) {
            Poly poly = new Poly(new Point2D.Double[]{headPt.mutable(), tailPt.mutable()});
            if (style == Poly.Type.FILLED) {
                style = Poly.Type.OPENED;
            }
            poly.setStyle(style);
            return poly;
        }
        double extendH = 0.0;
        if (real.isHeadExtended()) {
            extendH = width / 2.0;
            byte headShrink = real.getHeadPortInst().getNodeInst().shrink;
            if (headShrink != 0) {
                extendH = ArcInst.getExtendFactor(width, headShrink);
            }
        }
        double extendT = 0.0;
        if (real.isTailExtended()) {
            extendT = width / 2.0;
            byte tailShrink = real.getTailPortInst().getNodeInst().shrink;
            if (tailShrink != 0) {
                extendT = ArcInst.getExtendFactor(width, tailShrink);
            }
        }
        Poly poly = Poly.makeEndPointPoly(length, width, real.getAngle(), headPt, extendH, tailPt, extendT, style);
        return poly;
    }

    public Double getRadius() {
        Variable var = this.getVar(ARC_RADIUS);
        if (var == null) {
            return null;
        }
        Object obj = var.getObject();
        if (obj instanceof Integer) {
            return new Double((double)((Integer)obj).intValue() / 2000.0);
        }
        if (obj instanceof Double) {
            return new Double((Double)obj);
        }
        return null;
    }

    public Poly curvedArcOutline(Poly.Type style, double wid, double radius) {
        int pieces;
        double pureRadius = Math.abs(radius);
        if (pureRadius * 2.0 < this.d.length) {
            return null;
        }
        Point2D[] centers = DBMath.findCenters(pureRadius, this.d.headLocation, this.d.tailLocation, this.d.length);
        if (centers == null) {
            return null;
        }
        Point2D centerPt = centers[1];
        if (radius < 0.0) {
            centerPt = centers[0];
        }
        int angleBase = DBMath.figureAngle(centerPt, this.d.headLocation);
        int angleRange = DBMath.figureAngle(centerPt, this.d.tailLocation);
        if ((angleRange -= angleBase) < 0) {
            angleRange += 3600;
        }
        if (angleRange > 1800) {
            angleBase = DBMath.figureAngle(centerPt, this.d.tailLocation);
            angleRange = DBMath.figureAngle(centerPt, this.d.headLocation);
            if ((angleRange -= angleBase) < 0) {
                angleRange += 3600;
            }
        }
        for (pieces = angleRange; pieces > 16; pieces /= 2) {
        }
        if (pieces == 0) {
            return null;
        }
        int points = (pieces + 1) * 2;
        Point2D[] pointArray = new Point2D[points];
        double outerRadius = pureRadius + wid / 2.0;
        double innerRadius = outerRadius - wid;
        for (int i = 0; i <= pieces; ++i) {
            int a = (angleBase + i * angleRange / pieces) % 3600;
            double sin = DBMath.sin(a);
            double cos = DBMath.cos(a);
            pointArray[i] = new Point2D.Double(cos * innerRadius + centerPt.getX(), sin * innerRadius + centerPt.getY());
            pointArray[points - 1 - i] = new Point2D.Double(cos * outerRadius + centerPt.getX(), sin * outerRadius + centerPt.getY());
        }
        Poly poly = new Poly(pointArray);
        poly.setStyle(style);
        return poly;
    }

    public Poly[] getAllText(boolean hardToSelect, EditWindow0 wnd) {
        int dispVars = this.numDisplayableVariables(false);
        int totalText = dispVars;
        if (totalText == 0) {
            return null;
        }
        Poly[] polys = new Poly[totalText];
        this.addDisplayableVariables(this.getBounds(), polys, 0, wnd, false);
        return polys;
    }

    @Override
    public int numDisplayableVariables(boolean multipleStrings) {
        return super.numDisplayableVariables(multipleStrings) + (this.isUsernamed() ? 1 : 0);
    }

    @Override
    public int addDisplayableVariables(Rectangle2D rect, Poly[] polys, int start, EditWindow0 wnd, boolean multipleStrings) {
        int numVars = 0;
        if (this.isUsernamed()) {
            double cX = rect.getCenterX();
            double cY = rect.getCenterY();
            TextDescriptor td = this.d.nameDescriptor;
            double offX = td.getXOff();
            double offY = td.getYOff();
            AbstractTextDescriptor.Position pos = td.getPos();
            Poly.Type style = pos.getPolyType();
            Point2D[] pointList = null;
            pointList = style == Poly.Type.TEXTBOX ? Poly.makePoints(rect) : new Point2D.Double[]{new Point2D.Double(cX + offX, cY + offY)};
            polys[start] = new Poly(pointList);
            polys[start].setStyle(style);
            polys[start].setString(this.getNameKey().toString());
            polys[start].setTextDescriptor(td);
            polys[start].setLayer(null);
            polys[start].setDisplayedText(new DisplayedText(this, ARC_NAME));
            numVars = 1;
        }
        return super.addDisplayableVariables(rect, polys, start + numVars, wnd, multipleStrings) + numVars;
    }

    public static double getExtendFactor(double width, int extend) {
        if (extend <= 0) {
            return width / 2.0;
        }
        if (extend > 90) {
            return width / 2.0;
        }
        return width * 50.0 / (double)extendFactor[extend];
    }

    public void updateGeometric() {
        this.checkChanging();
        Poly poly = this.makePoly(this.d.width, Poly.Type.FILLED);
        this.visBounds.setRect(poly.getBounds2D());
        if (this.parent != null) {
            this.parent.setDirty();
        }
    }

    public void updateGeometricInUndo() {
        this.checkUndoing();
        Poly poly = this.makePoly(this.d.width, Poly.Type.FILLED);
        this.visBounds.setRect(poly.getBounds2D());
    }

    public TailConnection getTail() {
        return this.tailEnd;
    }

    public HeadConnection getHead() {
        return this.headEnd;
    }

    public Connection getConnection(int connIndex) {
        switch (connIndex) {
            case 0: {
                return this.tailEnd;
            }
            case 1: {
                return this.headEnd;
            }
        }
        throw new IllegalArgumentException("Bad end " + connIndex);
    }

    public PortInst getTailPortInst() {
        return this.tailPortInst;
    }

    public PortInst getHeadPortInst() {
        return this.headPortInst;
    }

    public PortInst getPortInst(int connIndex) {
        switch (connIndex) {
            case 0: {
                return this.tailPortInst;
            }
            case 1: {
                return this.headPortInst;
            }
        }
        throw new IllegalArgumentException("Bad end " + connIndex);
    }

    public EPoint getTailLocation() {
        return this.d.tailLocation;
    }

    public EPoint getHeadLocation() {
        return this.d.headLocation;
    }

    public EPoint getLocation(int connIndex) {
        switch (connIndex) {
            case 0: {
                return this.d.tailLocation;
            }
            case 1: {
                return this.d.headLocation;
            }
        }
        throw new IllegalArgumentException("Bad end " + connIndex);
    }

    public boolean tailStillInPort(Point2D pt, boolean reduceForArc) {
        return this.stillInPort(0, pt, reduceForArc);
    }

    public boolean headStillInPort(Point2D pt, boolean reduceForArc) {
        return this.stillInPort(1, pt, reduceForArc);
    }

    public boolean stillInPort(int connIndex, Point2D pt, boolean reduceForArc) {
        PortInst pi = this.getPortInst(connIndex);
        Poly poly = pi.getPoly();
        if (reduceForArc) {
            double wid = this.getWidth() - this.getProto().getWidthOffset();
            poly.reducePortPoly(pi, wid, this.getAngle());
        }
        return ArcInst.stillInPoly(pt, poly);
    }

    private static boolean stillInPoly(Point2D pt, Poly poly) {
        return poly.isInside(pt) || poly.polyDistance(pt.getX(), pt.getY()) < MINPORTDISTANCE;
    }

    public String getName() {
        return this.d.name.toString();
    }

    public boolean isUsernamed() {
        return !this.d.name.isTempname();
    }

    public Name getNameKey() {
        return this.d.name;
    }

    public boolean setName(String name) {
        TextDescriptor smartDescriptor;
        Name key;
        assert (this.isLinked());
        boolean doSmart = false;
        if (name != null && name.length() > 0) {
            if (name.equals(this.getName())) {
                return false;
            }
            if (!this.isUsernamed()) {
                doSmart = true;
            }
            key = Name.findName(name);
        } else {
            if (!this.isUsernamed()) {
                return false;
            }
            key = this.parent.getArcAutoname();
        }
        if (ArcInst.checkNameKey(key, this.parent)) {
            return true;
        }
        ImmutableArcInst oldD = this.d;
        this.lowLevelModify(this.d.withName(key));
        if (doSmart && (smartDescriptor = ArcInst.getSmartTextDescriptor(this.d.angle, this.d.width, this.d.nameDescriptor)) != null) {
            this.setTextDescriptor(ARC_NAME, smartDescriptor);
        }
        Constraints.getCurrent().modifyArcInst(this, oldD);
        return false;
    }

    private static TextDescriptor getSmartTextDescriptor(int angle, double width, TextDescriptor prev) {
        if (angle % 1800 == 0) {
            int smart = User.getSmartHorizontalPlacementArc();
            if (smart == 1) {
                return prev.withPos(AbstractTextDescriptor.Position.UP).withOff(0.0, width / 2.0);
            }
            if (smart == 2) {
                return prev.withPos(AbstractTextDescriptor.Position.DOWN).withOff(0.0, -width / 2.0);
            }
        } else if (angle % 1800 == 900) {
            int smart = User.getSmartVerticalPlacementArc();
            if (smart == 1) {
                return prev.withPos(AbstractTextDescriptor.Position.LEFT).withOff(-width / 2.0, 0.0);
            }
            if (smart == 2) {
                return prev.withPos(AbstractTextDescriptor.Position.RIGHT).withOff(width / 2.0, 0.0);
            }
        }
        return null;
    }

    protected static boolean checkNameKey(Name name, Cell parent) {
        if (!name.isValid()) {
            System.out.println(parent + ": Invalid name \"" + name + "\" wasn't assigned to arc" + " :" + Name.checkName(name.toString()));
            return true;
        }
        if (name.isTempname() && name.getBasename() != ImmutableArcInst.BASENAME) {
            System.out.println(parent + ": Temporary arc name \"" + name + "\" must have prefix net@");
            return true;
        }
        if (name.hasEmptySubnames()) {
            if (name.isBus()) {
                System.out.println(parent + ": Name \"" + name + "\" with empty subnames wasn't assigned to arc");
            } else {
                System.out.println(parent + ": Cannot assign empty name \"" + name + "\" to arc");
            }
            return true;
        }
        if (parent.hasTempArcName(name)) {
            System.out.println(parent + " already has ArcInst with temporary name \"" + name + "\"");
            return true;
        }
        return false;
    }

    @Override
    public TextDescriptor getTextDescriptor(Variable.Key varKey) {
        if (varKey == ARC_NAME) {
            return this.d.nameDescriptor;
        }
        return super.getTextDescriptor(varKey);
    }

    @Override
    public void setTextDescriptor(Variable.Key varKey, TextDescriptor td) {
        if (varKey == ARC_NAME) {
            this.setD(this.d.withNameDescriptor(td), true);
            return;
        }
        super.setTextDescriptor(varKey, td);
    }

    @Override
    public boolean isDeprecatedVariable(Variable.Key key) {
        if (key == ARC_NAME) {
            return true;
        }
        return super.isDeprecatedVariable(key);
    }

    @Override
    public String describe(boolean withQuotes) {
        String name;
        String description = this.getProto().describe();
        String string = name = withQuotes ? "'" + this.getName() + "'" : this.getName();
        if (name != null) {
            description = description + "[" + name + "]";
        }
        return description;
    }

    @Override
    public int compareTo(ArcInst that) {
        int cmp;
        if (this.parent != that.parent && (cmp = this.parent.compareTo(that.parent)) != 0) {
            return cmp;
        }
        cmp = this.getName().compareTo(that.getName());
        if (cmp != 0) {
            return cmp;
        }
        return this.d.arcId - that.d.arcId;
    }

    @Override
    public String toString() {
        return "arc " + this.describe(true);
    }

    private void setFlag(ImmutableArcInst.Flag flag, boolean state) {
        this.checkChanging();
        ImmutableArcInst oldD = this.d;
        this.lowLevelModify(this.d.withFlag(flag, state));
        if (this.parent != null) {
            Constraints.getCurrent().modifyArcInst(this, oldD);
        }
    }

    public void setRigid(boolean state) {
        this.setFlag(ImmutableArcInst.RIGID, state);
    }

    public boolean isRigid() {
        return this.d.is(ImmutableArcInst.RIGID);
    }

    public void setFixedAngle(boolean state) {
        this.setFlag(ImmutableArcInst.FIXED_ANGLE, state);
    }

    public boolean isFixedAngle() {
        return this.d.is(ImmutableArcInst.FIXED_ANGLE);
    }

    public void setSlidable(boolean state) {
        this.setFlag(ImmutableArcInst.SLIDABLE, state);
    }

    public boolean isSlidable() {
        return this.d.is(ImmutableArcInst.SLIDABLE);
    }

    public boolean isArrowed(int connIndex) {
        switch (connIndex) {
            case 0: {
                return this.isTailArrowed();
            }
            case 1: {
                return this.isHeadArrowed();
            }
        }
        throw new IllegalArgumentException("Bad end " + connIndex);
    }

    public boolean isTailArrowed() {
        return this.d.is(ImmutableArcInst.TAIL_ARROWED);
    }

    public boolean isHeadArrowed() {
        return this.d.is(ImmutableArcInst.HEAD_ARROWED);
    }

    public boolean isBodyArrowed() {
        return this.d.is(ImmutableArcInst.BODY_ARROWED);
    }

    public void setArrowed(int connIndex, boolean state) {
        switch (connIndex) {
            case 0: {
                this.setTailArrowed(state);
                break;
            }
            case 1: {
                this.setHeadArrowed(state);
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad end " + connIndex);
            }
        }
    }

    public void setTailArrowed(boolean state) {
        this.setFlag(ImmutableArcInst.TAIL_ARROWED, state);
    }

    public void setHeadArrowed(boolean state) {
        this.setFlag(ImmutableArcInst.HEAD_ARROWED, state);
    }

    public void setBodyArrowed(boolean state) {
        this.setFlag(ImmutableArcInst.BODY_ARROWED, state);
    }

    public boolean isExtended(int connIndex) {
        switch (connIndex) {
            case 0: {
                return this.isTailExtended();
            }
            case 1: {
                return this.isHeadExtended();
            }
        }
        throw new IllegalArgumentException("Bad end " + connIndex);
    }

    public boolean isTailExtended() {
        return this.d.is(ImmutableArcInst.TAIL_EXTENDED);
    }

    public boolean isHeadExtended() {
        return this.d.is(ImmutableArcInst.HEAD_EXTENDED);
    }

    public void setExtended(int connIndex, boolean e) {
        switch (connIndex) {
            case 0: {
                this.setTailExtended(e);
                break;
            }
            case 1: {
                this.setHeadExtended(e);
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad end " + connIndex);
            }
        }
    }

    public void setTailExtended(boolean e) {
        this.setFlag(ImmutableArcInst.TAIL_EXTENDED, e);
    }

    public void setHeadExtended(boolean e) {
        this.setFlag(ImmutableArcInst.HEAD_EXTENDED, e);
    }

    public boolean isNegated(int connIndex) {
        switch (connIndex) {
            case 0: {
                return this.isTailNegated();
            }
            case 1: {
                return this.isHeadNegated();
            }
        }
        throw new IllegalArgumentException("Bad end " + connIndex);
    }

    public boolean isTailNegated() {
        return this.d.is(ImmutableArcInst.TAIL_NEGATED);
    }

    public boolean isHeadNegated() {
        return this.d.is(ImmutableArcInst.HEAD_NEGATED);
    }

    public void setNegated(int connIndex, boolean n) {
        switch (connIndex) {
            case 0: {
                this.setTailNegated(n);
                break;
            }
            case 1: {
                this.setHeadNegated(n);
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad end " + connIndex);
            }
        }
    }

    public void setTailNegated(boolean n) {
        this.setFlag(ImmutableArcInst.TAIL_NEGATED, n);
    }

    public void setHeadNegated(boolean n) {
        this.setFlag(ImmutableArcInst.HEAD_NEGATED, n);
    }

    public int checkAndRepair(boolean repair, List<Geometric> list, ErrorLogger errorLogger) {
        ArrayList<Geometric> geomList;
        String msg;
        Poly poly;
        int errorCount = 0;
        ArcProto ap = this.getProto();
        if (ap.isNotUsed()) {
            if (errorLogger != null) {
                String msg2 = "Prototype of arc " + this.getName() + " is unused";
                if (repair) {
                    Poly poly2 = this.makePoly(this.getWidth() - ap.getWidthOffset(), Poly.Type.CLOSED);
                    errorLogger.logError(msg2, poly2, this.parent, 1);
                } else {
                    errorLogger.logError(msg2, this, this.parent, null, 1);
                }
            }
            if (repair) {
                list.add(this);
            }
            return 1;
        }
        if (!this.headStillInPort(this.d.headLocation, false)) {
            poly = this.headPortInst.getPoly();
            msg = this.parent + ", " + this + ": head not in port, is at (" + this.d.headLocation.getX() + "," + this.d.headLocation.getY() + ") distance to port is " + poly.polyDistance(this.d.headLocation.getX(), this.d.headLocation.getY()) + " port center is (" + poly.getCenterX() + "," + poly.getCenterY() + ")";
            System.out.println(msg);
            if (errorLogger != null) {
                if (repair) {
                    errorLogger.logError(msg, Collections.singletonList(this.headPortInst.getNodeInst()), null, null, null, Collections.singletonList(this.makePoly(this.getWidth() - ap.getWidthOffset(), Poly.Type.CLOSED)), this.parent, 1);
                } else {
                    geomList = new ArrayList<Geometric>();
                    geomList.add(this);
                    geomList.add(this.headPortInst.getNodeInst());
                    errorLogger.logError(msg, geomList, null, this.parent, 1);
                }
            }
            if (repair) {
                Constraints.getCurrent().modifyArcInst(this, this.getD());
            }
            ++errorCount;
        }
        if (!this.tailStillInPort(this.d.tailLocation, false)) {
            poly = this.tailPortInst.getPoly();
            msg = this.parent + ", " + this + ": tail not in port, is at (" + this.d.tailLocation.getX() + "," + this.d.tailLocation.getY() + ") distance to port is " + poly.polyDistance(this.d.tailLocation.getX(), this.d.tailLocation.getY()) + " port center is (" + poly.getCenterX() + "," + poly.getCenterY() + ")";
            System.out.println(msg);
            if (errorLogger != null) {
                if (repair) {
                    errorLogger.logError(msg, Collections.singletonList(this.tailPortInst.getNodeInst()), null, null, null, Collections.singletonList(this.makePoly(this.getWidth() - ap.getWidthOffset(), Poly.Type.CLOSED)), this.parent, 1);
                } else {
                    geomList = new ArrayList();
                    geomList.add(this);
                    geomList.add(this.tailPortInst.getNodeInst());
                    errorLogger.logError(msg, geomList, null, this.parent, 1);
                }
            }
            if (repair) {
                Constraints.getCurrent().modifyArcInst(this, this.getD());
            }
            ++errorCount;
        }
        return errorCount;
    }

    public void setArcIndex(int arcIndex) {
        this.arcIndex = arcIndex;
    }

    public final int getArcIndex() {
        return this.arcIndex;
    }

    @Override
    public boolean isLinked() {
        try {
            return this.parent != null && this.parent.isLinked() && this.parent.getArc(this.arcIndex) == this;
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    public ArcProto getProto() {
        return this.d.protoType;
    }

    public void copyPropertiesFrom(ArcInst fromAi) {
        if (fromAi == null) {
            return;
        }
        this.copyVarsFrom(fromAi);
        this.copyConstraintsFrom(fromAi);
        this.copyTextDescriptorFrom(fromAi, ARC_NAME);
    }

    public void copyConstraintsFrom(ArcInst fromAi) {
        this.checkChanging();
        if (fromAi == null) {
            return;
        }
        ImmutableArcInst oldD = this.d;
        this.lowLevelModify(this.d.withFlags(fromAi.d.flags).withAngle(fromAi.d.angle));
        if (this.parent != null) {
            Constraints.getCurrent().modifyArcInst(this, oldD);
        }
    }

    private void setDefaultConstraints(ArcProto protoType) {
        this.setRigid(protoType.isRigid());
        this.setFixedAngle(protoType.isFixedAngle());
        this.setSlidable(protoType.isSlidable());
        this.setHeadExtended(protoType.isExtended());
        this.setTailExtended(protoType.isExtended());
        this.setHeadArrowed(protoType.isDirectional());
        this.setBodyArrowed(protoType.isDirectional());
    }

    public void setHardSelect(boolean state) {
        this.setFlag(ImmutableArcInst.HARD_SELECT, state);
    }

    public boolean isHardSelect() {
        return this.d.is(ImmutableArcInst.HARD_SELECT);
    }

    public boolean compare(Object obj, StringBuffer buffer) {
        Poly[] aPolyList;
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ArcInst a = (ArcInst)obj;
        if (this.getProto().getClass() != a.getProto().getClass()) {
            return false;
        }
        ArcProto arcType = a.getProto();
        Technology tech = arcType.getTechnology();
        if (this.getProto().getTechnology() != tech) {
            if (buffer != null) {
                buffer.append("No same technology for arcs " + this.getName() + " and " + a.getName() + "\n");
            }
            return false;
        }
        Poly[] polyList = this.getProto().getTechnology().getShapeOfArc(this);
        if (polyList.length != (aPolyList = tech.getShapeOfArc(a)).length) {
            if (buffer != null) {
                buffer.append("No same number of geometries in " + this.getName() + " and " + a.getName() + "\n");
            }
            return false;
        }
        ArrayList<Poly> noCheckAgain = new ArrayList<Poly>();
        for (int i = 0; i < polyList.length; ++i) {
            boolean found = false;
            for (int j = 0; j < aPolyList.length; ++j) {
                if (noCheckAgain.contains(aPolyList[j]) || !polyList[i].compare(aPolyList[j], buffer)) continue;
                found = true;
                noCheckAgain.add(aPolyList[j]);
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public Poly cropPerLayer(Poly poly) {
        Rectangle2D polyBounds = poly.getBox();
        if (polyBounds == null) {
            return poly;
        }
        polyBounds = new Rectangle2D.Double(polyBounds.getMinX(), polyBounds.getMinY(), polyBounds.getWidth(), polyBounds.getHeight());
        for (int i = 0; i < 2; ++i) {
            PortInst pi = this.getPortInst(i);
            NodeInst ni = pi.getNodeInst();
            AffineTransform trans = ni.rotateOut();
            Technology tech = ni.getProto().getTechnology();
            for (Poly nPoly : tech.getShapeOfNode(ni)) {
                if (nPoly.getLayer() != poly.getLayer()) continue;
                nPoly.transform(trans);
                Rectangle2D nPolyBounds = nPoly.getBox();
                if (nPolyBounds == null) continue;
                int result = Poly.cropBoxComplete(polyBounds, nPolyBounds);
                if (result == 1) {
                    return null;
                }
                if (result == -2) {
                    System.out.println("When is this case?");
                }
                Poly newPoly = new Poly(polyBounds);
                newPoly.setLayer(poly.getLayer());
                newPoly.setStyle(poly.getStyle());
                return newPoly;
            }
        }
        return poly;
    }

    public boolean isDiffusionArc() {
        return this.getProto().getFunction().isDiffusion();
    }

    private static class ArcInstKey
    extends EObjectInputStream.Key {
        Cell cell;
        int arcId;

        private ArcInstKey(ArcInst ai) {
            assert (ai.isLinked());
            this.cell = ai.getParent();
            this.arcId = ai.getD().arcId;
        }

        protected Object readResolveInDatabase(EDatabase database) throws InvalidObjectException {
            ArcInst ai = this.cell.getArcById(this.arcId);
            if (ai == null) {
                throw new InvalidObjectException("ArcInst");
            }
            return ai;
        }
    }
}

